/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.ui.modelpath;

import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.etrice.core.common.ui.modelpath.ModelPathManager;
import org.eclipse.etrice.generator.base.io.IModelPath;
import org.eclipse.etrice.generator.base.io.ResourceSetModelPathProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.ui.resource.IResourceSetInitializer;

public class ModelPathResourceSetInitializer
implements IResourceSetInitializer {
    public void initialize(ResourceSet resourceSet, IProject project) {
        if (project != null) {
            ModelPathDelegate modelPath = new ModelPathDelegate(project);
            ResourceSetModelPathProvider.install((ResourceSet)resourceSet, (IModelPath)modelPath);
        }
    }

    private class ModelPathDelegate
    implements IModelPath {
        private IProject project;

        public ModelPathDelegate(IProject project) {
            this.project = project;
        }

        public Stream<IModelPath.ModelFile> getFiles(QualifiedName name) {
            return ModelPathManager.INSTANCE.getModelPath(this.project).getFiles(name);
        }

        public Stream<IModelPath.ModelFile> getAllFiles() {
            return ModelPathManager.INSTANCE.getModelPath(this.project).getAllFiles();
        }

        public Optional<QualifiedName> getQualifiedName(URI uri) {
            return ModelPathManager.INSTANCE.getModelPath(this.project).getQualifiedName(uri);
        }

        public boolean isEmpty() {
            return ModelPathManager.INSTANCE.getModelPath(this.project).isEmpty();
        }
    }
}

