/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class CurrencyNames_id extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "AED", "AED" },
            { "AFN", "AFN" },
            { "ALL", "ALL" },
            { "AMD", "AMD" },
            { "ANG", "ANG" },
            { "AOA", "AOA" },
            { "ARS", "ARS" },
            { "AUD", "AU$" },
            { "AWG", "AWG" },
            { "AZN", "AZN" },
            { "BAM", "BAM" },
            { "BBD", "BBD" },
            { "BDT", "BDT" },
            { "BGN", "BGN" },
            { "BHD", "BHD" },
            { "BIF", "BIF" },
            { "BMD", "BMD" },
            { "BND", "BND" },
            { "BOB", "BOB" },
            { "BSD", "BSD" },
            { "BTN", "BTN" },
            { "BWP", "BWP" },
            { "BYN", "BYN" },
            { "BYR", "BYR" },
            { "BZD", "BZD" },
            { "CDF", "CDF" },
            { "CHF", "CHF" },
            { "CLP", "CLP" },
            { "CNH", "CNH" },
            { "COP", "COP" },
            { "CRC", "CRC" },
            { "CUC", "CUC" },
            { "CUP", "CUP" },
            { "CVE", "CVE" },
            { "CZK", "CZK" },
            { "DJF", "DJF" },
            { "DKK", "DKK" },
            { "DOP", "DOP" },
            { "DZD", "DZD" },
            { "EGP", "EGP" },
            { "ERN", "ERN" },
            { "ETB", "ETB" },
            { "FJD", "FJD" },
            { "FKP", "FKP" },
            { "GEL", "GEL" },
            { "GHS", "GHS" },
            { "GIP", "GIP" },
            { "GMD", "GMD" },
            { "GNF", "GNF" },
            { "GTQ", "GTQ" },
            { "GYD", "GYD" },
            { "HNL", "HNL" },
            { "HRK", "HRK" },
            { "HTG", "HTG" },
            { "HUF", "HUF" },
            { "IDR", "Rp" },
            { "INR", "Rs" },
            { "IQD", "IQD" },
            { "IRR", "IRR" },
            { "ISK", "ISK" },
            { "JMD", "JMD" },
            { "JOD", "JOD" },
            { "KES", "KES" },
            { "KGS", "KGS" },
            { "KHR", "KHR" },
            { "KMF", "KMF" },
            { "KPW", "KPW" },
            { "KWD", "KWD" },
            { "KYD", "KYD" },
            { "KZT", "KZT" },
            { "LAK", "LAK" },
            { "LBP", "LBP" },
            { "LKR", "LKR" },
            { "LRD", "LRD" },
            { "LTL", "LTL" },
            { "LVL", "LVL" },
            { "LYD", "LYD" },
            { "MAD", "MAD" },
            { "MDL", "MDL" },
            { "MGA", "MGA" },
            { "MKD", "MKD" },
            { "MMK", "MMK" },
            { "MNT", "MNT" },
            { "MOP", "MOP" },
            { "MRO", "MRO" },
            { "MRU", "MRU" },
            { "MUR", "MUR" },
            { "MVR", "MVR" },
            { "MWK", "MWK" },
            { "MYR", "MYR" },
            { "MZN", "MZN" },
            { "NAD", "NAD" },
            { "NGN", "NGN" },
            { "NIO", "NIO" },
            { "NOK", "NOK" },
            { "NPR", "NPR" },
            { "OMR", "OMR" },
            { "PAB", "PAB" },
            { "PEN", "PEN" },
            { "PGK", "PGK" },
            { "PHP", "PHP" },
            { "PKR", "PKR" },
            { "PLN", "PLN" },
            { "PYG", "PYG" },
            { "QAR", "QAR" },
            { "RON", "RON" },
            { "RSD", "RSD" },
            { "RUB", "RUB" },
            { "RWF", "RWF" },
            { "SAR", "SAR" },
            { "SBD", "SBD" },
            { "SCR", "SCR" },
            { "SDG", "SDG" },
            { "SEK", "SEK" },
            { "SGD", "SGD" },
            { "SHP", "SHP" },
            { "SLL", "SLL" },
            { "SOS", "SOS" },
            { "SRD", "SRD" },
            { "SSP", "SSP" },
            { "STD", "STD" },
            { "STN", "STN" },
            { "SYP", "SYP" },
            { "SZL", "SZL" },
            { "THB", "\u0e3f" },
            { "TJS", "TJS" },
            { "TMT", "TMT" },
            { "TND", "TND" },
            { "TOP", "TOP" },
            { "TRY", "TRY" },
            { "TTD", "TTD" },
            { "TZS", "TZS" },
            { "UAH", "UAH" },
            { "UGX", "UGX" },
            { "UYU", "UYU" },
            { "UZS", "UZS" },
            { "VEF", "VEF" },
            { "VES", "VES" },
            { "VUV", "VUV" },
            { "WST", "WST" },
            { "XXX", "XXX" },
            { "YER", "YER" },
            { "ZAR", "ZAR" },
            { "ZMW", "ZMW" },
            { "adp", "Peseta Andorra" },
            { "aed", "Dirham Uni Emirat Arab" },
            { "afa", "Afgani Afganistan (1927\u20132002)" },
            { "afn", "Afgani Afganistan" },
            { "all", "Lek Albania" },
            { "amd", "Dram Armenia" },
            { "ang", "Guilder Antilla Belanda" },
            { "aoa", "Kwanza Angola" },
            { "aok", "Kwanza Angola (1977\u20131991)" },
            { "aon", "Kwanza Baru Angola (1990\u20132000)" },
            { "aor", "Kwanza Angola yang Disesuaikan Lagi (1995\u20131999)" },
            { "ara", "Austral Argentina" },
            { "arl", "Peso Ley Argentina (1970\u20131983)" },
            { "arm", "Peso Argentina (1881\u20131970)" },
            { "arp", "Peso Argentina (1983\u20131985)" },
            { "ars", "Peso Argentina" },
            { "ats", "Schilling Austria" },
            { "aud", "Dolar Australia" },
            { "awg", "Florin Aruba" },
            { "azm", "Manat Azerbaijan (1993\u20132006)" },
            { "azn", "Manat Azerbaijan" },
            { "bad", "Dinar Bosnia-Herzegovina (1992\u20131994)" },
            { "bam", "Mark Konvertibel Bosnia-Herzegovina" },
            { "ban", "Dinar Baru Bosnia-Herzegovina (1994\u20131997)" },
            { "bbd", "Dolar Barbados" },
            { "bdt", "Taka Bangladesh" },
            { "bec", "Franc Belgia (konvertibel)" },
            { "bef", "Franc Belgia" },
            { "bel", "Franc Belgia (keuangan)" },
            { "bgl", "Hard Lev Bulgaria" },
            { "bgm", "Socialist Lev Bulgaria" },
            { "bgn", "Lev Bulgaria" },
            { "bgo", "Lev Bulgaria (1879\u20131952)" },
            { "bhd", "Dinar Bahrain" },
            { "bif", "Franc Burundi" },
            { "bmd", "Dolar Bermuda" },
            { "bnd", "Dolar Brunei" },
            { "bob", "Boliviano" },
            { "bol", "Boliviano Bolivia (1863\u20131963)" },
            { "bop", "Peso Bolivia" },
            { "bov", "Mvdol Bolivia" },
            { "brb", "Cruzeiro Baru Brasil (1967\u20131986)" },
            { "brc", "Cruzado Brasil (1986\u20131989)" },
            { "bre", "Cruzeiro Brasil (1990\u20131993)" },
            { "brl", "Real Brasil" },
            { "brn", "Cruzado Baru Brasil (1989\u20131990)" },
            { "brr", "Cruzeiro Brasil (1993\u20131994)" },
            { "brz", "Cruzeiro Brasil (1942\u20131967)" },
            { "bsd", "Dolar Bahama" },
            { "btn", "Ngultrum Bhutan" },
            { "buk", "Kyat Burma" },
            { "bwp", "Pula Botswana" },
            { "byb", "Rubel Baru Belarus (1994\u20131999)" },
            { "byn", "Rubel Belarusia" },
            { "byr", "Rubel Belarusia (2000\u20132016)" },
            { "bzd", "Dolar Belize" },
            { "cad", "Dolar Kanada" },
            { "cdf", "Franc Kongo" },
            { "che", "Euro WIR" },
            { "chf", "Franc Swiss" },
            { "chw", "Franc WIR" },
            { "cle", "Escudo Cile" },
            { "clf", "Satuan Hitung (UF) Cile" },
            { "clp", "Peso Cile" },
            { "cnh", "Yuan Tiongkok (luar negeri)" },
            { "cny", "Yuan Tiongkok" },
            { "cop", "Peso Kolombia" },
            { "cou", "Unit Nilai Nyata Kolombia" },
            { "crc", "Colon Kosta Rika" },
            { "csd", "Dinar Serbia (2002\u20132006)" },
            { "csk", "Hard Koruna Cheska" },
            { "cuc", "Peso Konvertibel Kuba" },
            { "cup", "Peso Kuba" },
            { "cve", "Escudo Tanjung Verde" },
            { "cyp", "Pound Siprus" },
            { "czk", "Koruna Ceko" },
            { "ddm", "Mark Jerman Timur" },
            { "dem", "Mark Jerman" },
            { "djf", "Franc Jibuti" },
            { "dkk", "Krone Denmark" },
            { "dop", "Peso Dominika" },
            { "dzd", "Dinar Aljazair" },
            { "ecs", "Sucre Ekuador" },
            { "ecv", "Satuan Nilai Tetap Ekuador" },
            { "eek", "Kroon Estonia" },
            { "egp", "Pound Mesir" },
            { "ern", "Nakfa Eritrea" },
            { "esa", "Peseta Spanyol (akun)" },
            { "esb", "Peseta Spanyol (konvertibel)" },
            { "esp", "Peseta Spanyol" },
            { "etb", "Birr Etiopia" },
            { "eur", "Euro" },
            { "fim", "Markka Finlandia" },
            { "fjd", "Dolar Fiji" },
            { "fkp", "Pound Kepulauan Falkland" },
            { "frf", "Franc Prancis" },
            { "gbp", "Pound Inggris" },
            { "gek", "Kupon Larit Georgia" },
            { "gel", "Lari Georgia" },
            { "ghc", "Cedi Ghana (1979\u20132007)" },
            { "ghs", "Cedi Ghana" },
            { "gip", "Pound Gibraltar" },
            { "gmd", "Dalasi Gambia" },
            { "gnf", "Franc Guinea" },
            { "gns", "Syli Guinea" },
            { "gqe", "Ekuele Guinea Ekuatorial" },
            { "grd", "Drachma Yunani" },
            { "gtq", "Quetzal Guatemala" },
            { "gwe", "Escudo Guinea Portugal" },
            { "gwp", "Peso Guinea-Bissau" },
            { "gyd", "Dolar Guyana" },
            { "hkd", "Dolar Hong Kong" },
            { "hnl", "Lempira Honduras" },
            { "hrd", "Dinar Kroasia" },
            { "hrk", "Kuna Kroasia" },
            { "htg", "Gourde Haiti" },
            { "huf", "Forint Hungaria" },
            { "idr", "Rupiah Indonesia" },
            { "iep", "Pound Irlandia" },
            { "ilp", "Pound Israel" },
            { "ilr", "Shekel Israel" },
            { "ils", "Shekel Baru Israel" },
            { "inr", "Rupee India" },
            { "iqd", "Dinar Irak" },
            { "irr", "Rial Iran" },
            { "isj", "Krona Islandia (1918\u20131981)" },
            { "isk", "Krona Islandia" },
            { "itl", "Lira Italia" },
            { "jmd", "Dolar Jamaika" },
            { "jod", "Dinar Yordania" },
            { "jpy", "Yen Jepang" },
            { "kes", "Shilling Kenya" },
            { "kgs", "Som Kirgizstan" },
            { "khr", "Riel Kamboja" },
            { "kmf", "Franc Komoro" },
            { "kpw", "Won Korea Utara" },
            { "krh", "Hwan Korea Selatan (1953\u20131962)" },
            { "kro", "Won Korea Selatan (1945\u20131953)" },
            { "krw", "Won Korea Selatan" },
            { "kwd", "Dinar Kuwait" },
            { "kyd", "Dolar Kepulauan Cayman" },
            { "kzt", "Tenge Kazakhstan" },
            { "lak", "Kip Laos" },
            { "lbp", "Pound Lebanon" },
            { "lkr", "Rupee Sri Lanka" },
            { "lrd", "Dolar Liberia" },
            { "lsl", "Loti Lesotho" },
            { "ltl", "Litas Lituania" },
            { "ltt", "Talonas Lituania" },
            { "luc", "Franc Konvertibel Luksemburg" },
            { "luf", "Franc Luksemburg" },
            { "lul", "Financial Franc Luksemburg" },
            { "lvl", "Lats Latvia" },
            { "lvr", "Rubel Latvia" },
            { "lyd", "Dinar Libya" },
            { "mad", "Dirham Maroko" },
            { "maf", "Franc Maroko" },
            { "mcf", "Franc Monegasque" },
            { "mdc", "Cupon Moldova" },
            { "mdl", "Leu Moldova" },
            { "mga", "Ariary Madagaskar" },
            { "mgf", "Franc Malagasi" },
            { "mkd", "Denar Makedonia" },
            { "mkn", "Denar Makedonia (1992\u20131993)" },
            { "mlf", "Franc Mali" },
            { "mmk", "Kyat Myanmar" },
            { "mnt", "Tugrik Mongolia" },
            { "mop", "Pataca Makau" },
            { "mro", "Ouguiya Mauritania (1973\u20132017)" },
            { "mru", "Ouguiya Mauritania" },
            { "mtl", "Lira Malta" },
            { "mtp", "Pound Malta" },
            { "mur", "Rupee Mauritius" },
            { "mvp", "Rufiyaa Maladewa (1947\u20131981)" },
            { "mvr", "Rufiyaa Maladewa" },
            { "mwk", "Kwacha Malawi" },
            { "mxn", "Peso Meksiko" },
            { "mxp", "Peso Silver Meksiko (1861\u20131992)" },
            { "mxv", "Unit Investasi Meksiko" },
            { "myr", "Ringgit Malaysia" },
            { "mze", "Escudo Mozambik" },
            { "mzm", "Metical Mozambik (1980\u20132006)" },
            { "mzn", "Metical Mozambik" },
            { "nad", "Dolar Namibia" },
            { "ngn", "Naira Nigeria" },
            { "nic", "Cordoba Nikaragua (1988\u20131991)" },
            { "nio", "Cordoba Nikaragua" },
            { "nlg", "Guilder Belanda" },
            { "nok", "Krone Norwegia" },
            { "npr", "Rupee Nepal" },
            { "nzd", "Dolar Selandia Baru" },
            { "omr", "Rial Oman" },
            { "pab", "Balboa Panama" },
            { "pei", "Inti Peru" },
            { "pen", "Sol Peru" },
            { "pes", "Sol Peru (1863\u20131965)" },
            { "pgk", "Kina Papua Nugini" },
            { "php", "Peso Filipina" },
            { "pkr", "Rupee Pakistan" },
            { "pln", "Zloty Polandia" },
            { "plz", "Zloty Polandia (1950\u20131995)" },
            { "pte", "Escudo Portugal" },
            { "pyg", "Guarani Paraguay" },
            { "qar", "Rial Qatar" },
            { "rhd", "Dolar Rhodesia" },
            { "rol", "Leu Rumania (1952\u20132006)" },
            { "ron", "Leu Rumania" },
            { "rsd", "Dinar Serbia" },
            { "rub", "Rubel Rusia" },
            { "rur", "Rubel Rusia (1991\u20131998)" },
            { "rwf", "Franc Rwanda" },
            { "sar", "Riyal Arab Saudi" },
            { "sbd", "Dolar Kepulauan Solomon" },
            { "scr", "Rupee Seychelles" },
            { "sdd", "Dinar Sudan (1992\u20132007)" },
            { "sdg", "Pound Sudan" },
            { "sdp", "Pound Sudan (1957\u20131998)" },
            { "sek", "Krona Swedia" },
            { "sgd", "Dolar Singapura" },
            { "shp", "Pound Saint Helena" },
            { "sit", "Tolar Slovenia" },
            { "skk", "Koruna Slovakia" },
            { "sll", "Leone Sierra Leone" },
            { "sos", "Shilling Somalia" },
            { "srd", "Dolar Suriname" },
            { "srg", "Guilder Suriname" },
            { "ssp", "Pound Sudan Selatan" },
            { "std", "Dobra Sao Tome dan Principe (1977\u20132017)" },
            { "stn", "Dobra Sao Tome dan Principe" },
            { "sur", "Rubel Soviet" },
            { "svc", "Colon El Savador" },
            { "syp", "Pound Suriah" },
            { "szl", "Lilangeni Swaziland" },
            { "thb", "Baht Thailand" },
            { "tjr", "Rubel Tajikistan" },
            { "tjs", "Somoni Tajikistan" },
            { "tmm", "Manat Turkmenistan (1993\u20132009)" },
            { "tmt", "Manat Turkmenistan" },
            { "tnd", "Dinar Tunisia" },
            { "top", "Pa\u02bbanga Tonga" },
            { "tpe", "Escudo Timor" },
            { "trl", "Lira Turki (1922\u20132005)" },
            { "try", "Lira Turki" },
            { "ttd", "Dolar Trinidad dan Tobago" },
            { "twd", "Dolar Baru Taiwan" },
            { "tzs", "Shilling Tanzania" },
            { "uah", "Hryvnia Ukraina" },
            { "uak", "Karbovanet Ukraina" },
            { "ugs", "Shilling Uganda (1966\u20131987)" },
            { "ugx", "Shilling Uganda" },
            { "usd", "Dolar Amerika Serikat" },
            { "usn", "Dolar AS (Hari berikutnya)" },
            { "uss", "Dolar AS (Hari yang sama)" },
            { "uyi", "Peso Uruguay (Unit Diindeks)" },
            { "uyp", "Peso Uruguay (1975\u20131993)" },
            { "uyu", "Peso Uruguay" },
            { "uzs", "Som Uzbekistan" },
            { "veb", "Bolivar Venezuela (1871\u20132008)" },
            { "vef", "Bolivar Venezuela (2008\u20132018)" },
            { "ves", "Bolivar Venezuela" },
            { "vnd", "Dong Vietnam" },
            { "vnn", "Dong Vietnam (1978\u20131985)" },
            { "vuv", "Vatu Vanuatu" },
            { "wst", "Tala Samoa" },
            { "xaf", "Franc CFA Afrika Tengah" },
            { "xag", "Silver" },
            { "xau", "Emas" },
            { "xba", "Unit Gabungan Eropa" },
            { "xbb", "Unit Keuangan Eropa" },
            { "xbc", "Satuan Hitung Eropa (XBC)" },
            { "xbd", "Satuan Hitung Eropa (XBD)" },
            { "xcd", "Dolar Karibia Timur" },
            { "xdr", "Hak Khusus Menggambar" },
            { "xeu", "Satuan Mata Uang Eropa" },
            { "xfo", "Franc Gold Perancis" },
            { "xfu", "Franc UIC Perancis" },
            { "xof", "Franc CFA Afrika Barat" },
            { "xpd", "Palladium" },
            { "xpf", "Franc CFP" },
            { "xpt", "Platinum" },
            { "xre", "Dana RINET" },
            { "xts", "Kode Mata Uang Pengujian" },
            { "xxx", "Mata Uang Tidak Dikenal" },
            { "ydd", "Dinar Yaman" },
            { "yer", "Rial Yaman" },
            { "yud", "Hard Dinar Yugoslavia (1966\u20131990)" },
            { "yum", "Dinar Baru Yugoslavia (1994\u20132002)" },
            { "yun", "Dinar Konvertibel Yugoslavia (1990\u20131992)" },
            { "yur", "Dinar Reformasi Yugoslavia (1992\u20131993)" },
            { "zal", "Rand Afrika Selatan (Keuangan)" },
            { "zar", "Rand Afrika Selatan" },
            { "zmk", "Kwacha Zambia (1968\u20132012)" },
            { "zmw", "Kwacha Zambia" },
            { "zrn", "Zaire Baru Zaire (1993\u20131998)" },
            { "zrz", "Zaire Zaire (1971\u20131993)" },
            { "zwd", "Dolar Zimbabwe (1980\u20132008)" },
            { "zwl", "Dolar Zimbabwe (2009)" },
            { "zwr", "Dolar Zimbabwe (2008)" },
        };
        return data;
    }
}
