/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.Collection;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IProblemLocation;

public abstract class VarargsWarningsBaseSubProcessor<T> {
    public void createAddSafeVarargsProposals(IInvocationContext context, IProblemLocation problem, Collection<T> proposals) {
        ASTNode coveringNode = problem.getCoveringNode(context.getASTRoot());
        MethodDeclaration methodDeclaration = ASTResolving.findParentMethodDeclaration(coveringNode);
        if (methodDeclaration == null) {
            return;
        }
        IMethodBinding methodBinding = methodDeclaration.resolveBinding();
        if (methodBinding == null) {
            return;
        }
        int modifiers = methodBinding.getModifiers();
        if (!(Modifier.isStatic((int)modifiers) || Modifier.isFinal((int)modifiers) || Modifier.isPrivate((int)modifiers) || methodBinding.isConstructor())) {
            return;
        }
        String label = CorrectionMessages.VarargsWarningsSubProcessor_add_safevarargs_label;
        T proposal = this.createAddSafeVarargsProposal1(label, context.getCompilationUnit(), methodDeclaration, null, -2);
        if (proposal != null) {
            proposals.add(proposal);
        }
    }

    public void createAddSafeVarargsToDeclarationProposals(IInvocationContext context, IProblemLocation problem, Collection<T> proposals) {
        IMethodBinding methodBinding;
        if (!JavaModelUtil.is1d7OrHigher(context.getCompilationUnit().getJavaProject())) {
            return;
        }
        ASTNode coveringNode = problem.getCoveringNode(context.getASTRoot());
        if (coveringNode instanceof MethodInvocation) {
            methodBinding = ((MethodInvocation)coveringNode).resolveMethodBinding();
        } else if (coveringNode instanceof ClassInstanceCreation) {
            methodBinding = ((ClassInstanceCreation)coveringNode).resolveConstructorBinding();
        } else {
            return;
        }
        if (methodBinding == null) {
            return;
        }
        String label = Messages.format(CorrectionMessages.VarargsWarningsSubProcessor_add_safevarargs_to_method_label, methodBinding.getName());
        ITypeBinding declaringType = methodBinding.getDeclaringClass();
        CompilationUnit astRoot = (CompilationUnit)coveringNode.getRoot();
        if (declaringType != null && declaringType.isFromSource()) {
            try {
                T proposal;
                ICompilationUnit targetCu = ASTResolving.findCompilationUnitForBinding(context.getCompilationUnit(), astRoot, declaringType);
                if (targetCu != null && (proposal = this.createAddSafeVarargsToDeclarationProposal1(label, targetCu, null, methodBinding.getMethodDeclaration(), -2)) != null) {
                    proposals.add(proposal);
                }
            }
            catch (JavaModelException e) {
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void createRemoveSafeVarargsProposals(IInvocationContext context, IProblemLocation problem, Collection<T> proposals) {
        void methodDeclaration;
        ASTNode coveringNode = problem.getCoveringNode(context.getASTRoot());
        if (!(coveringNode instanceof MethodDeclaration)) {
            return;
        }
        MethodDeclaration methodDeclaration2 = (MethodDeclaration)coveringNode;
        MarkerAnnotation annotation = null;
        for (ASTNode node : methodDeclaration.modifiers()) {
            if (!(node instanceof MarkerAnnotation) || !"SafeVarargs".equals((annotation = (MarkerAnnotation)node).resolveAnnotationBinding().getName())) continue;
        }
        if (annotation == null) {
            return;
        }
        ASTRewrite rewrite = ASTRewrite.create((AST)coveringNode.getAST());
        rewrite.remove(annotation, null);
        String label = CorrectionMessages.VarargsWarningsSubProcessor_remove_safevarargs_label;
        T proposal = this.createRemoveSafeVarargsProposal1(label, context.getCompilationUnit(), rewrite, 5);
        if (proposal != null) {
            proposals.add(proposal);
        }
    }

    protected abstract T createAddSafeVarargsProposal1(String var1, ICompilationUnit var2, MethodDeclaration var3, IMethodBinding var4, int var5);

    protected abstract T createAddSafeVarargsToDeclarationProposal1(String var1, ICompilationUnit var2, Object var3, IMethodBinding var4, int var5);

    protected abstract T createRemoveSafeVarargsProposal1(String var1, ICompilationUnit var2, ASTRewrite var3, int var4);
}

