/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.ecore.delegates;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.ParserRuleReturnScope;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.TreeAdaptor;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.parse.EpsilonParser;
import org.eclipse.epsilon.common.parse.EpsilonTreeAdaptor;
import org.eclipse.epsilon.common.parse.IdentifiableCommonTokenStream;
import org.eclipse.epsilon.common.parse.Lexer;
import org.eclipse.epsilon.common.parse.Position;
import org.eclipse.epsilon.common.parse.problem.ParseProblem;
import org.eclipse.epsilon.common.util.AstUtil;
import org.eclipse.epsilon.ecore.delegates.DelegateContext;
import org.eclipse.epsilon.ecore.delegates.DelegateUri;
import org.eclipse.epsilon.ecore.delegates.execution.Program;
import org.eclipse.epsilon.ecore.delegates.notify.DelegateResourceAdapter;
import org.eclipse.epsilon.eol.IEolModule;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.tools.EolSystem;
import org.eclipse.epsilon.eol.util.ReflectionUtil;

public abstract class EpsilonDelegateContext<M extends IEolModule, R>
implements DelegateContext {
    protected final M module;
    protected final DelegateUri uri;
    private final EPackage ePackage;
    private final DelegateResourceAdapter delegateRA;
    private final String mainParserRule;

    public EpsilonDelegateContext(DelegateUri delegateURI, EPackage ePackage, DelegateResourceAdapter delegateRA, M module, String mainParserRule) {
        this.uri = delegateURI;
        this.ePackage = ePackage;
        this.delegateRA = delegateRA;
        this.module = module;
        this.mainParserRule = mainParserRule;
        Resource res = ePackage.eResource();
        EPackage.Registry packageRegistry = null;
        if (res != null) {
            this.delegateRA.adapt(res);
            ResourceSet resourceSet = res.getResourceSet();
            if (resourceSet != null) {
                packageRegistry = resourceSet.getPackageRegistry();
            }
        }
        if (packageRegistry == null) {
            packageRegistry = EPackage.Registry.INSTANCE;
        }
        this.prepareContext();
    }

    @Override
    public void dispose() {
        this.module.getContext().dispose();
    }

    public String toString() {
        return String.valueOf(this.ePackage.getName()) + " : " + this.uri;
    }

    public Program<R> parse(String code) {
        org.antlr.runtime.Lexer lexer;
        this.preParse();
        String contents = code.trim();
        ByteArrayInputStream noTabsStream = new ByteArrayInputStream(contents.replaceAll("\t", " ").getBytes());
        try {
            lexer = this.createLexer(new ANTLRInputStream((InputStream)noTabsStream));
        }
        catch (IOException e) {
            return this.error(e);
        }
        IdentifiableCommonTokenStream stream = new IdentifiableCommonTokenStream((TokenSource)lexer);
        List<CommonToken> comments = this.extractComments((CommonTokenStream)stream);
        EpsilonTreeAdaptor adaptor = new EpsilonTreeAdaptor(null, this.module);
        EpsilonParser parser = this.createParser((TokenStream)stream);
        parser.setDeepTreeAdaptor((TreeAdaptor)adaptor);
        parser.getParseProblems().addAll(((Lexer)lexer).getParseProblems());
        return this.invokeMainParserRule(parser, comments);
    }

    protected abstract Program<R> program();

    protected abstract EpsilonParser createParser(TokenStream var1);

    protected abstract org.antlr.runtime.Lexer createLexer(ANTLRInputStream var1) throws IOException;

    protected abstract void preParse();

    protected abstract void createAst(AST var1);

    protected abstract Program<R> program(List<ParseProblem> var1);

    private Program<R> invokeMainParserRule(EpsilonParser parser, List<CommonToken> comments) {
        AST cst = null;
        try {
            cst = (AST)((ParserRuleReturnScope)ReflectionUtil.executeMethod((Object)parser, (String)this.mainParserRule, (Object[])new Object[0])).getTree();
        }
        catch (RecognitionException ex) {
            return this.error(ex);
        }
        catch (Throwable ex) {
            return this.error(ex, parser.input.LT(1));
        }
        ArrayList<ParseProblem> parseProblems = new ArrayList<ParseProblem>(parser.getParseProblems());
        this.assignAnnotations(cst);
        this.assignComments(cst, comments);
        this.createAst(cst);
        return this.program(parseProblems);
    }

    private Program<R> error(IOException ex) {
        return this.program().error(ex);
    }

    private Program<R> error(Throwable ex, Token next) {
        return this.program().error(ex, next);
    }

    private Program<R> error(RecognitionException ex) {
        return this.program().error(ex);
    }

    private void assignComments(AST root, List<CommonToken> comments) {
        for (CommonToken comment : comments) {
            this.assignComment(root, comment);
        }
    }

    private void assignComment(AST root, CommonToken comment) {
        for (AST ast : root.getDescendants()) {
            Position start = ast.getRegion().getStart();
            if (ast.isImaginary() || comment.getLine() > start.getLine() || comment.getCharPositionInLine() > start.getColumn()) continue;
            ast.getCommentTokens().add(comment);
            return;
        }
    }

    private void assignAnnotations(AST ast) {
        List children = AstUtil.getChildren((AST)ast);
        for (AST child : children) {
            if (child.getType() == 55) {
                AST target = null;
                if (child.getNextSibling() != null) {
                    if (child.getNextSibling().getType() != 67) {
                        target = child.getNextSibling();
                    } else if (child.getNextSibling().getNextSibling() != null) {
                        target = child.getNextSibling().getNextSibling();
                    }
                }
                if (target == null) continue;
                target.setAnnotationsAst(child);
                continue;
            }
            this.assignAnnotations(child);
        }
    }

    private List<CommonToken> extractComments(CommonTokenStream stream) {
        ArrayList<CommonToken> comments = new ArrayList<CommonToken>();
        if (stream.size() == 0) {
            stream.toString();
        }
        for (Object t : stream.getTokens()) {
            CommonToken token = (CommonToken)t;
            int type = token.getType();
            if (type != 25 && type != 26) continue;
            comments.add(token);
        }
        return comments;
    }

    private void prepareContext() {
        IEolContext context = this.module.getContext();
        EolSystem system = new EolSystem();
        system.setContext(context);
        context.setModule(this.module);
        context.getFrameStack().putGlobal(new Variable[]{Variable.createReadOnlyVariable((String)"null", null), Variable.createReadOnlyVariable((String)"System", (Object)system)});
    }
}

