/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.rdf.emf;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.InfModel;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.epsilon.rdf.emf.IDisableable;
import org.eclipse.epsilon.rdf.emf.RDFDeserializer;
import org.eclipse.epsilon.rdf.emf.RDFGraphResourceNotificationAdapterChangeRDF;
import org.eclipse.epsilon.rdf.emf.RDFGraphResourceUpdate;
import org.eclipse.epsilon.rdf.emf.config.RDFResourceConfiguration;
import org.eclipse.epsilon.rdf.emf.config.RDFResourceConfigurationIO;
import org.eclipse.epsilon.rdf.validation.RDFValidation;
import org.eclipse.epsilon.rdf.validation.RDFValidationException;

public class RDFGraphResourceImpl
extends ResourceImpl {
    private static final Optional<Method> GET_FILE_LOCATOR;
    private static final boolean NOTIFICATION_TRACE = false;
    private RDFResourceConfiguration config = new RDFResourceConfiguration();
    private boolean isConfigSaved = false;
    private RDFDeserializer deserializer;
    private RDFGraphResourceUpdate rdfGraphUpdater;
    private Dataset dataModelSet;

    static {
        Optional<Object> result = Optional.empty();
        try {
            Class<?> fileLocatorKlazz = Class.forName("org.eclipse.core.runtime.FileLocator");
            result = Optional.of(fileLocatorKlazz.getMethod("toFileURL", URL.class));
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        GET_FILE_LOCATOR = result;
    }

    public RDFGraphResourceImpl() {
        this.eAdapters().add((Object)new RDFGraphResourceNotificationAdapterChangeRDF(this));
    }

    public boolean isConfigSaved() {
        return this.isConfigSaved;
    }

    public void setConfigSaved(boolean isConfigSaved) {
        this.isConfigSaved = isConfigSaved;
    }

    protected void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        if (this.getURI().isRelative()) {
            throw new IllegalArgumentException("URI must be absolute");
        }
        this.config = RDFResourceConfigurationIO.load(inputStream);
        OntModel rdfOntModel = this.loadRDFModels();
        this.initializeFromRDFModel((Model)rdfOntModel);
    }

    protected void initializeFromRDFModel(Model rdfOntModel) {
        try {
            this.setDisabledForAdapters(true);
            this.deserializer = new RDFDeserializer(() -> {
                if (this.getResourceSet() != null) {
                    return this.getResourceSet().getPackageRegistry();
                }
                return EPackage.Registry.INSTANCE;
            });
            this.deserializer.deserialize(rdfOntModel);
            for (EObject eob : this.deserializer.getEObjectToResourceMap().keySet()) {
                if (eob.eContainer() != null) continue;
                this.getContents().add((Object)eob);
            }
        }
        finally {
            this.setDisabledForAdapters(false);
        }
        this.rdfGraphUpdater = new RDFGraphResourceUpdate(this.deserializer, this);
    }

    protected void doUnload() {
        this.setDisabledForAdapters(true);
        this.deserializer = null;
        this.rdfGraphUpdater = null;
        this.dataModelSet = null;
        super.doUnload();
    }

    protected void setDisabledForAdapters(boolean isDisabled) {
        this.eAdapters().forEach(a -> {
            if (a instanceof IDisableable) {
                ((IDisableable)a).setDisabled(isDisabled);
            }
        });
    }

    protected RDFGraphResourceUpdate getRDFGraphUpdater() {
        return this.rdfGraphUpdater;
    }

    private void storeDatasetNamedModels(Dataset dataset, String namedModelURI, URL targetURL) throws IOException {
        block14: {
            if (dataset.containsNamedModel(namedModelURI)) {
                Model modelToSave = dataset.getNamedModel(namedModelURI);
                Lang lang = RDFDataMgr.determineLang((String)namedModelURI, null, null);
                if (lang == null) {
                    lang = Lang.TTL;
                }
                if ("file".equals(targetURL.getProtocol()) || targetURL.getProtocol() == null) {
                    try {
                        Throwable throwable = null;
                        Object var7_9 = null;
                        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(new File(targetURL.toURI())));){
                            RDFDataMgr.write((OutputStream)out, (Model)modelToSave, (Lang)lang);
                            ((OutputStream)out).close();
                            break block14;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (URISyntaxException e) {
                        throw new IOException(e);
                    }
                }
                throw new IOException("Protocol " + targetURL.getProtocol() + " is not supported");
            }
            System.err.printf("Cannot find named model URI: %s\n", namedModelURI);
        }
    }

    public void save(Map<?, ?> options) throws IOException {
        if (this.isConfigSaved) {
            String pathRdfRes = this.getFilePathForURI();
            if (pathRdfRes == null) {
                throw new IllegalStateException("Cannot save configuration to a non-file URI");
            }
            File fRdfRes = new File(pathRdfRes);
            Throwable throwable = null;
            Object var5_6 = null;
            try (FileWriter w = new FileWriter(fRdfRes);){
                RDFResourceConfigurationIO.save(this.config, w);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        Iterator namedModels = this.dataModelSet.listModelNames();
        while (namedModels.hasNext()) {
            Resource m = (Resource)namedModels.next();
            URL url = new URL(m.getURI());
            try {
                this.storeDatasetNamedModels(this.dataModelSet, m.getURI(), this.convertToFileURL(url));
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }
    }

    public Resource getRDFResource(EObject eob) {
        return this.deserializer.getRDFResource(eob);
    }

    public Collection<Resource> getRDFResources() {
        return this.deserializer.getRDFResources();
    }

    public Collection<EObject> getEObjects(Resource resource) {
        return this.deserializer.getEObjects(resource);
    }

    public EObject createInstanceAt(EClass eClass, String iri) {
        EObject eob = eClass.getEPackage().getEFactoryInstance().create(eClass);
        this.ensureGraphExists();
        List<Resource> resNamedModels = this.getResourcesForAllNamedModels();
        if (resNamedModels.isEmpty()) {
            throw new IllegalStateException("No named model in which to create the RDF resource");
        }
        for (Resource resNamedModel : resNamedModels) {
            this.rdfGraphUpdater.createNewEObjectResource(this.getNamedModel(resNamedModel), eob, iri);
        }
        this.getContents().add((Object)eob);
        return eob;
    }

    protected OntModel loadRDFModels() throws IOException {
        Dataset schemaModelSet = this.loadRDFModels(this.config.getSchemaModels());
        Model rdfSchemaModel = schemaModelSet.getUnionModel();
        this.dataModelSet = this.loadRDFModels(this.config.getDataModels());
        Model rdfDataModel = this.dataModelSet.getUnionModel();
        InfModel infModel = ModelFactory.createRDFSModel((Model)rdfSchemaModel, (Model)rdfDataModel);
        OntModel rdfOntModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM_RULE_INF, (Model)infModel);
        RDFValidation.ValidationMode.RDFModelValidationReport result = this.getConfig().getRawValidationMode().validate(rdfOntModel);
        if (!result.isValid()) {
            throw new RDFValidationException(result.getText());
        }
        return rdfOntModel;
    }

    protected Dataset loadRDFModels(Collection<String> uris) throws IOException, MalformedURLException {
        Dataset newDataset = null;
        ArrayList<String> namedModelSources = new ArrayList<String>();
        for (String sURI : uris) {
            URI uri = URI.createURI((String)sURI);
            if (uri.isRelative()) {
                uri = uri.resolve(this.getURI());
            }
            if ("platform".equals(uri.scheme()) && GET_FILE_LOCATOR.isPresent()) {
                try {
                    URL convertedURL = this.convertToFileURL(new URL(uri.toString()));
                    namedModelSources.add(convertedURL.toString());
                    continue;
                }
                catch (URISyntaxException e) {
                    throw new IOException(e);
                }
            }
            namedModelSources.add(uri.toString());
        }
        newDataset = !namedModelSources.isEmpty() ? DatasetFactory.createNamed(namedModelSources) : DatasetFactory.create();
        return newDataset;
    }

    public RDFResourceConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(RDFResourceConfiguration config) {
        this.config = config;
    }

    public List<Resource> getResourcesForNamedModelsContaining(EObject eObject) {
        Resource res = this.getRDFResource(eObject);
        return this.getResourcesForNamedModelsContaining(res);
    }

    public List<Resource> getResourcesForNamedModelsContaining(Resource res) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        if (this.dataModelSet != null && res != null) {
            Iterator namedModels = this.dataModelSet.listModelNames();
            namedModels.forEachRemaining(m -> {
                Model model = this.dataModelSet.getNamedModel(m);
                if (model.containsResource((RDFNode)res)) {
                    resources.add((Resource)m);
                }
            });
        }
        return resources;
    }

    public Model getNamedModel(Resource model) {
        return this.dataModelSet.getNamedModel(model);
    }

    public Model getFirstNamedModel() {
        return this.dataModelSet.getNamedModel(this.getResourcesForAllNamedModels().get(0));
    }

    public Resource getFirstNamedModelResource() {
        return this.getResourcesForAllNamedModels().get(0);
    }

    public List<Model> getNamedModels(List<Resource> namedModelURIs) {
        ArrayList<Model> namedModels = new ArrayList<Model>();
        for (Resource model : namedModelURIs) {
            namedModels.add(this.dataModelSet.getNamedModel(model));
        }
        return namedModels;
    }

    public List<Resource> getResourcesForAllNamedModels() {
        ArrayList<Resource> modelResourceList = new ArrayList<Resource>();
        this.dataModelSet.listModelNames().forEachRemaining(m -> {
            boolean bl = modelResourceList.add((Resource)m);
        });
        return modelResourceList;
    }

    protected URL convertToFileURL(URL url) throws URISyntaxException {
        if (GET_FILE_LOCATOR.isPresent()) {
            try {
                return (URL)GET_FILE_LOCATOR.get().invoke(null, url);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                System.err.println("Failed to use FileLocator with exception below, using URL as is: ");
                e.printStackTrace();
            }
        }
        return url;
    }

    public void ensureGraphExists() {
        if (this.dataModelSet != null) {
            return;
        }
        this.setConfigSaved(true);
        if (this.config.getDataModels().isEmpty()) {
            if (this.getURI() == null) {
                throw new IllegalStateException("Cannot create in-memory .ttl on the fly for a resource with a null URI");
            }
            String rdfResPath = this.getFilePathForURI();
            if (rdfResPath == null) {
                throw new IllegalStateException("Cannot create in-memory .ttl on the fly for a resource in a non-file URI");
            }
            try {
                File fRdfRes = new File(rdfResPath).getCanonicalFile();
                File fTurtle = new File(fRdfRes.getParentFile(), fRdfRes.getName().replaceAll("[.]rdfres", ".ttl"));
                this.config.getDataModels().add(fTurtle.getName());
            }
            catch (IOException ex) {
                throw new RuntimeException("Could not compute path to .ttl on the fly", ex);
            }
        }
        this.dataModelSet = DatasetFactory.createGeneral();
        for (String sURI : this.config.getDataModels()) {
            URI uri = URI.createURI((String)sURI);
            if (uri.isRelative()) {
                uri = uri.resolve(this.getURI());
            }
            this.dataModelSet = this.dataModelSet.addNamedModel(ResourceFactory.createResource((String)uri.toString()), ModelFactory.createDefaultModel());
        }
        this.initializeFromRDFModel(this.dataModelSet.getUnionModel());
    }

    protected String getFilePathForURI() {
        String rdfResPath = this.getURI().toFileString();
        if ("platform".equals(this.uri.scheme()) && GET_FILE_LOCATOR.isPresent()) {
            try {
                URL fileURL = this.convertToFileURL(new URL(this.uri.toString()));
                if (!"file".equals(fileURL.getProtocol())) {
                    throw new IllegalStateException("Cannot convert the platform: URL to a file: URL - " + String.valueOf(this.uri));
                }
                rdfResPath = URI.createURI((String)fileURL.toString()).toFileString();
            }
            catch (MalformedURLException | URISyntaxException ex) {
                throw new RuntimeException("Invalid URI syntax: " + String.valueOf(this.uri));
            }
        }
        return rdfResPath;
    }
}

