/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.process.normalize;

import org.apache.jena.graph.NodeFactory;
import org.apache.jena.riot.process.normalize.DatatypeHandler;

class NormalizeValueByCode {
    static char NonChar = '\u0000';
    static char CH_ZERO = (char)48;
    static DatatypeHandler dtIntegerCode = (node, lexicalForm, datatype) -> {
        char[] chars = lexicalForm.toCharArray();
        if (chars.length == 0) {
            return node;
        }
        NormalizeValueByCode.stripLeadingPlus(chars);
        NormalizeValueByCode.stripLeadingZeros(chars);
        String lex2 = NormalizeValueByCode.rebuild(chars);
        if (lex2 == null) {
            return node;
        }
        return NodeFactory.createLiteralDT(lex2, datatype);
    };
    static DatatypeHandler dtDecimalCode = (node, lexicalForm, datatype) -> {
        char[] chars = lexicalForm.toCharArray();
        if (chars.length == 0) {
            return node;
        }
        NormalizeValueByCode.stripLeadingPlus(chars);
        NormalizeValueByCode.stripLeadingZeros(chars);
        NormalizeValueByCode.stripTrailingZeros(chars);
        String lex2 = NormalizeValueByCode.rebuild(chars);
        if (lex2 == null) {
            return node;
        }
        return NodeFactory.createLiteralDT(lex2, datatype);
    };

    NormalizeValueByCode() {
    }

    private static void stripLeadingPlus(char[] chars) {
        if (chars[0] == '+') {
            chars[0] = NonChar;
        }
    }

    private static void stripLeadingZeros(char[] chars) {
        int idx = 0;
        if (chars[0] == '-' || chars[0] == NonChar) {
            idx = 1;
        }
        while (idx < chars.length && chars[idx] == CH_ZERO) {
            chars[idx] = NonChar;
            ++idx;
        }
        if (idx == chars.length || chars[idx] == '.') {
            chars[idx - 1] = CH_ZERO;
        }
    }

    private static void stripTrailingZeros(char[] chars) {
        int idx;
        int iDot;
        for (iDot = 0; iDot < chars.length && chars[iDot] != '.'; ++iDot) {
        }
        if (iDot == chars.length) {
            return;
        }
        int start = 0;
        if (chars[0] == '-' || chars[0] == NonChar) {
            start = 1;
        }
        for (idx = chars.length - 1; idx >= start && chars[idx] == CH_ZERO; --idx) {
            chars[idx] = NonChar;
        }
        if (idx == start || chars[idx] == '.') {
            chars[idx - 1] = CH_ZERO;
        }
    }

    private static String rebuild(char[] chars) {
        boolean modified = false;
        int j = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == NonChar) {
                modified = true;
                continue;
            }
            if (!modified) continue;
            chars[j] = chars[i];
            ++j;
        }
        if (!modified) {
            return null;
        }
        return new String(chars, 0, j);
    }
}

