/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dap.variables;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.epsilon.eol.dap.variables.IVariableReference;
import org.eclipse.epsilon.eol.dap.variables.IdentifiableReference;
import org.eclipse.epsilon.eol.dap.variables.SuspendedState;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.types.EolTuple;
import org.eclipse.epsilon.eol.types.EolTupleType;

public class TupleReference
extends IdentifiableReference<EolTuple> {
    private final String name;

    public TupleReference(IEolContext context, String name, EolTuple tuple) {
        super(context, tuple);
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTypeName() {
        return new EolTupleType().getName();
    }

    @Override
    public List<IVariableReference> getVariables(SuspendedState state) {
        ArrayList<IVariableReference> refs = new ArrayList<IVariableReference>(((EolTuple)this.target).size());
        for (Map.Entry entry : ((EolTuple)this.target).entrySet()) {
            refs.add(state.getValueReference(this.context, (String)entry.getKey(), entry.getValue()));
        }
        return refs;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.name);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TupleReference other = (TupleReference)obj;
        return Objects.equals(this.name, other.name);
    }
}

