/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.services.lifecycle;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.util.List;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fx.ui.workbench.services.ELifecycleService;
import org.osgi.service.event.Event;

public class LifecycleAddon {
    public static final String LIFECYCLE_TRANSIENT_KEY = "EFX_LIFECYCLE";
    public static final String LIFECYCLE_TAG_PREFIX = "EFX_LC:";
    private final ELifecycleService lifecycleService;

    @Inject
    public LifecycleAddon(ELifecycleService lifecycleService) {
        this.lifecycleService = lifecycleService;
    }

    @PostConstruct
    void postConstruct(MApplication app, IEventBroker eventBroker) {
        TreeIterator it = EcoreUtil.getAllContents((EObject)((EObject)app), (boolean)true);
        while (it.hasNext()) {
            EObject e = (EObject)it.next();
            if (!(e instanceof MUIElement)) continue;
            this.processLifecycle((MUIElement)e);
        }
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/children/*", this::handleEventTopic);
        eventBroker.subscribe("org/eclipse/e4/ui/model/basic/Window/windows/*", this::handleEventTopic);
        eventBroker.subscribe("org/eclipse/e4/ui/model/advanced/Perspective/windows/*", this::handleEventTopic);
    }

    private void processLifecycle(MUIElement element) {
        if (element instanceof MPartDescriptor) {
            return;
        }
        List tags = element.getTags();
        for (String tag : tags) {
            if (!tag.startsWith(LIFECYCLE_TAG_PREFIX)) continue;
            this.lifecycleService.registerLifecycleURI(element, tag.substring(LIFECYCLE_TAG_PREFIX.length()));
        }
    }

    private void handleEventTopic(Event e) {
        if (UIEvents.isADD((Event)e)) {
            Iterable asIterable = UIEvents.asIterable((Event)e, (String)"NewValue");
            asIterable.forEach(this::processLifecycle);
        }
    }
}

