/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.expressly;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.FunctionMapper;
import jakarta.el.MethodExpression;
import jakarta.el.MethodInfo;
import jakarta.el.MethodNotFoundException;
import jakarta.el.MethodReference;
import jakarta.el.PropertyNotFoundException;
import jakarta.el.VariableMapper;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.glassfish.expressly.lang.EvaluationContext;
import org.glassfish.expressly.lang.ExpressionBuilder;
import org.glassfish.expressly.parser.Node;
import org.glassfish.expressly.util.ReflectionUtil;

public final class MethodExpressionImpl
extends MethodExpression
implements Externalizable {
    private Class<?> expectedType;
    private String expression;
    private FunctionMapper functionMapper;
    private VariableMapper variableMapper;
    private Class<?>[] paramTypes;
    private transient Node node;

    public MethodExpressionImpl() {
    }

    public MethodExpressionImpl(String expr, Node node, FunctionMapper fnMapper, VariableMapper varMapper, Class<?> expectedType, Class<?>[] paramTypes) {
        this.expression = expr;
        this.node = node;
        this.functionMapper = fnMapper;
        this.variableMapper = varMapper;
        this.expectedType = expectedType;
        this.paramTypes = paramTypes;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MethodExpressionImpl) {
            MethodExpressionImpl methodExpressionImpl = (MethodExpressionImpl)obj;
            return this.getNode().equals(methodExpressionImpl.getNode());
        }
        return false;
    }

    public String getExpressionString() {
        return this.expression;
    }

    public MethodInfo getMethodInfo(ELContext context) throws PropertyNotFoundException, MethodNotFoundException, ELException {
        return this.getNode().getMethodInfo(new EvaluationContext(context, this.functionMapper, this.variableMapper), this.paramTypes);
    }

    public MethodReference getMethodReference(ELContext context) {
        EvaluationContext ctx = new EvaluationContext(context, this.functionMapper, this.variableMapper);
        ctx.notifyBeforeEvaluation(this.getExpressionString());
        MethodReference methodReference = this.getNode().getMethodReference(ctx);
        ctx.notifyAfterEvaluation(this.getExpressionString());
        return methodReference;
    }

    private Node getNode() throws ELException {
        if (this.node == null) {
            this.node = ExpressionBuilder.createNode(this.expression);
        }
        return this.node;
    }

    public int hashCode() {
        return this.getNode().hashCode();
    }

    public Object invoke(ELContext context, Object[] params) throws PropertyNotFoundException, MethodNotFoundException, ELException {
        EvaluationContext ctx = new EvaluationContext(context, this.functionMapper, this.variableMapper);
        ctx.notifyBeforeEvaluation(this.expression);
        Object obj = this.getNode().invoke(ctx, this.paramTypes, params);
        ctx.notifyAfterEvaluation(this.expression);
        return obj;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.expression = in.readUTF();
        String type = in.readUTF();
        if (!"".equals(type)) {
            this.expectedType = ReflectionUtil.forName(type);
        }
        this.paramTypes = ReflectionUtil.toTypeArray((String[])in.readObject());
        this.functionMapper = (FunctionMapper)in.readObject();
        this.variableMapper = (VariableMapper)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.expression);
        out.writeUTF(this.expectedType != null ? this.expectedType.getName() : "");
        out.writeObject(ReflectionUtil.toTypeNameArray(this.paramTypes));
        out.writeObject(this.functionMapper);
        out.writeObject(this.variableMapper);
    }

    public boolean isLiteralText() {
        return false;
    }

    public boolean isParametersProvided() {
        return this.getNode().isParametersProvided();
    }
}

