/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.naming.impl;

import com.sun.enterprise.naming.impl.JavaURLContext;
import com.sun.enterprise.naming.impl.ProviderManager;
import com.sun.enterprise.naming.impl.SerialContext;
import com.sun.enterprise.naming.impl.SerialNameParser;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.NamingManager;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.glassfish.api.naming.JNDIBinding;
import org.glassfish.api.naming.NamingObjectProxy;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;
import org.omg.CORBA.ORB;

@Service
@Singleton
public final class GlassfishNamingManagerImpl
implements GlassfishNamingManager {
    public static final String IIOPOBJECT_FACTORY = "com.sun.enterprise.naming.util.IIOPObjectFactory";
    private static final System.Logger LOG = System.getLogger(GlassfishNamingManagerImpl.class.getName());
    @Inject
    private ServiceLocator serviceLocator;
    private final InitialContext initialContext;
    private final NameParser nameParser = new SerialNameParser();
    private final NamespacesMap<String> componentNamespaces;
    private final NamespacesMap<String> appNamespaces;
    private final NamespacesMap<AppModuleKey> moduleNamespaces;
    private final Map<String, ComponentIdInfo> componentIdInfo;
    private InvocationManager invMgr;
    private Context cosContext;

    public GlassfishNamingManagerImpl() throws NamingException {
        this(new InitialContext());
    }

    public GlassfishNamingManagerImpl(InitialContext initialContext) {
        this.initialContext = initialContext;
        this.componentNamespaces = new NamespacesMap("java:comp/");
        this.appNamespaces = new NamespacesMap("java:app/");
        this.moduleNamespaces = new NamespacesMap("java:module/");
        this.componentIdInfo = new HashMap<String, ComponentIdInfo>();
        JavaURLContext.setNamingManager(this);
    }

    void setInvocationManager(InvocationManager invMgr) {
        this.invMgr = invMgr;
    }

    public Context getInitialContext() {
        return this.initialContext;
    }

    public NameParser getNameParser() {
        return this.nameParser;
    }

    public Remote initializeRemoteNamingSupport(ORB orb) throws NamingException {
        Remote remoteProvider;
        try {
            Hashtable<String, String> cosNamingEnv = new Hashtable<String, String>();
            cosNamingEnv.put("java.naming.factory.initial", "org.glassfish.jndi.cosnaming.CNCtxFactory");
            cosNamingEnv.put("java.naming.corba.orb", (String)orb);
            this.cosContext = new InitialContext(cosNamingEnv);
            ProviderManager pm = ProviderManager.getProviderManager();
            remoteProvider = pm.initRemoteProvider(orb);
        }
        catch (RemoteException re) {
            NamingException ne = new NamingException("Exception during remote naming initialization");
            ne.initCause(ne);
            throw ne;
        }
        return remoteProvider;
    }

    private Context getCosContext() {
        return Objects.requireNonNull(this.cosContext, "cosContext was not initialized by initializeRemoteNamingSupport method");
    }

    public void publishObject(SimpleJndiName name, Object obj, boolean rebind) throws NamingException {
        this.publishObject(name.toName(), obj, rebind);
    }

    public void publishObject(Name name, Object obj, boolean rebind) throws NamingException {
        LOG.log(System.Logger.Level.DEBUG, "publishObject(name={0}, obj={1}, rebind={2})", name, obj, rebind);
        if (rebind) {
            this.initialContext.rebind(name, obj);
        } else {
            this.initialContext.bind(name, obj);
        }
    }

    public void publishCosNamingObject(SimpleJndiName name, Object obj, boolean rebind) throws NamingException {
        LOG.log(System.Logger.Level.DEBUG, "publishCosNamingObject(name={0}, obj={1}, rebind={2})", name, obj, rebind);
        Name nameObj = name.toName();
        this.createSubContexts(nameObj, this.getCosContext());
        if (rebind) {
            this.getCosContext().rebind(nameObj, obj);
        } else {
            this.getCosContext().bind(nameObj, obj);
        }
        StringRefAddr addr = new StringRefAddr("url", name.toString());
        Reference serialObj = new Reference("reference", addr, IIOPOBJECT_FACTORY, null);
        this.publishObject(name, (Object)serialObj, rebind);
    }

    public void unpublishObject(Name name) throws NamingException {
        LOG.log(System.Logger.Level.DEBUG, "unpublishObject(name={0})", name);
        this.initialContext.unbind(name);
    }

    public void unpublishObject(SimpleJndiName name) throws NamingException {
        LOG.log(System.Logger.Level.DEBUG, "unpublishObject(name={0})", name);
        this.initialContext.unbind(name.toName());
    }

    public void unpublishCosNamingObject(SimpleJndiName name) throws NamingException {
        LOG.log(System.Logger.Level.DEBUG, "unpublishCosNamingObject(name={0})", name);
        try {
            this.getCosContext().unbind(name.toName());
        }
        catch (NamingException cne) {
            LOG.log(System.Logger.Level.WARNING, "Error during CosNaming.unbind for name: " + String.valueOf(name), (Throwable)cne);
        }
        this.initialContext.unbind(name.toString());
    }

    private void createSubContexts(Name name, Context rootCtx) throws NamingException {
        int numSubContexts = name.size() - 1;
        Context currentCtx = rootCtx;
        for (int subCtxIndex = 0; subCtxIndex < numSubContexts; ++subCtxIndex) {
            String subCtxName = name.get(subCtxIndex);
            try {
                Object obj = currentCtx.lookup(subCtxName);
                if (obj == null) {
                    currentCtx = currentCtx.createSubcontext(subCtxName);
                    continue;
                }
                if (obj instanceof Context) {
                    currentCtx = (Context)obj;
                    continue;
                }
                throw new NameAlreadyBoundException(subCtxName);
            }
            catch (NameNotFoundException e) {
                currentCtx = currentCtx.createSubcontext(subCtxName);
            }
        }
    }

    private JavaNamespace getComponentNamespace(String componentId) {
        JavaNamespace namespace = (JavaNamespace)this.componentNamespaces.get(componentId);
        if (namespace == null) {
            namespace = new JavaNamespace(componentId, "comp");
            this.componentNamespaces.put(componentId, namespace);
        }
        return namespace;
    }

    private JavaNamespace getModuleNamespace(AppModuleKey appModuleKey) throws NamingException {
        if (appModuleKey.getAppName() == null || appModuleKey.getModuleName() == null) {
            throw new NamingException("Invalid appModuleKey " + String.valueOf(appModuleKey));
        }
        JavaNamespace namespace = (JavaNamespace)this.moduleNamespaces.get(appModuleKey);
        if (namespace == null) {
            namespace = new JavaNamespace(appModuleKey.toString(), "module");
            this.moduleNamespaces.put(appModuleKey, namespace);
        }
        return namespace;
    }

    public <T> T lookupFromAppNamespace(String appName, SimpleJndiName name, Hashtable<?, ?> env) throws NamingException {
        LOG.log(System.Logger.Level.TRACE, "lookupFromAppNamespace(appName={0}, name={1}, env)", appName, name);
        JavaNamespace namespace = this.getAppNamespace(appName);
        return this.lookupFromNamespace(name, namespace, env);
    }

    public <T> T lookupFromModuleNamespace(String appName, String moduleName, SimpleJndiName name, Hashtable<?, ?> env) throws NamingException {
        LOG.log(System.Logger.Level.TRACE, "lookupFromModuleNamespace(appName={0}, moduleName={1}, name={2}, env)", appName, moduleName, name);
        AppModuleKey appModuleKey = new AppModuleKey(appName, moduleName);
        JavaNamespace namespace = this.getModuleNamespace(appModuleKey);
        return this.lookupFromNamespace(name, namespace, env);
    }

    private <T> T getObjectInstance(SimpleJndiName name, Object obj, Hashtable<?, ?> env) throws Exception {
        LOG.log(System.Logger.Level.DEBUG, "getObjectInstance(name={0}, obj, env={1})", name, env);
        if (env == null) {
            env = new Hashtable();
        }
        return (T)NamingManager.getObjectInstance(obj, name.toName(), null, env);
    }

    private JavaNamespace getAppNamespace(String appName) throws NamingException {
        LOG.log(System.Logger.Level.TRACE, "getAppNamespace(appName={0})", appName);
        if (appName == null) {
            throw new NamingException("Null appName");
        }
        JavaNamespace namespace = (JavaNamespace)this.appNamespaces.get(appName);
        if (namespace == null) {
            namespace = new JavaNamespace(appName, "app");
            this.appNamespaces.put(appName, namespace);
        }
        return namespace;
    }

    private JavaNamespace getNamespace(ComponentIdInfo info, SimpleJndiName logicalJndiName) throws NamingException {
        LOG.log(System.Logger.Level.TRACE, "getNamespace(info, logicalJndiName={0})", logicalJndiName);
        if (logicalJndiName.isJavaModule()) {
            return this.getModuleNamespace(new AppModuleKey(info.appName, info.moduleName));
        }
        if (logicalJndiName.isJavaApp()) {
            return this.getAppNamespace(info.appName);
        }
        return this.getComponentNamespace(info.componentId);
    }

    private void bindToNamespace(JavaNamespace namespace, SimpleJndiName jndiName, Object value, boolean force) throws NamingException {
        LOG.log(System.Logger.Level.DEBUG, "bindToNamespace(namespace.name={0}, jndiName={1}, value={2}, force={3})", namespace.name, jndiName, value, force);
        if (force) {
            if (namespace.put(jndiName, value) != null) {
                LOG.log(System.Logger.Level.WARNING, "Replaced existing binding for ''{0}'' in namespace ''{1}''", jndiName, namespace.name);
            }
        } else if (namespace.putIfAbsent(jndiName, value) != null) {
            LOG.log(System.Logger.Level.TRACE, "The namespace already contains binding for ''{0}'' in namespace ''{1}'', ignoring request.", jndiName, namespace.name);
            return;
        }
        this.bindIntermediateContexts(namespace, jndiName);
    }

    public void bindToComponentNamespace(String appName, String moduleName, String componentId, boolean treatComponentAsModule, Collection<? extends JNDIBinding> bindings) throws NamingException {
        LOG.log(System.Logger.Level.DEBUG, "bindToComponentNamespace(appName={0}, moduleName={1}, componentId={2}, treatComponentAsModule={3}, bindings={4})", appName, moduleName, componentId, treatComponentAsModule, bindings);
        if (appName != null && moduleName != null) {
            ComponentIdInfo info = new ComponentIdInfo();
            info.appName = appName;
            info.moduleName = moduleName;
            info.componentId = componentId;
            info.treatComponentAsModule = treatComponentAsModule;
            this.componentIdInfo.put(componentId, info);
        }
        for (JNDIBinding jNDIBinding : bindings) {
            SimpleJndiName logicalJndiName = treatComponentAsModule && jNDIBinding.getName().isJavaComponent() ? jNDIBinding.getName().changePrefix("java:module/") : jNDIBinding.getName();
            JavaNamespace namespace = logicalJndiName.isJavaComponent() ? this.getComponentNamespace(componentId) : (logicalJndiName.isJavaModule() ? this.getModuleNamespace(new AppModuleKey(appName, moduleName)) : (logicalJndiName.isJavaApp() ? this.getAppNamespace(appName) : null));
            if (namespace == null) {
                LOG.log(System.Logger.Level.WARNING, "No namespace found for appName={0}, moduleName={1}, componentId={2}", appName, moduleName, componentId);
                return;
            }
            this.bindToNamespace(namespace, logicalJndiName, jNDIBinding.getValue(), false);
        }
    }

    public void bindToModuleNamespace(String appName, String moduleName, Collection<? extends JNDIBinding> bindings) throws NamingException {
        LOG.log(System.Logger.Level.TRACE, "bindToModuleNamespace(appName={0}, moduleName={1}, bindings={2})", appName, moduleName, bindings);
        AppModuleKey appModuleKey = new AppModuleKey(appName, moduleName);
        JavaNamespace namespace = this.getModuleNamespace(appModuleKey);
        for (JNDIBinding jNDIBinding : bindings) {
            SimpleJndiName logicalJndiName = jNDIBinding.getName();
            if (!logicalJndiName.isJavaModule()) continue;
            this.bindToNamespace(namespace, logicalJndiName, jNDIBinding.getValue(), true);
        }
    }

    public void bindToAppNamespace(String appName, Collection<? extends JNDIBinding> bindings) throws NamingException {
        LOG.log(System.Logger.Level.TRACE, "bindToAppNamespace(appName={0}, bindings={1})", appName, bindings);
        JavaNamespace namespace = this.getAppNamespace(appName);
        for (JNDIBinding jNDIBinding : bindings) {
            SimpleJndiName logicalJndiName = jNDIBinding.getName();
            if (!logicalJndiName.isJavaApp()) continue;
            this.bindToNamespace(namespace, logicalJndiName, jNDIBinding.getValue(), true);
        }
    }

    private void bindIntermediateContexts(JavaNamespace namespace, SimpleJndiName jndiName) throws NamingException {
        String partialName;
        LOG.log(System.Logger.Level.TRACE, "bindIntermediateContexts(namespace.name={0}, jndiName={1})", namespace.name, jndiName);
        if (jndiName.isJavaComponent()) {
            partialName = "java:comp";
        } else if (jndiName.isJavaModule()) {
            partialName = "java:module";
        } else if (jndiName.isJavaApp()) {
            partialName = "java:app";
        } else {
            throw new NamingException("Invalid environment namespace name: " + String.valueOf(jndiName));
        }
        String name = jndiName.toString().substring(partialName.length() + 1);
        StringTokenizer toks = new StringTokenizer(name, "/", false);
        StringBuilder sb = new StringBuilder();
        sb.append(partialName);
        while (toks.hasMoreTokens()) {
            String tok = toks.nextToken();
            sb.append('/').append(tok);
            SimpleJndiName nsJndiName = new SimpleJndiName(sb.toString());
            if (namespace.get(nsJndiName) != null) continue;
            namespace.put(nsJndiName, new JavaURLContext(nsJndiName));
        }
    }

    public void unbindComponentObjects(String componentId) throws NamingException {
        LOG.log(System.Logger.Level.DEBUG, "unbindComponentObjects(componentId={0})", componentId);
        this.componentNamespaces.remove(componentId);
        this.componentIdInfo.remove(componentId);
    }

    public void unbindAppObjects(String appName) throws NamingException {
        LOG.log(System.Logger.Level.DEBUG, "unbindAppObjects(appName={0})", appName);
        this.appNamespaces.remove(appName);
        Iterator keys = this.moduleNamespaces.keySet().iterator();
        while (keys.hasNext()) {
            AppModuleKey key = (AppModuleKey)keys.next();
            if (!key.getAppName().equals(appName)) continue;
            keys.remove();
        }
    }

    public void unbindAppObject(String appName, SimpleJndiName name) throws NamingException {
        LOG.log(System.Logger.Level.DEBUG, "unbindAppObject(appName={0}, name={1})", appName, name);
        Map namespaces = (Map)this.appNamespaces.get(appName);
        if (namespaces != null) {
            namespaces.remove(name);
        }
    }

    public void unbindModuleObject(String appName, String moduleName, SimpleJndiName name) throws NamingException {
        LOG.log(System.Logger.Level.DEBUG, "unbindModuleObject(appName={0}, moduleName={1}, name={2})", appName, moduleName, name);
        AppModuleKey appModuleKey = new AppModuleKey(appName, moduleName);
        Map namespaces = (Map)this.moduleNamespaces.get(appModuleKey);
        if (namespaces != null) {
            namespaces.remove(name);
        }
    }

    public Context restoreJavaCompEnvContext(SimpleJndiName contextName) throws NamingException {
        if (contextName.hasJavaPrefix()) {
            return new JavaURLContext(contextName);
        }
        throw new NamingException("Invalid context name [" + String.valueOf(contextName) + "]. Name must start with java:");
    }

    public <T> T lookup(SimpleJndiName name) throws NamingException {
        return (T)this.initialContext.lookup(name.toName());
    }

    public <T> T lookupFromComponentNamespace(SimpleJndiName name) throws NamingException {
        String componentId = this.getComponentId();
        return this.lookup(componentId, name, this.initialContext);
    }

    public <T> T lookup(SimpleJndiName name, SerialContext serialContext) throws NamingException {
        Context context = serialContext == null ? this.initialContext : serialContext;
        String componentId = this.getComponentId();
        return this.lookup(componentId, name, context);
    }

    public <T> T lookup(String componentId, SimpleJndiName name) throws NamingException {
        return this.lookup(componentId, name, this.initialContext);
    }

    private <T> T lookup(String componentId, SimpleJndiName name, Context ctx) throws NamingException {
        LOG.log(System.Logger.Level.DEBUG, "lookup(componentId={0}, name={1}, ctx={2})", componentId, name, ctx);
        ComponentIdInfo info = this.componentIdInfo.get(componentId);
        LOG.log(System.Logger.Level.TRACE, "Found componentIdInfo={0}", info);
        boolean replaceName = info != null && info.treatComponentAsModule && name.isJavaComponent();
        SimpleJndiName replacedName = replaceName ? name.changePrefix("java:module/") : name;
        JavaNamespace namespace = info == null ? this.getComponentNamespace(componentId) : this.getNamespace(info, replacedName);
        Object obj = namespace.get(replacedName);
        LOG.log(System.Logger.Level.TRACE, "For {0} found object={1} in namespace.name={2}", replacedName, obj, namespace.name);
        if (obj == null) {
            throw new NameNotFoundException("No object bound to name " + String.valueOf(replacedName) + " in namespace " + String.valueOf(namespace));
        }
        if (obj instanceof NamingObjectProxy) {
            NamingObjectProxy namingProxy = (NamingObjectProxy)obj;
            return (T)namingProxy.create(ctx);
        }
        if (obj instanceof Context) {
            if (replaceName) {
                obj = new JavaURLContext(name);
            }
            if (obj instanceof JavaURLContext) {
                if (ctx instanceof SerialContext) {
                    return (T)new JavaURLContext((JavaURLContext)obj, (SerialContext)ctx);
                }
                return (T)new JavaURLContext((JavaURLContext)obj);
            }
        }
        return (T)obj;
    }

    public NamingEnumeration<NameClassPair> list(SimpleJndiName name) throws NamingException {
        ArrayList<SimpleJndiName> list = this.listNames(name);
        return new BindingsIterator<NameClassPair>(this, list.iterator(), true);
    }

    public NamingEnumeration<Binding> listBindings(SimpleJndiName name) throws NamingException {
        ArrayList<SimpleJndiName> list = this.listNames(name);
        return new BindingsIterator<Binding>(this, list.iterator(), false);
    }

    private ArrayList<SimpleJndiName> listNames(SimpleJndiName name) throws NamingException {
        boolean replaceName;
        SimpleJndiName logicalJndiName;
        String componentId;
        ComponentIdInfo info;
        JavaNamespace namespace = info == null ? this.getComponentNamespace(componentId) : this.getNamespace(info, logicalJndiName);
        Object obj = namespace.get(logicalJndiName = (replaceName = (info = this.componentIdInfo.get(componentId = this.getComponentId())) != null && info.treatComponentAsModule && name.isJavaComponent()) ? name.changePrefix("java:module/") : name);
        if (obj == null) {
            throw new NameNotFoundException("No object bound to name " + String.valueOf(name) + " in namespace " + String.valueOf(namespace));
        }
        if (!(obj instanceof JavaURLContext)) {
            throw new NotContextException(String.valueOf(name) + " cannot be listed");
        }
        ArrayList<SimpleJndiName> list = new ArrayList<SimpleJndiName>();
        Object logicalNameWithSlash = logicalJndiName.hasSuffix("/") ? logicalJndiName.toString() : String.valueOf(logicalJndiName) + "/";
        for (SimpleJndiName key : namespace.keySet()) {
            if (!key.hasPrefix((String)logicalNameWithSlash) || key.toString().indexOf(47, ((String)logicalNameWithSlash).length()) != -1 || key.toString().equals(logicalNameWithSlash)) continue;
            SimpleJndiName toAdd = replaceName ? key.changePrefix("java:comp/") : key;
            list.add(toAdd);
        }
        return list;
    }

    private String getComponentId() throws NamingException {
        ComponentInvocation invocation = this.invMgr == null ? ((InvocationManager)this.serviceLocator.getService(InvocationManager.class, new Annotation[0])).getCurrentInvocation() : this.invMgr.getCurrentInvocation();
        if (invocation == null) {
            throw new NamingException("Invocation exception: Got null ComponentInvocation!");
        }
        String id = invocation.getComponentId();
        if (id == null) {
            throw new NamingException("Invocation exception: Got null ComponentId!");
        }
        return id;
    }

    private <T> T lookupFromNamespace(SimpleJndiName name, Map<SimpleJndiName, Object> namespace, Hashtable<?, ?> env) throws NamingException {
        Object objectOrProxyOrRef = namespace.get(name);
        if (objectOrProxyOrRef == null) {
            throw new NameNotFoundException("No object bound to name " + String.valueOf(name));
        }
        if (objectOrProxyOrRef instanceof NamingObjectProxy) {
            NamingObjectProxy namingProxy = (NamingObjectProxy)objectOrProxyOrRef;
            return (T)namingProxy.create((Context)(env == null || env.isEmpty() ? this.initialContext : new InitialContext(env)));
        }
        if (objectOrProxyOrRef instanceof Reference) {
            try {
                return this.getObjectInstance(name, objectOrProxyOrRef, env);
            }
            catch (Exception e) {
                LOG.log(System.Logger.Level.DEBUG, () -> "Unable to get Object instance from Reference for name [" + String.valueOf(name) + "]. Hence returning the Reference object " + String.valueOf(objectOrProxyOrRef), (Throwable)e);
            }
        }
        return (T)objectOrProxyOrRef;
    }

    private static class NamespacesMap<K extends Serializable>
    extends HashMap<K, JavaNamespace> {
        private static final long serialVersionUID = 7921214769289453089L;
        private final String name;

        private NamespacesMap(String name) {
            this.name = name;
        }

        @Override
        public String toString() {
            return "NamespacesMap[name=" + this.name + ", keys=" + String.valueOf(this.keySet()) + "]";
        }
    }

    private static class JavaNamespace
    extends HashMap<SimpleJndiName, Object> {
        private static final long serialVersionUID = 8493699306782159175L;
        private final String name;

        private JavaNamespace(String name, String subContextName) {
            this.name = name;
            SimpleJndiName javaJndi = new SimpleJndiName("java:");
            JavaURLContext javaContext = new JavaURLContext(javaJndi);
            this.put(javaJndi, javaContext);
            this.put(new SimpleJndiName(String.valueOf(javaJndi) + "/"), javaContext);
            JavaURLContext subContext = new JavaURLContext(new SimpleJndiName(String.valueOf(javaJndi) + subContextName));
            this.put(subContext.getName(), subContext);
            SimpleJndiName subContextJndi = new SimpleJndiName(String.valueOf(subContext.getName()) + "/");
            this.put(subContextJndi, subContext);
            JavaURLContext envContext = new JavaURLContext(new SimpleJndiName(String.valueOf(subContextJndi) + "env"));
            this.put(envContext.getName(), envContext);
            this.put(new SimpleJndiName(String.valueOf(envContext.getName()) + "/"), envContext);
        }

        @Override
        public String toString() {
            return "JavaNamespace[name=" + this.name + ", keys=" + String.valueOf(this.keySet()) + "]";
        }
    }

    private static class AppModuleKey
    implements Serializable {
        private static final long serialVersionUID = -6080646413719869870L;
        private final String app;
        private final String module;

        public AppModuleKey(String appName, String moduleName) {
            this.app = appName;
            this.module = moduleName;
        }

        public String getAppName() {
            return this.app;
        }

        public String getModuleName() {
            return this.module;
        }

        public boolean equals(Object o) {
            if (o != null && o instanceof AppModuleKey) {
                AppModuleKey other = (AppModuleKey)o;
                return this.app.equals(other.app) && this.module.equals(other.module);
            }
            return false;
        }

        public int hashCode() {
            return this.app.hashCode();
        }

        public String toString() {
            return this.app + "/" + this.module;
        }
    }

    private static class ComponentIdInfo {
        String appName;
        String moduleName;
        String componentId;
        boolean treatComponentAsModule;

        private ComponentIdInfo() {
        }

        public String toString() {
            return "ComponentIdInfo[appName=" + this.appName + ", module=" + this.moduleName + ", componentId=" + this.componentId + ", treatComponentAsModule=" + this.treatComponentAsModule + "]";
        }
    }

    private static class BindingsIterator<T>
    implements NamingEnumeration<T> {
        private final GlassfishNamingManagerImpl nm;
        private final Iterator<SimpleJndiName> names;
        private final boolean producesNamesOnly;

        BindingsIterator(GlassfishNamingManagerImpl nm, Iterator<SimpleJndiName> names, boolean producesNamesOnly) {
            this.nm = nm;
            this.names = names;
            this.producesNamesOnly = producesNamesOnly;
        }

        @Override
        public boolean hasMoreElements() {
            return this.names.hasNext();
        }

        @Override
        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        @Override
        public T nextElement() {
            if (!this.names.hasNext()) {
                return null;
            }
            try {
                SimpleJndiName name = this.names.next();
                Object obj = this.nm.lookupFromComponentNamespace(name);
                NameClassPair next = this.producesNamesOnly ? new NameClassPair(name.toString(), this.getClass().getName()) : new Binding(name.toString(), obj);
                return (T)next;
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public T next() throws NamingException {
            return this.nextElement();
        }

        @Override
        public void close() {
        }
    }
}

