/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jdbcruntime;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.ConnectorRuntimeExtension;
import com.sun.enterprise.connectors.DeferredResourceConfig;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.deployment.Application;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.jdbc.config.JdbcConnectionPool;
import org.glassfish.jdbc.config.JdbcResource;
import org.glassfish.jdbc.deployer.DataSourceDefinitionDeployer;
import org.glassfish.jdbc.util.JdbcResourcesUtil;
import org.glassfish.jdbcruntime.service.JdbcDataSource;
import org.glassfish.resourcebase.resources.api.PoolInfo;
import org.glassfish.resourcebase.resources.api.ResourceInfo;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;

@Service
public class JdbcRuntimeExtension
implements ConnectorRuntimeExtension {
    private static final Logger LOG = LogDomains.getLogger(JdbcRuntimeExtension.class, (String)"jakarta.enterprise.resource.resourceadapter");
    @Inject
    private Provider<Domain> domainProvider;
    @Inject
    private Provider<DataSourceDefinitionDeployer> dataSourceDefinitionDeployerProvider;
    private final ConnectorRuntime runtime = ConnectorRuntime.getRuntime();

    public Collection<Resource> getAllSystemRAResourcesAndPools() {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        Domain domain = (Domain)this.domainProvider.get();
        if (domain != null) {
            Resources allResources = domain.getResources();
            for (Resource resource : allResources.getResources()) {
                if (resource instanceof JdbcConnectionPool) {
                    resources.add(resource);
                    continue;
                }
                if (!(resource instanceof JdbcResource)) continue;
                resources.add(resource);
            }
        }
        System.out.println("JdbcRuntimeExtension,  getAllSystemRAResourcesAndPools = " + String.valueOf(resources));
        return resources;
    }

    public void registerDataSourceDefinitions(Application application) {
        ((DataSourceDefinitionDeployer)this.dataSourceDefinitionDeployerProvider.get()).registerDataSourceDefinitions(application);
    }

    public void unRegisterDataSourceDefinitions(Application application) {
        ((DataSourceDefinitionDeployer)this.dataSourceDefinitionDeployerProvider.get()).unRegisterDataSourceDefinitions(application);
    }

    public JdbcDataSource lookupDataSourceInDAS(ResourceInfo resourceInfo) throws ConnectorRuntimeException {
        return new JdbcDataSource(resourceInfo);
    }

    public PoolInfo getPoolNameFromResourceJndiName(ResourceInfo resourceInfo) {
        String suffix;
        SimpleJndiName jndiName = resourceInfo.getName();
        ResourceInfo actualResourceInfo = new ResourceInfo(jndiName, resourceInfo.getApplicationName(), resourceInfo.getModuleName());
        JdbcResource jdbcResource = (JdbcResource)this.runtime.getResources(actualResourceInfo).getResourceByName(JdbcResource.class, actualResourceInfo.getName());
        if (jdbcResource == null && (suffix = ConnectorsUtil.getValidSuffix((SimpleJndiName)jndiName)) != null) {
            jndiName = jndiName.removeSuffix(suffix);
            actualResourceInfo = new ResourceInfo(jndiName, resourceInfo.getApplicationName(), resourceInfo.getModuleName());
        }
        if ((jdbcResource = (JdbcResource)this.runtime.getResources(actualResourceInfo).getResourceByName(JdbcResource.class, actualResourceInfo.getName())) != null && LOG.isLoggable(Level.FINE)) {
            LOG.fine("jdbcRes is ---: " + jdbcResource.getJndiName());
            LOG.fine("poolName is ---: " + jdbcResource.getPoolName());
        }
        if (jdbcResource != null) {
            SimpleJndiName poolName = new SimpleJndiName(jdbcResource.getPoolName());
            return new PoolInfo(poolName, actualResourceInfo.getApplicationName(), actualResourceInfo.getModuleName());
        }
        return null;
    }

    public boolean isConnectionPoolReferredInServerInstance(PoolInfo poolInfo) {
        Collection jdbcResources = ConnectorRuntime.getRuntime().getResources(poolInfo).getResources(JdbcResource.class);
        for (JdbcResource resource : jdbcResources) {
            ResourceInfo resourceInfo = ConnectorsUtil.getResourceInfo((BindableResource)resource);
            ResourcesUtil resourcesUtil = ResourcesUtil.createInstance();
            if (!resource.getPoolName().equals(poolInfo.getName().toString()) || !resourcesUtil.isReferenced(resourceInfo) || !resourcesUtil.isEnabled((BindableResource)resource)) continue;
            LOG.log(Level.CONFIG, "JDBC pool {0} is referred by resource {1} and is enabled on this server", new Object[]{poolInfo, resourceInfo});
            return true;
        }
        LOG.log(Level.FINE, "No JDBC resource refers [{0}] in this server instance", poolInfo);
        return false;
    }

    public String getResourceType(ConfigBeanProxy cb) {
        if (cb instanceof JdbcConnectionPool) {
            return "jcp";
        }
        if (cb instanceof JdbcResource) {
            return "jdbc";
        }
        return null;
    }

    public DeferredResourceConfig getDeferredResourceConfig(Object resource, Object pool, String resType, String raName) throws ConnectorRuntimeException {
        DeferredResourceConfig resConfig = null;
        if (!(resource instanceof JdbcResource) && !(pool instanceof JdbcConnectionPool)) {
            throw new ConnectorRuntimeException("unsupported resource type : " + String.valueOf(resource));
        }
        JdbcConnectionPool jdbcPool = (JdbcConnectionPool)pool;
        JdbcResource jdbcResource = (JdbcResource)resource;
        String resourceAdapterName = this.getRANameofJdbcConnectionPool((JdbcConnectionPool)pool);
        resConfig = new DeferredResourceConfig(resourceAdapterName, null, (ResourcePool)jdbcPool, (BindableResource)jdbcResource, null);
        Resource[] resourcesToload = new Resource[]{jdbcPool, jdbcResource};
        resConfig.setResourcesToLoad(resourcesToload);
        return resConfig;
    }

    private String getRANameofJdbcConnectionPool(JdbcConnectionPool pool) {
        JdbcResourcesUtil resourcesUtil = JdbcResourcesUtil.createInstance();
        return resourcesUtil.getRANameofJdbcConnectionPool(pool);
    }
}

