/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.progress;

import com.sun.enterprise.admin.progress.CommandProgressImpl;
import com.sun.enterprise.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.api.admin.CommandProgress;
import org.glassfish.api.admin.ProgressStatus;
import org.glassfish.api.admin.progress.ProgressStatusBase;
import org.glassfish.api.admin.progress.ProgressStatusDTO;
import org.glassfish.api.admin.progress.ProgressStatusEvent;
import org.glassfish.api.admin.progress.ProgressStatusEventCreateChild;
import org.glassfish.main.jdke.i18n.LocalStringsImpl;

public class ProgressStatusClient {
    private static final LocalStringsImpl strings = new LocalStringsImpl(ProgressStatusClient.class);
    private ProgressStatus status;
    private final Map<String, ProgressStatus> map = new HashMap<String, ProgressStatus>();

    public ProgressStatusClient(ProgressStatus status) {
        this.status = status;
    }

    private synchronized void preventNullStatus(String name, String id) {
        if (this.status == null) {
            this.status = new CommandProgressImpl(name, id);
        }
        this.map.put(id, this.status);
    }

    public synchronized void mirror(ProgressStatusDTO dto) {
        if (dto == null) {
            return;
        }
        this.preventNullStatus(dto.getName(), dto.getId());
        this.mirror(dto, this.status);
    }

    private void mirror(ProgressStatusDTO dto, ProgressStatus stat) {
        stat.setTotalStepCount(dto.getTotalStepCount());
        stat.setCurrentStepCount(dto.getCurrentStepCount());
        if (dto.isCompleted()) {
            stat.complete();
        }
        for (ProgressStatusDTO.ChildProgressStatusDTO chld : dto.getChildren()) {
            ProgressStatus dst = this.map.get(chld.getProgressStatus().getId());
            if (dst == null) {
                dst = stat.createChild(chld.getProgressStatus().getName(), chld.getAllocatedSteps());
                this.map.put(chld.getProgressStatus().getId(), dst);
            }
            this.mirror(chld.getProgressStatus(), dst);
        }
    }

    public synchronized void mirror(ProgressStatusBase source) {
        if (source == null) {
            return;
        }
        this.preventNullStatus(source.getName(), source.getId());
        this.mirror(source, this.status);
    }

    private void mirror(ProgressStatusBase source, ProgressStatus stat) {
        stat.setTotalStepCount(source.getTotalStepCount());
        stat.setCurrentStepCount(source.getCurrentStepCount());
        if (source.isComplete()) {
            stat.complete();
        }
        for (ProgressStatusBase.ChildProgressStatus chld : source.getChildProgressStatuses()) {
            ProgressStatus dst = this.map.get(chld.getProgressStatus().getId());
            if (dst == null) {
                dst = stat.createChild(chld.getProgressStatus().getName(), chld.getAllocatedSteps());
                this.map.put(chld.getProgressStatus().getId(), dst);
            }
            this.mirror(chld.getProgressStatus(), dst);
        }
    }

    public synchronized void mirror(ProgressStatusEvent event) {
        if (event == null) {
            return;
        }
        ProgressStatus effected = this.map.get(event.getSourceId());
        ProgressStatus result = event.apply(effected);
        if (event instanceof ProgressStatusEventCreateChild) {
            this.map.put(((ProgressStatusEventCreateChild)event).getChildId(), result);
        }
    }

    public synchronized ProgressStatus getProgressStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String composeMessageForPrint(CommandProgress cp) {
        if (cp == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        CommandProgress commandProgress = cp;
        synchronized (commandProgress) {
            int percentage = Math.round(cp.computeCompletePortion() * 100.0f);
            if (percentage >= 0) {
                result.append(percentage);
                switch (result.length()) {
                    case 1: {
                        result.insert(0, "  ");
                        break;
                    }
                    case 2: {
                        result.insert(0, ' ');
                        break;
                    }
                }
                result.append('%');
            } else {
                int sumSteps = cp.computeSumSteps();
                result.append(sumSteps);
            }
            String message = cp.getLastMessage();
            if (!StringUtils.ok((String)message) && StringUtils.ok((String)cp.getName())) {
                message = strings.getString("progressstatus.message.starting", "Starting");
            }
            if (StringUtils.ok((String)message)) {
                result.append(": ");
                result.append(message);
            }
        }
        return result.toString();
    }
}

