/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors.partitioning;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.partitioning.PartitioningPolicy;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.server.ClientSession;

public abstract class FieldPartitioningPolicy
extends PartitioningPolicy {
    protected DatabaseField partitionField;
    protected boolean unionUnpartitionableQueries = false;

    protected FieldPartitioningPolicy() {
    }

    protected FieldPartitioningPolicy(String partitionField) {
        this.partitionField = new DatabaseField(partitionField);
    }

    protected FieldPartitioningPolicy(String partitionField, boolean unionUnpartitionableQueries) {
        this(partitionField);
        this.unionUnpartitionableQueries = unionUnpartitionableQueries;
    }

    public DatabaseField getPartitionField() {
        return this.partitionField;
    }

    public void setPartitionField(DatabaseField partitionField) {
        this.partitionField = partitionField;
    }

    public String getPartitionFieldName() {
        return this.getPartitionField().getName();
    }

    public void setPartitionField(String partitionField) {
        this.partitionField = new DatabaseField(partitionField);
    }

    public boolean getUnionUnpartitionableQueries() {
        return this.unionUnpartitionableQueries;
    }

    public void setUnionUnpartitionableQueries(boolean unionUnpartitionableQueries) {
        this.unionUnpartitionableQueries = unionUnpartitionableQueries;
    }

    protected Object extractPartitionValueForPersist(AbstractSession session, Object object, ClassDescriptor descriptor) {
        if (!session.isClientSession()) {
            return null;
        }
        ClientSession client = (ClientSession)session;
        if (!client.isExclusiveIsolatedClientSession() || client.hasWriteConnection()) {
            return null;
        }
        return descriptor.getObjectBuilder().extractValueFromObjectForField(object, this.partitionField, session);
    }
}

