/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.broker;

import com.sun.messaging.jmq.admin.apps.broker.BrokerCmdException;
import com.sun.messaging.jmq.admin.apps.broker.BrokerCmdHelpPrinter;
import com.sun.messaging.jmq.admin.apps.broker.BrokerCmdOptionParser;
import com.sun.messaging.jmq.admin.apps.broker.BrokerCmdOptions;
import com.sun.messaging.jmq.admin.apps.broker.BrokerCmdPrinter;
import com.sun.messaging.jmq.admin.apps.broker.BrokerCmdProperties;
import com.sun.messaging.jmq.admin.apps.broker.CmdRunner;
import com.sun.messaging.jmq.admin.apps.broker.CommonCmdRunnerUtil;
import com.sun.messaging.jmq.admin.bkrutil.BrokerConstants;
import com.sun.messaging.jmq.admin.resources.AdminResources;
import com.sun.messaging.jmq.admin.util.Globals;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.util.options.OptionException;
import com.sun.messaging.jmq.util.options.UnrecognizedOptionException;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.Properties;

public class BrokerCmd
implements BrokerCmdOptions,
BrokerConstants {
    private static AdminResources ar = Globals.getAdminResources();

    public static void main(String[] args) {
        Enumeration<?> e;
        BrokerCmdHelpPrinter hp;
        int exitcode = 0;
        if (BrokerCmd.silentModeOptionSpecified(args)) {
            Globals.setSilentMode(true);
        }
        if (BrokerCmd.shortHelpOptionSpecified(args)) {
            hp = new BrokerCmdHelpPrinter();
            hp.printShortHelp(0);
        } else if (BrokerCmd.longHelpOptionSpecified(args)) {
            hp = new BrokerCmdHelpPrinter();
            hp.printLongHelp();
        }
        if (BrokerCmd.versionOptionSpecified(args)) {
            CommonCmdRunnerUtil.printBanner();
            CommonCmdRunnerUtil.printVersion();
            System.exit(0);
        }
        BrokerCmdProperties brokerCmdProps = null;
        try {
            brokerCmdProps = BrokerCmdOptionParser.parseArgs(args);
        }
        catch (OptionException e2) {
            CommonCmdRunnerUtil.handleArgsParsingExceptions(e2, "-p", "imqcmd");
            System.exit(1);
        }
        String propFileName = brokerCmdProps.getInputFileName();
        if (propFileName != null && !propFileName.equals("")) {
            BrokerCmdProperties tmpProps = new BrokerCmdProperties();
            try {
                FileInputStream fis = new FileInputStream(propFileName);
                tmpProps.load(fis);
            }
            catch (Exception e3) {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3080"), false);
                Globals.stdErrPrintln(e3.toString());
                System.exit(1);
            }
            e = brokerCmdProps.propertyNames();
            while (e.hasMoreElements()) {
                String propVal;
                String propName = (String)e.nextElement();
                if (propName == null || (propVal = brokerCmdProps.getProperty(propName)) == null || propName.equals("inputfile")) continue;
                tmpProps.put(propName, propVal);
            }
            brokerCmdProps = tmpProps;
        }
        try {
            BrokerCmd.checkOptions(brokerCmdProps);
        }
        catch (UnrecognizedOptionException oe) {
            CommonCmdRunnerUtil.handleArgsParsingExceptions(oe, null, "imqcmd");
            System.exit(1);
        }
        catch (BrokerCmdException ome) {
            BrokerCmd.handleCheckOptionsExceptions(ome);
            System.exit(1);
        }
        Properties sysProps = brokerCmdProps.getSysProps();
        if (sysProps != null && sysProps.size() > 0) {
            e = sysProps.propertyNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String value = sysProps.getProperty(name);
                if (brokerCmdProps.adminDebugModeSet()) {
                    Globals.stdOutPrintln("Setting system property: " + name + "=" + value);
                }
                try {
                    System.setProperty(name, value);
                }
                catch (Exception ex) {
                    Globals.stdErrPrintln("Failed to set system property: " + name + "=" + value);
                    Globals.stdErrPrintln(ex.toString());
                }
            }
        }
        CmdRunner cmdRunner = new CmdRunner(brokerCmdProps);
        exitcode = cmdRunner.runCommands();
        System.exit(exitcode);
    }

    public static void checkOptions(BrokerCmdProperties brokerCmdProps) throws BrokerCmdException, UnrecognizedOptionException {
        String numRetriesStr;
        if (brokerCmdProps.debugModeSet() || brokerCmdProps.noCheckModeSet()) {
            return;
        }
        String cmd = brokerCmdProps.getCommand();
        if (cmd == null) {
            BrokerCmdException objMgrEx = new BrokerCmdException(10000);
            objMgrEx.setProperties(brokerCmdProps);
            throw objMgrEx;
        }
        BrokerCmd.checkWarnPassword(brokerCmdProps);
        if (cmd.equals("list")) {
            BrokerCmd.checkList(brokerCmdProps);
        } else if (cmd.equals("pause")) {
            BrokerCmd.checkPause(brokerCmdProps);
        } else if (cmd.equals("resume")) {
            BrokerCmd.checkResume(brokerCmdProps);
        } else if (cmd.equals("shutdown")) {
            BrokerCmd.checkShutdown(brokerCmdProps);
        } else if (cmd.equals("restart")) {
            BrokerCmd.checkRestart(brokerCmdProps);
        } else if (cmd.equals("create")) {
            BrokerCmd.checkCreate(brokerCmdProps);
        } else if (cmd.equals("destroy")) {
            BrokerCmd.checkDestroy(brokerCmdProps);
        } else if (cmd.equals(".destroyall")) {
            BrokerCmd.checkDestroyAll(brokerCmdProps);
        } else if (cmd.equals("purge")) {
            BrokerCmd.checkPurge(brokerCmdProps);
        } else if (cmd.equals(".purgeall")) {
            BrokerCmd.checkPurgeAll(brokerCmdProps);
        } else if (cmd.equals("update")) {
            BrokerCmd.checkUpdate(brokerCmdProps);
        } else if (cmd.equals("query")) {
            BrokerCmd.checkQuery(brokerCmdProps);
        } else if (cmd.equals("metrics")) {
            BrokerCmd.checkMetrics(brokerCmdProps);
        } else if (cmd.equals("reload")) {
            BrokerCmd.checkReload(brokerCmdProps);
        } else if (cmd.equals("changemaster")) {
            BrokerCmd.checkChangeMaster(brokerCmdProps);
        } else if (cmd.equals("commit")) {
            BrokerCmd.checkCommit(brokerCmdProps);
        } else if (cmd.equals("rollback")) {
            BrokerCmd.checkRollback(brokerCmdProps);
        } else if (cmd.equals("compact")) {
            BrokerCmd.checkCompact(brokerCmdProps);
        } else if (cmd.equals("quiesce")) {
            BrokerCmd.checkQuiesce(brokerCmdProps);
        } else if (cmd.equals("takeover")) {
            BrokerCmd.checkTakeover(brokerCmdProps);
        } else if (cmd.equals("migratestore")) {
            BrokerCmd.checkMigrateStore(brokerCmdProps);
        } else if (cmd.equals("unquiesce")) {
            BrokerCmd.checkUnquiesce(brokerCmdProps);
        } else if (cmd.equals("reset")) {
            BrokerCmd.checkReset(brokerCmdProps);
        } else if (cmd.equals("checkpoint")) {
            BrokerCmd.checkCheckpoint();
        } else if (cmd.equals(".exists")) {
            BrokerCmd.checkExists(brokerCmdProps);
        } else if (cmd.equals(".getattr")) {
            BrokerCmd.checkGetAttr(brokerCmdProps);
        } else if (cmd.equals("._kill")) {
            BrokerCmd.checkUngracefulKill(brokerCmdProps);
        } else {
            BrokerCmdException objMgrEx = new BrokerCmdException(10001);
            objMgrEx.setProperties(brokerCmdProps);
            throw objMgrEx;
        }
        String recvTimeoutStr = brokerCmdProps.getProperty("receiveTimeout");
        if (recvTimeoutStr != null) {
            try {
                BrokerCmd.checkIntegerValue(brokerCmdProps, "receiveTimeout", recvTimeoutStr);
            }
            catch (Exception e) {
                BrokerCmdException bce = new BrokerCmdException(10004);
                bce.setProperties(brokerCmdProps);
                bce.setErrorString(recvTimeoutStr);
                throw bce;
            }
        }
        if ((numRetriesStr = brokerCmdProps.getProperty("numRetries")) != null) {
            try {
                BrokerCmd.checkIntegerValue(brokerCmdProps, "numRetries", numRetriesStr);
            }
            catch (Exception e) {
                BrokerCmdException bce = new BrokerCmdException(10005);
                bce.setProperties(brokerCmdProps);
                bce.setErrorString(numRetriesStr);
                throw bce;
            }
        }
    }

    private static void checkList(BrokerCmdProperties brokerCmdProps) throws BrokerCmdException {
        BrokerCmd.checkCmdArg(brokerCmdProps, CommonCmdRunnerUtil.toStringArray((Object[])BrokerCmdOptions.CMD_LIST_VALID_CMDARGS.values()));
        String cmdArg = brokerCmdProps.getCommandArg();
        if (cmdArg.equals("dst")) {
            String s = brokerCmdProps.getDestType();
            if (s != null) {
                BrokerCmd.checkDestType(brokerCmdProps);
            }
        } else if (cmdArg.equals("msg")) {
            BrokerCmd.checkDestType(brokerCmdProps);
            BrokerCmd.checkTargetName(brokerCmdProps);
        }
    }

    private static void checkCompact(BrokerCmdProperties brokerCmdProps) throws BrokerCmdException {
        BrokerCmd.checkCmdArg(brokerCmdProps, CMD_COMPACT_VALID_CMDARGS);
        String cmdArg = brokerCmdProps.getCommandArg();
        if (cmdArg.equals("dst")) {
            String destType = brokerCmdProps.getDestType();
            String destName = brokerCmdProps.getTargetName();
            if (destType != null) {
                BrokerCmd.checkDestType(brokerCmdProps);
                BrokerCmd.checkTargetName(brokerCmdProps);
            } else if (destName != null) {
                BrokerCmd.checkDestType(brokerCmdProps);
            }
        }
    }

    private static void checkQuiesce(BrokerCmdProperties brokerCmdProps) throws BrokerCmdException {
        BrokerCmd.checkCmdArg(brokerCmdProps, CMD_QUIESCE_VALID_CMDARGS);
    }

    private static void checkUnquiesce(BrokerCmdProperties brokerCmdProps) throws BrokerCmdException {
        BrokerCmd.checkCmdArg(brokerCmdProps, CMD_UNQUIESCE_VALID_CMDARGS);
    }

    private static void checkTakeover(BrokerCmdProperties brokerCmdProps) throws BrokerCmdException {
        BrokerCmd.checkCmdArg(brokerCmdProps, CMD_TAKEOVER_VALID_CMDARGS);
        BrokerCmd.checkTargetName(brokerCmdProps);
    }

    private static void checkMigrateStore(BrokerCmdProperties brokerCmdProps) throws BrokerCmdException {
        BrokerCmd.checkCmdArg(brokerCmdProps, CMD_MIGRATESTORE_VALID_CMDARGS);
    }

    private static void checkPause(BrokerCmdProperties brokerCmdProps) throws BrokerCmdException {
        BrokerCmd.checkCmdArg(brokerCmdProps, CommonCmdRunnerUtil.toStringArray((Object[])BrokerCmdOptions.CMD_PAUSE_VALID_CMDARGS.values()));
        String cmdArg = brokerCmdProps.getCommandArg();
        if (cmdArg.equals("svc")) {
            BrokerCmd.checkTargetName(brokerCmdProps);
        } else if (cmdArg.equals("dst")) {
            String destType = brokerCmdProps.getDestType();
            String destName = brokerCmdProps.getTargetName();
            if (destType != null) {
                BrokerCmd.checkDestType(brokerCmdProps);
                BrokerCmd.checkTargetName(brokerCmdProps);
            } else if (destName != null) {
                BrokerCmd.checkDestType(brokerCmdProps);
            }
            BrokerCmd.checkPauseDstType(brokerCmdProps);
        }
    }

    private static void checkResume(BrokerCmdProperties brokerCmdProps) throws BrokerCmdException {
        BrokerCmd.checkCmdArg(brokerCmdProps, CMD_RESUME_VALID_CMDARGS);
        String cmdArg = brokerCmdProps.getCommandArg();
        if (cmdArg.equals("svc")) {
            BrokerCmd.checkTargetName(brokerCmdProps);
        } else if (cmdArg.equals("dst")) {
            String destType = brokerCmdProps.getDestType();
            String destName = brokerCmdProps.getTargetName();
            if (destType != null) {
                BrokerCmd.checkDestType(brokerCmdProps);
                BrokerCmd.checkTargetName(brokerCmdProps);
            } else if (destName != null) {
                BrokerCmd.checkDestType(brokerCmdProps);
            }
        }
    }

    private static void checkReset(BrokerCmdProperties brokerCmdProps) throws BrokerCmdException {
        BrokerCmd.checkCmdArg(brokerCmdProps, CMD_RESET_VALID_CMDARGS);
        String cmdArg = brokerCmdProps.getCommandArg();
        if (cmdArg.equals("bkr")) {
            BrokerCmd.checkResetType(brokerCmdProps);
        }
    }

    private static void checkCheckpoint() {
    }

    private static void checkShutdown(BrokerCmdProperties brokerCmdProps) throws BrokerCmdException {
        BrokerCmd.checkCmdArg(brokerCmdProps, CMD_SHUTDOWN_VALID_CMDARGS);
        BrokerCmd.checkTimeValue(brokerCmdProps);
    }

    private static void checkRestart(BrokerCmdProperties brokerCmdProps) throws BrokerCmdException {
        BrokerCmd.checkCmdArg(brokerCmdProps, CMD_RESTART_VALID_CMDARGS);
    }

    private static void checkCreate(BrokerCmdProperties brokerCmdProps) throws BrokerCmdException {
        BrokerCmd.checkCmdArg(brokerCmdProps, CMD_CREATE_VALID_CMDARGS);
        String cmdArg = brokerCmdProps.getCommandArg();
        if (cmdArg.equals("dst")) {
            int exceptionType = -1;
            String[] validAttrs = null;
            String[] deprecatedAttrs = null;
            BrokerCmd.checkDestType(brokerCmdProps);
            BrokerCmd.checkTargetName(brokerCmdProps);
            String destType = brokerCmdProps.getDestType();
            if (destType.equals("t")) {
                validAttrs = CREATE_DST_TOPIC_VALID_ATTRS;
                exceptionType = 13;
            } else if (destType.equals("q")) {
                validAttrs = CREATE_DST_QUEUE_VALID_ATTRS;
                deprecatedAttrs = CREATE_DST_QUEUE_DEPRECATED_ATTRS;
                exceptionType = 12;
            }
            BrokerCmd.checkDeprecatedAttrs(brokerCmdProps, deprecatedAttrs);
            BrokerCmd.checkValidAttrs(brokerCmdProps, validAttrs, exceptionType);
            Properties attrs = brokerCmdProps.getTargetAttrs();
            String value = attrs.getProperty("maxTotalMsgBytes");
            if (value != null) {
                BrokerCmd.checkByteValue(brokerCmdProps, "maxTotalMsgBytes", value);
            }
            if ((value = attrs.getProperty("maxBytesPerMsg")) != null) {
                BrokerCmd.checkByteValue(brokerCmdProps, "maxBytesPerMsg", value);
            }
            if ((value = attrs.getProperty("maxNumMsgs")) != null) {
                BrokerCmd.checkLongValue(brokerCmdProps, "maxNumMsgs", value);
            }
            if ((value = attrs.getProperty("isLocalOnly")) != null) {
                BrokerCmd.checkBooleanValue(brokerCmdProps, "isLocalOnly", value);
            }
            if ((value = attrs.getProperty("limitBehavior")) != null) {
                BrokerCmd.checkLimitBehaviourValue(brokerCmdProps, "limitBehavior", value);
            }
            if ((value = attrs.getProperty("consumerFlowLimit")) != null) {
                BrokerCmd.checkIntegerValue(brokerCmdProps, "consumerFlowLimit", value);
            }
            if ((value = attrs.getProperty("maxNumProducers")) != null) {
                BrokerCmd.checkIntegerValue(brokerCmdProps, "maxNumProducers", value);
            }
            if ((value = attrs.getProperty("useDMQ")) != null) {
                BrokerCmd.checkBooleanValue(brokerCmdProps, "useDMQ", value);
            }
            if ((value = attrs.getProperty("validateXMLSchemaEnabled")) != null) {
                BrokerCmd.checkBooleanValue(brokerCmdProps, "validateXMLSchemaEnabled", value);
            }
            if ((value = attrs.getProperty("reloadXMLSchemaOnFailure")) != null) {
                BrokerCmd.checkBooleanValue(brokerCmdProps, "reloadXMLSchemaOnFailure", value);
            }
            if (destType.equals("q")) {
                value = attrs.getProperty("maxNumBackupConsumers");
                if (value != null) {
                    BrokerCmd.checkIntegerValue(brokerCmdProps, "maxNumBackupConsumers", value);
                }
                if ((value = attrs.getProperty("maxNumActiveConsumers")) != null) {
                    BrokerCmd.checkIntegerValue(brokerCmdProps, "maxNumActiveConsumers", value);
                }
                if ((value = attrs.getProperty("localDeliveryPreferred")) != null) {
                    BrokerCmd.checkBooleanValue(brokerCmdProps, "localDeliveryPreferred", value);
                }
            }
            BrokerCmd.checkUnlimitedValues(brokerCmdProps, DEST_ATTRS_UNLIMITED_CONV);
        }
    }

    private static void checkValidAttrs(BrokerCmdProperties brokerCmdProps, String[] validAttrs, int exceptionType) throws BrokerCmdException {
        Properties attrs = brokerCmdProps.getTargetAttrs();
        BrokerCmdException ex = null;
        if (attrs == null) {
            return;
        }
        Enumeration<?> e = attrs.propertyNames();
        while (e.hasMoreElements()) {
            String oneAttrName = (String)e.nextElement();
            if (BrokerCmd.arrayContainsStr(validAttrs, oneAttrName)) continue;
            ex = new BrokerCmdException(exceptionType);
            ex.setProperties(brokerCmdProps);
            ex.setValidAttrs(validAttrs);
            ex.setBadAttr(oneAttrName);
            throw ex;
        }
    }

    private static void checkCreateOnlyAttrs(BrokerCmdProperties brokerCmdProps, String[] createOnlyAttrs, String[] validAttrs, int createOnlyExceptionType) throws BrokerCmdException {
        Properties attrs = brokerCmdProps.getTargetAttrs();
        BrokerCmdException ex = null;
        if (attrs == null) {
            return;
        }
        Enumeration<?> e = attrs.propertyNames();
        while (e.hasMoreElements()) {
            String oneAttrName = (String)e.nextElement();
            if (!BrokerCmd.arrayContainsStr(createOnlyAttrs, oneAttrName)) continue;
            ex = new BrokerCmdException(createOnlyExceptionType);
            ex.setProperties(brokerCmdProps);
            ex.setValidAttrs(validAttrs);
            ex.setBadAttr(oneAttrName);
            throw ex;
        }
    }

    private static void checkDeprecatedAttrs(BrokerCmdProperties brokerCmdProps, String[] deprecatedAttrs) throws BrokerCmdException {
        Properties attrs = brokerCmdProps.getTargetAttrs();
        if (attrs == null || deprecatedAttrs == null) {
            return;
        }
        Enumeration<?> e = attrs.propertyNames();
        while (e.hasMoreElements()) {
            String oneAttrName = (String)e.nextElement();
            if (!BrokerCmd.arrayContainsStr(deprecatedAttrs, oneAttrName)) continue;
            String value = attrs.getProperty(oneAttrName);
            BrokerCmd.handleDeprecatedAttr(brokerCmdProps, oneAttrName, value);
        }
    }

    private static void handleDeprecatedAttr(BrokerCmdProperties brokerCmdProps, String deprecatedAttr, String deprecatedValue) throws BrokerCmdException {
        Properties attrs = brokerCmdProps.getTargetAttrs();
        if (deprecatedAttr.equals("queueDeliveryPolicy")) {
            String flavor = deprecatedValue;
            String maxFailoverCons = null;
            String maxActiveCons = null;
            if (flavor == null) {
                return;
            }
            BrokerCmd.checkFlavorType(brokerCmdProps, flavor, 32);
            maxFailoverCons = attrs.getProperty("maxNumBackupConsumers");
            maxActiveCons = attrs.getProperty("maxNumActiveConsumers");
            if (maxFailoverCons == null && maxActiveCons == null) {
                if (flavor.equals("s")) {
                    maxActiveCons = "1";
                    maxFailoverCons = "0";
                } else if (flavor.equals("f")) {
                    maxActiveCons = "1";
                    maxFailoverCons = "-1";
                } else if (flavor.equals("r")) {
                    maxActiveCons = "-1";
                    maxFailoverCons = "0";
                }
                brokerCmdProps.setTargetAttr("maxNumBackupConsumers", maxFailoverCons);
                brokerCmdProps.setTargetAttr("maxNumActiveConsumers", maxActiveCons);
                Globals.stdErrPrintln(ar.getString("A1000"), ar.getKString("A2005"));
                Object[] args2 = new Object[]{flavor, maxFailoverCons, maxActiveCons};
                Globals.stdErrPrintln(ar.getString("A1000"), ar.getKString("A2006", args2));
            } else {
                Globals.stdErrPrintln(ar.getString("A1000"), ar.getKString("A2005"));
                Globals.stdErrPrintln(ar.getString("A1000"), ar.getKString("A2007", flavor));
            }
            brokerCmdProps.removeTargetAttr("queueDeliveryPolicy");
        } else if (deprecatedAttr.equals("imq.queue.deliverypolicy")) {
            String flavor = deprecatedValue;
            String maxFailoverCons = null;
            String maxActiveCons = null;
            if (flavor == null) {
                return;
            }
            BrokerCmd.checkFlavorType(brokerCmdProps, flavor, 33);
            maxFailoverCons = attrs.getProperty("imq.autocreate.queue.maxNumBackupConsumers");
            maxActiveCons = attrs.getProperty("imq.autocreate.queue.maxNumActiveConsumers");
            if (maxFailoverCons == null && maxActiveCons == null) {
                if (flavor.equals("s")) {
                    maxActiveCons = "1";
                    maxFailoverCons = "0";
                } else if (flavor.equals("f")) {
                    maxActiveCons = "1";
                    maxFailoverCons = "-1";
                } else if (flavor.equals("r")) {
                    maxActiveCons = "-1";
                    maxFailoverCons = "0";
                }
                brokerCmdProps.setTargetAttr("imq.autocreate.queue.maxNumBackupConsumers", maxFailoverCons);
                brokerCmdProps.setTargetAttr("imq.autocreate.queue.maxNumActiveConsumers", maxActiveCons);
                Globals.stdErrPrintln(ar.getString("A1000"), ar.getKString("A2008"));
                Object[] args = new Object[]{flavor, maxFailoverCons, maxActiveCons};
                Globals.stdErrPrintln(ar.getString("A1000"), ar.getKString("A2009", args));
            } else {
                Globals.stdErrPrintln(ar.getString("A1000"), ar.getKString("A2008"));
                Globals.stdErrPrintln(ar.getString("A1000"), ar.getKString("A2010", flavor));
            }
            brokerCmdProps.removeTargetAttr("imq.queue.deliverypolicy");
        }
    }

    private static void checkUnlimitedValues(BrokerCmdProperties brokerCmdProps, String[] unlimitedAttrs) throws BrokerCmdException {
        String value;
        String oneAttrName;
        Properties attrs = brokerCmdProps.getTargetAttrs();
        Properties saveAttrs = new Properties();
        if (attrs == null || unlimitedAttrs == null) {
            return;
        }
        Enumeration<?> e = attrs.propertyNames();
        while (e.hasMoreElements()) {
            oneAttrName = (String)e.nextElement();
            if (!BrokerCmd.arrayContainsStr(unlimitedAttrs, oneAttrName) || !(value = attrs.getProperty(oneAttrName)).equals("0")) continue;
            saveAttrs.setProperty(oneAttrName, value);
        }
        if (saveAttrs.size() > 0) {
            Globals.stdErrPrintln(ar.getString("A1000"), ar.getKString("A2011", "0"));
            e = saveAttrs.propertyNames();
            while (e.hasMoreElements()) {
                oneAttrName = (String)e.nextElement();
                value = attrs.getProperty(oneAttrName);
                Globals.stdErrPrintln("\t" + oneAttrName + "=" + value);
            }
            Globals.stdErrPrintln("");
            Globals.stdErrPrintln(ar.getString("A2012", "-1"));
            Globals.stdErrPrintln(ar.getString("A2013"));
            e = saveAttrs.propertyNames();
            while (e.hasMoreElements()) {
                oneAttrName = (String)e.nextElement();
                Globals.stdErrPrintln("\t" + oneAttrName + "=-1");
                brokerCmdProps.setTargetAttr(oneAttrName, "-1");
            }
            Globals.stdErrPrintln("");
        }
    }

    private static void checkValidSingleAttr(BrokerCmdProperties brokerCmdProps, String[] validAttrs) throws BrokerCmdException {
        String attr = brokerCmdProps.getSingleTargetAttr();
        BrokerCmdException ex = null;
        if (attr == null) {
            ex = new BrokerCmdException(25);
            ex.setProperties(brokerCmdProps);
            throw ex;
        }
        if (validAttrs != null && !BrokerCmd.arrayContainsStr(validAttrs, attr)) {
            ex = new BrokerCmdException(24);
            ex.setProperties(brokerCmdProps);
            ex.setValidAttrs(validAttrs);
            ex.setBadAttr(attr);
            throw ex;
        }
    }

    private static boolean arrayContainsStr(String[] strArray, String str) {
        if (strArray == null || str == null) {
            return false;
        }
        for (int i = 0; i < strArray.length; ++i) {
            if (!str.equals(strArray[i])) continue;
            return true;
        }
        return false;
    }

    private static void checkFlavorType(BrokerCmdProperties brokerCmdProps, String flavor) throws BrokerCmdException {
        BrokerCmd.checkFlavorType(brokerCmdProps, flavor, -1);
    }

    private static void checkFlavorType(BrokerCmdProperties brokerCmdProps, String flavor, int exceptionType) throws BrokerCmdException {
        BrokerCmdException ex = null;
        if (exceptionType == -1) {
            exceptionType = 8;
        }
        if (!("s".equals(flavor) || "f".equals(flavor) || "r".equals(flavor))) {
            ex = new BrokerCmdException(exceptionType);
            ex.setProperties(brokerCmdProps);
            ex.setBadValue(flavor);
            throw ex;
        }
    }

    private static void checkPauseDstType(BrokerCmdProperties brokerCmdProps) throws BrokerCmdException {
        BrokerCmdException ex = null;
        String pauseType = brokerCmdProps.getPauseType();
        if (pauseType == null) {
            return;
        }
        for (int i = 0; i < PAUSE_DST_TYPE_VALID_VALUES.length; ++i) {
            if (!pauseType.equals(PAUSE_DST_TYPE_VALID_VALUES[i])) continue;
            return;
        }
        ex = new BrokerCmdException(27);
        ex.setProperties(brokerCmdProps);
        ex.setBadValue(pauseType);
        throw ex;
    }

    private static void checkResetType(BrokerCmdProperties brokerCmdProps) throws BrokerCmdException {
        BrokerCmdException ex = null;
        String resetType = brokerCmdProps.getResetType();
        if (resetType == null) {
            return;
        }
        for (int i = 0; i < RESET_BKR_TYPE_VALID_VALUES.length; ++i) {
            if (!resetType.equals(RESET_BKR_TYPE_VALID_VALUES[i])) continue;
            return;
        }
        ex = new BrokerCmdException(36);
        ex.setProperties(brokerCmdProps);
        ex.setBadValue(resetType);
        throw ex;
    }

    private static void checkMetricInterval(BrokerCmdProperties brokerCmdProps) throws BrokerCmdException {
        String s = brokerCmdProps.getProperty("metricInterval");
        BrokerCmdException ex = null;
        if (s == null) {
            return;
        }
        try {
            long l = Long.parseLong(s);
            if (l < 0L) {
                ex = new BrokerCmdException(20);
                ex.setProperties(brokerCmdProps);
                ex.setBadValue(s);
                throw ex;
            }
        }
        catch (NumberFormatException nfe) {
            ex = new BrokerCmdException(20);
            ex.setProperties(brokerCmdProps);
            ex.setBadValue(s);
            throw ex;
        }
    }

    private static void checkMetricSamples(BrokerCmdProperties brokerCmdProps) throws BrokerCmdException {
        String s = brokerCmdProps.getProperty("metricSamples");
        BrokerCmdException ex = null;
        if (s == null) {
            return;
        }
        try {
            int i = Integer.parseInt(s);
            if (i < 0 && i != -1) {
                ex = new BrokerCmdException(29);
                ex.setProperties(brokerCmdProps);
                ex.setBadValue(s);
                throw ex;
            }
        }
        catch (NumberFormatException nfe) {
            ex = new BrokerCmdException(29);
            ex.setProperties(brokerCmdProps);
            ex.setBadValue(s);
            throw ex;
        }
    }

    private static void checkMetricType(BrokerCmdProperties brokerCmdProps) throws BrokerCmdException {
        String metricType = brokerCmdProps.getMetricType();
        BrokerCmdException ex = null;
        if (metricType == null) {
            return;
        }
        for (int i = 0; i < METRIC_TYPE_VALID_VALUES.length; ++i) {
            if (!metricType.equals(METRIC_TYPE_VALID_VALUES[i])) continue;
            return;
        }
        ex = new BrokerCmdException(21);
        ex.setProperties(brokerCmdProps);
        ex.setBadValue(metricType);
        throw ex;
    }

    private static void checkMetricDstType(BrokerCmdProperties brokerCmdProps) throws BrokerCmdException {
        String metricType = brokerCmdProps.getMetricType();
        BrokerCmdException ex = null;
        if (metricType == null) {
            return;
        }
        for (int i = 0; i < METRIC_DST_TYPE_VALID_VALUES.length; ++i) {
            if (!metricType.equals(METRIC_DST_TYPE_VALID_VALUES[i])) continue;
            return;
        }
        ex = new BrokerCmdException(28);
        ex.setProperties(brokerCmdProps);
        ex.setBadValue(metricType);
        throw ex;
    }

    private static int checkIntegerValue(BrokerCmdProperties brokerCmdProps, String type, String maxValue) throws BrokerCmdException {
        int iValue;
        BrokerCmdException ex = null;
        try {
            iValue = Integer.parseInt(maxValue);
            if (iValue < -1) {
                ex = new BrokerCmdException(10008);
                ex.setProperties(brokerCmdProps);
                ex.setErrorString(type);
                throw ex;
            }
        }
        catch (Exception e) {
            ex = new BrokerCmdException(10008);
            ex.setProperties(brokerCmdProps);
            ex.setErrorString(type);
            throw ex;
        }
        return iValue;
    }

    private static long checkLongValue(BrokerCmdProperties brokerCmdProps, String type, String maxValue) throws BrokerCmdException {
        long lValue;
        BrokerCmdException ex = null;
        try {
            lValue = Long.parseLong(maxValue);
            if (lValue < -1L) {
                ex = new BrokerCmdException(10008);
                ex.setProperties(brokerCmdProps);
                ex.setErrorString(type);
                throw ex;
            }
        }
        catch (Exception e) {
            ex = new BrokerCmdException(10008);
            ex.setProperties(brokerCmdProps);
            ex.setErrorString(type);
            throw ex;
        }
        return lValue;
    }

    private static void checkByteValue(BrokerCmdProperties brokerCmdProps, String type, String byteString) throws BrokerCmdException {
        BrokerCmdException ex = null;
        try {
            SizeString ss = new SizeString(byteString);
            long bytesValue = ss.getBytes();
            if (bytesValue < -1L) {
                ex = new BrokerCmdException(22);
                ex.setProperties(brokerCmdProps);
                ex.setErrorString(type);
                throw ex;
            }
        }
        catch (Exception e) {
            ex = new BrokerCmdException(22);
            ex.setProperties(brokerCmdProps);
            ex.setErrorString(type);
            throw ex;
        }
    }

    private static void checkBooleanValue(BrokerCmdProperties brokerCmdProps, String type, String boolValue) throws BrokerCmdException {
        BrokerCmdException ex = null;
        if (boolValue.equalsIgnoreCase("true") || boolValue.equalsIgnoreCase("t") || boolValue.equalsIgnoreCase("false") || boolValue.equalsIgnoreCase("f")) {
            return;
        }
        ex = new BrokerCmdException(18);
        ex.setProperties(brokerCmdProps);
        ex.setErrorString(type);
        throw ex;
    }

    private static void checkLogLevelValue(BrokerCmdProperties brokerCmdProps, String type, String logLevelValue) throws BrokerCmdException {
        BrokerCmdException ex = null;
        for (String value : BKR_LOG_LEVEL_VALID_VALUES) {
            if (!logLevelValue.equals(value)) continue;
            return;
        }
        ex = new BrokerCmdException(19);
        ex.setProperties(brokerCmdProps);
        ex.setErrorString(type);
        throw ex;
    }

    private static void checkTimeValue(BrokerCmdProperties brokerCmdProps) throws BrokerCmdException {
        String s = brokerCmdProps.getProperty("time");
        BrokerCmdException ex = null;
        if (s == null) {
            return;
        }
        try {
            int i = Integer.parseInt(s);
            if (i < 0) {
                ex = new BrokerCmdException(10007);
                ex.setProperties(brokerCmdProps);
                ex.setBadValue(s);
                throw ex;
            }
        }
        catch (NumberFormatException nfe) {
            ex = new BrokerCmdException(10007);
            ex.setProperties(brokerCmdProps);
            ex.setBadValue(s);
            throw ex;
        }
    }

    private static void checkLimitBehaviourValue(BrokerCmdProperties brokerCmdProps, String type, String limitBehaviourValue) throws BrokerCmdException {
        BrokerCmdException ex = null;
        for (String value : BKR_LIMIT_BEHAV_VALID_VALUES) {
            if (!limitBehaviourValue.equals(value)) continue;
            return;
        }
        ex = new BrokerCmdException(31);
        ex.setProperties(brokerCmdProps);
        ex.setErrorString(type);
        throw ex;
    }

    private static void checkDestroy(BrokerCmdProperties brokerCmdProps) throws BrokerCmdException {
        BrokerCmd.checkCmdArg(brokerCmdProps, CMD_DESTROY_VALID_CMDARGS);
        String cmdArg = brokerCmdProps.getCommandArg();
        if (cmdArg.equals("dst")) {
            BrokerCmd.checkDestType(brokerCmdProps);
            BrokerCmd.checkTargetName(brokerCmdProps);
        } else if (cmdArg.equals("dur")) {
            BrokerCmd.checkTargetName(brokerCmdProps);
        } else if (cmdArg.equals("cxn")) {
            BrokerCmd.checkTargetName(brokerCmdProps);
        } else if (cmdArg.equals("msg")) {
            BrokerCmd.checkDestType(brokerCmdProps);
            BrokerCmd.checkTargetName(brokerCmdProps);
            BrokerCmd.checkMsgID(brokerCmdProps);
        }
    }

    private static void checkPurge(BrokerCmdProperties brokerCmdProps) throws BrokerCmdException {
        BrokerCmd.checkCmdArg(brokerCmdProps, CMD_PURGE_VALID_CMDARGS);
        String cmdArg = brokerCmdProps.getCommandArg();
        if (cmdArg.equals("dst")) {
            BrokerCmd.checkTargetName(brokerCmdProps);
            BrokerCmd.checkDestType(brokerCmdProps);
        } else if (cmdArg.equals("dur")) {
            BrokerCmd.checkTargetName(brokerCmdProps);
        }
    }

    private static void checkDestroyAll(BrokerCmdProperties brokerCmdProps) throws BrokerCmdException {
        BrokerCmd.checkCmdArg(brokerCmdProps, CMD_DESTROYALL_VALID_CMDARGS);
    }

    private static void checkPurgeAll(BrokerCmdProperties brokerCmdProps) throws BrokerCmdException {
        BrokerCmd.checkCmdArg(brokerCmdProps, CMD_PURGEALL_VALID_CMDARGS);
    }

    private static void checkUpdate(BrokerCmdProperties brokerCmdProps) throws BrokerCmdException {
        BrokerCmd.checkCmdArg(brokerCmdProps, CMD_UPDATE_VALID_CMDARGS);
        String cmdArg = brokerCmdProps.getCommandArg();
        if (cmdArg.equals("dst")) {
            int exceptionType = -1;
            int createOnlyExceptionType = -1;
            String[] validAttrs = null;
            String[] createOnlyAttrs = null;
            BrokerCmd.checkDestType(brokerCmdProps);
            BrokerCmd.checkTargetName(brokerCmdProps);
            BrokerCmd.checkTargetAttrs(brokerCmdProps);
            String destType = brokerCmdProps.getDestType();
            if (destType.equals("t")) {
                createOnlyAttrs = CREATE_ONLY_DST_ATTRS;
                validAttrs = UPDATE_DST_TOPIC_VALID_ATTRS;
                exceptionType = 16;
                createOnlyExceptionType = 39;
            } else if (destType.equals("q")) {
                createOnlyAttrs = CREATE_ONLY_DST_ATTRS;
                validAttrs = UPDATE_DST_QUEUE_VALID_ATTRS;
                exceptionType = 15;
                createOnlyExceptionType = 38;
            }
            BrokerCmd.checkCreateOnlyAttrs(brokerCmdProps, createOnlyAttrs, validAttrs, createOnlyExceptionType);
            BrokerCmd.checkValidAttrs(brokerCmdProps, validAttrs, exceptionType);
            Properties attrs = brokerCmdProps.getTargetAttrs();
            String value = attrs.getProperty("maxTotalMsgBytes");
            if (value != null) {
                BrokerCmd.checkByteValue(brokerCmdProps, "maxTotalMsgBytes", value);
            }
            if ((value = attrs.getProperty("maxBytesPerMsg")) != null) {
                BrokerCmd.checkByteValue(brokerCmdProps, "maxBytesPerMsg", value);
            }
            if ((value = attrs.getProperty("maxNumMsgs")) != null) {
                BrokerCmd.checkLongValue(brokerCmdProps, "maxNumMsgs", value);
            }
            if ((value = attrs.getProperty("limitBehavior")) != null) {
                BrokerCmd.checkLimitBehaviourValue(brokerCmdProps, "limitBehavior", value);
            }
            if ((value = attrs.getProperty("consumerFlowLimit")) != null) {
                BrokerCmd.checkIntegerValue(brokerCmdProps, "consumerFlowLimit", value);
            }
            if ((value = attrs.getProperty("maxNumProducers")) != null) {
                BrokerCmd.checkIntegerValue(brokerCmdProps, "maxNumProducers", value);
            }
            if ((value = attrs.getProperty("useDMQ")) != null) {
                BrokerCmd.checkBooleanValue(brokerCmdProps, "useDMQ", value);
            }
            if ((value = attrs.getProperty("validateXMLSchemaEnabled")) != null) {
                BrokerCmd.checkBooleanValue(brokerCmdProps, "validateXMLSchemaEnabled", value);
            }
            if ((value = attrs.getProperty("reloadXMLSchemaOnFailure")) != null) {
                BrokerCmd.checkBooleanValue(brokerCmdProps, "reloadXMLSchemaOnFailure", value);
            }
            if (destType.equals("q")) {
                value = attrs.getProperty("maxNumBackupConsumers");
                if (value != null) {
                    BrokerCmd.checkIntegerValue(brokerCmdProps, "maxNumBackupConsumers", value);
                }
                if ((value = attrs.getProperty("maxNumActiveConsumers")) != null) {
                    BrokerCmd.checkIntegerValue(brokerCmdProps, "maxNumActiveConsumers", value);
                }
                if ((value = attrs.getProperty("localDeliveryPreferred")) != null) {
                    BrokerCmd.checkBooleanValue(brokerCmdProps, "localDeliveryPreferred", value);
                }
            }
            BrokerCmd.checkUnlimitedValues(brokerCmdProps, DEST_ATTRS_UNLIMITED_CONV);
        } else if (cmdArg.equals("bkr")) {
            String useDMQ;
            String truncateBody;
            String logDeadMsgs;
            String logLevelValue;
            String deliveryPolicyValue;
            String autoCreateValue;
            int exceptionType = -1;
            String[] validAttrs = null;
            BrokerCmd.checkTargetAttrs(brokerCmdProps);
            BrokerCmd.checkDeprecatedAttrs(brokerCmdProps, UPDATE_BKR_DEPRECATED_ATTRS);
            validAttrs = UPDATE_BKR_VALID_ATTRS;
            exceptionType = 14;
            BrokerCmd.checkValidAttrs(brokerCmdProps, validAttrs, exceptionType);
            Properties attrs = brokerCmdProps.getTargetAttrs();
            String maxValue = attrs.getProperty("imq.portmapper.port");
            if (maxValue != null) {
                BrokerCmd.checkIntegerValue(brokerCmdProps, "imq.portmapper.port", maxValue);
            }
            if ((autoCreateValue = attrs.getProperty("imq.autocreate.topic")) != null) {
                BrokerCmd.checkBooleanValue(brokerCmdProps, "imq.autocreate.topic", autoCreateValue);
            }
            if ((autoCreateValue = attrs.getProperty("imq.autocreate.queue")) != null) {
                BrokerCmd.checkBooleanValue(brokerCmdProps, "imq.autocreate.queue", autoCreateValue);
            }
            if ((deliveryPolicyValue = attrs.getProperty("imq.queue.deliverypolicy")) != null) {
                BrokerCmd.checkFlavorType(brokerCmdProps, deliveryPolicyValue);
            }
            if ((logLevelValue = attrs.getProperty(".level")) != null) {
                BrokerCmd.checkLogLevelValue(brokerCmdProps, ".level", logLevelValue);
            }
            if ((maxValue = attrs.getProperty("java.util.logging.FileHandler.limit")) != null) {
                BrokerCmd.checkIntegerValue(brokerCmdProps, "java.util.logging.FileHandler.limit", maxValue);
            }
            if ((maxValue = attrs.getProperty("imq.log.file.rolloversecs")) != null) {
                BrokerCmd.checkIntegerValue(brokerCmdProps, "imq.log.file.rolloversecs", maxValue);
            }
            if ((maxValue = attrs.getProperty("imq.autocreate.queue.maxNumActiveConsumers")) != null) {
                BrokerCmd.checkIntegerValue(brokerCmdProps, "imq.autocreate.queue.maxNumActiveConsumers", maxValue);
            }
            if ((maxValue = attrs.getProperty("imq.autocreate.queue.maxNumBackupConsumers")) != null) {
                BrokerCmd.checkIntegerValue(brokerCmdProps, "imq.autocreate.queue.maxNumBackupConsumers", maxValue);
            }
            if ((maxValue = attrs.getProperty("imq.system.max_count")) != null) {
                BrokerCmd.checkLongValue(brokerCmdProps, "imq.system.max_count", maxValue);
            }
            if ((maxValue = attrs.getProperty("imq.system.max_size")) != null) {
                BrokerCmd.checkByteValue(brokerCmdProps, "imq.system.max_size", maxValue);
            }
            if ((maxValue = attrs.getProperty("imq.message.max_size")) != null) {
                BrokerCmd.checkByteValue(brokerCmdProps, "imq.message.max_size", maxValue);
            }
            if ((logDeadMsgs = attrs.getProperty("imq.destination.logDeadMsgs")) != null) {
                BrokerCmd.checkBooleanValue(brokerCmdProps, "imq.destination.logDeadMsgs", logDeadMsgs);
            }
            if ((truncateBody = attrs.getProperty("imq.destination.DMQ.truncateBody")) != null) {
                BrokerCmd.checkBooleanValue(brokerCmdProps, "imq.destination.DMQ.truncateBody", truncateBody);
            }
            if ((useDMQ = attrs.getProperty("imq.autocreate.destination.useDMQ")) != null) {
                BrokerCmd.checkBooleanValue(brokerCmdProps, "imq.autocreate.destination.useDMQ", useDMQ);
            }
            BrokerCmd.checkUnlimitedValues(brokerCmdProps, BKR_ATTRS_UNLIMITED_CONV);
        } else if (cmdArg.equals("svc")) {
            int exceptionType = -1;
            String[] validAttrs = null;
            BrokerCmd.checkTargetName(brokerCmdProps);
            BrokerCmd.checkTargetAttrs(brokerCmdProps);
            validAttrs = UPDATE_SVC_VALID_ATTRS;
            exceptionType = 17;
            BrokerCmd.checkValidAttrs(brokerCmdProps, validAttrs, exceptionType);
            Properties attrs = brokerCmdProps.getTargetAttrs();
            String value = attrs.getProperty("port");
            if (value != null) {
                BrokerCmd.checkIntegerValue(brokerCmdProps, "port", value);
            }
            if ((value = attrs.getProperty("minThreads")) != null) {
                BrokerCmd.checkIntegerValue(brokerCmdProps, "minThreads", value);
            }
            if ((value = attrs.getProperty("maxThreads")) != null) {
                BrokerCmd.checkIntegerValue(brokerCmdProps, "maxThreads", value);
            }
        }
    }

    private static void checkQuery(BrokerCmdProperties brokerCmdProps) throws BrokerCmdException {
        BrokerCmd.checkCmdArg(brokerCmdProps, CMD_QUERY_VALID_CMDARGS);
        String cmdArg = brokerCmdProps.getCommandArg();
        if (cmdArg.equals("dst")) {
            BrokerCmd.checkDestType(brokerCmdProps);
            BrokerCmd.checkTargetName(brokerCmdProps);
        } else if (cmdArg.equals("svc")) {
            BrokerCmd.checkTargetName(brokerCmdProps);
        } else if (cmdArg.equals("txn")) {
            BrokerCmd.checkTargetName(brokerCmdProps);
        } else if (cmdArg.equals("cxn")) {
            BrokerCmd.checkTargetName(brokerCmdProps);
        } else if (cmdArg.equals("msg")) {
            BrokerCmd.checkDestType(brokerCmdProps);
            BrokerCmd.checkTargetName(brokerCmdProps);
        }
    }

    private static void checkMetrics(BrokerCmdProperties brokerCmdProps) throws BrokerCmdException {
        BrokerCmd.checkCmdArg(brokerCmdProps, CMD_METRICS_VALID_CMDARGS);
        String cmdArg = brokerCmdProps.getCommandArg();
        BrokerCmd.checkMetricInterval(brokerCmdProps);
        BrokerCmd.checkMetricSamples(brokerCmdProps);
        if (cmdArg.equals("bkr")) {
            BrokerCmd.checkMetricType(brokerCmdProps);
        } else if (cmdArg.equals("svc")) {
            BrokerCmd.checkMetricType(brokerCmdProps);
            BrokerCmd.checkTargetName(brokerCmdProps);
        } else if (cmdArg.equals("dst")) {
            BrokerCmd.checkMetricDstType(brokerCmdProps);
            BrokerCmd.checkDestType(brokerCmdProps);
            BrokerCmd.checkTargetName(brokerCmdProps);
        }
    }

    private static void checkReload(BrokerCmdProperties brokerCmdProps) throws BrokerCmdException {
        BrokerCmd.checkCmdArg(brokerCmdProps, CMD_RELOAD_VALID_CMDARGS);
    }

    private static void checkChangeMaster(BrokerCmdProperties brokerCmdProps) throws BrokerCmdException {
        BrokerCmd.checkCmdArg(brokerCmdProps, CMD_CHANGEMASTER_VALID_CMDARGS);
        int exceptionType = -1;
        String[] validAttrs = null;
        BrokerCmd.checkTargetAttrs(brokerCmdProps);
        validAttrs = CHANGEMASTER_VALID_ATTRS;
        exceptionType = 40;
        BrokerCmd.checkValidAttrs(brokerCmdProps, validAttrs, exceptionType);
    }

    private static void checkCommit(BrokerCmdProperties brokerCmdProps) throws BrokerCmdException {
        BrokerCmd.checkCmdArg(brokerCmdProps, CMD_COMMIT_VALID_CMDARGS);
        String cmdArg = brokerCmdProps.getCommandArg();
        if (cmdArg.equals("txn")) {
            BrokerCmd.checkTargetName(brokerCmdProps);
        }
    }

    private static void checkRollback(BrokerCmdProperties brokerCmdProps) throws BrokerCmdException, UnrecognizedOptionException {
        BrokerCmd.checkCmdArg(brokerCmdProps, CMD_ROLLBACK_VALID_CMDARGS);
        String cmdArg = brokerCmdProps.getCommandArg();
        if (cmdArg.equals("txn")) {
            BrokerCmd.checkTargetName(brokerCmdProps);
        }
        if (brokerCmdProps.msgOptionSet() && !brokerCmdProps.noCheckModeSet()) {
            UnrecognizedOptionException e = new UnrecognizedOptionException();
            e.setOption("-msg");
            throw e;
        }
    }

    private static void checkExists(BrokerCmdProperties brokerCmdProps) throws BrokerCmdException {
        BrokerCmd.checkCmdArg(brokerCmdProps, CMD_EXISTS_VALID_CMDARGS);
        String cmdArg = brokerCmdProps.getCommandArg();
        if (cmdArg.equals("dst")) {
            BrokerCmd.checkDestType(brokerCmdProps);
            BrokerCmd.checkTargetName(brokerCmdProps);
        }
    }

    private static void checkGetAttr(BrokerCmdProperties brokerCmdProps) throws BrokerCmdException {
        BrokerCmd.checkCmdArg(brokerCmdProps, CommonCmdRunnerUtil.toStringArray((Object[])BrokerCmdOptions.CMD_GETATTR_VALID_CMDARGS.values()));
        String cmdArg = brokerCmdProps.getCommandArg();
        if (cmdArg.equals("dst")) {
            String[] validAttrs = null;
            BrokerCmd.checkDestType(brokerCmdProps);
            BrokerCmd.checkTargetName(brokerCmdProps);
            String destType = brokerCmdProps.getDestType();
            if (destType.equals("t")) {
                validAttrs = GETATTR_DST_TOPIC_VALID_ATTRS;
            } else if (destType.equals("q")) {
                validAttrs = GETATTR_DST_QUEUE_VALID_ATTRS;
            }
            BrokerCmd.checkValidSingleAttr(brokerCmdProps, validAttrs);
        } else if (cmdArg.equals("svc")) {
            BrokerCmd.checkTargetName(brokerCmdProps);
            BrokerCmd.checkValidSingleAttr(brokerCmdProps, GETATTR_SVC_VALID_ATTRS);
        } else if (cmdArg.equals("bkr")) {
            BrokerCmd.checkValidSingleAttr(brokerCmdProps, null);
        } else if (cmdArg.equals("txn")) {
            BrokerCmd.checkValidSingleAttr(brokerCmdProps, GETATTR_TXN_VALID_ATTRS);
        }
    }

    private static void checkUngracefulKill(BrokerCmdProperties brokerCmdProps) throws BrokerCmdException {
        BrokerCmd.checkCmdArg(brokerCmdProps, CMD_UNGRACEFUL_KILL_VALID_CMDARGS);
    }

    private static void checkCmdArg(BrokerCmdProperties brokerCmdProps, String[] validCmdArgs) throws BrokerCmdException {
        String cmdArg = brokerCmdProps.getCommandArg();
        if (cmdArg == null) {
            BrokerCmdException ex = new BrokerCmdException(10002);
            ex.setProperties(brokerCmdProps);
            throw ex;
        }
        if (validCmdArgs == null) {
            return;
        }
        for (int i = 0; i < validCmdArgs.length; ++i) {
            if (!cmdArg.equals(validCmdArgs[i])) continue;
            return;
        }
        BrokerCmdException ex = new BrokerCmdException(10003);
        ex.setProperties(brokerCmdProps);
        ex.setValidCmdArgs(validCmdArgs);
        throw ex;
    }

    private static void checkDestType(BrokerCmdProperties brokerCmdProps) throws BrokerCmdException {
        BrokerCmdException ex = null;
        String destType = brokerCmdProps.getDestType();
        if (destType == null) {
            ex = new BrokerCmdException(7);
            ex.setProperties(brokerCmdProps);
            throw ex;
        }
        if (!destType.equals("t") && !destType.equals("q")) {
            ex = new BrokerCmdException(10);
            ex.setProperties(brokerCmdProps);
            throw ex;
        }
    }

    private static void checkTargetName(BrokerCmdProperties brokerCmdProps) throws BrokerCmdException {
        String targetName = brokerCmdProps.getTargetName();
        if (targetName == null) {
            BrokerCmdException ex = new BrokerCmdException(2);
            ex.setProperties(brokerCmdProps);
            throw ex;
        }
    }

    private static void checkTargetAttrs(BrokerCmdProperties brokerCmdProps) throws BrokerCmdException {
        Properties attrs = brokerCmdProps.getTargetAttrs();
        if (attrs == null || attrs.isEmpty()) {
            BrokerCmdException ex = new BrokerCmdException(6);
            ex.setProperties(brokerCmdProps);
            throw ex;
        }
    }

    private static void checkMsgID(BrokerCmdProperties brokerCmdProps) throws BrokerCmdException {
        String msgID = brokerCmdProps.getMsgID();
        if (msgID == null) {
            BrokerCmdException ex = new BrokerCmdException(37);
            ex.setProperties(brokerCmdProps);
            throw ex;
        }
    }

    private static void checkWarnPassword(BrokerCmdProperties brokerCmdProps) {
        String passwd = brokerCmdProps.getAdminPasswd();
        if (passwd != null) {
            Globals.stdErrPrintln(ar.getString("A1000"), ar.getKString("A2014"));
            Globals.stdErrPrintln("");
        }
    }

    private static boolean shortHelpOptionSpecified(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-h") && !args[i].equals("-help")) continue;
            return true;
        }
        return false;
    }

    private static boolean longHelpOptionSpecified(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-H") && !args[i].equals("-Help")) continue;
            return true;
        }
        return false;
    }

    private static boolean versionOptionSpecified(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-v") && !args[i].equals("-version")) continue;
            return true;
        }
        return false;
    }

    private static boolean silentModeOptionSpecified(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-s")) continue;
            return true;
        }
        return false;
    }

    private static void handleCheckOptionsExceptions(BrokerCmdException e) {
        BrokerCmdProperties brokerCmdProps = (BrokerCmdProperties)e.getProperties();
        String cmd = brokerCmdProps.getCommand();
        String cmdArg = brokerCmdProps.getCommandArg();
        String badAttr = e.getBadAttr();
        String badValue = e.getBadValue();
        String errorString = e.getErrorString();
        String[] validAttrs = e.getValidAttrs();
        int type = e.getType();
        switch (type) {
            case 2: {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3100", "-n"));
                break;
            }
            case 5: {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3103", "-d"));
                break;
            }
            case 6: {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3104", "-o"));
                break;
            }
            case 7: {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3105", "-t"));
                break;
            }
            case 8: {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3106", badValue));
                break;
            }
            case 32: {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3106", badValue));
                Globals.stdErrPrintln(ar.getString("A1000"), ar.getKString("A2005"));
                break;
            }
            case 33: {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3106", badValue));
                Globals.stdErrPrintln(ar.getString("A1000"), ar.getKString("A2008"));
                break;
            }
            case 10008: {
                Properties attrs = brokerCmdProps.getTargetAttrs();
                String errorValue = attrs.getProperty(errorString);
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3107", errorValue, errorString));
                break;
            }
            case 22: {
                Properties attrs = brokerCmdProps.getTargetAttrs();
                String errorValue = attrs.getProperty(errorString);
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3117", errorValue, errorString));
                break;
            }
            case 18: {
                Properties attrs = brokerCmdProps.getTargetAttrs();
                String errorValue = attrs.getProperty(errorString);
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3114", errorValue, errorString));
                break;
            }
            case 19: {
                Properties attrs = brokerCmdProps.getTargetAttrs();
                String errorValue = attrs.getProperty(errorString);
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3115", errorValue, errorString));
                Globals.stdErrPrintln(ar.getString("A1170", ".level"));
                Globals.stdErrPrint("\t");
                for (int i = 0; i < BKR_LOG_LEVEL_VALID_VALUES.size(); ++i) {
                    Globals.stdErrPrint((String)BKR_LOG_LEVEL_VALID_VALUES.get(i));
                    if (i + 1 >= BKR_LOG_LEVEL_VALID_VALUES.size()) continue;
                    Globals.stdErrPrint(" ");
                }
                Globals.stdErrPrintln("");
                break;
            }
            case 31: {
                Properties attrs = brokerCmdProps.getTargetAttrs();
                String errorValue = attrs.getProperty(errorString);
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3160", errorValue, errorString));
                Globals.stdErrPrintln(ar.getString("A1170", "limitBehavior"));
                Globals.stdErrPrint("\t");
                for (int i = 0; i < BKR_LIMIT_BEHAV_VALID_VALUES.size(); ++i) {
                    Globals.stdErrPrint((String)BKR_LIMIT_BEHAV_VALID_VALUES.get(i));
                    if (i + 1 >= BKR_LIMIT_BEHAV_VALID_VALUES.size()) continue;
                    Globals.stdErrPrint(" ");
                }
                Globals.stdErrPrintln("");
                break;
            }
            case 20: {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3137", badValue));
                break;
            }
            case 29: {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3157", badValue));
                break;
            }
            case 21: {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3138", badValue));
                Globals.stdErrPrint("\t");
                for (int i = 0; i < METRIC_TYPE_VALID_VALUES.length; ++i) {
                    Globals.stdErrPrint(METRIC_TYPE_VALID_VALUES[i]);
                    if (i + 1 >= METRIC_TYPE_VALID_VALUES.length) continue;
                    Globals.stdErrPrint(" ");
                }
                Globals.stdErrPrintln("");
                break;
            }
            case 28: {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3156", badValue));
                Globals.stdErrPrint("\t");
                for (int i = 0; i < METRIC_DST_TYPE_VALID_VALUES.length; ++i) {
                    Globals.stdErrPrint(METRIC_DST_TYPE_VALID_VALUES[i]);
                    if (i + 1 >= METRIC_DST_TYPE_VALID_VALUES.length) continue;
                    Globals.stdErrPrint(" ");
                }
                Globals.stdErrPrintln("");
                break;
            }
            case 10: {
                String invalidDestType = brokerCmdProps.getDestType();
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3108", invalidDestType));
                break;
            }
            case 27: {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3119", badValue));
                Globals.stdErrPrint("\t");
                for (int i = 0; i < PAUSE_DST_TYPE_VALID_VALUES.length; ++i) {
                    Globals.stdErrPrint(PAUSE_DST_TYPE_VALID_VALUES[i]);
                    if (i + 1 >= PAUSE_DST_TYPE_VALID_VALUES.length) continue;
                    Globals.stdErrPrint(" ");
                }
                Globals.stdErrPrintln("");
                break;
            }
            case 36: {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3166", badValue));
                Globals.stdErrPrint("\t");
                for (int i = 0; i < RESET_BKR_TYPE_VALID_VALUES.length; ++i) {
                    Globals.stdErrPrint(RESET_BKR_TYPE_VALID_VALUES[i]);
                    if (i + 1 >= RESET_BKR_TYPE_VALID_VALUES.length) continue;
                    Globals.stdErrPrint(" ");
                }
                Globals.stdErrPrintln("");
                break;
            }
            case 11: {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3112", "-c"));
                break;
            }
            case 37: {
                Globals.stdErrPrintln(ar.getString("A1001"), "The message ID must be specified with the -msgIDoption.");
                break;
            }
            case 25: {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3148", "-attr"));
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 24: 
            case 26: 
            case 38: 
            case 39: 
            case 40: {
                String msg2ID;
                String msg1ID = "A3129";
                switch (type) {
                    case 12: {
                        msg2ID = "A3131";
                        break;
                    }
                    case 13: {
                        msg2ID = "A3132";
                        break;
                    }
                    case 14: {
                        msg2ID = "A3133";
                        break;
                    }
                    case 15: {
                        msg2ID = "A3134";
                        break;
                    }
                    case 16: {
                        msg2ID = "A3135";
                        break;
                    }
                    case 17: {
                        msg2ID = "A3136";
                        break;
                    }
                    case 26: {
                        msg2ID = "A3155";
                        break;
                    }
                    case 38: {
                        msg1ID = "A3168";
                        msg2ID = "A3134";
                        break;
                    }
                    case 39: {
                        msg1ID = "A3168";
                        msg2ID = "A3135";
                        break;
                    }
                    default: {
                        msg2ID = "A3130";
                    }
                }
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString(msg1ID, badAttr));
                if (validAttrs == null) break;
                Globals.stdErrPrintln(ar.getString(msg2ID));
                BrokerCmdPrinter bcp = new BrokerCmdPrinter(1, 4, null);
                Object[] row = new String[1];
                for (int i = 0; i < validAttrs.length; ++i) {
                    row[0] = validAttrs[i];
                    bcp.add(row);
                }
                bcp.println();
                break;
            }
            default: {
                CommonCmdRunnerUtil.handleCommonCheckOptionsExceptions(e, cmd, cmdArg, new BrokerCmdHelpPrinter());
            }
        }
    }
}

