/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.io.IOException;
import org.jboss.jdeparser.AbstractJType;
import org.jboss.jdeparser.CachingLinkedHashMap;
import org.jboss.jdeparser.ImplJAnonymousClassDef;
import org.jboss.jdeparser.JAnonymousClassDef;
import org.jboss.jdeparser.JCall;
import org.jboss.jdeparser.JExpr;
import org.jboss.jdeparser.JType;
import org.jboss.jdeparser.NarrowedJType;
import org.jboss.jdeparser.NewJCall;
import org.jboss.jdeparser.SourceFileWriter;
import org.jboss.jdeparser.StaticRefJExpr;
import org.jboss.jdeparser.Tokens$;

class NestedJType
extends AbstractJType {
    private final AbstractJType enclosingType;
    private final String name;
    private StaticRefJExpr classExpr;
    private StaticRefJExpr thisExpr;
    private StaticRefJExpr superExpr;
    private CachingLinkedHashMap<String, NestedJType> nestedTypes;

    NestedJType(AbstractJType enclosingType, String name) {
        this.enclosingType = enclosingType;
        this.name = name;
    }

    @Override
    String qualifiedName() {
        return this.enclosingType.qualifiedName() + "." + this.name;
    }

    @Override
    public JExpr _class() {
        StaticRefJExpr expr = this.classExpr;
        if (expr == null) {
            expr = this.classExpr = new StaticRefJExpr(this, "class");
        }
        return expr;
    }

    @Override
    public JExpr _this() {
        StaticRefJExpr expr = this.thisExpr;
        if (expr == null) {
            expr = this.thisExpr = new StaticRefJExpr(this, "this");
        }
        return expr;
    }

    @Override
    public JExpr _super() {
        StaticRefJExpr expr = this.superExpr;
        if (expr == null) {
            expr = this.superExpr = new StaticRefJExpr(this, "super");
        }
        return expr;
    }

    @Override
    public JCall _new(JExpr dim) {
        return new NewJCall(this);
    }

    @Override
    public JAnonymousClassDef _newAnon() {
        return new ImplJAnonymousClassDef(this);
    }

    @Override
    boolean equals(AbstractJType other) {
        return other instanceof NestedJType && this.equals((NestedJType)other);
    }

    private boolean equals(NestedJType other) {
        return this.enclosingType.equals(other.enclosingType) && this.name.equals(other.name);
    }

    @Override
    public int hashCode() {
        return this.enclosingType.hashCode() * 17 + this.name.hashCode();
    }

    @Override
    public String simpleName() {
        return this.name;
    }

    @Override
    public JType typeArg(JType ... args) {
        return new NarrowedJType(this, args);
    }

    @Override
    public JType nestedType(String name) {
        NestedJType nestedType;
        CachingLinkedHashMap<String, NestedJType> nestedTypes = this.nestedTypes;
        if (nestedTypes == null) {
            this.nestedTypes = new CachingLinkedHashMap();
            nestedTypes = this.nestedTypes;
        }
        if ((nestedType = (NestedJType)nestedTypes.get(name)) == null) {
            nestedType = new NestedJType(this, name);
            nestedTypes.put(name, nestedType);
        }
        return nestedType;
    }

    @Override
    public String toString() {
        return "Nested type " + this.name + " of " + this.enclosingType;
    }

    @Override
    void writeDirect(SourceFileWriter writer) throws IOException {
        if (!writer.getClassFile().hasStaticImport(this.name, this.enclosingType) && !writer.getClassFile().hasImport(this)) {
            this.enclosingType.writeDirect(writer);
            writer.write(Tokens$.PUNCT.DOT);
        }
        writer.writeClass(this.name);
    }
}

