/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop.security;

import com.sun.corba.ee.org.omg.CSIIOP.CompoundSecMech;
import com.sun.corba.ee.org.omg.GSSUP.InitialContextToken;
import com.sun.corba.ee.org.omg.GSSUP.InitialContextTokenHelper;
import com.sun.enterprise.iiop.security.GSSUtils;
import com.sun.enterprise.iiop.security.SecurityMechanismException;
import com.sun.enterprise.security.auth.login.common.PasswordCredential;
import com.sun.enterprise.util.Utility;
import com.sun.logging.LogDomains;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ietf.jgss.GSSException;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.IOP.Codec;

public class GSSUPToken {
    private static final Logger LOG = LogDomains.getLogger(GSSUPToken.class, (String)"jakarta.enterprise.system.core.security", (boolean)false);
    public static final String DELIMITER_REGEXP = "\\@";
    public static final String ESCAPE_CHAR_REGEXP = "\\\\\\@";
    public static final String ESCAPE_CHAR = "\\";
    public static final String DELIMITER = "@";
    public static final String DEFAULT_REALM_NAME = "default";
    private byte[] cdr_encoded_token = new byte[0];
    PasswordCredential pwdcred;

    public static GSSUPToken getClientSideInstance(ORB orb, Codec codec, PasswordCredential pwdcred, CompoundSecMech mech) {
        return new GSSUPToken(orb, codec, pwdcred, mech);
    }

    public static GSSUPToken getServerSideInstance(ORB orb, Codec codec, byte[] authtok) throws SecurityMechanismException {
        return new GSSUPToken(orb, codec, authtok);
    }

    private GSSUPToken(ORB orb, Codec codec, PasswordCredential pwdcred, CompoundSecMech mech) {
        byte[] name_utf8 = new byte[]{};
        byte[] password_utf8 = new byte[]{};
        LOG.log(Level.FINE, "IIOP: Going to construct a GSSUPToken: {0}", pwdcred);
        try {
            String realm;
            Object _name_ = pwdcred.getUser();
            int index = ((String)_name_).indexOf(DELIMITER);
            if (index != -1) {
                int escaped_index = ((String)_name_).indexOf(ESCAPE_CHAR);
                if (escaped_index == -1) {
                    _name_ = ((String)_name_).replaceAll(DELIMITER_REGEXP, ESCAPE_CHAR_REGEXP);
                } else {
                    _name_ = ((String)_name_).replaceAll(ESCAPE_CHAR_REGEXP, DELIMITER_REGEXP);
                    _name_ = ((String)_name_).replaceAll(DELIMITER_REGEXP, ESCAPE_CHAR_REGEXP);
                }
            }
            if ((realm = pwdcred.getRealm()) != null) {
                _name_ = (String)_name_ + DELIMITER + realm;
            }
            name_utf8 = ((String)_name_).getBytes(StandardCharsets.UTF_8);
            password_utf8 = Utility.convertCharArrayToByteArray((char[])pwdcred.getPassword(), (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Construction of GSSUPToken failed.", e);
        }
        byte[] target_name = mech.as_context_mech.target_name;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Username (UTF8) " + GSSUtils.dumpHex(name_utf8));
            LOG.fine("Password (UTF8) ########");
            LOG.fine("Targetname      " + GSSUtils.dumpHex(target_name));
        }
        InitialContextToken inctxToken = new InitialContextToken(name_utf8, password_utf8, target_name);
        Any a = orb.create_any();
        InitialContextTokenHelper.insert((Any)a, (InitialContextToken)inctxToken);
        try {
            this.cdr_encoded_token = codec.encode_value(a);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Could not encode token value.", e);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "IIOP:Mech specific token length (CDR encoded) = " + this.cdr_encoded_token.length);
        }
    }

    private GSSUPToken(ORB orb, Codec codec, byte[] authtok) throws SecurityMechanismException {
        String name;
        byte[] name_utf8 = null;
        byte[] password_utf8 = null;
        byte[] target_name = null;
        String username = "";
        char[] userpwd = null;
        String realm = "";
        byte[] encoded_token = null;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "IIOP:Going to construct a GSSUPToken:");
            LOG.log(Level.FINE, "IIOP:Getting CDR encoded GSSUP mechanism token from client authentication token");
        }
        encoded_token = GSSUtils.getMechToken(GSSUtils.GSSUP_MECH_OID, authtok);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "CDR encoded mech specific token length = " + encoded_token.length);
        }
        Any a = orb.create_any();
        try {
            a = codec.decode_value(encoded_token, InitialContextTokenHelper.type());
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Could not decode token value.", e);
        }
        InitialContextToken inctxToken = InitialContextTokenHelper.extract((Any)a);
        password_utf8 = inctxToken.password;
        name_utf8 = inctxToken.username;
        target_name = inctxToken.target_name;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("IIOP:Username (UTF8) " + GSSUtils.dumpHex(name_utf8));
            LOG.fine("IIOP:Password (UTF8) ########");
            LOG.fine("IIOP:Targetname      " + GSSUtils.dumpHex(target_name));
        }
        try {
            username = new String(name_utf8, StandardCharsets.UTF_8);
            userpwd = Utility.convertByteArrayToCharArray((byte[])password_utf8, (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "IIOP1001: Exception getting username and password", e);
        }
        int index = username.indexOf(DELIMITER);
        int esc_index = username.indexOf(ESCAPE_CHAR);
        if (index == -1) {
            name = username;
        } else {
            if (index == 0 || esc_index == 0) {
                throw new SecurityMechanismException("No name_value in username");
            }
            if (esc_index != -1) {
                if (esc_index + 2 >= username.length()) {
                    name = username.replaceAll(ESCAPE_CHAR_REGEXP, DELIMITER);
                    LOG.log(Level.FINE, "IIOP:No Realm specified, creating a default realm for login");
                    realm = DEFAULT_REALM_NAME;
                } else {
                    int second_at_index = username.indexOf(DELIMITER, esc_index + 3);
                    if (second_at_index == -1) {
                        name = username.replaceAll(ESCAPE_CHAR_REGEXP, DELIMITER);
                        LOG.log(Level.FINE, "IIOP:No Realm specified, creating a default realm for login");
                        realm = DEFAULT_REALM_NAME;
                    } else {
                        name = username.substring(0, second_at_index);
                        name = name.replaceAll(ESCAPE_CHAR_REGEXP, DELIMITER);
                        realm = username.substring(second_at_index + 1);
                        if (realm == null || realm.isEmpty()) {
                            LOG.log(Level.FINE, "IIOP:No Realm specified, creating a default realm for login");
                            realm = DEFAULT_REALM_NAME;
                        }
                    }
                }
            } else {
                StringTokenizer strtok = new StringTokenizer(username, DELIMITER);
                name = strtok.nextToken();
                if (strtok.hasMoreTokens() && (realm = strtok.nextToken()).isEmpty()) {
                    LOG.log(Level.FINE, "IIOP:No Realm specified, creating a default realm for login");
                    realm = DEFAULT_REALM_NAME;
                }
            }
        }
        String targetNameRealm = null;
        try {
            if (target_name != null && target_name.length != 0) {
                targetNameRealm = new String(GSSUtils.importName(GSSUtils.GSSUP_MECH_OID, target_name));
            }
        }
        catch (GSSException ex) {
            LOG.log(Level.FINE, null, ex);
        }
        if (targetNameRealm != null && !DEFAULT_REALM_NAME.equals(targetNameRealm)) {
            realm = targetNameRealm;
        }
        this.pwdcred = new PasswordCredential(name, userpwd, realm, target_name);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, this.pwdcred.toString());
        }
    }

    byte[] getGSSToken() throws GSSException {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "IIOP:GSSUP mech token : " + GSSUtils.dumpHex(this.cdr_encoded_token));
        }
        byte[] gsstoken = GSSUtils.createMechIndToken(GSSUtils.GSSUP_MECH_OID, this.cdr_encoded_token);
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "IIOP:GSSUP token length : " + gsstoken.length);
            LOG.log(Level.FINER, "IIOP:GSSUP token: " + GSSUtils.dumpHex(gsstoken));
        }
        return gsstoken;
    }

    PasswordCredential getPwdcred() {
        return this.pwdcred;
    }
}

