/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.io.IOException;
import org.jboss.jdeparser.BasicJBlock;
import org.jboss.jdeparser.FormatPreferences;
import org.jboss.jdeparser.ImplJSwitch;
import org.jboss.jdeparser.JBlock;
import org.jboss.jdeparser.JExpr;
import org.jboss.jdeparser.SourceFileWriter;
import org.jboss.jdeparser.Tokens$;

class CaseJBlock
extends BasicJBlock {
    private final JExpr expr;

    CaseJBlock(ImplJSwitch _switch, JExpr expr) {
        super(_switch.getParent(), JBlock.Braces.OPTIONAL);
        this.expr = expr;
    }

    JExpr getExpression() {
        return this.expr;
    }

    @Override
    public void write(SourceFileWriter writer) throws IOException {
        this.writeComments(writer);
        writer.pushIndent(FormatPreferences.Indentation.CASE_LABELS);
        try {
            writer.write(Tokens$.KW.CASE);
            writer.write(this.expr);
            writer.write(Tokens$.PUNCT.COLON);
        }
        finally {
            writer.popIndent(FormatPreferences.Indentation.CASE_LABELS);
        }
        writer.write(FormatPreferences.Space.AFTER_LABEL);
        super.write(writer, FormatPreferences.Space.BEFORE_BRACE);
    }
}

