/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop.security;

import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.iiop.AlternateIIOPAddressComponent;
import com.sun.corba.ee.spi.ior.iiop.IIOPAddress;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfileTemplate;
import com.sun.corba.ee.spi.transport.IORToSocketInfo;
import com.sun.corba.ee.spi.transport.SocketInfo;
import com.sun.enterprise.iiop.security.ConnectionContext;
import com.sun.enterprise.iiop.security.SecurityMechanismSelector;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.internal.api.Globals;

public class IORToSocketInfoImpl
implements IORToSocketInfo {
    private static final Logger LOG = LogDomains.getLogger(IORToSocketInfoImpl.class, (String)"jakarta.enterprise.resource.corba", (boolean)false);
    private final Map primaryToAddresses = new HashMap();
    private final Map primaryToRandomizedAddresses = new HashMap();
    private final SecurityMechanismSelector selector = (SecurityMechanismSelector)Globals.get(SecurityMechanismSelector.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public List getSocketInfo(IOR ior, List previous) {
        List existing;
        SocketInfo primarySocketInfo;
        List<SocketInfo> result;
        block17: {
            block16: {
                LOG.entering(this.getClass().getName(), "getSocketInfo");
                result = new ArrayList<SocketInfo>();
                IIOPProfileTemplate iiopProfileTemplate = (IIOPProfileTemplate)ior.getProfile().getTaggedProfileTemplate();
                IIOPAddress primary = iiopProfileTemplate.getPrimaryAddress();
                Locale loc = Locale.getDefault();
                String host = primary.getHost().toLowerCase(loc);
                String type = null;
                int port = 0;
                ConnectionContext ctx = new ConnectionContext();
                SocketInfo socketInfo = this.selector.getSSLPort(ior, ctx);
                this.selector.setClientConnectionContext(ctx);
                if (socketInfo == null) {
                    type = "IIOP_CLEAR_TEXT";
                    port = primary.getPort();
                    LOG.log(Level.FINE, "Did not find SSL SocketInfo");
                } else {
                    type = socketInfo.getType();
                    port = socketInfo.getPort();
                    LOG.log(Level.FINE, "Found SSL socketInfo");
                }
                LOG.log(Level.FINE, "Connection Context: {0}", ctx);
                LOG.log(Level.FINE, "Endpoint: type={0}, host={1}, port={2}", new Object[]{type, host, port});
                if (socketInfo != null) {
                    result.add(socketInfo);
                    LOG.log(Level.FINE, "Returning SSL socketInfo: type={0}, host={1}, port={2}.", new Object[]{socketInfo.getType(), socketInfo.getHost(), socketInfo.getPort()});
                    ArrayList<SocketInfo> arrayList = result;
                    LOG.exiting(this.getClass().getName(), "getSocketInfo");
                    return arrayList;
                }
                LOG.log(Level.FINE, "Returning non SSL socketInfo");
                if (!previous.isEmpty()) {
                    LOG.log(Level.FINE, "Returning previous socketInfo: {0}", previous);
                    List list = previous;
                    LOG.exiting(this.getClass().getName(), "getSocketInfo");
                    return list;
                }
                primarySocketInfo = IORToSocketInfoImpl.createSocketInfo("primary", type, host, port);
                result.add(primarySocketInfo);
                Iterator iterator = iiopProfileTemplate.iteratorById(3);
                while (iterator.hasNext()) {
                    AlternateIIOPAddressComponent alternate = (AlternateIIOPAddressComponent)iterator.next();
                    host = alternate.getAddress().getHost().toLowerCase(loc);
                    port = alternate.getAddress().getPort();
                    result.add(IORToSocketInfoImpl.createSocketInfo("AlternateIIOPAddressComponent", "IIOP_CLEAR_TEXT", host, port));
                }
                IORToSocketInfoImpl iORToSocketInfoImpl = this;
                // MONITORENTER : iORToSocketInfoImpl
                existing = (List)this.primaryToAddresses.get(primarySocketInfo);
                if (existing != null) break block16;
                this.primaryToAddresses.put(primarySocketInfo, result);
                result.remove(0);
                Collections.shuffle(result);
                result.add(0, primarySocketInfo);
                this.primaryToRandomizedAddresses.put(primarySocketInfo, result);
                LOG.log(Level.FINE, "Initial randomized result: {0}", result);
                List<SocketInfo> list = result;
                // MONITOREXIT : iORToSocketInfoImpl
                LOG.exiting(this.getClass().getName(), "getSocketInfo");
                return list;
            }
            if (!result.equals(existing)) break block17;
            result = (List)this.primaryToRandomizedAddresses.get(primarySocketInfo);
            LOG.log(Level.FINE, "Existing randomized result: {0}", result);
            List<SocketInfo> list = result;
            // MONITOREXIT : iORToSocketInfoImpl
            LOG.exiting(this.getClass().getName(), "getSocketInfo");
            return list;
            {
                catch (Exception ex) {
                    LOG.log(Level.WARNING, "Exception getting SocketInfo", ex);
                    throw new RuntimeException(ex);
                }
            }
        }
        LOG.log(Level.FINE, "Address lists do not match: primary: {0}; returning current: {1}; existing is: {2}", new Object[]{primarySocketInfo, result, existing});
        List<SocketInfo> list = result;
        // MONITOREXIT : iORToSocketInfoImpl
        LOG.exiting(this.getClass().getName(), "getSocketInfo");
        return list;
        catch (Throwable throwable) {
            LOG.exiting(this.getClass().getName(), "getSocketInfo");
            throw throwable;
        }
    }

    public static SocketInfo createSocketInfo(String msg, final String type, final String host, final int port) {
        LOG.log(Level.FINE, "Address from: {0}; type/address/port: {1}/{2}/{3}", new Object[]{msg, type, host, port});
        return new SocketInfo(){

            public String getType() {
                return type;
            }

            public String getHost() {
                return host;
            }

            public int getPort() {
                return port;
            }

            public boolean equals(Object o) {
                if (o == null) {
                    return false;
                }
                if (!(o instanceof SocketInfo)) {
                    return false;
                }
                SocketInfo other = (SocketInfo)o;
                if (other.getPort() != port) {
                    return false;
                }
                if (!other.getHost().equals(host)) {
                    return false;
                }
                return other.getType().equals(type);
            }

            public int hashCode() {
                return type.hashCode() ^ host.hashCode() ^ port;
            }

            public String toString() {
                return "SocketInfo[" + type + " " + host + " " + port + "]";
            }
        };
    }
}

