/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util.log;

import com.sun.messaging.jmq.resources.SharedResources;
import com.sun.messaging.jmq.util.LoggerWrapper;
import com.sun.messaging.jmq.util.MQResourceBundle;
import com.sun.messaging.jmq.util.StringUtil;
import com.sun.messaging.jmq.util.log.ForceLogLevel;
import com.sun.messaging.jmq.util.log.LogRecord;
import com.sun.messaging.jmq.util.log.SysLogHandler;
import com.sun.messaging.jmq.util.log.UniformLogFormatter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;
import java.util.logging.ErrorManager;
import java.util.logging.FileHandler;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import org.glassfish.hk2.api.ServiceLocator;

public class Logger
implements LoggerWrapper {
    private MQResourceBundle rb = null;
    private static java.util.logging.Logger newLogger = null;
    public static final Level EMERGENCY = ForceLogLevel.FORCE;
    public static final String GFLOGFILEKEY = "com.sun.enterprise.server.logging.GFFileHandler.file";
    public static final String JULLOGFILEKEY = "java.util.logging.FileHandler.pattern";
    public static final String SYSLOGHANDLRIDENTKEY = "imq.log.syslog.identity";
    public static final String LOGGERNAME = "imq.log.Logger";
    private Vector deferBuffer = null;
    private boolean closed = false;
    String logHome = null;
    String propPrefix = "";
    public int level = 8;
    public static final int FORCE = 64;
    public static final int ERROR = 32;
    public static final int WARNING = 16;
    public static final int INFO = 8;
    public static final int DEBUG = 4;
    public static final int DEBUGMED = 2;
    public static final int DEBUGHIGH = 1;
    public static final int OFF = Integer.MAX_VALUE;
    private static final String LOGLEVEL_PROP = ".level";
    private static final String TIMEZONE_PROP = "log.timezone";
    private static final String ROLLOVERSECS_PROP = "log.file.rolloversecs";
    private static final String ROLLOVERBYTES_PROP = "java.util.logging.FileHandler.limit";
    private static SharedResources myrb = SharedResources.getResources();
    private SimpleDateFormat df = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss z");

    public Logger(String logHome) {
        this.logHome = logHome;
        newLogger = java.util.logging.Logger.getLogger(LOGGERNAME);
    }

    public void useMilliseconds() {
        this.df = new SimpleDateFormat("dd/MM/yyyy:HH:mm:ss:SS z");
    }

    public int getLevel() {
        return this.level;
    }

    public String[] getUpdateableProperties() {
        String[] v = new String[]{this.propPrefix + "..level", this.propPrefix + ".log.file.rolloversecs", this.propPrefix + ".java.util.logging.FileHandler.limit", this.propPrefix + ".log.timezone"};
        return v;
    }

    public synchronized void updateProperty(String name, String value) {
        if (name == null || value == null || value.equals("")) {
            return;
        }
        name = name.substring(this.propPrefix.length() + 1);
        long n = -1L;
        if (name.equals(LOGLEVEL_PROP)) {
            this.level = Logger.levelStrToInt(value);
            Level julLevel = Logger.levelIntToJULLevel(this.level);
            newLogger.setLevel(julLevel);
        } else if (name.equals(TIMEZONE_PROP)) {
            if (value.length() > 0) {
                this.df.setTimeZone(TimeZone.getTimeZone(value));
            }
        } else if (name.equals(ROLLOVERSECS_PROP) || name.equals(ROLLOVERBYTES_PROP)) {
            try {
                n = Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(myrb.getString("S2000", name, value));
            }
            Handler[] handlers = null;
            handlers = newLogger.getUseParentHandlers() ? newLogger.getParent().getHandlers() : newLogger.getHandlers();
            FileHandler flh = null;
            for (Handler handler : handlers) {
                if (!(handler instanceof FileHandler)) continue;
                flh = (FileHandler)handler;
                break;
            }
            if (flh == null) {
                return;
            }
            if (n == -1L) {
                n = 0L;
            }
        } else {
            throw new IllegalArgumentException(myrb.getString("S4005", name));
        }
    }

    public synchronized void configure(Properties props, String prefix, boolean inProcess, boolean jmsraManaged, ServiceLocator habitat) {
        this.propPrefix = prefix;
        if (props == null) {
            return;
        }
        Level julLevel = null;
        Object property = prefix + ".log.level";
        String value = props.getProperty((String)property);
        if (value != null && !value.trim().equals("")) {
            try {
                this.level = Logger.levelStrToInt(value);
                julLevel = Logger.levelIntToJULLevel(this.level);
            }
            catch (IllegalArgumentException e) {
                this.level = 8;
                julLevel = null;
                this.log(16, myrb.getKString("S2001", property, value));
            }
        }
        if ((value = props.getProperty((String)(property = LOGLEVEL_PROP))) != null && !value.trim().equals("")) {
            try {
                julLevel = Level.parse(value);
                this.level = Logger.levelJULLevelToInt(julLevel);
            }
            catch (IllegalArgumentException e) {
                this.level = 8;
                julLevel = null;
                this.log(16, myrb.getKString("S2001", property, value));
            }
        }
        if (julLevel != null) {
            newLogger.setLevel(julLevel);
        }
        this.loadPropsToNucleusLogging(props, habitat, inProcess, jmsraManaged);
        Handler[] handlers = null;
        handlers = newLogger.getUseParentHandlers() ? newLogger.getParent().getHandlers() : newLogger.getHandlers();
        for (Handler handler : handlers) {
            handler.setErrorManager(new ErrorManager(){
                private boolean reported = false;

                @Override
                public synchronized void error(String msg, Exception ex, int code) {
                    if (this.reported) {
                        return;
                    }
                    this.reported = true;
                    Object text = "java.util.logging.Logger Trouble logging:";
                    if (msg != null) {
                        text = (String)text + ": " + msg;
                    }
                    System.err.println((String)text + ex.getClass().getName());
                }
            });
        }
    }

    private void loadPropsToNucleusLogging(Properties props, ServiceLocator habitat, boolean inProcess, boolean jmsraManaged) {
        boolean rcode;
        File d;
        if (habitat != null) {
            return;
        }
        String propToBeRemoved = "sun.os.patch.level";
        if (props.containsKey("sun.os.patch.level")) {
            props.remove("sun.os.patch.level");
        }
        Properties p = System.getProperties();
        String installRoot = StringUtil.expandVariables("${imq.instanceshome}${/}${imq.instancename}", props);
        if (!(inProcess && jmsraManaged || System.getProperty("com.sun.aas.installRoot") != null)) {
            p.put("com.sun.aas.installRoot", installRoot);
        }
        String key = JULLOGFILEKEY;
        String origValue = null;
        String expandedValue = null;
        origValue = props.getProperty(key);
        if (origValue != null) {
            expandedValue = StringUtil.expandVariables(origValue, props);
            props.put(key, expandedValue);
            this.publish(4, "File logger log file location property key=" + key + ", value=" + expandedValue);
            d = new File(expandedValue);
            if (!d.getParentFile().exists() && !(rcode = d.getParentFile().mkdir())) {
                this.publish(32, myrb.getString("S4000", d.getParentFile().getAbsolutePath()));
            }
        }
        key = GFLOGFILEKEY;
        origValue = null;
        expandedValue = null;
        origValue = props.getProperty(key);
        if (origValue != null) {
            expandedValue = StringUtil.expandVariables(origValue, props);
            props.put(key, expandedValue);
            this.publish(4, "File logger log file location property key=" + key + ", value=" + expandedValue);
            d = new File(expandedValue);
            if (!d.getParentFile().exists() && !(rcode = d.getParentFile().mkdir())) {
                this.publish(32, myrb.getString("S4000", d.getParentFile().getAbsolutePath()));
            }
        }
        key = SYSLOGHANDLRIDENTKEY;
        origValue = null;
        expandedValue = null;
        origValue = props.getProperty(key);
        if (origValue != null) {
            expandedValue = StringUtil.expandVariables(origValue, props);
            props.put(key, expandedValue);
            this.publish(4, "System loghandler identity property key=" + key + ", value=" + expandedValue);
        }
        ByteArrayOutputStream propsStream = new ByteArrayOutputStream();
        if (inProcess && jmsraManaged) {
            this.manuallyConfigureLogging(props);
            return;
        }
        try {
            props.store(propsStream, "Loading into stream to pass on to nucleus logging framework");
            LogManager.getLogManager().readConfiguration(new ByteArrayInputStream(propsStream.toByteArray()));
        }
        catch (IOException e) {
            this.log(32, "Pushing jms properties file to logging framework failed", e);
        }
    }

    private void manuallyConfigureLogging(Properties props) {
        String[] handlerClasses;
        newLogger.setUseParentHandlers(false);
        for (String handlerClass : handlerClasses = this.parseClassNames(props.getProperty("handlers"))) {
            Handler newHandler = null;
            try {
                Class<?> clz = this.getClass().getClassLoader().loadClass(handlerClass);
                if (clz.equals(FileHandler.class)) {
                    int count;
                    int limit;
                    String pattern = props.containsKey(handlerClass + ".pattern") ? props.getProperty(handlerClass + ".pattern") : null;
                    int n = limit = props.containsKey(handlerClass + ".limit") ? Integer.parseInt(props.getProperty(handlerClass + ".limit")) : 0;
                    if (limit < 0) {
                        limit = 0;
                    }
                    int n2 = count = props.containsKey(handlerClass + ".count") ? Integer.parseInt(props.getProperty(handlerClass + ".count")) : 1;
                    if (count <= 0) {
                        count = 1;
                    }
                    boolean append = props.containsKey(handlerClass + ".append") && Boolean.parseBoolean(props.getProperty(handlerClass + ".append"));
                    newHandler = new FileHandler(pattern, limit, count, append);
                    newHandler.setFormatter(new UniformLogFormatter());
                } else {
                    newHandler = clz.equals(SysLogHandler.class) ? new SysLogHandler(props) : (Handler)clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                try {
                    String levs = props.getProperty(handlerClass + LOGLEVEL_PROP);
                    if (levs != null) {
                        newHandler.setLevel(Level.parse(levs));
                    }
                    this.configureCommonHandler(newHandler, props);
                }
                catch (Exception ex) {
                    System.err.println("Can't set level for " + handlerClass);
                }
                newLogger.addHandler(newHandler);
            }
            catch (Exception ex) {
                System.err.println("Can't load config class \"" + handlerClass + "\"");
                System.err.println(String.valueOf(ex));
            }
        }
    }

    private void configureCommonHandler(Handler handler, Properties props) {
        String baseProp = handler.getClass().getName();
        String filterStr = props.getProperty(baseProp + ".filter");
        Filter filter = null;
        try {
            if (filterStr != null) {
                Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(filterStr);
                filter = (Filter)clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                handler.setFilter(filter);
            }
        }
        catch (Exception clz) {
            // empty catch block
        }
        String formatterStr = props.getProperty(baseProp + ".formatter");
        Formatter formatter = this.getFormatter(formatterStr);
        if (formatter != null) {
            handler.setFormatter(formatter);
        }
    }

    private Formatter getFormatter(String formatterString) {
        Formatter formatter = null;
        try {
            if (formatterString != null) {
                Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(formatterString);
                formatter = (Formatter)clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return formatter;
    }

    private String[] parseClassNames(String classNamePropertyValue) {
        if (classNamePropertyValue == null) {
            return new String[0];
        }
        classNamePropertyValue = classNamePropertyValue.trim();
        int ix = 0;
        Vector<String> result = new Vector<String>();
        while (ix < classNamePropertyValue.length()) {
            int end;
            for (end = ix; end < classNamePropertyValue.length() && !Character.isWhitespace(classNamePropertyValue.charAt(end)) && classNamePropertyValue.charAt(end) != ','; ++end) {
            }
            String word = classNamePropertyValue.substring(ix, end);
            ix = end + 1;
            if ((word = word.trim()).length() == 0) continue;
            result.add(word);
        }
        return result.toArray(new String[result.size()]);
    }

    public static int levelStrToInt(String levelStr) {
        if (levelStr.equals("FORCE")) {
            return 64;
        }
        if (levelStr.equals("ERROR")) {
            return 32;
        }
        if (levelStr.equals("WARNING")) {
            return 16;
        }
        if (levelStr.equals("INFO")) {
            return 8;
        }
        if (levelStr.equals("DEBUG")) {
            return 4;
        }
        if (levelStr.equals("DEBUGMED")) {
            return 2;
        }
        if (levelStr.equals("DEBUGHIGH")) {
            return 1;
        }
        if (levelStr.equals("NONE")) {
            return Integer.MAX_VALUE;
        }
        throw new IllegalArgumentException(myrb.getString("S2001", levelStr));
    }

    public static String levelIntToStr(int level) {
        switch (level) {
            case 64: {
                return "FORCE";
            }
            case 32: {
                return "ERROR";
            }
            case 16: {
                return "WARNING";
            }
            case 8: {
                return "INFO";
            }
            case 4: {
                return "DEBUG";
            }
            case 2: {
                return "DEBUGMED";
            }
            case 1: {
                return "DEBUGHIGH";
            }
        }
        String errmsg = "Conversion from custom log level int " + level + " to String failed";
        throw new IllegalArgumentException(errmsg);
    }

    public static String jullevelIntToStr(int level) {
        if (level == Level.ALL.intValue()) {
            return Level.ALL.getName();
        }
        if (level == EMERGENCY.intValue()) {
            return EMERGENCY.getName();
        }
        if (level == Level.SEVERE.intValue()) {
            return Level.SEVERE.getName();
        }
        if (level == Level.WARNING.intValue()) {
            return Level.WARNING.getName();
        }
        if (level == Level.INFO.intValue()) {
            return Level.INFO.getName();
        }
        if (level == Level.CONFIG.intValue()) {
            return Level.CONFIG.getName();
        }
        if (level == Level.FINE.intValue()) {
            return Level.FINE.getName();
        }
        if (level == Level.FINER.intValue()) {
            return Level.FINER.getName();
        }
        if (level == Level.FINEST.intValue()) {
            return Level.FINEST.getName();
        }
        if (level == Level.OFF.intValue()) {
            return Level.OFF.getName();
        }
        String errmsg = "Conversion from JUL log level int " + level + " to String failed";
        throw new IllegalArgumentException(errmsg);
    }

    public static Level levelIntToJULLevel(int level) {
        switch (level) {
            case 64: {
                return EMERGENCY;
            }
            case 32: {
                return Level.SEVERE;
            }
            case 16: {
                return Level.WARNING;
            }
            case 8: {
                return Level.INFO;
            }
            case 4: {
                return Level.FINE;
            }
            case 2: {
                return Level.FINER;
            }
            case 1: {
                return Level.FINEST;
            }
            case 0x7FFFFFFF: {
                return Level.OFF;
            }
        }
        String errmsg = "Conversion from " + level + " to JULLevel failed";
        newLogger.log(Level.SEVERE, errmsg);
        throw new IllegalArgumentException(errmsg);
    }

    public static int levelJULLevelToInt(Level level) {
        if (level.equals(EMERGENCY)) {
            return 64;
        }
        if (level.equals(Level.SEVERE)) {
            return 32;
        }
        if (level.equals(Level.WARNING)) {
            return 16;
        }
        if (level.equals(Level.INFO)) {
            return 8;
        }
        if (level.equals(Level.FINE)) {
            return 4;
        }
        if (level.equals(Level.FINER)) {
            return 2;
        }
        if (level.equals(Level.FINEST)) {
            return 1;
        }
        if (level.equals(Level.OFF)) {
            return Integer.MAX_VALUE;
        }
        String errmsg = "Conversion from " + String.valueOf(level) + " to int failed";
        newLogger.log(Level.SEVERE, errmsg);
        throw new IllegalArgumentException(errmsg);
    }

    public void setResourceBundle(MQResourceBundle rb) {
        this.rb = rb;
    }

    public synchronized void close() {
        Handler[] handlers = null;
        handlers = newLogger.getUseParentHandlers() ? newLogger.getParent().getHandlers() : newLogger.getHandlers();
        if (handlers != null) {
            for (Handler handler : handlers) {
                handler.close();
            }
        }
        this.closed = true;
    }

    public void flush() {
    }

    public void publish(int level, String message) {
        if (this.closed) {
            if (newLogger.getHandlers() == null || newLogger.getHandlers().length == 0) {
                this.defer(level, message);
                return;
            }
            this.flushDeferBuffer();
            this.closed = false;
        }
        try {
            newLogger.log(Logger.levelIntToJULLevel(level), message);
        }
        catch (Exception e) {
            this.defer(level, message);
            this.closed = true;
        }
        boolean loggedOnce = true;
        if (!loggedOnce) {
            System.err.println(message);
        }
    }

    private synchronized void defer(int level, String message) {
        if (this.deferBuffer == null) {
            this.deferBuffer = new Vector(32);
        }
        LogRecord dr = new LogRecord(level, message);
        this.deferBuffer.addElement(dr);
    }

    private synchronized void flushDeferBuffer() {
        if (this.deferBuffer == null) {
            return;
        }
        LogRecord df = null;
        Enumeration e = this.deferBuffer.elements();
        while (e.hasMoreElements()) {
            df = (LogRecord)e.nextElement();
            this.publish(df.level, df.message);
        }
        this.deferBuffer.clear();
        this.deferBuffer = null;
    }

    public String format(int level, String key, Object[] args, Throwable ex, boolean printStack) {
        StringBuilder sb = new StringBuilder(80);
        switch (level) {
            case 32: {
                sb.append(myrb.getString("S0000"));
                break;
            }
            case 16: {
                sb.append(myrb.getString("S0001"));
                break;
            }
        }
        String message = null;
        if (key == null) {
            key = "";
        }
        if (this.rb != null) {
            try {
                message = args == null ? this.rb.getKString(key) : this.rb.getKString(key, args);
            }
            catch (MissingResourceException e) {
                message = null;
            }
        }
        if (message == null) {
            message = args == null ? key : MessageFormat.format(key, args);
        }
        sb.append(message);
        if (ex != null) {
            sb.append(":" + SharedResources.NL);
            if (printStack) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream(512);
                PrintWriter pw = new PrintWriter(bos);
                ex.printStackTrace(pw);
                pw.flush();
                pw.close();
                sb.append(bos);
                try {
                    bos.close();
                }
                catch (IOException iOException) {}
            } else {
                sb.append(String.valueOf(ex) + SharedResources.NL);
            }
        } else {
            sb.append(SharedResources.NL);
        }
        return sb.toString();
    }

    public void log(int level, String msg) {
        if (level < this.level) {
            return;
        }
        this.publish(level, this.format(level, msg, null, null, false));
    }

    public void log(int level, String msg, Object arg) {
        if (level < this.level) {
            return;
        }
        if (arg instanceof Object[]) {
            this.publish(level, this.format(level, msg, (Object[])arg, null, false));
        } else {
            Object[] args = new Object[]{arg};
            this.publish(level, this.format(level, msg, args, null, false));
        }
    }

    public void log(int level, String msg, Object arg1, Object arg2) {
        if (level < this.level) {
            return;
        }
        Object[] args = new Object[]{arg1, arg2};
        this.publish(level, this.format(level, msg, args, null, false));
    }

    public void log(int level, String msg, Object[] args) {
        if (level < this.level) {
            return;
        }
        this.publish(level, this.format(level, msg, args, null, false));
    }

    public void log(int level, String msg, Throwable ex) {
        if (level < this.level) {
            return;
        }
        boolean logStack = this.level <= 4;
        this.publish(level, this.format(level, msg, null, ex, logStack));
    }

    public void log(int level, String msg, Object arg, Throwable ex) {
        boolean logStack;
        if (level < this.level) {
            return;
        }
        boolean bl = logStack = this.level <= 4;
        if (arg instanceof Object[]) {
            this.publish(level, this.format(level, msg, (Object[])arg, ex, logStack));
        } else {
            Object[] args = new Object[]{arg};
            this.publish(level, this.format(level, msg, args, ex, logStack));
        }
    }

    public void log(int level, String msg, Object arg1, Object arg2, Throwable ex) {
        if (level < this.level) {
            return;
        }
        boolean logStack = this.level <= 4;
        Object[] args = new Object[]{arg1, arg2};
        this.publish(level, this.format(level, msg, args, ex, logStack));
    }

    public void log(int level, String msg, Object[] args, Throwable ex) {
        if (level < this.level) {
            return;
        }
        boolean logStack = this.level <= 4;
        this.publish(level, this.format(level, msg, args, ex, logStack));
    }

    public void logStack(int level, String msg, Throwable ex) {
        if (level < this.level) {
            return;
        }
        this.publish(level, this.format(level, msg, null, ex, true));
    }

    public void logStack(int level, String msg, Object arg, Throwable ex) {
        if (level < this.level) {
            return;
        }
        if (arg instanceof Object[]) {
            this.publish(level, this.format(level, msg, (Object[])arg, ex, true));
        } else {
            Object[] args = new Object[]{arg};
            this.publish(level, this.format(level, msg, args, ex, true));
        }
    }

    public void logStack(int level, String msg, Object arg1, Object arg2, Throwable ex) {
        if (level < this.level) {
            return;
        }
        Object[] args = new Object[]{arg1, arg2};
        this.publish(level, this.format(level, msg, args, ex, true));
    }

    public void logStack(int level, String msg, Object[] args, Throwable ex) {
        if (level < this.level) {
            return;
        }
        this.publish(level, this.format(level, msg, args, ex, true));
    }

    public void logToAll(int level, String msg, Object[] args) {
        this.publish(64, this.format(level, msg, args, null, false));
    }

    public void logToAll(int level, String msg) {
        this.publish(64, this.format(level, msg, null, null, false));
    }

    public void logToAll(int level, String msg, Object arg1, Object arg2) {
        Object[] args = new Object[]{arg1, arg2};
        this.publish(64, this.format(level, msg, args, null, false));
    }

    public void logToAll(int level, String msg, Object arg) {
        if (arg instanceof Object[]) {
            this.publish(64, this.format(level, msg, (Object[])arg, null, false));
        } else {
            Object[] args = new Object[]{arg};
            this.publish(64, this.format(level, msg, args, null, false));
        }
    }

    @Override
    public void logInfo(String msg, Throwable t) {
        if (t == null) {
            this.log(8, msg);
        } else {
            this.logStack(8, msg, t);
        }
    }

    @Override
    public void logWarn(String msg, Throwable t) {
        if (t == null) {
            this.log(16, msg);
        } else {
            this.logStack(16, msg, t);
        }
    }

    @Override
    public void logSevere(String msg, Throwable t) {
        if (t == null) {
            this.log(32, msg);
        } else {
            this.logStack(32, msg, t);
        }
    }

    @Override
    public void logFine(String msg, Throwable t) {
        if (t == null) {
            this.log(4, msg);
        } else {
            this.logStack(4, msg, t);
        }
    }

    @Override
    public void logFinest(String msg, Throwable t) {
        if (t == null) {
            this.log(1, msg);
        } else {
            this.logStack(1, msg, t);
        }
    }

    @Override
    public boolean isFineLoggable() {
        return this.getLevel() <= 4;
    }

    @Override
    public boolean isFinestLoggable() {
        return this.getLevel() <= 1;
    }

    @Override
    public boolean isInfoLoggable() {
        return this.getLevel() <= 8;
    }
}

