/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.lite.extension.translator;

import jakarta.enterprise.inject.build.compatible.spi.ParameterConfig;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.configurator.AnnotatedParameterConfigurator;
import jakarta.enterprise.lang.model.AnnotationInfo;
import jakarta.enterprise.lang.model.declarations.ParameterInfo;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.function.Predicate;
import org.jboss.weld.lite.extension.translator.AnnotationInfoImpl;
import org.jboss.weld.lite.extension.translator.AnnotationProxy;
import org.jboss.weld.lite.extension.translator.ParameterInfoImpl;

class ParameterConfigImpl
implements ParameterConfig {
    private final AnnotatedParameterConfigurator<?> configurator;
    private final BeanManager bm;

    ParameterConfigImpl(AnnotatedParameterConfigurator<?> configurator, BeanManager bm) {
        this.configurator = configurator;
        this.bm = bm;
    }

    @Override
    public ParameterInfo info() {
        return new ParameterInfoImpl(this.configurator.getAnnotated(), this.bm);
    }

    @Override
    public ParameterConfig addAnnotation(Class<? extends Annotation> annotationType) {
        this.configurator.add(AnnotationProxy.create(annotationType, Collections.emptyMap()));
        return this;
    }

    @Override
    public ParameterConfig addAnnotation(AnnotationInfo annotation) {
        this.configurator.add(((AnnotationInfoImpl)annotation).annotation);
        return this;
    }

    @Override
    public ParameterConfig addAnnotation(Annotation annotation) {
        this.configurator.add(annotation);
        return this;
    }

    @Override
    public ParameterConfig removeAnnotation(Predicate<AnnotationInfo> predicate) {
        this.configurator.remove(annotation -> predicate.test(new AnnotationInfoImpl((Annotation)annotation, this.bm)));
        return this;
    }

    @Override
    public ParameterConfig removeAllAnnotations() {
        this.configurator.removeAll();
        return this;
    }
}

