/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import com.sun.enterprise.security.store.DomainScopedPasswordAliasStore;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glassfish.config.support.Strings;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigView;

public class TranslatedConfigView
implements ConfigView {
    static final Pattern p = Pattern.compile("([^\\$]*)\\$\\{([^\\}]*)\\}([^\\$]*)");
    private static final String ALIAS_TOKEN = "ALIAS";
    private static final int MAX_SUBSTITUTION_DEPTH = 100;
    private static final Pattern INVALID_ENV_VAR_CHARS_PATTERN = Pattern.compile("[^a-zA-Z0-9_]");
    final ConfigView masterView;
    static ServiceLocator habitat;

    public static String expandValue(String value) {
        return (String)TranslatedConfigView.getTranslatedValue(value);
    }

    public static String getProperty(String propertyName) {
        return TranslatedConfigView.expandValue("${" + propertyName + "}");
    }

    public static boolean isPropertyTrue(String propertyName) {
        return Boolean.parseBoolean(TranslatedConfigView.expandValue("${" + propertyName + "}"));
    }

    public static Object getTranslatedValue(Object value) {
        if (value != null && value instanceof String) {
            int i;
            String stringValue = value.toString();
            if (stringValue.indexOf(36) == -1) {
                return value;
            }
            DomainScopedPasswordAliasStore dasPasswordAliasStore = TranslatedConfigView.domainPasswordAliasStore();
            if (dasPasswordAliasStore != null && TranslatedConfigView.getAlias(stringValue) != null) {
                try {
                    return TranslatedConfigView.getRealPasswordFromAlias(stringValue, dasPasswordAliasStore);
                }
                catch (Exception e) {
                    Logger.getAnonymousLogger().severe(Strings.get("TranslatedConfigView.aliaserror", stringValue, e.getLocalizedMessage()));
                    return stringValue;
                }
            }
            Matcher m = p.matcher(stringValue);
            String origValue = stringValue;
            boolean useEnvVars = !Boolean.getBoolean("org.glassfish.variableExpansion.envDisabled");
            boolean preferEnvVars = false;
            if (useEnvVars) {
                preferEnvVars = Boolean.getBoolean("org.glassfish.variableExpansion.envPreferred");
            }
            for (i = 0; m.find() && i < 100; ++i) {
                String variableName = m.group(2).trim();
                String newValue = TranslatedConfigView.getPropertyValue(variableName, useEnvVars, preferEnvVars);
                if (newValue == null) continue;
                stringValue = m.replaceFirst(Matcher.quoteReplacement(m.group(1) + newValue + m.group(3)));
                m.reset(stringValue);
            }
            if (i >= 100) {
                Logger.getAnonymousLogger().severe(Strings.get("TranslatedConfigView.badprop", i, origValue));
            }
            return stringValue;
        }
        return value;
    }

    private static String getPropertyValue(String variableName, boolean useEnvVars, boolean preferEnvVars) {
        String value = null;
        if (!preferEnvVars || !useEnvVars) {
            value = System.getProperty(variableName);
        }
        if (value == null && useEnvVars && (value = System.getenv(variableName)) == null) {
            String modifiedVariableName = INVALID_ENV_VAR_CHARS_PATTERN.matcher(variableName).replaceAll("_");
            value = System.getenv(modifiedVariableName);
            if (value == null) {
                modifiedVariableName = modifiedVariableName.toUpperCase();
                value = System.getenv(modifiedVariableName);
            }
            if (value == null && preferEnvVars) {
                value = System.getProperty(variableName);
            }
        }
        return value;
    }

    TranslatedConfigView(ConfigView master) {
        this.masterView = master;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return TranslatedConfigView.getTranslatedValue(this.masterView.invoke(proxy, method, args));
    }

    public ConfigView getMasterView() {
        return this.masterView;
    }

    public void setMasterView(ConfigView view) {
    }

    public <T extends ConfigBeanProxy> Class<T> getProxyType() {
        return this.masterView.getProxyType();
    }

    public <T extends ConfigBeanProxy> T getProxy(Class<T> proxyType) {
        return (T)((ConfigBeanProxy)proxyType.cast(Proxy.newProxyInstance(proxyType.getClassLoader(), new Class[]{proxyType}, (InvocationHandler)((Object)this))));
    }

    public static void setHabitat(ServiceLocator h) {
        habitat = h;
    }

    private static DomainScopedPasswordAliasStore domainPasswordAliasStore() {
        return (DomainScopedPasswordAliasStore)habitat.getService(DomainScopedPasswordAliasStore.class, new Annotation[0]);
    }

    public static String getAlias(String propName) {
        int lastIdx;
        String aliasName = null;
        String starter = "${ALIAS=";
        String ender = "}";
        if ((propName = propName.trim()).startsWith(starter) && propName.endsWith(ender) && (lastIdx = (propName = propName.substring(starter.length())).length() - 1) > 1) {
            propName = propName.substring(0, lastIdx);
            aliasName = propName.trim();
        }
        return aliasName;
    }

    private static String getRealPasswordFromAlias(String at, DomainScopedPasswordAliasStore dasPwdAliasStore) {
        String an = TranslatedConfigView.getAlias(at);
        boolean exists = dasPwdAliasStore.containsKey(an);
        if (!exists) {
            throw new IllegalArgumentException(String.format("Alias  %s does not exist", an));
        }
        return new String(dasPwdAliasStore.get(an));
    }
}

