/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.loader;

import com.sun.logging.LogCleanerUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipFile;
import org.apache.catalina.LogFacade;
import org.glassfish.web.loader.Reloader;

public class StandardClassLoader
extends URLClassLoader
implements Reloader {
    private static final Logger log = LogFacade.getLogger();
    protected int debug = 0;
    protected boolean delegate = false;
    protected ArrayList<String> repositories = new ArrayList();
    private final ArrayList<Permission> permissionList = new ArrayList();
    private final HashMap<String, PermissionCollection> loaderPC = new HashMap();
    private boolean policy_refresh = false;
    private ClassLoader parent = null;
    private ClassLoader system = null;
    protected URLStreamHandlerFactory factory = null;

    public StandardClassLoader() {
        super(new URL[0]);
        this.parent = this.getParent();
        this.system = StandardClassLoader.getSystemClassLoader();
    }

    public StandardClassLoader(URLStreamHandlerFactory factory) {
        super(new URL[0], null, factory);
        this.factory = factory;
    }

    public StandardClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
        this.parent = parent;
        this.system = StandardClassLoader.getSystemClassLoader();
    }

    public StandardClassLoader(ClassLoader parent, URLStreamHandlerFactory factory) {
        super(new URL[0], parent, factory);
        this.factory = factory;
    }

    public StandardClassLoader(String[] repositories) {
        this(StandardClassLoader.convert(repositories));
    }

    public StandardClassLoader(String[] repositories, ClassLoader parent) {
        this(StandardClassLoader.convert(repositories), parent);
    }

    public StandardClassLoader(URL[] repositories) {
        super(repositories);
        this.parent = this.getParent();
        this.system = StandardClassLoader.getSystemClassLoader();
        if (repositories != null) {
            for (URL element : repositories) {
                this.addRepositoryInternal(element.toString());
            }
        }
    }

    public StandardClassLoader(URL[] repositories, ClassLoader parent) {
        super(repositories, parent);
        this.parent = parent;
        this.system = StandardClassLoader.getSystemClassLoader();
        if (repositories != null) {
            for (URL element : repositories) {
                this.addRepositoryInternal(element.toString());
            }
        }
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public boolean getDelegate() {
        return this.delegate;
    }

    public void setDelegate(boolean delegate) {
        this.delegate = delegate;
    }

    public void addRepository(String repository) {
        if (this.debug >= 1) {
            this.log("addRepository(" + repository + ")");
        }
        try {
            URLStreamHandler streamHandler = null;
            String protocol = StandardClassLoader.parseProtocol(repository);
            if (this.factory != null) {
                streamHandler = this.factory.createURLStreamHandler(protocol);
            }
            URL url = new URL(null, repository, streamHandler);
            super.addURL(url);
        }
        catch (MalformedURLException e) {
            IllegalArgumentException iae = new IllegalArgumentException("Invalid repository: " + repository);
            iae.initCause(e);
            throw iae;
        }
        this.addRepositoryInternal(repository);
    }

    public boolean modified() {
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("StandardClassLoader\r\n");
        sb.append("  delegate: ");
        sb.append(this.delegate);
        sb.append("\r\n");
        sb.append("  repositories:\r\n");
        for (String element : this.repositories) {
            sb.append("    ");
            sb.append(element);
            sb.append("\r\n");
        }
        if (this.parent != null) {
            sb.append("----------> Parent Classloader:\r\n");
            sb.append(this.parent.toString());
            sb.append("\r\n");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class findClass(String name) throws ClassNotFoundException {
        if (this.debug >= 3) {
            this.log("    findClass(" + name + ")");
        }
        Class<?> clazz = null;
        try {
            if (this.debug >= 4) {
                this.log("      super.findClass(" + name + ")");
            }
            try {
                StandardClassLoader standardClassLoader = this;
                synchronized (standardClassLoader) {
                    clazz = this.findLoadedClass(name);
                    if (clazz != null) {
                        return clazz;
                    }
                    clazz = super.findClass(name);
                }
            }
            catch (RuntimeException e) {
                if (this.debug >= 4) {
                    this.log("      -->RuntimeException Rethrown", e);
                }
                throw e;
            }
            if (clazz == null) {
                if (this.debug >= 3) {
                    this.log("    --> Returning ClassNotFoundException");
                }
                throw new ClassNotFoundException(name);
            }
        }
        catch (ClassNotFoundException e) {
            if (this.debug >= 3) {
                this.log("    --> Passing on ClassNotFoundException", e);
            }
            throw e;
        }
        if (this.debug >= 4) {
            this.log("      Returning class " + String.valueOf(clazz));
            this.log("      Loaded by " + String.valueOf(clazz.getClassLoader()));
        }
        return clazz;
    }

    @Override
    public URL findResource(String name) {
        if (this.debug >= 3) {
            this.log("    findResource(" + name + ")");
        }
        URL url = super.findResource(name);
        if (this.debug >= 3) {
            if (url != null) {
                this.log("    --> Returning '" + url.toString() + "'");
            } else {
                this.log("    --> Resource not found, returning null");
            }
        }
        return url;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        if (this.debug >= 3) {
            this.log("    findResources(" + name + ")");
        }
        return super.findResources(name);
    }

    @Override
    public URL getResource(String name) {
        ClassLoader loader;
        if (this.debug >= 2) {
            this.log("getResource(" + name + ")");
        }
        URL url = null;
        if (this.delegate) {
            if (this.debug >= 3) {
                this.log("  Delegating to parent classloader");
            }
            if ((loader = this.parent) == null) {
                loader = this.system;
            }
            if ((url = loader.getResource(name)) != null) {
                if (this.debug >= 2) {
                    this.log("  --> Returning '" + url.toString() + "'");
                }
                return url;
            }
        }
        if (this.debug >= 3) {
            this.log("  Searching local repositories");
        }
        if ((url = this.findResource(name)) != null) {
            if (this.debug >= 2) {
                this.log("  --> Returning '" + url.toString() + "'");
            }
            return url;
        }
        if (!this.delegate) {
            loader = this.parent;
            if (loader == null) {
                loader = this.system;
            }
            if ((url = loader.getResource(name)) != null) {
                if (this.debug >= 2) {
                    this.log("  --> Returning '" + url.toString() + "'");
                }
                return url;
            }
        }
        if (this.debug >= 2) {
            this.log("  --> Resource not found, returning null");
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        URL url;
        if (this.debug >= 2) {
            this.log("getResourceAsStream(" + name + ")");
        }
        InputStream stream = null;
        stream = this.findLoadedResource(name);
        if (stream != null) {
            if (this.debug >= 2) {
                this.log("  --> Returning stream from cache");
            }
            return stream;
        }
        if (this.delegate) {
            ClassLoader loader;
            if (this.debug >= 3) {
                this.log("  Delegating to parent classloader");
            }
            if ((loader = this.parent) == null) {
                loader = this.system;
            }
            if ((stream = loader.getResourceAsStream(name)) != null) {
                if (this.debug >= 2) {
                    this.log("  --> Returning stream from parent");
                }
                return stream;
            }
        }
        if (this.debug >= 3) {
            this.log("  Searching local repositories");
        }
        if ((url = this.findResource(name)) != null) {
            if (this.debug >= 2) {
                this.log("  --> Returning stream from local");
            }
            try {
                return url.openStream();
            }
            catch (IOException e) {
                this.log("url.openStream(" + url.toString() + ")", e);
                return null;
            }
        }
        if (!this.delegate) {
            ClassLoader loader;
            if (this.debug >= 3) {
                this.log("  Delegating to parent classloader");
            }
            if ((loader = this.parent) == null) {
                loader = this.system;
            }
            if ((stream = loader.getResourceAsStream(name)) != null) {
                if (this.debug >= 2) {
                    this.log("  --> Returning stream from parent");
                }
                return stream;
            }
        }
        if (this.debug >= 2) {
            this.log("  --> Resource not found, returning null");
        }
        return null;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        ClassLoader loader3;
        if (this.debug >= 2) {
            this.log("loadClass(" + name + ", " + resolve + ")");
        }
        Class<?> clazz = null;
        clazz = this.findLoadedClass(name);
        if (clazz != null) {
            if (this.debug >= 3) {
                this.log("  Returning class from cache");
            }
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        if (name.startsWith("java.")) {
            ClassLoader loader2 = this.system;
            clazz = loader2.loadClass(name);
            if (clazz != null) {
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
            throw new ClassNotFoundException(name);
        }
        if (this.delegate) {
            if (this.debug >= 3) {
                this.log("  Delegating to parent classloader");
            }
            if ((loader3 = this.parent) == null) {
                loader3 = this.system;
            }
            try {
                clazz = loader3.loadClass(name);
                if (clazz != null) {
                    if (this.debug >= 3) {
                        this.log("  Loading class from parent");
                    }
                    if (resolve) {
                        this.resolveClass(clazz);
                    }
                    return clazz;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (this.debug >= 3) {
            this.log("  Searching local repositories");
        }
        try {
            clazz = this.findClass(name);
            if (clazz != null) {
                if (this.debug >= 3) {
                    this.log("  Loading class from local repository");
                }
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
        }
        catch (ClassNotFoundException loader3) {
            // empty catch block
        }
        if (!this.delegate) {
            if (this.debug >= 3) {
                this.log("  Delegating to parent classloader");
            }
            if ((loader3 = this.parent) == null) {
                loader3 = this.system;
            }
            try {
                clazz = loader3.loadClass(name);
                if (clazz != null) {
                    if (this.debug >= 3) {
                        this.log("  Loading class from parent");
                    }
                    if (resolve) {
                        this.resolveClass(clazz);
                    }
                    return clazz;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException(name);
    }

    protected static String parseProtocol(String spec) {
        if (spec == null) {
            return "";
        }
        int pos = spec.indexOf(58);
        if (pos <= 0) {
            return "";
        }
        return spec.substring(0, pos).trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addRepositoryInternal(String repository) {
        block23: {
            URLStreamHandler streamHandler = null;
            String protocol = StandardClassLoader.parseProtocol(repository);
            if (this.factory != null) {
                streamHandler = this.factory.createURLStreamHandler(protocol);
            }
            if (!repository.endsWith(File.separator) && !repository.endsWith("/")) {
                ZipFile jarFile = null;
                try {
                    if (repository.startsWith("jar:")) {
                        URL url = new URL(null, repository, streamHandler);
                        JarURLConnection conn = (JarURLConnection)url.openConnection();
                        conn.setAllowUserInteraction(false);
                        conn.setDoInput(true);
                        conn.setDoOutput(false);
                        conn.connect();
                        jarFile = conn.getJarFile();
                        break block23;
                    }
                    if (repository.startsWith("file://")) {
                        jarFile = new JarFile(repository.substring(7));
                        break block23;
                    }
                    if (repository.startsWith("file:")) {
                        jarFile = new JarFile(repository.substring(5));
                        break block23;
                    }
                    if (repository.endsWith(".jar")) {
                        URL url = new URL(null, repository, streamHandler);
                        URLConnection conn = url.openConnection();
                        JarInputStream jis = new JarInputStream(conn.getInputStream());
                        try {
                            jis.getManifest();
                            break block23;
                        }
                        finally {
                            try {
                                jis.close();
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                    throw new IllegalArgumentException("addRepositoryInternal:  Invalid URL '" + repository + "'");
                }
                catch (Throwable t) {
                    IllegalArgumentException iae = new IllegalArgumentException("addRepositoryInternal");
                    iae.initCause(t);
                    throw iae;
                }
                finally {
                    if (jarFile != null) {
                        try {
                            jarFile.close();
                        }
                        catch (Throwable url) {}
                    }
                }
            }
        }
        this.repositories.add(repository);
    }

    protected static URL[] convert(String[] input) {
        return StandardClassLoader.convert(input, null);
    }

    protected static URL[] convert(String[] input, URLStreamHandlerFactory factory) {
        URLStreamHandler streamHandler = null;
        URL[] url = new URL[input.length];
        for (int i = 0; i < url.length; ++i) {
            try {
                String protocol = StandardClassLoader.parseProtocol(input[i]);
                streamHandler = factory != null ? factory.createURLStreamHandler(protocol) : null;
                url[i] = new URL(null, input[i], streamHandler);
                continue;
            }
            catch (MalformedURLException e) {
                url[i] = null;
            }
        }
        return url;
    }

    protected InputStream findLoadedResource(String name) {
        return null;
    }

    private void log(String message) {
        message = LogCleanerUtil.neutralizeForLog((String)message);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "StandardClassLoader: " + message);
        }
    }

    private void log(String message, Throwable throwable) {
        message = LogCleanerUtil.neutralizeForLog((String)message);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "StandardClassLoader: " + message, throwable);
        }
    }
}

