/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.logging;

import java.io.Serializable;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.logging.ConfigurationLogger;
import org.jboss.weld.logging.WeldLogger;

public class ConfigurationLogger_$logger
extends DelegatingBasicLogger
implements ConfigurationLogger,
WeldLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ConfigurationLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public ConfigurationLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String invalidConfigurationPropertyValue$str() {
        return "WELD-001900: Invalid configuration property value {0} for key {1}";
    }

    @Override
    public final IllegalStateException invalidConfigurationPropertyValue(Object value, Object key) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.invalidConfigurationPropertyValue$str(), value, key));
        ConfigurationLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private String _formatMessage(String format, Object ... args) {
        MessageFormat formatter = new MessageFormat(format, this.getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new FieldPosition(0)).toString();
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) {
            e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        }
    }

    protected String configurationPropertyTypeMismatch$str() {
        return "WELD-001901: Configuration property type {0} does not match the required type {1} for configuration key {2}";
    }

    @Override
    public final IllegalStateException configurationPropertyTypeMismatch(Object propertyType, Object requiredType, Object key) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.configurationPropertyTypeMismatch$str(), propertyType, requiredType, key));
        ConfigurationLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void configurationInitialized(Object configuration) {
        this.log.logv(FQCN, Logger.Level.DEBUG, (Throwable)null, this.configurationInitialized$str(), configuration);
    }

    protected String configurationInitialized$str() {
        return "WELD-001902: Following configuration was detected and applied: {0}";
    }

    @Override
    public final void configurationKeyAlreadySet(Object configurationKey, Object value, Object ignoredValue, String mergedSourceDescription) {
        this.log.logv(FQCN, Logger.Level.DEBUG, null, this.configurationKeyAlreadySet$str(), configurationKey, value, ignoredValue, mergedSourceDescription);
    }

    protected String configurationKeyAlreadySet$str() {
        return "WELD-001903: Configuration key {0} already set to {1} in a source with higher priority, value {2} from {3} is ignored";
    }

    @Override
    public final void unsupportedConfigurationKeyFound(Object key) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.unsupportedConfigurationKeyFound$str(), key);
    }

    protected String unsupportedConfigurationKeyFound$str() {
        return "WELD-001904: Unsupported configuration key found and ignored: {0}";
    }

    protected String configurationKeyHasDifferentValues$str() {
        return "WELD-001905: Configuration key {0} set to different values in the same source:\n - {1}\n - {2}";
    }

    @Override
    public final IllegalStateException configurationKeyHasDifferentValues(Object key, Object value1, Object value2) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.configurationKeyHasDifferentValues$str(), key, value1, value2));
        ConfigurationLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void resourceLoaderNotSpecifiedForArchive(Object archive) {
        this.log.logv(FQCN, Logger.Level.DEBUG, (Throwable)null, this.resourceLoaderNotSpecifiedForArchive$str(), archive);
    }

    protected String resourceLoaderNotSpecifiedForArchive$str() {
        return "WELD-001906: ResourceLoader not specified for {0}, file properties will not be loaded";
    }

    @Override
    public final void readingPropertiesFile(Object file) {
        this.log.logv(FQCN, Logger.Level.DEBUG, (Throwable)null, this.readingPropertiesFile$str(), file);
    }

    protected String readingPropertiesFile$str() {
        return "WELD-001907: Reading properties file: {0}";
    }

    @Override
    public final void cannotSetIntegratorOnlyConfigurationProperty(Object key, Object value) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.cannotSetIntegratorOnlyConfigurationProperty$str(), key, value);
    }

    protected String cannotSetIntegratorOnlyConfigurationProperty$str() {
        return "WELD-001908: Configuration property {0} can only be set by integrator - value {1} ignored";
    }

    @Override
    public final void catchingDebug(Throwable throwable) {
        this.log.logf(FQCN, Logger.Level.DEBUG, throwable, this.catchingDebug$str(), new Object[0]);
    }

    protected String catchingDebug$str() {
        return "Catching";
    }
}

