/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.epicyro.services;

import jakarta.security.auth.message.config.AuthConfigProvider;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import org.glassfish.epicyro.config.factory.ConfigParser;
import org.glassfish.epicyro.config.factory.DefaultConfigParser;
import org.glassfish.epicyro.config.helper.AuthMessagePolicy;
import org.glassfish.epicyro.config.module.configprovider.GFServerConfigProvider;
import org.glassfish.epicyro.config.servlet.sam.BasicServerAuthModule;
import org.glassfish.epicyro.config.servlet.sam.FormServerAuthModule;
import org.glassfish.epicyro.services.BaseAuthenticationService;

public class DefaultAuthenticationService
extends BaseAuthenticationService {
    public DefaultAuthenticationService(String appContextId, Map<String, Object> properties, ConfigParser parser, CallbackHandler callbackHandler) {
        ConfigParser configParser = parser;
        if (properties.containsKey("authMethod")) {
            if ("basic".equalsIgnoreCase((String)properties.get("authMethod"))) {
                DefaultConfigParser newParser = new DefaultConfigParser();
                newParser.withAuthModuleClass(BasicServerAuthModule.class).getOptions().put("realmName", properties.get("realmName"));
                properties.put("authModuleId", BasicServerAuthModule.class.getSimpleName());
                configParser = newParser;
            } else if ("form".equalsIgnoreCase((String)properties.get("authMethod"))) {
                DefaultConfigParser newParser = new DefaultConfigParser();
                Map<String, Object> options = newParser.withAuthModuleClass(FormServerAuthModule.class).getOptions();
                options.put("formLoginPage", properties.get("formLoginPage"));
                options.put("formErrorPage", properties.get("formErrorPage"));
                properties.put("authModuleId", FormServerAuthModule.class.getSimpleName());
                configParser = newParser;
            }
        }
        this.init("HttpServlet", appContextId, properties, callbackHandler, null);
        if (properties.containsKey("authModuleId") && !this.hasExactMatchAuthProvider()) {
            this.setRegistrationId(this.authConfigFactory.registerConfigProvider((AuthConfigProvider)new GFServerConfigProvider(properties, configParser, this.authConfigFactory), "HttpServlet", appContextId, "Eleos provider: HttpServlet:" + appContextId));
        }
    }

    @Override
    public CallbackHandler getCallbackHandler() {
        return AuthMessagePolicy.getDefaultCallbackHandler();
    }
}

