/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.portunif;

import com.sun.messaging.portunif.PUServiceCallback;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.nio.transport.TCPNIOConnection;
import org.glassfish.grizzly.portunif.PUContext;
import org.glassfish.grizzly.portunif.ProtocolFinder;

public class PortMapperProtocolFinder
implements ProtocolFinder {
    private static boolean DEBUG = false;
    public static final int PORTMAPPER_VERSION_MAX_LEN = 128;
    private PUServiceCallback callback = null;
    private boolean ssl = false;

    public PortMapperProtocolFinder(PUServiceCallback callback, boolean ssl) {
        this.callback = callback;
        this.ssl = ssl;
    }

    public ProtocolFinder.Result find(PUContext puContext, FilterChainContext ctx) {
        InetSocketAddress address;
        TCPNIOConnection connection;
        SocketAddress sa;
        Buffer input = (Buffer)ctx.getMessage();
        int len = input.remaining();
        if (len <= 0) {
            return ProtocolFinder.Result.NEED_MORE_DATA;
        }
        String data = input.toStringContent(Charset.forName("UTF-8"), 0, Math.min(128, len));
        int ind1 = data.indexOf("\r");
        int ind2 = data.indexOf("\n");
        if (DEBUG) {
            String logmsg = String.valueOf(this) + ": input=" + input.toStringContent() + ", newline index: " + ind1 + ", " + ind2;
            if (this.callback != null) {
                this.callback.logInfo(logmsg);
            } else {
                System.out.println(logmsg);
            }
        }
        if (ind1 == 0 || ind2 == 0) {
            return ProtocolFinder.Result.NOT_FOUND;
        }
        int indmax = Math.max(ind1, ind2);
        if (indmax < 0) {
            if (len >= 128) {
                return ProtocolFinder.Result.NOT_FOUND;
            }
            return ProtocolFinder.Result.NEED_MORE_DATA;
        }
        int indmin = Math.min(ind1, ind2);
        if (!data.substring(0, indmin < 0 ? indmax : indmin).matches("\\d+")) {
            if (DEBUG) {
                String logmsg = String.valueOf(this) + ": data not all digits before newline:[" + data.substring(0, indmin < 0 ? indmax : indmin) + "]";
                if (this.callback != null) {
                    this.callback.logInfo(logmsg);
                } else {
                    System.out.println(logmsg);
                }
            }
            return ProtocolFinder.Result.NOT_FOUND;
        }
        if (DEBUG) {
            String logmsg = String.valueOf(this) + ": FOUND input=" + input.toStringContent();
            if (this.callback != null) {
                this.callback.logInfo(logmsg);
            } else {
                System.out.println(logmsg);
            }
        }
        if (this.callback == null) {
            return ProtocolFinder.Result.FOUND;
        }
        Connection c = ctx.getConnection();
        if (c instanceof TCPNIOConnection && (sa = (connection = (TCPNIOConnection)c).getPeerAddress()) instanceof InetSocketAddress && this.callback.allowConnection(address = (InetSocketAddress)sa, this.ssl)) {
            return ProtocolFinder.Result.FOUND;
        }
        return ProtocolFinder.Result.NOT_FOUND;
    }
}

