/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ee.authorization;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.security.ee.web.integration.SecurityRoleMapperFactoryGen;
import com.sun.enterprise.security.util.IASSecurityException;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.security.jacc.PolicyConfiguration;
import jakarta.security.jacc.PolicyConfigurationFactory;
import jakarta.security.jacc.PolicyContextException;
import jakarta.security.jacc.PolicyFactory;
import java.util.Set;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.deployment.common.RootDeploymentDescriptor;
import org.glassfish.deployment.common.SecurityRoleMapperFactory;
import org.glassfish.deployment.versioning.VersioningUtils;

public class AuthorizationUtil {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(AuthorizationUtil.class);
    public static final String VENDOR_PRESENT = "com.sun.enterprise.security.ee.provider.jaccvendorpresent";
    private static final String REPOSITORY_HOME_PROP = "com.sun.enterprise.jaccprovider.property.repository";
    public static final String repository = System.getProperty("com.sun.enterprise.jaccprovider.property.repository");

    public static String getContextID(EjbBundleDescriptor ejbBundleDesc) {
        if (ejbBundleDesc == null) {
            return null;
        }
        RootDeploymentDescriptor root = ejbBundleDesc.getModuleDescriptor().getDescriptor();
        if (root != ejbBundleDesc && root instanceof WebBundleDescriptor) {
            return AuthorizationUtil.createUniquePseudoModuleID(ejbBundleDesc);
        }
        return VersioningUtils.getRepositoryName((String)ejbBundleDesc.getApplication().getRegistrationName()) + "/" + ejbBundleDesc.getUniqueFriendlyId();
    }

    public static String getContextID(WebBundleDescriptor webBundleDescriptor) {
        if (webBundleDescriptor == null) {
            return null;
        }
        return VersioningUtils.getRepositoryName((String)webBundleDescriptor.getApplication().getRegistrationName()) + "/" + webBundleDescriptor.getUniqueFriendlyId();
    }

    public static void removePolicy(String contextId) throws IASSecurityException {
        if (contextId == null) {
            throw new IASSecurityException("Invalid Module Name");
        }
        try {
            boolean wasInService = PolicyConfigurationFactory.getPolicyConfigurationFactory().inService(contextId);
            PolicyConfiguration policyConfiguration = PolicyConfigurationFactory.getPolicyConfigurationFactory().getPolicyConfiguration(contextId, false);
            policyConfiguration.delete();
            if (wasInService) {
                PolicyFactory.getPolicyFactory().getPolicy().refresh();
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new IASSecurityException(localStrings.getLocalString("enterprise.security.securityutil.classnotfound", "Could not find PolicyConfigurationFactory class. Check jakarta.security.jacc.PolicyConfigurationFactory.provider property"));
        }
        catch (PolicyContextException pce) {
            throw new IASSecurityException(pce.toString());
        }
    }

    public static SecurityRoleMapperFactory getRoleMapperFactory() {
        SecurityRoleMapperFactory factory = SecurityRoleMapperFactoryGen.getSecurityRoleMapperFactory();
        if (factory == null) {
            throw new IllegalArgumentException("This application has no role mapper factory defined");
        }
        return factory;
    }

    public static void removeRoleMapper(DeploymentContext deploymentContext) {
        OpsParams params = deploymentContext.getCommandParameters(OpsParams.class);
        if (params.origin != OpsParams.Origin.undeploy) {
            return;
        }
        AuthorizationUtil.getRoleMapperFactory().removeRoleMapper(params.name());
    }

    private static String createUniquePseudoModuleID(EjbBundleDescriptor ejbDesc) {
        String pseudonym;
        boolean unique;
        Application app = ejbDesc.getApplication();
        Set webModules = app.getBundleDescriptors(WebBundleDescriptor.class);
        Set ejbModules = app.getBundleDescriptors(EjbBundleDescriptor.class);
        String moduleName = ejbDesc.getUniqueFriendlyId();
        int uniquifier = 0;
        do {
            unique = true;
            pseudonym = moduleName + (String)(uniquifier == 0 ? "_internal" : "_internal_" + uniquifier);
            if (webModules != null) {
                for (WebBundleDescriptor w : webModules) {
                    if (!pseudonym.equals(w.getUniqueFriendlyId())) continue;
                    unique = false;
                    break;
                }
            }
            if (unique && ejbModules != null) {
                for (EjbBundleDescriptor e : ejbModules) {
                    if (!pseudonym.equals(e.getUniqueFriendlyId())) continue;
                    unique = false;
                    break;
                }
            }
            ++uniquifier;
        } while (!unique);
        return VersioningUtils.getRepositoryName((String)app.getRegistrationName()) + "/" + pseudonym;
    }
}

