/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.mp;

import io.helidon.common.GenericType;
import io.helidon.config.Config;
import io.helidon.config.ConfigValue;
import io.helidon.config.MetaConfig;
import io.helidon.config.mp.MpConfig;
import io.helidon.config.mp.MpConfigBuilder;
import io.helidon.config.mp.MpMetaConfig;
import io.helidon.config.spi.ConfigMapper;
import java.time.Instant;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.Converter;

public class MpConfigProviderResolver
extends ConfigProviderResolver {
    private static final System.Logger LOGGER = System.getLogger(MpConfigProviderResolver.class.getName());
    private static final Map<ClassLoader, ConfigDelegate> CONFIGS = new IdentityHashMap<ClassLoader, ConfigDelegate>();
    private static final ReadWriteLock RW_LOCK = new ReentrantReadWriteLock();
    private static final List<ConfigDelegate> BUILD_CONFIG = new LinkedList<ConfigDelegate>();

    public org.eclipse.microprofile.config.Config getConfig() {
        return this.getConfig(Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.eclipse.microprofile.config.Config getConfig(ClassLoader classLoader) {
        ClassLoader loader = classLoader == null ? Thread.currentThread().getContextClassLoader() : classLoader;
        Lock lock = RW_LOCK.readLock();
        try {
            lock.lock();
            org.eclipse.microprofile.config.Config config = CONFIGS.get(loader);
            if (null == config) {
                lock.unlock();
                lock = RW_LOCK.writeLock();
                lock.lock();
                org.eclipse.microprofile.config.Config c = this.buildConfig(loader);
                ConfigDelegate configDelegate = this.doRegisterConfig(c, loader);
                return configDelegate;
            }
            org.eclipse.microprofile.config.Config config2 = config;
            return config2;
        }
        finally {
            lock.unlock();
        }
    }

    private org.eclipse.microprofile.config.Config buildConfig(ClassLoader loader) {
        MpConfigBuilder builder = this.getBuilder();
        builder.forClassLoader(loader);
        Optional<Config> meta = MpMetaConfig.metaConfig();
        if (meta.isEmpty()) {
            meta = MetaConfig.metaConfig();
            if (meta.isPresent()) {
                builder.metaConfig(meta.get());
                LOGGER.log(System.Logger.Level.WARNING, "You are using Helidon SE meta configuration in a Helidon MP application. Some features work differently, such as environment variable resolving, and mutability");
            }
        } else {
            builder.mpMetaConfig(meta.get());
        }
        if (meta.isEmpty()) {
            builder.addDefaultSources();
            builder.addDiscoveredSources();
            builder.addDiscoveredConverters();
        }
        return builder.build();
    }

    public MpConfigBuilder getBuilder() {
        return new MpConfigBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConfig(org.eclipse.microprofile.config.Config config, ClassLoader classLoader) {
        ClassLoader usedClassloader = null == classLoader ? Thread.currentThread().getContextClassLoader() : classLoader;
        Lock lock = RW_LOCK.writeLock();
        try {
            lock.lock();
            this.doRegisterConfig(config, usedClassloader);
        }
        finally {
            lock.unlock();
        }
    }

    public static void runtimeStart(org.eclipse.microprofile.config.Config config) {
        if (BUILD_CONFIG.isEmpty()) {
            return;
        }
        BUILD_CONFIG.forEach(it -> it.set(config));
        BUILD_CONFIG.clear();
    }

    public static void buildTimeEnd() {
        Lock lock = RW_LOCK.writeLock();
        try {
            lock.lock();
            CONFIGS.forEach((key, value) -> BUILD_CONFIG.add((ConfigDelegate)value));
            CONFIGS.clear();
        }
        finally {
            lock.unlock();
        }
    }

    private ConfigDelegate doRegisterConfig(org.eclipse.microprofile.config.Config config, ClassLoader classLoader) {
        ConfigDelegate currentConfig = CONFIGS.remove(classLoader);
        if (config instanceof ConfigDelegate) {
            config = ((ConfigDelegate)config).delegate();
        }
        if (null != currentConfig) {
            currentConfig.set(config);
        }
        ConfigDelegate newConfig = new ConfigDelegate(config);
        CONFIGS.put(classLoader, newConfig);
        return newConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseConfig(org.eclipse.microprofile.config.Config config) {
        AtomicReference<ClassLoader> cl;
        Lock lock;
        block10: {
            lock = RW_LOCK.readLock();
            cl = new AtomicReference<ClassLoader>();
            try {
                lock.lock();
                if (config instanceof ConfigDelegate) {
                    for (Map.Entry<ClassLoader, ConfigDelegate> entry : CONFIGS.entrySet()) {
                        if (config != entry.getValue()) continue;
                        cl.set(entry.getKey());
                        break block10;
                    }
                    break block10;
                }
                for (Map.Entry<ClassLoader, ConfigDelegate> entry : CONFIGS.entrySet()) {
                    org.eclipse.microprofile.config.Config configFromRef = entry.getValue().delegate();
                    if (config != configFromRef) continue;
                    cl.set(entry.getKey());
                    break;
                }
            }
            finally {
                lock.unlock();
            }
        }
        if (cl.get() != null) {
            lock = RW_LOCK.writeLock();
            try {
                lock.lock();
                CONFIGS.remove(cl.get());
            }
            finally {
                lock.unlock();
            }
        }
    }

    static final class ConfigDelegate
    implements Config,
    org.eclipse.microprofile.config.Config {
        private final AtomicReference<org.eclipse.microprofile.config.Config> delegate = new AtomicReference();
        private final AtomicReference<Config> helidonDelegate = new AtomicReference();

        private ConfigDelegate(org.eclipse.microprofile.config.Config delegate) {
            this.set(delegate);
        }

        void set(org.eclipse.microprofile.config.Config delegate) {
            this.delegate.set(delegate);
            if (delegate instanceof Config) {
                this.helidonDelegate.set((Config)delegate);
            } else {
                this.helidonDelegate.set(MpConfig.toHelidonConfig(delegate));
            }
        }

        public org.eclipse.microprofile.config.ConfigValue getConfigValue(String s) {
            return this.delegate.get().getConfigValue(s);
        }

        public <T> Optional<Converter<T>> getConverter(Class<T> aClass) {
            return this.delegate.get().getConverter(aClass);
        }

        public <T> T unwrap(Class<T> aClass) {
            if (org.eclipse.microprofile.config.Config.class.equals(aClass)) {
                return (T)this.delegate.get();
            }
            return (T)this.delegate.get().unwrap(aClass);
        }

        private Config getCurrent() {
            return this.helidonDelegate.get().context().last();
        }

        @Override
        public Instant timestamp() {
            return this.getCurrent().timestamp();
        }

        @Override
        public Config.Key key() {
            return this.getCurrent().key();
        }

        @Override
        public Config root() {
            return this.getCurrent().root();
        }

        @Override
        public Config get(Config.Key key) {
            return this.getCurrent().get(key);
        }

        @Override
        public Config detach() {
            return this.getCurrent().detach();
        }

        @Override
        public Config.Type type() {
            return this.getCurrent().type();
        }

        @Override
        public boolean hasValue() {
            return this.getCurrent().hasValue();
        }

        @Override
        public Stream<Config> traverse(Predicate<Config> predicate) {
            return this.getCurrent().traverse();
        }

        @Override
        public <T> T convert(Class<T> type, String value) {
            return this.getCurrent().convert(type, value);
        }

        @Override
        public <T> ConfigValue<T> as(GenericType<T> genericType) {
            return this.getCurrent().as(genericType);
        }

        @Override
        public <T> ConfigValue<T> as(Class<T> type) {
            return this.getCurrent().as((Class)type);
        }

        @Override
        public <T> ConfigValue<T> as(Function<Config, T> mapper) {
            return this.getCurrent().as(mapper);
        }

        @Override
        public <T> ConfigValue<List<T>> asList(Class<T> type) {
            return this.getCurrent().asList((Class)type);
        }

        @Override
        public <T> ConfigValue<List<T>> asList(Function<Config, T> mapper) {
            return this.getCurrent().asList(mapper);
        }

        @Override
        public ConfigValue<List<Config>> asNodeList() {
            return this.getCurrent().asNodeList();
        }

        @Override
        public ConfigValue<Map<String, String>> asMap() {
            return this.getCurrent().asMap();
        }

        @Override
        public ConfigMapper mapper() {
            return this.getCurrent().mapper();
        }

        public <T> T getValue(String propertyName, Class<T> propertyType) {
            return (T)this.delegate.get().getValue(propertyName, propertyType);
        }

        public <T> Optional<T> getOptionalValue(String propertyName, Class<T> propertyType) {
            return this.delegate.get().getOptionalValue(propertyName, propertyType);
        }

        public Iterable<String> getPropertyNames() {
            return this.delegate.get().getPropertyNames();
        }

        public Iterable<ConfigSource> getConfigSources() {
            return this.delegate.get().getConfigSources();
        }

        public org.eclipse.microprofile.config.Config delegate() {
            return this.delegate.get();
        }
    }
}

