/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.exousia.mapping;

import jakarta.security.jacc.PrincipalMapper;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.security.auth.Subject;

public class DefaultPrincipalMapper
implements PrincipalMapper {
    private static Object geronimoPolicyConfigurationFactoryInstance;
    private static ConcurrentMap<String, Map<Principal, Set<String>>> geronimoContextToRoleMapping;
    private Map<String, List<String>> groupToRoles = new HashMap<String, List<String>>();
    private boolean oneToOneMapping;
    private boolean anyAuthenticatedUserRoleMapped = false;

    public Principal getCallerPrincipal(Subject subject) {
        return null;
    }

    public Set<String> getMappedRoles(Subject subject) {
        return new HashSet<String>(this.getMappedRoles(subject.getPrincipals(), subject));
    }

    public static void onFactoryCreated() {
        DefaultPrincipalMapper.tryInitGeronimo();
    }

    private static void tryInitGeronimo() {
        try {
            geronimoPolicyConfigurationFactoryInstance = Class.forName("org.apache.geronimo.security.jacc.mappingprovider.GeronimoPolicyConfigurationFactory").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            geronimoContextToRoleMapping = new ConcurrentHashMap<String, Map<Principal, Set<String>>>();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void onPolicyConfigurationCreated(final String contextID) {
        if (geronimoPolicyConfigurationFactoryInstance != null) {
            try {
                Class<?> geronimoPolicyConfigurationClass = Class.forName("org.apache.geronimo.security.jacc.mappingprovider.GeronimoPolicyConfiguration");
                Object geronimoPolicyConfigurationProxy = Proxy.newProxyInstance(DefaultPrincipalMapper.class.getClassLoader(), new Class[]{geronimoPolicyConfigurationClass}, new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        if (method.getName().equals("setPrincipalRoleMapping")) {
                            geronimoContextToRoleMapping.put(contextID, (Map)args[0]);
                        }
                        return null;
                    }
                });
                Class.forName("org.apache.geronimo.security.jacc.mappingprovider.GeronimoPolicyConfigurationFactory").getMethod("setPolicyConfiguration", String.class, geronimoPolicyConfigurationClass).invoke(geronimoPolicyConfigurationFactoryInstance, contextID, geronimoPolicyConfigurationProxy);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                // empty catch block
            }
        }
    }

    public DefaultPrincipalMapper(String contextID, Collection<String> allDeclaredRoles) {
        if (this.tryGlassFish(contextID, allDeclaredRoles)) {
            return;
        }
        if (this.tryWebLogic(contextID, allDeclaredRoles)) {
            return;
        }
        if (this.tryGeronimo(contextID, allDeclaredRoles)) {
            return;
        }
        this.oneToOneMapping = true;
    }

    public List<String> getMappedRoles(Principal[] principals, Subject subject) {
        return this.getMappedRoles(Arrays.asList(principals), subject);
    }

    public boolean isAnyAuthenticatedUserRoleMapped() {
        return this.anyAuthenticatedUserRoleMapped;
    }

    public List<String> getMappedRoles(Iterable<Principal> principals, Subject subject) {
        List<String> groups = this.getGroups(principals, subject);
        return this.mapGroupsToRoles(groups);
    }

    private List<String> mapGroupsToRoles(List<String> groups) {
        if (this.oneToOneMapping) {
            return groups;
        }
        ArrayList<String> roles = new ArrayList<String>();
        for (String group : groups) {
            if (this.groupToRoles.containsKey(group)) {
                roles.addAll((Collection<String>)this.groupToRoles.get(group));
                continue;
            }
            roles.add(group);
        }
        return roles;
    }

    private boolean tryGlassFish(String contextID, Collection<String> allDeclaredRoles) {
        try {
            Class<?> SecurityRoleMapperFactoryClass = Class.forName("org.glassfish.deployment.common.SecurityRoleMapperFactory");
            Object factoryInstance = Class.forName("org.glassfish.internal.api.Globals").getMethod("get", SecurityRoleMapperFactoryClass.getClass()).invoke(null, SecurityRoleMapperFactoryClass);
            Object securityRoleMapperInstance = SecurityRoleMapperFactoryClass.getMethod("getRoleMapper", String.class).invoke(factoryInstance, contextID);
            Map roleToSubjectMap = (Map)Class.forName("org.glassfish.deployment.common.SecurityRoleMapper").getMethod("getRoleToSubjectMapping", new Class[0]).invoke(securityRoleMapperInstance, new Object[0]);
            for (String role : allDeclaredRoles) {
                if (!roleToSubjectMap.containsKey(role)) continue;
                Set<Principal> principals = ((Subject)roleToSubjectMap.get(role)).getPrincipals();
                List<String> groups = this.getGroups(principals, null);
                for (String group : groups) {
                    if (!this.groupToRoles.containsKey(group)) {
                        this.groupToRoles.put(group, new ArrayList());
                    }
                    this.groupToRoles.get(group).add(role);
                }
                if (!"**".equals(role) || groups.isEmpty()) continue;
                this.anyAuthenticatedUserRoleMapped = true;
            }
            return true;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            return false;
        }
    }

    private boolean tryWebLogic(String contextID, Collection<String> allDeclaredRoles) {
        try {
            Class<?> roleMapperFactoryClass = Class.forName("weblogic.security.jacc.RoleMapperFactory");
            Object roleMapperFactoryInstance = roleMapperFactoryClass.getMethod("getRoleMapperFactory", new Class[0]).invoke(null, new Object[0]);
            Object roleMapperInstance = roleMapperFactoryClass.getMethod("getRoleMapperForContextID", String.class).invoke(roleMapperFactoryInstance, contextID);
            Map roleToPrincipalNamesMap = (Map)Class.forName("weblogic.security.jacc.simpleprovider.RoleMapperImpl").getMethod("getRolesToPrincipalNames", new Class[0]).invoke(roleMapperInstance, new Object[0]);
            for (String role : allDeclaredRoles) {
                if (!roleToPrincipalNamesMap.containsKey(role)) continue;
                List<String> groupsOrUserNames = Arrays.asList((String[])roleToPrincipalNamesMap.get(role));
                for (String groupOrUserName : (String[])roleToPrincipalNamesMap.get(role)) {
                    if (!this.groupToRoles.containsKey(groupOrUserName)) {
                        this.groupToRoles.put(groupOrUserName, new ArrayList());
                    }
                    this.groupToRoles.get(groupOrUserName).add(role);
                }
                if (!"**".equals(role) || groupsOrUserNames.isEmpty()) continue;
                this.anyAuthenticatedUserRoleMapped = true;
            }
            return true;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            return false;
        }
    }

    private boolean tryGeronimo(String contextID, Collection<String> allDeclaredRoles) {
        if (geronimoContextToRoleMapping != null) {
            if (geronimoContextToRoleMapping.containsKey(contextID)) {
                Map principalsToRoles = (Map)geronimoContextToRoleMapping.get(contextID);
                for (Map.Entry entry : principalsToRoles.entrySet()) {
                    for (String group : this.principalToGroups((Principal)entry.getKey())) {
                        if (!this.groupToRoles.containsKey(group)) {
                            this.groupToRoles.put(group, new ArrayList());
                        }
                        this.groupToRoles.get(group).addAll((Collection)entry.getValue());
                        if (!((Set)entry.getValue()).contains("**")) continue;
                        this.anyAuthenticatedUserRoleMapped = true;
                    }
                }
            }
            return true;
        }
        return false;
    }

    public List<String> getGroups(Iterable<Principal> principals, Subject subject) {
        List<String> groups = new ArrayList<String>();
        for (Principal principal : principals) {
            if (!this.principalToGroups(principal, groups)) continue;
            return groups;
        }
        if (subject == null) {
            return groups;
        }
        Set<Principal> privatePrincipals = subject.getPrivateCredentials(Principal.class);
        for (Principal principal : privatePrincipals) {
            if (!this.principalToGroups(principal, groups)) continue;
            return groups;
        }
        Set<Hashtable> set = subject.getPrivateCredentials(Hashtable.class);
        if (set != null && !set.isEmpty()) {
            Hashtable table = set.iterator().next();
            groups = (List)table.get("com.ibm.wsspi.security.cred.groups");
            return groups != null ? groups : Collections.emptyList();
        }
        return groups;
    }

    public List<String> principalToGroups(Principal principal) {
        ArrayList<String> groups = new ArrayList<String>();
        this.principalToGroups(principal, groups);
        return groups;
    }

    public boolean principalToGroups(Principal principal, List<String> groups) {
        switch (principal.getClass().getName()) {
            case "org.glassfish.security.common.Group": 
            case "org.apache.geronimo.security.realm.providers.GeronimoGroupPrincipal": 
            case "weblogic.security.principal.WLSGroupImpl": 
            case "jeus.security.resource.GroupPrincipalImpl": {
                groups.add(principal.getName());
                break;
            }
            case "org.apache.openejb.core.security.AbstractSecurityService$Group": 
            case "org.jboss.security.SimpleGroup": {
                if (principal.getName().equals("Roles") && principal.getClass().getName().equals("org.jboss.security.SimpleGroup")) {
                    try {
                        Enumeration groupMembers = (Enumeration)Class.forName("org.jboss.security.SimpleGroup").getMethod("members", new Class[0]).invoke((Object)principal, new Object[0]);
                        for (Principal groupPrincipal : Collections.list(groupMembers)) {
                            groups.add(groupPrincipal.getName());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return true;
                }
            }
            case "org.apache.tomee.catalina.TomcatSecurityService$TomcatUser": {
                try {
                    groups.addAll(Arrays.asList((String[])Class.forName("org.apache.catalina.realm.GenericPrincipal").getMethod("getRoles", new Class[0]).invoke(Class.forName("org.apache.tomee.catalina.TomcatSecurityService$TomcatUser").getMethod("getTomcatPrincipal", new Class[0]).invoke((Object)principal, new Object[0]), new Object[0])));
                }
                catch (Exception exception) {}
                break;
            }
            case "org.apache.catalina.realm.GenericPrincipal": {
                try {
                    groups.addAll(Arrays.asList((String[])Class.forName("org.apache.catalina.realm.GenericPrincipal").getMethod("getRoles", new Class[0]).invoke((Object)principal, new Object[0])));
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return false;
    }
}

