/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.interceptor.builder;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.weld.interceptor.builder.InterceptionModelImpl;
import org.jboss.weld.interceptor.reader.TargetClassInterceptorMetadata;
import org.jboss.weld.interceptor.spi.metadata.InterceptorClassMetadata;
import org.jboss.weld.interceptor.spi.model.InterceptionModel;
import org.jboss.weld.interceptor.spi.model.InterceptionType;
import org.jboss.weld.util.collections.ImmutableList;
import org.jboss.weld.util.collections.ImmutableMap;
import org.jboss.weld.util.collections.ImmutableSet;

public class InterceptionModelBuilder {
    private boolean isModelBuilt = false;
    private boolean hasExternalNonConstructorInterceptors;
    private final ImmutableSet.Builder<Method> methodsIgnoringGlobalInterceptors = ImmutableSet.builder();
    private final ImmutableSet.Builder<InterceptorClassMetadata<?>> allInterceptors = ImmutableSet.builder();
    private final Map<InterceptionType, List<InterceptorClassMetadata<?>>> globalInterceptors = new EnumMap(InterceptionType.class);
    private final Map<InterceptionType, Map<Method, List<InterceptorClassMetadata<?>>>> methodBoundInterceptors = new EnumMap(InterceptionType.class);
    private TargetClassInterceptorMetadata targetClassInterceptorMetadata;
    private final ImmutableMap.Builder<Member, Set<Annotation>> memberInterceptorBindings = ImmutableMap.builder();
    private Set<Annotation> classInterceptorBindings;

    public InterceptionModel build() {
        this.checkModelNotBuilt();
        this.isModelBuilt = true;
        return new InterceptionModelImpl(this);
    }

    public void interceptMethod(jakarta.enterprise.inject.spi.InterceptionType interceptionType, Method method, Collection<InterceptorClassMetadata<?>> interceptors, Set<Annotation> interceptorBindings) {
        List<InterceptorClassMetadata<?>> interceptorsList;
        this.checkModelNotBuilt();
        InterceptionType weldInterceptionType = InterceptionType.valueOf(interceptionType);
        if (weldInterceptionType.isLifecycleCallback()) {
            throw new IllegalArgumentException("Illegal interception type: " + String.valueOf(interceptionType));
        }
        if (null == this.methodBoundInterceptors.get((Object)weldInterceptionType)) {
            this.methodBoundInterceptors.put(weldInterceptionType, new HashMap());
        }
        if ((interceptorsList = this.methodBoundInterceptors.get((Object)weldInterceptionType).get(method)) == null) {
            interceptorsList = new ArrayList();
            this.methodBoundInterceptors.get((Object)weldInterceptionType).put(method, interceptorsList);
        }
        interceptorsList.addAll(interceptors);
        this.intercept(weldInterceptionType, interceptors);
        if (interceptorBindings != null) {
            this.memberInterceptorBindings.put(method, interceptorBindings);
        }
    }

    public void interceptGlobal(jakarta.enterprise.inject.spi.InterceptionType interceptionType, Constructor<?> constructor, Collection<InterceptorClassMetadata<?>> interceptors, Set<Annotation> interceptorBindings) {
        this.checkModelNotBuilt();
        InterceptionType weldInterceptionType = InterceptionType.valueOf(interceptionType);
        List<InterceptorClassMetadata<?>> interceptorsList = this.globalInterceptors.get((Object)weldInterceptionType);
        if (interceptorsList == null) {
            interceptorsList = new ArrayList();
            this.globalInterceptors.put(weldInterceptionType, interceptorsList);
        }
        interceptorsList.addAll(interceptors);
        this.intercept(weldInterceptionType, interceptors);
        if (constructor != null) {
            this.memberInterceptorBindings.put(constructor, interceptorBindings);
        }
    }

    private void intercept(InterceptionType interceptionType, Collection<InterceptorClassMetadata<?>> interceptors) {
        if (interceptionType != InterceptionType.AROUND_CONSTRUCT) {
            this.hasExternalNonConstructorInterceptors = true;
        }
        this.allInterceptors.addAll((Iterable<InterceptorClassMetadata<?>>)interceptors);
    }

    public void addMethodIgnoringGlobalInterceptors(Method method) {
        this.checkModelNotBuilt();
        this.methodsIgnoringGlobalInterceptors.add(method);
    }

    boolean isHasExternalNonConstructorInterceptors() {
        return this.hasExternalNonConstructorInterceptors;
    }

    Set<Method> getMethodsIgnoringGlobalInterceptors() {
        return this.methodsIgnoringGlobalInterceptors.build();
    }

    Set<InterceptorClassMetadata<?>> getAllInterceptors() {
        return this.allInterceptors.build();
    }

    Map<InterceptionType, List<InterceptorClassMetadata<?>>> getGlobalInterceptors() {
        if (this.globalInterceptors.isEmpty()) {
            return Collections.emptyMap();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<InterceptionType, List<InterceptorClassMetadata<?>>> entry : this.globalInterceptors.entrySet()) {
            builder.put(entry.getKey(), ImmutableList.copyOf((Collection)entry.getValue()));
        }
        return builder.build();
    }

    Map<InterceptionType, Map<Method, List<InterceptorClassMetadata<?>>>> getMethodBoundInterceptors() {
        if (this.methodBoundInterceptors.isEmpty()) {
            return Collections.emptyMap();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<InterceptionType, Map<Method, List<InterceptorClassMetadata<?>>>> entry : this.methodBoundInterceptors.entrySet()) {
            ImmutableMap.Builder metadataBuilder = ImmutableMap.builder();
            for (Map.Entry<Method, List<InterceptorClassMetadata<?>>> metadataEntry : entry.getValue().entrySet()) {
                metadataBuilder.put(metadataEntry.getKey(), ImmutableList.copyOf((Collection)metadataEntry.getValue()));
            }
            builder.put(entry.getKey(), metadataBuilder.build());
        }
        return builder.build();
    }

    private void checkModelNotBuilt() {
        if (this.isModelBuilt) {
            throw new IllegalStateException("InterceptionModelBuilder cannot be reused");
        }
    }

    TargetClassInterceptorMetadata getTargetClassInterceptorMetadata() {
        return this.targetClassInterceptorMetadata;
    }

    public void setTargetClassInterceptorMetadata(TargetClassInterceptorMetadata targetClassInterceptorMetadata) {
        this.targetClassInterceptorMetadata = targetClassInterceptorMetadata;
    }

    Collection<Annotation> getClassInterceptorBindings() {
        return this.classInterceptorBindings;
    }

    public void setClassInterceptorBindings(Set<Annotation> classInterceptorBindings) {
        this.classInterceptorBindings = classInterceptorBindings;
    }

    Map<Member, Set<Annotation>> getMemberInterceptorBindings() {
        return this.memberInterceptorBindings.build();
    }
}

