/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import com.sun.faces.util.Cache;
import com.sun.faces.util.LRUMap;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

public class LRUCache<K, V> {
    private final ReentrantLock lock = new ReentrantLock(true);
    private final LRUMap<K, V> cache;
    private final Cache.Factory<K, V> factory;

    public LRUCache(Cache.Factory<K, V> factory, int capacity) {
        this.cache = new LRUMap(capacity);
        this.factory = factory;
    }

    public V get(K key) {
        Objects.requireNonNull(key);
        try {
            this.lock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            return null;
        }
        try {
            V v = this.cache.computeIfAbsent(key, this.factory);
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clear() {
        try {
            this.lock.lockInterruptibly();
        }
        catch (InterruptedException ignored) {
            return;
        }
        try {
            this.cache.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    public V remove(K key) {
        Objects.requireNonNull(key);
        try {
            this.lock.lockInterruptibly();
        }
        catch (InterruptedException ignored) {
            return null;
        }
        try {
            Object v = this.cache.remove(key);
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }
}

