/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;

public final class ConstructorExpression
extends AbstractExpression {
    private String className;
    private AbstractExpression constructorItems;
    private boolean hasLeftParenthesis;
    private boolean hasRightParenthesis;
    private boolean hasSpaceAfterConstructorName;
    private boolean hasSpaceAfterNew;
    private String identifier;

    public ConstructorExpression(AbstractExpression parent) {
        super(parent, "NEW");
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getConstructorItems().accept(visitor);
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
        children.add(this.getConstructorItems());
    }

    @Override
    protected void addOrderedChildrenTo(List<Expression> children) {
        children.add(this.buildStringExpression("NEW"));
        if (this.hasSpaceAfterNew) {
            children.add(this.buildStringExpression(' '));
        }
        if (!this.className.isEmpty()) {
            children.add(this.buildStringExpression(this.className));
        }
        if (this.hasLeftParenthesis) {
            children.add(this.buildStringExpression('('));
        } else if (this.hasSpaceAfterConstructorName) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.hasConstructorItems()) {
            children.add(this.constructorItems);
        }
        if (this.hasRightParenthesis) {
            children.add(this.buildStringExpression(')'));
        }
    }

    public CollectionExpression buildCollectionExpression() {
        ArrayList<AbstractExpression> children = new ArrayList<AbstractExpression>(1);
        children.add((AbstractExpression)this.getConstructorItems());
        ArrayList<Boolean> commas = new ArrayList<Boolean>(1);
        commas.add(Boolean.FALSE);
        ArrayList<Boolean> spaces = new ArrayList<Boolean>(1);
        spaces.add(Boolean.FALSE);
        return new CollectionExpression(this, children, commas, spaces, true);
    }

    @Override
    public JPQLQueryBNF findQueryBNF(Expression expression) {
        if (this.constructorItems != null && this.constructorItems.isAncestor(expression)) {
            return this.getQueryBNF("constructor_item");
        }
        return super.findQueryBNF(expression);
    }

    public String getActualIdentifier() {
        return this.identifier;
    }

    public String getClassName() {
        return this.className;
    }

    public Expression getConstructorItems() {
        if (this.constructorItems == null) {
            this.constructorItems = this.buildNullExpression();
        }
        return this.constructorItems;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("constructor_expression");
    }

    public boolean hasConstructorItems() {
        return this.constructorItems != null && !this.constructorItems.isNull();
    }

    public boolean hasLeftParenthesis() {
        return this.hasLeftParenthesis;
    }

    public boolean hasRightParenthesis() {
        return this.hasRightParenthesis;
    }

    public boolean hasSpaceAfterNew() {
        return this.hasSpaceAfterNew;
    }

    @Override
    protected boolean isParsingComplete(WordParser wordParser, String word, Expression expression) {
        return wordParser.character() == ')' || super.isParsingComplete(wordParser, word, expression);
    }

    @Override
    protected void parse(WordParser wordParser, boolean tolerant) {
        this.identifier = wordParser.moveForward("NEW");
        this.hasSpaceAfterNew = wordParser.skipLeadingWhitespace() > 0;
        String className = wordParser.word();
        if (tolerant && this.isIdentifier(className)) {
            this.className = "";
            return;
        }
        this.className = className;
        wordParser.moveForward(className);
        int count = wordParser.skipLeadingWhitespace();
        this.hasLeftParenthesis = wordParser.startsWith('(');
        if (this.hasLeftParenthesis) {
            wordParser.moveForward(1);
            count = wordParser.skipLeadingWhitespace();
        } else {
            this.hasSpaceAfterConstructorName = count > 0;
        }
        this.constructorItems = this.parse(wordParser, "constructor_item", tolerant);
        if (this.constructorItems != null) {
            count = wordParser.skipLeadingWhitespace();
        }
        boolean bl = this.hasRightParenthesis = wordParser.character() == ')';
        if (this.hasRightParenthesis) {
            wordParser.moveForward(1);
        } else {
            wordParser.moveBackward(count);
        }
    }

    @Override
    protected boolean shouldSkipLiteral(AbstractExpression expression) {
        return false;
    }

    @Override
    protected void toParsedText(StringBuilder writer, boolean actual) {
        writer.append(actual ? this.identifier : this.getText());
        if (this.hasSpaceAfterNew) {
            writer.append(' ');
        }
        writer.append(this.className);
        if (this.hasLeftParenthesis) {
            writer.append('(');
        } else if (this.hasSpaceAfterConstructorName) {
            writer.append(' ');
        }
        if (this.constructorItems != null) {
            this.constructorItems.toParsedText(writer, actual);
        }
        if (this.hasRightParenthesis) {
            writer.append(')');
        }
    }
}

