/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices.node;

import com.sun.enterprise.deployment.NameValuePairDescriptor;
import com.sun.enterprise.deployment.WebServiceHandler;
import com.sun.enterprise.deployment.node.DisplayableComponentNode;
import com.sun.enterprise.deployment.node.XMLElement;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.glassfish.webservices.connector.LogUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WebServiceHandlerNode
extends DisplayableComponentNode<WebServiceHandler> {
    private static final Logger LOG = LogUtils.getLogger();
    private static final XMLElement TAG = new XMLElement("handler");
    private NameValuePairDescriptor initParam;

    @Override
    protected XMLElement getXMLRootTag() {
        return TAG;
    }

    @Override
    protected Map<String, String> getDispatchTable() {
        Map<String, String> table = super.getDispatchTable();
        table.put("soap-role", "addSoapRole");
        table.put("handler-name", "setHandlerName");
        table.put("handler-class", "setHandlerClass");
        table.put("port-name", "addPortName");
        return table;
    }

    @Override
    protected WebServiceHandler createDescriptor() {
        return new WebServiceHandler();
    }

    @Override
    public void setElementValue(XMLElement element, String value) {
        String qname = element.getQName();
        WebServiceHandler handler = (WebServiceHandler)((Object)this.getDescriptor());
        if ("param-name".equals(qname)) {
            this.initParam = new NameValuePairDescriptor();
            this.initParam.setName(value);
        } else if ("param-value".equals(qname)) {
            this.initParam.setValue(value);
            handler.addInitParam(this.initParam);
        } else if ("description".equals(qname)) {
            if (this.initParam != null) {
                this.initParam.setDescription(value);
                this.initParam = null;
            } else {
                super.setElementValue(element, value);
            }
        } else if ("soap-header".equals(qname)) {
            String prefix = this.getPrefixFromQName(value);
            String localPart = this.getLocalPartFromQName(value);
            String namespaceUri = this.resolvePrefix(element, prefix);
            if (namespaceUri == null) {
                LOG.log(Level.SEVERE, "AS-WSCONNECTOR-00046", new Object[]{prefix, handler.getHandlerName()});
            } else {
                QName soapHeader = new QName(namespaceUri, localPart);
                handler.addSoapHeader(soapHeader);
            }
        } else {
            super.setElementValue(element, value);
        }
    }

    @Override
    public Node writeDescriptor(Node parent, String nodeName, WebServiceHandler handler) {
        Node wshNode = super.writeDescriptor(parent, nodeName, handler);
        this.writeDisplayableComponentInfo(wshNode, handler);
        WebServiceHandlerNode.appendTextChild(wshNode, "handler-name", handler.getHandlerName());
        WebServiceHandlerNode.appendTextChild(wshNode, "handler-class", handler.getHandlerClass());
        for (NameValuePairDescriptor nameValuePairDescriptor : handler.getInitParams()) {
            Element initParamNode = WebServiceHandlerNode.appendChild(wshNode, "init-param");
            WebServiceHandlerNode.appendTextChild((Node)initParamNode, "param-name", nameValuePairDescriptor.getName());
            WebServiceHandlerNode.appendTextChild((Node)initParamNode, "param-value", nameValuePairDescriptor.getValue());
        }
        for (QName qName : handler.getSoapHeaders()) {
            this.appendQNameChild("soap-header", wshNode, qName.getNamespaceURI(), qName.getLocalPart(), null);
        }
        for (String string : handler.getSoapRoles()) {
            WebServiceHandlerNode.appendTextChild(wshNode, "soap-role", string);
        }
        for (String string : handler.getPortNames()) {
            WebServiceHandlerNode.appendTextChild(wshNode, "port-name", string);
        }
        return wshNode;
    }

    public void writeWebServiceHandlers(Node parent, List<WebServiceHandler> handlerChain) {
        for (WebServiceHandler next : handlerChain) {
            this.writeDescriptor(parent, "handler", next);
        }
    }
}

