/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.ext.cdi1x.internal;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.InjectionTarget;
import jakarta.enterprise.inject.spi.InjectionTargetFactory;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import org.glassfish.jersey.ext.cdi1x.internal.CdiComponentProvider;
import org.glassfish.jersey.ext.cdi1x.internal.CdiUtil;
import org.glassfish.jersey.ext.cdi1x.internal.LocalizationMessages;
import org.glassfish.jersey.internal.inject.DisposableSupplier;
import org.glassfish.jersey.internal.inject.InjectionManager;

public abstract class AbstractCdiBeanSupplier<T>
implements DisposableSupplier<T> {
    private static final Logger LOGGER = Logger.getLogger(AbstractCdiBeanSupplier.class.getName());
    final Class<T> clazz;
    final InstanceManager<T> referenceProvider;
    final Annotation[] qualifiers;

    public AbstractCdiBeanSupplier(Class<T> rawType, final InjectionManager injectionManager, final BeanManager beanManager, boolean cdiManaged) {
        this.clazz = rawType;
        this.qualifiers = CdiUtil.getQualifiers(this.clazz.getAnnotations());
        this.referenceProvider = cdiManaged ? new InstanceManager<T>(){
            final Iterator<Bean<?>> beans;
            final Bean bean;
            {
                this.beans = beanManager.getBeans(AbstractCdiBeanSupplier.this.clazz, AbstractCdiBeanSupplier.this.qualifiers).iterator();
                this.bean = this.beans.hasNext() ? this.beans.next() : null;
            }

            @Override
            public T getInstance(Class<T> clazz) {
                return this.bean != null ? (Object)CdiUtil.getBeanReference(clazz, this.bean, beanManager) : null;
            }

            @Override
            public void preDestroy(T instance) {
            }
        } : new InstanceManager<T>(){
            final AnnotatedType<T> annotatedType;
            final InjectionTargetFactory<T> injectionTargetFactory;
            final InjectionTarget<T> injectionTarget;
            {
                this.annotatedType = beanManager.createAnnotatedType(AbstractCdiBeanSupplier.this.clazz);
                this.injectionTargetFactory = beanManager.getInjectionTargetFactory(this.annotatedType);
                this.injectionTarget = this.injectionTargetFactory.createInjectionTarget(null);
            }

            @Override
            public T getInstance(Class<T> clazz) {
                CdiComponentProvider cdiComponentProvider;
                CreationalContext creationalContext = beanManager.createCreationalContext(null);
                Object instance = AbstractCdiBeanSupplier.produce(this.injectionTarget, creationalContext, injectionManager, clazz);
                CdiComponentProvider cdiComponentProvider2 = cdiComponentProvider = (CdiComponentProvider)beanManager.getExtension(CdiComponentProvider.class);
                Objects.requireNonNull(cdiComponentProvider2);
                CdiComponentProvider.InjectionManagerInjectedCdiTarget hk2managedTarget = new CdiComponentProvider.InjectionManagerInjectedCdiTarget(cdiComponentProvider2, this.injectionTarget){
                    {
                        CdiComponentProvider cdiComponentProvider = x0;
                        Objects.requireNonNull(cdiComponentProvider);
                        super(cdiComponentProvider, delegate);
                    }

                    @Override
                    public Set<InjectionPoint> getInjectionPoints() {
                        return injectionTarget.getInjectionPoints();
                    }
                };
                hk2managedTarget.setInjectionManager(injectionManager);
                hk2managedTarget.inject(instance, creationalContext);
                hk2managedTarget.postConstruct(instance);
                return instance;
            }

            @Override
            public void preDestroy(T instance) {
                this.injectionTarget.preDestroy(instance);
            }
        };
    }

    private static <T> T produce(InjectionTarget<T> target, CreationalContext<T> ctx, InjectionManager im, Class<T> clazz) {
        try {
            return (T)target.produce(ctx);
        }
        catch (Exception e) {
            LOGGER.fine(LocalizationMessages.CDI_FAILED_LOADING(clazz, e.getMessage()));
            try {
                return (T)im.create(clazz);
            }
            catch (RuntimeException re) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                LOGGER.warning(LocalizationMessages.CDI_FAILED_LOADING(clazz, sw.toString()));
                throw re;
            }
        }
    }

    T _provide() {
        T instance = this.referenceProvider.getInstance(this.clazz);
        if (instance != null) {
            return instance;
        }
        throw new NoSuchElementException(LocalizationMessages.CDI_LOOKUP_FAILED(this.clazz));
    }

    public void dispose(T instance) {
        this.referenceProvider.preDestroy(instance);
    }

    private static interface InstanceManager<T> {
        public T getInstance(Class<T> var1);

        public void preDestroy(T var1);
    }
}

