/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.core;

import com.sun.messaging.jmq.io.SysMessageID;
import java.io.Serializable;
import java.util.Comparator;

public class ExpirationInfo {
    static Comparator expireCompare = new ExpirationComparator();
    SysMessageID id;
    long expireTime;
    boolean expired = false;
    int reapCount = 0;

    public String toString() {
        return "ExpirationInfo[" + String.valueOf(this.id) + "," + this.expireTime + "]";
    }

    public synchronized boolean isExpired() {
        if (!this.expired) {
            this.expired = this.expireTime <= System.currentTimeMillis();
        }
        return this.expired;
    }

    public static Comparator getComparator() {
        return expireCompare;
    }

    public ExpirationInfo(SysMessageID id, long expireTime) {
        this.id = id;
        this.expireTime = expireTime;
    }

    public long getExpireTime() {
        return this.expireTime;
    }

    public int getReapCount() {
        return this.reapCount;
    }

    public void incrementReapCount() {
        ++this.reapCount;
    }

    public void clearReapCount() {
        this.reapCount = 0;
    }

    public SysMessageID getSysMessageID() {
        return this.id;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ExpirationInfo)) {
            return false;
        }
        ExpirationInfo ei = (ExpirationInfo)o;
        assert (this.id != null && ei.id != null);
        return this.id.equals((Object)ei.id);
    }

    static class ExpirationComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 8859855693453685960L;

        ExpirationComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof ExpirationInfo && o2 instanceof ExpirationInfo) {
                ExpirationInfo ei1 = (ExpirationInfo)o1;
                ExpirationInfo ei2 = (ExpirationInfo)o2;
                long dif = ei2.expireTime - ei1.expireTime;
                if (dif == 0L) {
                    SysMessageID sys1 = ei1.id;
                    SysMessageID sys2 = ei2.id;
                    dif = sys2.getTimestamp() - sys1.getTimestamp();
                    if (dif == 0L) {
                        dif = sys2.getSequence() - sys1.getSequence();
                    }
                }
                if (dif < 0L) {
                    return 1;
                }
                if (dif > 0L) {
                    return -1;
                }
                return 0;
            }
            assert (false);
            return o1.hashCode() - o2.hashCode();
        }
    }
}

