/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.lite.extension.translator;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;

class ReflectionMembers {
    private ReflectionMembers() {
    }

    static Set<Method> allMethods(Class<?> clazz) {
        HashSet<Method> result = new HashSet<Method>();
        ReflectionMembers.forEachSuperclass(clazz, it -> result.addAll(Arrays.asList(it.getDeclaredMethods())));
        return result;
    }

    static Set<Field> allFields(Class<?> clazz) {
        HashSet<Field> result = new HashSet<Field>();
        ReflectionMembers.forEachSuperclass(clazz, it -> result.addAll(Arrays.asList(it.getDeclaredFields())));
        return result;
    }

    private static void forEachSuperclass(Class<?> clazz, Consumer<Class<?>> action) {
        ArrayDeque workQueue = new ArrayDeque();
        workQueue.add(clazz);
        while (!workQueue.isEmpty()) {
            Class item = (Class)workQueue.remove();
            if (item.equals(Object.class)) continue;
            Class superclass = item.getSuperclass();
            if (superclass != null) {
                workQueue.add(superclass);
            }
            workQueue.addAll(Arrays.asList(item.getInterfaces()));
            action.accept(item);
        }
    }
}

