/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.broker;

import com.sun.messaging.jmq.admin.apps.broker.BrokerCmdOptions;
import com.sun.messaging.jmq.admin.apps.broker.BrokerCmdPrinter;
import com.sun.messaging.jmq.admin.apps.broker.BrokerCmdProperties;
import com.sun.messaging.jmq.admin.apps.broker.CommonCmdException;
import com.sun.messaging.jmq.admin.apps.broker.CommonCmdRunnerUtil;
import com.sun.messaging.jmq.admin.bkrutil.BrokerAdmin;
import com.sun.messaging.jmq.admin.bkrutil.BrokerAdminException;
import com.sun.messaging.jmq.admin.bkrutil.BrokerAdminUtil;
import com.sun.messaging.jmq.admin.bkrutil.BrokerConstants;
import com.sun.messaging.jmq.admin.event.AdminEvent;
import com.sun.messaging.jmq.admin.event.AdminEventListener;
import com.sun.messaging.jmq.admin.event.BrokerCmdStatusEvent;
import com.sun.messaging.jmq.admin.resources.AdminResources;
import com.sun.messaging.jmq.admin.util.Globals;
import com.sun.messaging.jmq.io.Status;
import com.sun.messaging.jmq.jmsclient.GenericPortMapperClient;
import com.sun.messaging.jmq.util.DestLimitBehavior;
import com.sun.messaging.jmq.util.DestMetricsCounters;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.MetricCounters;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.util.admin.ConsumerInfo;
import com.sun.messaging.jmq.util.admin.DestinationInfo;
import com.sun.messaging.jmq.util.admin.DurableInfo;
import com.sun.messaging.jmq.util.admin.ServiceInfo;
import com.sun.messaging.jms.management.server.BrokerState;
import jakarta.jms.Message;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class CmdRunner
implements BrokerCmdOptions,
BrokerConstants,
AdminEventListener {
    private static final int METRICS_TOTALS = 0;
    private static final int METRICS_RATES = 1;
    private static final int METRICS_CONNECTIONS = 2;
    private static final int METRICS_CONSUMER = 3;
    private static final int METRICS_DISK = 4;
    private static final int METRICS_REMOVE = 5;
    private static final int LIST_ALL = 0;
    private static final int LIST_TOPIC = 1;
    private static final int LIST_QUEUE = 2;
    private int[] zeroNegOneInt = new int[]{0, -1};
    private long[] zeroNegOneLong = new long[]{0L, -1L};
    private String[] zeroNegOneString = new String[]{"0", "-1"};
    private String[] negOneString = new String[]{"-1"};
    private AdminResources ar = Globals.getAdminResources();
    private BrokerCmdProperties brokerCmdProps;

    public CmdRunner(BrokerCmdProperties props) {
        this.brokerCmdProps = props;
    }

    public int runCommands() {
        int exitcode = 0;
        if (this.brokerCmdProps.debugModeSet()) {
            exitcode = this.runDebug(this.brokerCmdProps);
            return exitcode;
        }
        String cmd = this.brokerCmdProps.getCommand();
        if (cmd.equals("list")) {
            exitcode = this.runList(this.brokerCmdProps);
        } else if (cmd.equals("pause")) {
            exitcode = this.runPause(this.brokerCmdProps);
        } else if (cmd.equals("resume")) {
            exitcode = this.runResume(this.brokerCmdProps);
        } else if (cmd.equals("shutdown")) {
            exitcode = this.runShutdown(this.brokerCmdProps);
        } else if (cmd.equals("restart")) {
            exitcode = this.runRestart(this.brokerCmdProps);
        } else if (cmd.equals("create")) {
            exitcode = this.runCreate(this.brokerCmdProps);
        } else if (cmd.equals("destroy")) {
            exitcode = this.runDestroy(this.brokerCmdProps);
        } else if (cmd.equals("purge")) {
            exitcode = this.runPurge(this.brokerCmdProps);
        } else if (cmd.equals("update")) {
            exitcode = this.runUpdate(this.brokerCmdProps);
        } else if (cmd.equals("query")) {
            exitcode = this.runQuery(this.brokerCmdProps);
        } else if (cmd.equals("metrics")) {
            exitcode = this.runMetrics(this.brokerCmdProps);
        } else if (cmd.equals("reload")) {
            exitcode = this.runReload(this.brokerCmdProps);
        } else if (cmd.equals("changemaster")) {
            exitcode = this.runChangeMaster(this.brokerCmdProps);
        } else if (cmd.equals("commit")) {
            exitcode = this.runCommit(this.brokerCmdProps);
        } else if (cmd.equals("rollback")) {
            exitcode = this.runRollback(this.brokerCmdProps);
        } else if (cmd.equals("compact")) {
            exitcode = this.runCompact(this.brokerCmdProps);
        } else if (cmd.equals("quiesce")) {
            exitcode = this.runQuiesce(this.brokerCmdProps);
        } else if (cmd.equals("takeover")) {
            exitcode = this.runTakeover(this.brokerCmdProps);
        } else if (cmd.equals("migratestore")) {
            exitcode = this.runMigrateStore(this.brokerCmdProps);
        } else if (cmd.equals("unquiesce")) {
            exitcode = this.runUnquiesce(this.brokerCmdProps);
        } else if (cmd.equals("reset")) {
            exitcode = this.runReset(this.brokerCmdProps);
        } else if (cmd.equals("checkpoint")) {
            exitcode = this.runCheckpoint(this.brokerCmdProps);
        } else if (cmd.equals(".exists")) {
            exitcode = this.runExists(this.brokerCmdProps);
        } else if (cmd.equals(".getattr")) {
            exitcode = this.runGetAttr(this.brokerCmdProps);
        } else if (cmd.equals("._kill")) {
            exitcode = this.runUngracefulKill(this.brokerCmdProps);
        } else if (cmd.equals(".purgeall")) {
            exitcode = this.runPurgeAll(this.brokerCmdProps);
        } else if (cmd.equals(".destroyall")) {
            exitcode = this.runDestroyAll(this.brokerCmdProps);
        }
        return exitcode;
    }

    @Override
    public void adminEventDispatched(AdminEvent e) {
        BrokerCmdStatusEvent be;
        int type;
        if (e instanceof BrokerCmdStatusEvent && (type = (be = (BrokerCmdStatusEvent)e).getType()) == 10000) {
            CommonCmdRunnerUtil.printBrokerBusyEvent(be);
        }
    }

    private int runList(BrokerCmdProperties brokerCmdProps) {
        boolean listAll;
        BrokerAdmin broker = this.init();
        String commandArg = brokerCmdProps.getCommandArg();
        String destTypeStr = brokerCmdProps.getDestType();
        int destTypeMask = this.getDestTypeMask(brokerCmdProps);
        boolean bl = listAll = destTypeStr == null;
        if ("dst".equals(commandArg)) {
            if (broker == null) {
                Globals.stdErrPrintln(this.ar.getString("A1203"));
                return 1;
            }
            boolean force = brokerCmdProps.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            if (listAll) {
                Globals.stdOutPrintln(this.ar.getString("A1201"));
            } else if (DestType.isQueue(destTypeMask)) {
                Globals.stdOutPrintln(this.ar.getString("A1291"));
            } else if (DestType.isTopic(destTypeMask)) {
                Globals.stdOutPrintln(this.ar.getString("A1290"));
            }
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
                broker.sendGetDestinationsMessage(null, -1, brokerCmdProps.showPartitionModeSet(), brokerCmdProps.loadDestinationSet());
                Vector dests = broker.receiveGetDestinationsReplyMessage();
                if (dests != null) {
                    if (listAll) {
                        this.listDests(brokerCmdProps, dests, 0);
                    } else if (DestType.isTopic(destTypeMask)) {
                        this.listDests(brokerCmdProps, dests, 1);
                    } else if (DestType.isQueue(destTypeMask)) {
                        this.listDests(brokerCmdProps, dests, 2);
                    }
                } else {
                    Globals.stdErrPrintln(this.ar.getString("A1203"));
                    return 1;
                }
                Globals.stdOutPrintln(this.ar.getString("A1202"));
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                Globals.stdErrPrintln(this.ar.getString("A1203"));
                return 1;
            }
        }
        if ("svc".equals(commandArg)) {
            if (broker == null) {
                Globals.stdErrPrintln(this.ar.getString("A1206"));
                return 1;
            }
            boolean force = brokerCmdProps.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            Globals.stdOutPrintln(this.ar.getString("A1204"));
            this.printBrokerInfo(broker);
            try {
                BrokerCmdPrinter bcp;
                this.connectToBroker(broker);
                broker.sendGetServicesMessage(null);
                Vector svcs = broker.receiveGetServicesReplyMessage();
                if (svcs != null) {
                    bcp = new BrokerCmdPrinter(3, 4, "-");
                    Object[] row = new String[3];
                    row[0] = this.ar.getString("A1420");
                    row[1] = this.ar.getString("A1421");
                    row[2] = this.ar.getString("A1422");
                    bcp.addTitle((String[])row);
                    Enumeration thisEnum = svcs.elements();
                    while (thisEnum.hasMoreElements()) {
                        ServiceInfo sInfo = (ServiceInfo)thisEnum.nextElement();
                        row[0] = sInfo.name;
                        if (sInfo.port == -1) {
                            row[1] = "-";
                        } else if (sInfo.dynamicPort) {
                            switch (sInfo.state) {
                                case -1: {
                                    row[1] = this.ar.getString("A1520");
                                    break;
                                }
                                default: {
                                    row[1] = Integer.toString(sInfo.port) + " (" + this.ar.getString("A1520") + ")";
                                    break;
                                }
                            }
                        } else {
                            row[1] = Integer.toString(sInfo.port) + " (" + this.ar.getString("A1521") + ")";
                        }
                        row[2] = BrokerAdminUtil.getServiceState(sInfo.state);
                        bcp.add(row);
                    }
                } else {
                    Globals.stdErrPrintln(this.ar.getString("A1206"));
                    return 1;
                }
                bcp.println();
                Globals.stdOutPrintln(this.ar.getString("A1205"));
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                Globals.stdErrPrintln(this.ar.getString("A1206"));
                return 1;
            }
        }
        if ("dur".equals(commandArg)) {
            String destName;
            boolean listDstName = false;
            if (broker == null) {
                Globals.stdErrPrintln(this.ar.getString("A1553"));
                return 1;
            }
            boolean force = brokerCmdProps.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            if ((destName = brokerCmdProps.getDestName()) != null) {
                Globals.stdOutPrintln(this.ar.getString("A1551", destName));
            } else {
                Globals.stdOutPrintln(this.ar.getString("A1780"));
            }
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                Globals.stdErrPrintln(this.ar.getString("A1553"));
                return 1;
            }
            try {
                if (destName == null) {
                    listDstName = true;
                } else {
                    this.isDestTypeTopic(broker, destName);
                }
            }
            catch (BrokerAdminException bae) {
                if (7 == bae.getType()) {
                    bae.setBrokerErrorStr(this.ar.getString("A1001") + this.ar.getKString("A3111", destName));
                }
                this.handleBrokerAdminException(bae);
                Globals.stdErrPrintln(this.ar.getString("A1553"));
                return 1;
            }
            try {
                BrokerCmdPrinter bcp;
                broker.sendGetDurablesMessage(destName, null);
                Vector durs = broker.receiveGetDurablesReplyMessage();
                if (durs != null) {
                    bcp = null;
                    Object[] row = null;
                    if (listDstName) {
                        row = new String[6];
                        bcp = new BrokerCmdPrinter(6, 3, "-");
                    } else {
                        row = new String[5];
                        bcp = new BrokerCmdPrinter(5, 3, "-");
                    }
                    if (brokerCmdProps.detailModeSet()) {
                        bcp.setSortNeeded(false);
                    }
                    int indx = 0;
                    int n = indx++;
                    row[n] = this.ar.getString("A1434");
                    int n2 = indx++;
                    row[n2] = this.ar.getString("A1431");
                    if (listDstName) {
                        int n3 = indx++;
                        row[n3] = this.ar.getString("A1400");
                    }
                    int n4 = indx++;
                    row[n4] = this.ar.getString("A1435");
                    int n5 = indx++;
                    row[n5] = this.ar.getString("A1432");
                    int n6 = indx++;
                    row[n6] = this.ar.getString("A1433");
                    bcp.addTitle((String[])row);
                    Enumeration thisEnum = durs.elements();
                    while (thisEnum.hasMoreElements()) {
                        DurableInfo dInfo = (DurableInfo)thisEnum.nextElement();
                        indx = 0;
                        row[indx++] = dInfo.name == null ? "" : dInfo.name;
                        String string = row[indx++] = dInfo.clientID == null ? "" : dInfo.clientID;
                        if (listDstName) {
                            row[indx++] = dInfo.consumer == null ? "" : dInfo.consumer.destination;
                        }
                        row[indx++] = String.valueOf(dInfo.isDurable);
                        row[indx++] = Integer.toString(dInfo.nMessages);
                        row[indx] = dInfo.isActive ? (dInfo.isShared ? this.ar.getString("A1510") + "[" + dInfo.activeCount + "]" + (dInfo.isJMSShared ? "jms" : "mq") : this.ar.getString("A1510")) : (dInfo.isShared ? this.ar.getString("A1511") + "[0]" + (dInfo.isJMSShared ? "jms" : "mq") : this.ar.getString("A1511"));
                        if (brokerCmdProps.detailModeSet()) {
                            row[indx] = (String)row[indx] + ", [" + dInfo.uidString + "]";
                        }
                        ++indx;
                        bcp.add(row);
                        if (!brokerCmdProps.detailModeSet() || dInfo.activeConsumers == null) continue;
                        for (Map.Entry<String, ConsumerInfo> pair : dInfo.activeConsumers.entrySet()) {
                            ConsumerInfo cinfo = pair.getValue();
                            String cinfostr = null;
                            cinfostr = cinfo.connection != null ? "[" + cinfo.uidString + ", " + cinfo.subuidString + ", [" + cinfo.connection.uuid + ", " + String.valueOf(cinfo.connection) + "], " + cinfo.brokerAddressShortString + "]" : "[" + cinfo.uidString + ", " + cinfo.subuidString + ", " + cinfo.brokerAddressShortString + "]";
                            int tmpindx = 0;
                            row[tmpindx++] = " ";
                            row[tmpindx++] = " ";
                            if (listDstName) {
                                row[tmpindx++] = " ";
                            }
                            row[tmpindx++] = " ";
                            row[tmpindx++] = " ";
                            row[tmpindx++] = cinfostr;
                            bcp.add(row);
                        }
                    }
                } else {
                    Globals.stdErrPrintln(this.ar.getString("A1553"));
                    return 1;
                }
                bcp.setKeyCriteria(new int[]{0, 1});
                bcp.println();
                Globals.stdOutPrintln(this.ar.getString("A1552"));
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                Globals.stdErrPrintln(this.ar.getString("A1553"));
                return 1;
            }
        }
        if ("txn".equals(commandArg)) {
            if (broker == null) {
                Globals.stdErrPrintln(this.ar.getString("A1253"));
                return 1;
            }
            boolean force = brokerCmdProps.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            Globals.stdOutPrintln(this.ar.getString("A1250"));
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
                broker.sendGetTxnsMessage(brokerCmdProps.showPartitionModeSet());
                Vector txns = broker.receiveGetTxnsReplyMessage();
                if (txns != null && !txns.isEmpty()) {
                    BrokerCmdPrinter bcp = new BrokerCmdPrinter(5, 3, "-");
                    BrokerCmdPrinter bcp_local = new BrokerCmdPrinter(4, 3, "-");
                    BrokerCmdPrinter bcp_remote = new BrokerCmdPrinter(4, 3, "-");
                    Object[] row = new String[5];
                    row[0] = this.ar.getString("A1263");
                    row[1] = this.ar.getString("A1269");
                    row[2] = this.ar.getString("A1270");
                    row[3] = this.ar.getString("A1272");
                    row[4] = this.ar.getString("A1266");
                    bcp.addTitle((String[])row);
                    row[0] = this.ar.getString("A1263");
                    row[1] = this.ar.getString("A1269");
                    row[2] = this.ar.getString("A1270");
                    row[3] = this.ar.getString("A1266");
                    bcp_local.addTitle((String[])row);
                    row[0] = this.ar.getString("A1263");
                    row[1] = this.ar.getString("A1269");
                    row[2] = "# Acks";
                    row[3] = "Remote broker";
                    bcp_remote.addTitle((String[])row);
                    Enumeration thisEnum = txns.elements();
                    while (thisEnum.hasMoreElements()) {
                        Long tmpLong;
                        String tmpStr2;
                        Integer tmpInt;
                        String tmpStr;
                        Hashtable txnInfo = (Hashtable)thisEnum.nextElement();
                        Integer type = (Integer)txnInfo.get("type");
                        if (type == 0) {
                            tmpStr = (String)txnInfo.get("txnid");
                            row[0] = this.checkNullAndPrint(tmpStr);
                            tmpInt = (Integer)txnInfo.get("state");
                            row[1] = this.getTxnStateString(tmpInt);
                            tmpStr = (String)txnInfo.get("user");
                            row[2] = this.checkNullAndPrint(tmpStr);
                            tmpInt = (Integer)txnInfo.get("nmsgs");
                            tmpStr = this.checkNullAndPrint(tmpInt);
                            tmpInt = (Integer)txnInfo.get("nacks");
                            tmpStr2 = this.checkNullAndPrint(tmpInt);
                            row[3] = tmpStr + "/" + tmpStr2;
                            tmpLong = (Long)txnInfo.get("timestamp");
                            row[4] = this.checkNullAndPrintTimestamp(tmpLong);
                            bcp.add(row);
                            continue;
                        }
                        if (type == 1) {
                            tmpStr = (String)txnInfo.get("txnid");
                            row[0] = this.checkNullAndPrint(tmpStr);
                            tmpInt = (Integer)txnInfo.get("state");
                            row[1] = this.getTxnStateString(tmpInt);
                            tmpStr = (String)txnInfo.get("user");
                            row[2] = this.checkNullAndPrint(tmpStr);
                            tmpLong = (Long)txnInfo.get("timestamp");
                            row[3] = this.checkNullAndPrintTimestamp(tmpLong);
                            bcp_local.add(row);
                            continue;
                        }
                        if (type != 2) continue;
                        tmpStr = (String)txnInfo.get("txnid");
                        row[0] = this.checkNullAndPrint(tmpStr);
                        tmpInt = (Integer)txnInfo.get("state");
                        row[1] = this.getTxnStateString(tmpInt);
                        tmpInt = (Integer)txnInfo.get("nacks");
                        row[2] = tmpStr2 = this.checkNullAndPrint(tmpInt);
                        tmpStr = (String)txnInfo.get("homebroker");
                        row[3] = this.checkNullAndPrint(tmpStr);
                        bcp_remote.add(row);
                    }
                    Globals.stdOutPrintln("Transactions that are owned by this broker");
                    bcp.println();
                    Globals.stdOutPrintln("   Transactions that involve remote brokers");
                    bcp_local.setIndent(3);
                    bcp_local.println();
                    Globals.stdOutPrintln("Transactions that are owned by a remote broker");
                    bcp_remote.println();
                    Globals.stdOutPrintln(this.ar.getString("A1251"));
                }
                Globals.stdOutPrintln(this.ar.getString("A1252"));
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                Globals.stdErrPrintln(this.ar.getString("A1253"));
                return 1;
            }
        } else if ("cxn".equals(commandArg)) {
            String svcName = brokerCmdProps.getService();
            if (broker == null) {
                Globals.stdErrPrintln(this.ar.getString("A1321"));
                return 1;
            }
            boolean force = brokerCmdProps.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            if (svcName == null) {
                Globals.stdOutPrintln(this.ar.getString("A1318"));
                this.printBrokerInfo(broker);
            } else {
                Globals.stdOutPrintln(this.ar.getString("A1319"));
                this.printServiceInfo(svcName);
                Globals.stdOutPrintln(this.ar.getString("A1200"));
                this.printBrokerInfo(broker);
            }
            try {
                this.connectToBroker(broker);
                broker.sendGetConnectionsMessage(svcName, null);
                Vector cxnList = broker.receiveGetConnectionsReplyMessage();
                if (cxnList != null && !cxnList.isEmpty()) {
                    BrokerCmdPrinter bcp = new BrokerCmdPrinter(6, 2, "-");
                    Object[] row = new String[6];
                    int i = 0;
                    int n = i++;
                    row[n] = this.ar.getString("A1323");
                    int n7 = i++;
                    row[n7] = this.ar.getString("A1327");
                    int n8 = i++;
                    row[n8] = this.ar.getString("A1331");
                    int n9 = i++;
                    row[n9] = this.ar.getString("A1328");
                    int n10 = i++;
                    row[n10] = this.ar.getString("A1329");
                    int n11 = i++;
                    row[n11] = this.ar.getString("A1325");
                    bcp.addTitle((String[])row);
                    Enumeration thisEnum = cxnList.elements();
                    while (thisEnum.hasMoreElements()) {
                        Hashtable cxnInfo = (Hashtable)thisEnum.nextElement();
                        i = 0;
                        Long tmpLong = (Long)cxnInfo.get("cxnid");
                        row[i++] = this.checkNullAndPrint(tmpLong);
                        String tmpStr = (String)cxnInfo.get("user");
                        row[i++] = this.checkNullAndPrint(tmpStr);
                        tmpStr = (String)cxnInfo.get("service");
                        row[i++] = this.checkNullAndPrint(tmpStr);
                        Integer tmpInt = (Integer)cxnInfo.get("nproducers");
                        row[i++] = this.checkNullAndPrint(tmpInt);
                        tmpInt = (Integer)cxnInfo.get("nconsumers");
                        row[i++] = this.checkNullAndPrint(tmpInt);
                        tmpStr = (String)cxnInfo.get("host");
                        row[i++] = this.checkNullAndPrint(tmpStr);
                        bcp.add(row);
                    }
                    bcp.println();
                    Globals.stdOutPrintln(this.ar.getString("A1320"));
                }
                Globals.stdOutPrintln(this.ar.getString("A1322"));
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                Globals.stdErrPrintln(this.ar.getString("A1321"));
                return 1;
            }
        } else if ("bkr".equals(commandArg)) {
            if (broker == null) {
                Globals.stdErrPrintln(this.ar.getString("A1713"));
                return 1;
            }
            boolean force = brokerCmdProps.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            Globals.stdOutPrintln(this.ar.getString("A1712"));
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
                broker.sendGetBrokerPropsMessage();
                Properties bkrProps = broker.receiveGetBrokerPropsReplyMessage();
                BrokerCmdPrinter haBcp = new BrokerCmdPrinter(2, 3, null);
                Object[] haInfoRow = new String[2];
                String value = bkrProps.getProperty("imq.cluster.ha");
                boolean isHA = Boolean.parseBoolean(value);
                value = bkrProps.getProperty("imq.storemigratable");
                boolean isStoreMigratable = Boolean.parseBoolean(value);
                haInfoRow[0] = this.ar.getString("A1709");
                haInfoRow[1] = value = bkrProps.getProperty("imq.cluster.clusterid", "");
                haBcp.add(haInfoRow);
                haInfoRow[0] = this.ar.getString("A1710");
                haInfoRow[1] = !isHA ? Boolean.FALSE.toString() : Boolean.TRUE.toString();
                haBcp.add(haInfoRow);
                haBcp.println();
                broker.sendGetClusterMessage(true);
                Vector bkrList = broker.receiveGetClusterReplyMessage();
                if (bkrList != null && !bkrList.isEmpty()) {
                    BrokerCmdPrinter bcp;
                    if (isHA) {
                        bcp = new BrokerCmdPrinter(6, 3, "-");
                        Object[] row = new String[6];
                        bcp.setSortNeeded(false);
                        bcp.setTitleAlign(1);
                        int i = 0;
                        row[i++] = "";
                        row[i++] = "";
                        row[i++] = "";
                        row[i++] = "";
                        int n = i++;
                        row[n] = this.ar.getString("A1720");
                        int n12 = i++;
                        row[n12] = this.ar.getString("A1721");
                        bcp.addTitle((String[])row);
                        i = 0;
                        int n13 = i++;
                        row[n13] = this.ar.getString("A1716");
                        int n14 = i++;
                        row[n14] = this.ar.getString("A1717");
                        int n15 = i++;
                        row[n15] = this.ar.getString("A1718");
                        int n16 = i++;
                        row[n16] = this.ar.getString("A1719");
                        int n17 = i++;
                        row[n17] = this.ar.getString("A1736");
                        int n18 = i++;
                        row[n18] = this.ar.getString("A1737");
                        bcp.addTitle((String[])row);
                        Enumeration thisEnum = bkrList.elements();
                        while (thisEnum.hasMoreElements()) {
                            Hashtable bkrClsInfo = (Hashtable)thisEnum.nextElement();
                            i = 0;
                            row[i++] = this.checkNullAndPrint(bkrClsInfo.get("ID"));
                            row[i++] = this.checkNullAndPrint(bkrClsInfo.get("Address"));
                            Integer tmpInt = (Integer)bkrClsInfo.get("State");
                            row[i++] = tmpInt != null ? BrokerState.toString(tmpInt) : "";
                            Long tmpLong = (Long)bkrClsInfo.get("NumMsgs");
                            row[i++] = this.checkNullAndPrint(tmpLong);
                            row[i++] = this.checkNullAndPrint(bkrClsInfo.get("TakeoverBrokerID"));
                            tmpLong = (Long)bkrClsInfo.get("StatusTimestamp");
                            if (tmpLong != null) {
                                long idle = System.currentTimeMillis() - tmpLong;
                                row[i++] = CommonCmdRunnerUtil.getTimeString(idle);
                            } else {
                                row[i++] = "";
                            }
                            bcp.add(row);
                        }
                    } else if (isStoreMigratable) {
                        bcp = new BrokerCmdPrinter(3, 3, "-");
                        Object[] row = new String[3];
                        bcp.setSortNeeded(false);
                        bcp.setTitleAlign(1);
                        int i = 0;
                        int n = i++;
                        row[n] = this.ar.getString("A1716");
                        int n19 = i++;
                        row[n19] = this.ar.getString("A1717");
                        int n20 = i++;
                        row[n20] = this.ar.getString("A1718");
                        bcp.addTitle((String[])row);
                        Enumeration thisEnum = bkrList.elements();
                        while (thisEnum.hasMoreElements()) {
                            Hashtable bkrClsInfo = (Hashtable)thisEnum.nextElement();
                            i = 0;
                            row[i++] = this.checkNullAndPrint(bkrClsInfo.get("ID"));
                            row[i++] = this.checkNullAndPrint(bkrClsInfo.get("Address"));
                            Integer tmpInt = (Integer)bkrClsInfo.get("State");
                            row[i++] = tmpInt != null ? BrokerState.toString(tmpInt) : "";
                            bcp.add(row);
                        }
                    } else {
                        bcp = new BrokerCmdPrinter(2, 3, "-");
                        Object[] row = new String[2];
                        bcp.setSortNeeded(false);
                        bcp.setTitleAlign(1);
                        int i = 0;
                        int n = i++;
                        row[n] = this.ar.getString("A1717");
                        int n21 = i++;
                        row[n21] = this.ar.getString("A1718");
                        bcp.addTitle((String[])row);
                        Enumeration thisEnum = bkrList.elements();
                        while (thisEnum.hasMoreElements()) {
                            Hashtable bkrClsInfo = (Hashtable)thisEnum.nextElement();
                            i = 0;
                            row[i++] = this.checkNullAndPrint(bkrClsInfo.get("Address"));
                            Integer tmpInt = (Integer)bkrClsInfo.get("State");
                            row[i++] = tmpInt != null ? BrokerState.toString(tmpInt) : "";
                            bcp.add(row);
                        }
                    }
                    bcp.println();
                    Globals.stdOutPrintln(this.ar.getString("A1714"));
                }
                Globals.stdOutPrintln(this.ar.getString("A1715"));
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                Globals.stdErrPrintln(this.ar.getString("A1713"));
                return 1;
            }
        } else if ("jmx".equals(commandArg)) {
            if (broker == null) {
                Globals.stdErrPrintln(this.ar.getString("A1723"));
                return 1;
            }
            boolean force = brokerCmdProps.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            Globals.stdOutPrintln(this.ar.getString("A1722"));
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
                broker.sendGetJMXConnectorsMessage(null);
                Vector jmxList = broker.receiveGetJMXConnectorsReplyMessage();
                if (jmxList != null) {
                    BrokerCmdPrinter bcp = new BrokerCmdPrinter(3, 4, null);
                    Object[] row = new String[3];
                    row[0] = this.ar.getString("A1726");
                    row[1] = this.ar.getString("A1727");
                    row[2] = this.ar.getString("A1728");
                    bcp.addTitle((String[])row);
                    Enumeration thisEnum = jmxList.elements();
                    while (thisEnum.hasMoreElements()) {
                        Hashtable jmxInfo = (Hashtable)thisEnum.nextElement();
                        int i = 0;
                        row[i++] = this.checkNullAndPrint(jmxInfo.get("name"));
                        row[i++] = this.checkNullAndPrint(jmxInfo.get("active"));
                        row[i++] = this.checkNullAndPrint(jmxInfo.get("url"));
                        bcp.add(row);
                    }
                    bcp.println();
                    Globals.stdOutPrintln(this.ar.getString("A1724"));
                }
                Globals.stdErrPrintln(this.ar.getString("A1725"));
                Globals.stdOutPrintln("");
                Globals.stdOutPrintln(this.ar.getString("A1724"));
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                Globals.stdErrPrintln(this.ar.getString("A1723"));
                return 1;
            }
        } else if ("msg".equals(commandArg)) {
            if (broker == null) {
                Globals.stdErrPrintln("Listing messages failed.");
                return 1;
            }
            boolean force = brokerCmdProps.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            String destName = brokerCmdProps.getTargetName();
            destTypeMask = this.getDestTypeMask(brokerCmdProps);
            Long maxNumMsgsRetrieved = brokerCmdProps.getMaxNumMsgsRetrieved();
            Long startMsgIndex = brokerCmdProps.getStartMsgIndex();
            Globals.stdOutPrintln("Listing messages for the destination");
            this.printDestinationInfo();
            Globals.stdOutPrintln(this.ar.getString("A1200"));
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
                broker.sendGetMessagesMessage(destName, destTypeMask, false, null, startMsgIndex, maxNumMsgsRetrieved);
                Vector msgList = broker.receiveGetMessagesReplyMessage();
                if (msgList != null && !msgList.isEmpty()) {
                    BrokerCmdPrinter bcp = new BrokerCmdPrinter(4, 3, "-");
                    Object[] row = new String[4];
                    bcp.setSortNeeded(false);
                    int i = 0;
                    row[i++] = "Message #";
                    row[i++] = "Message IDs";
                    row[i++] = "Priority";
                    row[i++] = "Body Type";
                    bcp.addTitle((String[])row);
                    long start = 0L;
                    if (startMsgIndex != null) {
                        start = startMsgIndex;
                    }
                    Enumeration thisEnum = msgList.elements();
                    while (thisEnum.hasMoreElements()) {
                        HashMap oneMsg = (HashMap)thisEnum.nextElement();
                        i = 0;
                        row[i++] = Long.toString(start++);
                        row[i++] = this.checkNullAndPrint(oneMsg.get("MessageID"));
                        row[i++] = this.checkNullAndPrint(oneMsg.get("Priority"));
                        row[i++] = this.checkNullAndPrintMsgBodyType((Integer)oneMsg.get("MessageBodyType"), false);
                        bcp.add(row);
                    }
                    bcp.println();
                    Globals.stdOutPrintln("Successfully listed messages.");
                } else {
                    Globals.stdErrPrintln("There are no messages.");
                    Globals.stdOutPrintln("");
                    Globals.stdOutPrintln("Successfully listed messages.");
                }
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                Globals.stdErrPrintln("Listing messages failed.");
                return 1;
            }
        }
        broker.close();
        return 0;
    }

    private void listDests(BrokerCmdProperties brokerCmdProps, Vector dests, int listType) {
        BrokerCmdPrinter bcp = this.setupListDestTitle(listType);
        Object[] row = new String[12];
        Enumeration thisEnum = dests.elements();
        while (thisEnum.hasMoreElements()) {
            Hashtable h;
            Object destType;
            DestinationInfo dInfo = (DestinationInfo)thisEnum.nextElement();
            int j = 0;
            float avgMsgSize = 0.0f;
            if ("__JMQAdmin".equals(dInfo.name) || "__JMQBridgeAdmin".equals(dInfo.name) || DestType.isInternal(dInfo.fulltype)) continue;
            if (DestType.isTemporary(dInfo.type)) {
                if (!brokerCmdProps.showTempDestModeSet()) continue;
                destType = BrokerAdminUtil.getDestinationType(dInfo.type) + " (" + this.ar.getString("A1631") + ")";
            } else {
                destType = BrokerAdminUtil.getDestinationType(dInfo.type);
            }
            if (listType == 1 && !DestType.isTopic(dInfo.type) || listType == 2 && !DestType.isQueue(dInfo.type)) continue;
            int numMsgs = dInfo.nMessages - dInfo.nTxnMessages;
            long totalMsgSize = dInfo.nMessageBytes;
            if (numMsgs > 0) {
                avgMsgSize = (float)totalMsgSize / (float)numMsgs;
            }
            row[j++] = dInfo.name;
            row[j++] = destType;
            row[j++] = BrokerAdminUtil.getDestinationState(dInfo.destState);
            row[j++] = Integer.toString(dInfo.nProducers);
            if (listType != 2) {
                if (DestType.isTopic(dInfo.type)) {
                    h = dInfo.producerWildcards;
                    row[j++] = Integer.toString(this.getWildcardCount(h));
                } else {
                    row[j++] = "-";
                }
            }
            if (DestType.isTopic(dInfo.type)) {
                row[j++] = Integer.toString(dInfo.nConsumers);
                h = dInfo.consumerWildcards;
                row[j++] = Integer.toString(this.getWildcardCount(h));
            } else if (listType == 2) {
                row[j++] = Integer.toString(dInfo.naConsumers);
                row[j++] = Integer.toString(dInfo.nfConsumers);
            } else {
                row[j++] = Integer.toString(dInfo.naConsumers + dInfo.nfConsumers);
                row[j++] = "-";
            }
            row[j++] = Integer.toString(numMsgs);
            row[j++] = Integer.toString(dInfo.nRemoteMessages);
            row[j++] = Integer.toString(dInfo.nUnackMessages);
            row[j++] = Integer.toString(dInfo.nInDelayMessages);
            row[j++] = Float.toString(avgMsgSize);
            bcp.add(row);
        }
        bcp.setKeyCriteria(new int[]{0, 1});
        bcp.println();
    }

    private int getWildcardCount(Hashtable h) {
        int count = 0;
        if (h == null) {
            return 0;
        }
        Enumeration keys = h.keys();
        while (keys.hasMoreElements()) {
            String wildcard = (String)keys.nextElement();
            Integer val = (Integer)h.get(wildcard);
            count += val.intValue();
        }
        return count;
    }

    public String getTxnStateString(Integer txnState) {
        if (txnState == null) {
            return "";
        }
        int tmpInt = txnState;
        switch (tmpInt) {
            case 0: {
                return this.ar.getString("A1280");
            }
            case 1: {
                return this.ar.getString("A1281");
            }
            case 2: {
                return this.ar.getString("A1282");
            }
            case 3: {
                return this.ar.getString("A1283");
            }
            case 4: {
                return this.ar.getString("A1284");
            }
            case 5: {
                return this.ar.getString("A1285");
            }
            case 6: {
                return this.ar.getString("A1286");
            }
            case 7: {
                return this.ar.getString("A1287");
            }
        }
        return this.ar.getString("A1288");
    }

    private int runPause(BrokerCmdProperties brokerCmdProps) {
        String input = null;
        String yes = this.ar.getString("A5016");
        String yesShort = this.ar.getString("A5015");
        String no = this.ar.getString("A5018");
        String noShort = this.ar.getString("A5017");
        BrokerAdmin broker = this.init();
        boolean force = brokerCmdProps.forceModeSet();
        String commandArg = brokerCmdProps.getCommandArg();
        if ("bkr".equals(commandArg)) {
            if (broker == null) {
                Globals.stdErrPrintln(this.ar.getString("A1209"));
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            Globals.stdOutPrintln(this.ar.getString("A1207"));
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                Globals.stdErrPrintln(this.ar.getString("A1209"));
                return 1;
            }
            if (!force) {
                input = CommonCmdRunnerUtil.getUserInput(this.ar.getString("A5005"), noShort);
                Globals.stdOutPrintln("");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    broker.sendPauseMessage(null);
                    broker.receivePauseReplyMessage();
                    Globals.stdOutPrintln(this.ar.getString("A1208"));
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    Globals.stdErrPrintln(this.ar.getString("A1209"));
                    return 1;
                }
            }
            if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                Globals.stdOutPrintln(this.ar.getString("A1210"));
                return 0;
            }
            Globals.stdOutPrintln(this.ar.getString("A1026", input));
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(this.ar.getString("A1210"));
            return 1;
        }
        if ("svc".equals(commandArg)) {
            if (broker == null) {
                Globals.stdErrPrintln(this.ar.getString("A1213"));
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            String svcName = brokerCmdProps.getTargetName();
            Globals.stdOutPrintln(this.ar.getString("A1211"));
            this.printServiceInfo();
            Globals.stdOutPrintln(this.ar.getString("A1200"));
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                Globals.stdErrPrintln(this.ar.getString("A1213"));
                return 1;
            }
            try {
                this.isAdminService(broker, svcName);
            }
            catch (BrokerAdminException bae) {
                if (7 == bae.getType()) {
                    bae.setBrokerErrorStr(this.ar.getString("A1001") + this.ar.getKString("A3109", svcName));
                }
                this.handleBrokerAdminException(bae);
                Globals.stdErrPrintln(this.ar.getString("A1213"));
                return 1;
            }
            if (!force) {
                input = CommonCmdRunnerUtil.getUserInput(this.ar.getString("A5006"), noShort);
                Globals.stdOutPrintln("");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    broker.sendPauseMessage(svcName);
                    broker.receivePauseReplyMessage();
                    Globals.stdOutPrintln(this.ar.getString("A1212"));
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    Globals.stdErrPrintln(this.ar.getString("A1213"));
                    return 1;
                }
            }
            if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                Globals.stdOutPrintln(this.ar.getString("A1214"));
                return 0;
            }
            Globals.stdOutPrintln(this.ar.getString("A1026", input));
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(this.ar.getString("A1214"));
            return 1;
        }
        if ("dst".equals(commandArg)) {
            BrokerCmdPrinter bcp = new BrokerCmdPrinter(2, 4);
            Object[] row = new String[2];
            boolean pauseAll = true;
            String destName = brokerCmdProps.getTargetName();
            int destTypeMask = this.getDestTypeMask(brokerCmdProps);
            String pauseTypeStr = brokerCmdProps.getPauseType();
            if (destName != null) {
                pauseAll = false;
            }
            if (broker == null) {
                if (pauseAll) {
                    Globals.stdErrPrintln(this.ar.getString("A1311"));
                } else {
                    Globals.stdErrPrintln(this.ar.getString("A1275"));
                }
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            if (pauseAll) {
                Globals.stdOutPrintln(this.ar.getString("A1309"));
            } else {
                Globals.stdOutPrintln(this.ar.getString("A1273"));
                this.printDestinationInfo();
            }
            if (pauseTypeStr != null) {
                Globals.stdOutPrintln(this.ar.getString("A1317"));
                row[0] = this.ar.getString("A1442");
                row[1] = pauseTypeStr;
                bcp.add(row);
                bcp.println();
            }
            Globals.stdOutPrintln(this.ar.getString("A1200"));
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                if (pauseAll) {
                    Globals.stdErrPrintln(this.ar.getString("A1311"));
                } else {
                    Globals.stdErrPrintln(this.ar.getString("A1275"));
                }
                return 1;
            }
            if (!force) {
                input = pauseAll ? CommonCmdRunnerUtil.getUserInput(this.ar.getString("A5025"), noShort) : CommonCmdRunnerUtil.getUserInput(this.ar.getString("A5021"), noShort);
                Globals.stdOutPrintln("");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    int pauseType = this.getPauseTypeVal(pauseTypeStr);
                    broker.sendPauseMessage(destName, destTypeMask, pauseType);
                    broker.receivePauseReplyMessage();
                    if (pauseAll) {
                        Globals.stdOutPrintln(this.ar.getString("A1310"));
                    }
                    Globals.stdOutPrintln(this.ar.getString("A1274"));
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    if (pauseAll) {
                        Globals.stdErrPrintln(this.ar.getString("A1311"));
                    } else {
                        Globals.stdErrPrintln(this.ar.getString("A1275"));
                    }
                    return 1;
                }
            } else {
                if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                    if (pauseAll) {
                        Globals.stdOutPrintln(this.ar.getString("A1312"));
                    } else {
                        Globals.stdOutPrintln(this.ar.getString("A1276"));
                    }
                    return 0;
                }
                Globals.stdOutPrintln(this.ar.getString("A1026", input));
                Globals.stdOutPrintln("");
                if (pauseAll) {
                    Globals.stdOutPrintln(this.ar.getString("A1312"));
                } else {
                    Globals.stdOutPrintln(this.ar.getString("A1276"));
                }
                return 1;
            }
        }
        broker.close();
        return 0;
    }

    private int runReset(BrokerCmdProperties brokerCmdProps) {
        String input = null;
        String yes = this.ar.getString("A5016");
        String yesShort = this.ar.getString("A5015");
        String no = this.ar.getString("A5018");
        String noShort = this.ar.getString("A5017");
        BrokerAdmin broker = this.init();
        boolean force = brokerCmdProps.forceModeSet();
        String commandArg = brokerCmdProps.getCommandArg();
        if ("bkr".equals(commandArg)) {
            BrokerCmdPrinter bcp = new BrokerCmdPrinter(2, 4);
            Object[] row = new String[2];
            String resetType = brokerCmdProps.getResetType();
            if (broker == null) {
                Globals.stdErrPrintln(this.ar.getString("A1766"));
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            Globals.stdOutPrintln(this.ar.getString("A1764"));
            if (resetType != null) {
                Globals.stdOutPrintln(this.ar.getString("A1317"));
                row[0] = this.ar.getString("A1768");
                row[1] = resetType;
                bcp.add(row);
                bcp.println();
            }
            Globals.stdOutPrintln(this.ar.getString("A1200"));
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                Globals.stdErrPrintln(this.ar.getString("A1766"));
                return 1;
            }
            if (!force) {
                input = CommonCmdRunnerUtil.getUserInput(this.ar.getString("A5031"), noShort);
                Globals.stdOutPrintln("");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    String resetTypeVal = this.getResetTypeVal(resetType);
                    broker.sendResetBrokerMessage(resetTypeVal);
                    broker.receiveResetBrokerReplyMessage();
                    Globals.stdOutPrintln(this.ar.getString("A1765"));
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    Globals.stdErrPrintln(this.ar.getString("A1766"));
                    return 1;
                }
            } else {
                if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                    Globals.stdOutPrintln(this.ar.getString("A1767"));
                    return 0;
                }
                Globals.stdOutPrintln(this.ar.getString("A1026", input));
                Globals.stdOutPrintln("");
                Globals.stdOutPrintln(this.ar.getString("A1767"));
                return 1;
            }
        }
        broker.close();
        return 0;
    }

    private int runCheckpoint(BrokerCmdProperties brokerCmdProps) {
        String input = null;
        String yes = this.ar.getString("A5016");
        String yesShort = this.ar.getString("A5015");
        String no = this.ar.getString("A5018");
        String noShort = this.ar.getString("A5017");
        BrokerAdmin broker = this.init();
        if (broker == null) {
            Globals.stdErrPrintln(this.ar.getString("A1783"));
            return 1;
        }
        boolean force = brokerCmdProps.forceModeSet();
        if (!force) {
            broker = this.promptForAuthentication(broker);
        }
        Globals.stdOutPrintln(this.ar.getString("A1781"));
        this.printBrokerInfo(broker);
        try {
            this.connectToBroker(broker);
        }
        catch (BrokerAdminException bae) {
            this.handleBrokerAdminException(bae);
            Globals.stdErrPrintln(this.ar.getString("A1783"));
            return 1;
        }
        if (!force) {
            input = CommonCmdRunnerUtil.getUserInput(this.ar.getString("A5035"), noShort);
            Globals.stdOutPrintln("");
        }
        if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
            try {
                broker.sendCheckpointBrokerMessage();
                broker.receiveCheckpointBrokerReplyMessage();
                Globals.stdOutPrintln(this.ar.getString("A1782"));
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                Globals.stdErrPrintln(this.ar.getString("A1783"));
                return 1;
            }
        } else {
            if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                Globals.stdOutPrintln(this.ar.getString("A1784"));
                return 0;
            }
            Globals.stdOutPrintln(this.ar.getString("A1026", input));
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(this.ar.getString("A1784"));
            return 1;
        }
        broker.close();
        return 0;
    }

    private int runResume(BrokerCmdProperties brokerCmdProps) {
        String input = null;
        String yes = this.ar.getString("A5016");
        String yesShort = this.ar.getString("A5015");
        String no = this.ar.getString("A5018");
        String noShort = this.ar.getString("A5017");
        BrokerAdmin broker = this.init();
        boolean force = brokerCmdProps.forceModeSet();
        String commandArg = brokerCmdProps.getCommandArg();
        if ("bkr".equals(commandArg)) {
            if (broker == null) {
                Globals.stdErrPrintln(this.ar.getString("A1217"));
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            Globals.stdOutPrintln(this.ar.getString("A1215"));
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                Globals.stdErrPrintln(this.ar.getString("A1217"));
                return 1;
            }
            if (!force) {
                input = CommonCmdRunnerUtil.getUserInput(this.ar.getString("A5007"), noShort);
                Globals.stdOutPrintln("");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    broker.sendResumeMessage(null);
                    broker.receiveResumeReplyMessage();
                    Globals.stdOutPrintln(this.ar.getString("A1216"));
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    Globals.stdErrPrintln(this.ar.getString("A1217"));
                    return 1;
                }
            }
            if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                Globals.stdOutPrintln(this.ar.getString("A1218"));
                return 0;
            }
            Globals.stdOutPrintln(this.ar.getString("A1026", input));
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(this.ar.getString("A1218"));
            return 1;
        }
        if ("svc".equals(commandArg)) {
            if (broker == null) {
                Globals.stdErrPrintln(this.ar.getString("A1221"));
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            String svcName = brokerCmdProps.getTargetName();
            Globals.stdOutPrintln(this.ar.getString("A1219"));
            this.printServiceInfo();
            Globals.stdOutPrintln(this.ar.getString("A1200"));
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                Globals.stdErrPrintln(this.ar.getString("A1221"));
                return 1;
            }
            try {
                this.isAdminService(broker, svcName);
            }
            catch (BrokerAdminException bae) {
                if (7 == bae.getType()) {
                    bae.setBrokerErrorStr(this.ar.getString("A1001") + this.ar.getKString("A3110", svcName));
                }
                this.handleBrokerAdminException(bae);
                Globals.stdErrPrintln(this.ar.getString("A1221"));
                return 1;
            }
            if (!force) {
                input = CommonCmdRunnerUtil.getUserInput(this.ar.getString("A5008"), noShort);
                Globals.stdOutPrintln("");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    broker.sendResumeMessage(svcName);
                    broker.receiveResumeReplyMessage();
                    Globals.stdOutPrintln(this.ar.getString("A1220"));
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    Globals.stdErrPrintln(this.ar.getString("A1221"));
                    return 1;
                }
            }
            if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                Globals.stdOutPrintln(this.ar.getString("A1222"));
                return 0;
            }
            Globals.stdOutPrintln(this.ar.getString("A1026", input));
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(this.ar.getString("A1222"));
            return 1;
        }
        if ("dst".equals(commandArg)) {
            boolean resumeAll = true;
            String destName = brokerCmdProps.getTargetName();
            int destTypeMask = this.getDestTypeMask(brokerCmdProps);
            if (destName != null) {
                resumeAll = false;
            }
            if (broker == null) {
                if (resumeAll) {
                    Globals.stdErrPrintln(this.ar.getString("A1315"));
                } else {
                    Globals.stdErrPrintln(this.ar.getString("A1294"));
                }
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            if (resumeAll) {
                Globals.stdOutPrintln(this.ar.getString("A1313"));
            } else {
                Globals.stdOutPrintln(this.ar.getString("A1292"));
                this.printDestinationInfo();
                Globals.stdOutPrintln(this.ar.getString("A1200"));
            }
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                if (resumeAll) {
                    Globals.stdErrPrintln(this.ar.getString("A1315"));
                } else {
                    Globals.stdErrPrintln(this.ar.getString("A1294"));
                }
                return 1;
            }
            if (!force) {
                input = resumeAll ? CommonCmdRunnerUtil.getUserInput(this.ar.getString("A5026"), noShort) : CommonCmdRunnerUtil.getUserInput(this.ar.getString("A5022"), noShort);
                Globals.stdOutPrintln("");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    broker.sendResumeMessage(destName, destTypeMask);
                    broker.receiveResumeReplyMessage();
                    if (resumeAll) {
                        Globals.stdOutPrintln(this.ar.getString("A1314"));
                    }
                    Globals.stdOutPrintln(this.ar.getString("A1293"));
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    if (resumeAll) {
                        Globals.stdErrPrintln(this.ar.getString("A1315"));
                    } else {
                        Globals.stdErrPrintln(this.ar.getString("A1294"));
                    }
                    return 1;
                }
            } else {
                if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                    if (resumeAll) {
                        Globals.stdOutPrintln(this.ar.getString("A1316"));
                    } else {
                        Globals.stdOutPrintln(this.ar.getString("A1295"));
                    }
                    return 0;
                }
                Globals.stdOutPrintln(this.ar.getString("A1026", input));
                Globals.stdOutPrintln("");
                if (resumeAll) {
                    Globals.stdOutPrintln(this.ar.getString("A1316"));
                } else {
                    Globals.stdOutPrintln(this.ar.getString("A1295"));
                }
                return 1;
            }
        }
        broker.close();
        return 0;
    }

    private int runShutdown(BrokerCmdProperties brokerCmdProps) {
        String sessionID;
        String input = null;
        String yes = this.ar.getString("A5016");
        String yesShort = this.ar.getString("A5015");
        String no = this.ar.getString("A5018");
        String noShort = this.ar.getString("A5017");
        BrokerAdmin broker = this.init();
        if (broker == null) {
            Globals.stdErrPrintln(this.ar.getString("A1225"));
            return 1;
        }
        boolean force = brokerCmdProps.forceModeSet();
        if (!force) {
            broker = this.promptForAuthentication(broker);
        }
        boolean noFailover = brokerCmdProps.noFailoverSet();
        int time = brokerCmdProps.getTime();
        Globals.stdOutPrintln(this.ar.getString("A1223"));
        this.printBrokerInfo(broker);
        try {
            this.connectToBroker(broker);
            sessionID = this.getPortMapperSessionID(brokerCmdProps, broker);
        }
        catch (BrokerAdminException bae) {
            this.handleBrokerAdminException(bae);
            Globals.stdErrPrintln(this.ar.getString("A1225"));
            return 1;
        }
        if (!force) {
            input = CommonCmdRunnerUtil.getUserInput(this.ar.getString("A5009"), noShort);
            Globals.stdOutPrintln("");
        }
        if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
            try {
                broker.sendShutdownMessage(false, false, noFailover, time);
                broker.receiveShutdownReplyMessage();
                if (this.waitForShutdown(broker, sessionID, brokerCmdProps)) {
                    Globals.stdOutPrintln(this.ar.getString("A1224"));
                }
                Globals.stdOutPrintln(this.ar.getString("A1760"));
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                Globals.stdErrPrintln(this.ar.getString("A1225"));
                return 1;
            }
        } else {
            if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                Globals.stdOutPrintln(this.ar.getString("A1226"));
                return 0;
            }
            Globals.stdOutPrintln(this.ar.getString("A1026", input));
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(this.ar.getString("A1226"));
            return 1;
        }
        return 0;
    }

    private boolean waitForShutdown(BrokerAdmin broker, String waitSessionID, BrokerCmdProperties brokerCmdProps) {
        int port;
        GenericPortMapperClient pmc = null;
        String hostName = broker.getBrokerHost();
        String portString = broker.getBrokerPort();
        String sessionID = null;
        if (brokerCmdProps == null) {
            return false;
        }
        long sleepTime = brokerCmdProps.getShutdownWaitInterval();
        int shutdownDelaySecs = brokerCmdProps.getTime();
        if (shutdownDelaySecs > 0) {
            return false;
        }
        if (waitSessionID == null) {
            return false;
        }
        try {
            port = Integer.parseInt(portString);
        }
        catch (Exception e) {
            port = 7676;
        }
        boolean brokerDown = false;
        Globals.stdOutPrintln(this.ar.getString("A1761", hostName + ":" + portString));
        while (!brokerDown) {
            try {
                Thread.sleep(sleepTime);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                pmc = new GenericPortMapperClient(hostName, port);
            }
            catch (Exception e) {
                brokerDown = true;
            }
            if (pmc == null) continue;
            sessionID = pmc.getProperty("sessionid", null, "PORTMAPPER", "portmapper");
            if (sessionID == null) {
                brokerDown = true;
                continue;
            }
            if (sessionID.equals(waitSessionID)) continue;
            brokerDown = true;
        }
        return true;
    }

    private String getPortMapperSessionID(BrokerCmdProperties brokerCmdProps, BrokerAdmin broker) {
        int port;
        String hostName = broker.getBrokerHost();
        String portString = broker.getBrokerPort();
        String sessionID = null;
        try {
            port = Integer.parseInt(portString);
        }
        catch (Exception e) {
            port = 7676;
        }
        try {
            GenericPortMapperClient pmc = new GenericPortMapperClient(hostName, port);
            sessionID = pmc.getProperty("sessionid", null, "PORTMAPPER", "portmapper");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sessionID;
    }

    private int runRestart(BrokerCmdProperties brokerCmdProps) {
        String input = null;
        String yes = this.ar.getString("A5016");
        String yesShort = this.ar.getString("A5015");
        String no = this.ar.getString("A5018");
        String noShort = this.ar.getString("A5017");
        BrokerAdmin broker = this.init();
        if (broker == null) {
            Globals.stdErrPrintln(this.ar.getString("A1229"));
            return 1;
        }
        boolean force = brokerCmdProps.forceModeSet();
        if (!force) {
            broker = this.promptForAuthentication(broker);
        }
        Globals.stdOutPrintln(this.ar.getString("A1227"));
        this.printBrokerInfo(broker);
        try {
            this.connectToBroker(broker);
        }
        catch (BrokerAdminException bae) {
            this.handleBrokerAdminException(bae);
            Globals.stdErrPrintln(this.ar.getString("A1229"));
            return 1;
        }
        if (!force) {
            input = CommonCmdRunnerUtil.getUserInput(this.ar.getString("A5010"), noShort);
            Globals.stdOutPrintln("");
        }
        if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
            try {
                broker.sendShutdownMessage(true);
                broker.receiveShutdownReplyMessage();
                if (!this.reconnectToBroker(broker)) {
                    Globals.stdErrPrintln(this.ar.getString("A1229"));
                    return 1;
                }
                Globals.stdOutPrintln(this.ar.getString("A1228"));
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                Globals.stdErrPrintln(this.ar.getString("A1229"));
                return 1;
            }
        } else {
            if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                Globals.stdOutPrintln(this.ar.getString("A1230"));
                return 0;
            }
            Globals.stdOutPrintln(this.ar.getString("A1026", input));
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(this.ar.getString("A1230"));
            return 1;
        }
        broker.close();
        return 0;
    }

    private int runCreate(BrokerCmdProperties brokerCmdProps) {
        BrokerAdmin broker = this.init();
        if (broker == null) {
            Globals.stdErrPrintln(this.ar.getString("A1233"));
            return 1;
        }
        boolean force = brokerCmdProps.forceModeSet();
        if (!force) {
            broker = this.promptForAuthentication(broker);
        }
        String destName = brokerCmdProps.getTargetName();
        int destTypeMask = this.getDestTypeMask(brokerCmdProps);
        Properties destAttrs = brokerCmdProps.getTargetAttrs();
        Globals.stdOutPrintln(this.ar.getString("A1231"));
        BrokerCmdPrinter bcp = new BrokerCmdPrinter(2, 4);
        Object[] row = new String[2];
        bcp.setSortNeeded(false);
        row[0] = this.ar.getString("A1400");
        row[1] = destName;
        bcp.add(row);
        row[0] = this.ar.getString("A1401");
        row[1] = BrokerAdminUtil.getDestinationType(destTypeMask);
        bcp.add(row);
        String prop = null;
        prop = destAttrs.getProperty("maxNumMsgs");
        if (prop != null) {
            row[0] = this.ar.getString("A1407");
            row[1] = prop;
            bcp.add(row);
        }
        if ((prop = destAttrs.getProperty("maxTotalMsgBytes")) != null) {
            row[0] = this.ar.getString("A1406");
            row[1] = prop;
            bcp.add(row);
        }
        if ((prop = destAttrs.getProperty("maxBytesPerMsg")) != null) {
            row[0] = this.ar.getString("A1408");
            row[1] = prop;
            bcp.add(row);
        }
        if ((prop = destAttrs.getProperty("maxNumProducers")) != null) {
            row[0] = this.ar.getString("A1415");
            row[1] = prop;
            bcp.add(row);
        }
        if ((prop = destAttrs.getProperty("maxNumActiveConsumers")) != null) {
            row[0] = this.ar.getString("A1410");
            row[1] = prop;
            bcp.add(row);
        }
        if ((prop = destAttrs.getProperty("maxNumBackupConsumers")) != null) {
            row[0] = this.ar.getString("A1409");
            row[1] = prop;
            bcp.add(row);
        }
        if ((prop = destAttrs.getProperty("limitBehavior")) != null) {
            row[0] = this.ar.getString("A1412");
            row[1] = prop;
            bcp.add(row);
        }
        if ((prop = destAttrs.getProperty("consumerFlowLimit")) != null) {
            row[0] = this.ar.getString("A1414");
            row[1] = prop;
            bcp.add(row);
        }
        if ((prop = destAttrs.getProperty("isLocalOnly")) != null) {
            row[0] = this.ar.getString("A1411");
            row[1] = prop;
            bcp.add(row);
        }
        if ((prop = destAttrs.getProperty("localDeliveryPreferred")) != null) {
            row[0] = this.ar.getString("A1413");
            row[1] = prop;
            bcp.add(row);
        }
        if ((prop = destAttrs.getProperty("useDMQ")) != null) {
            row[0] = this.ar.getString("A1446");
            row[1] = prop;
            bcp.add(row);
        }
        if ((prop = destAttrs.getProperty("validateXMLSchemaEnabled")) != null) {
            row[0] = this.ar.getString("A1447");
            row[1] = prop;
            bcp.add(row);
        }
        if ((prop = destAttrs.getProperty("XMLSchemaURIList")) != null) {
            row[0] = this.ar.getString("A1448");
            row[1] = prop;
            bcp.add(row);
        }
        bcp.println();
        Globals.stdOutPrintln(this.ar.getString("A1200"));
        this.printBrokerInfo(broker);
        try {
            long byteValue;
            SizeString ss;
            DestinationInfo destInfo = new DestinationInfo();
            destInfo.setType(destTypeMask);
            destInfo.setName(destName);
            prop = destAttrs.getProperty("maxTotalMsgBytes");
            if (prop != null) {
                try {
                    ss = new SizeString(prop);
                    byteValue = ss.getBytes();
                    destInfo.setMaxMessageBytes(byteValue);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((prop = destAttrs.getProperty("maxNumMsgs")) != null) {
                destInfo.setMaxMessages(Integer.parseInt(prop));
            }
            if ((prop = destAttrs.getProperty("maxBytesPerMsg")) != null) {
                try {
                    ss = new SizeString(prop);
                    byteValue = ss.getBytes();
                    destInfo.setMaxMessageSize(byteValue);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((prop = destAttrs.getProperty("maxNumBackupConsumers")) != null) {
                destInfo.setMaxFailoverConsumers(Integer.parseInt(prop));
            }
            if ((prop = destAttrs.getProperty("maxNumActiveConsumers")) != null) {
                destInfo.setMaxActiveConsumers(Integer.parseInt(prop));
            }
            if ((prop = destAttrs.getProperty("isLocalOnly")) != null) {
                destInfo.setScope(Boolean.parseBoolean(prop));
            }
            if ((prop = destAttrs.getProperty("limitBehavior")) != null) {
                destInfo.setLimitBehavior(this.getLimitBehavValue(prop));
            }
            if ((prop = destAttrs.getProperty("localDeliveryPreferred")) != null) {
                destInfo.setClusterDeliveryPolicy(this.getClusterDeliveryPolicy(prop));
            }
            if ((prop = destAttrs.getProperty("consumerFlowLimit")) != null) {
                destInfo.setPrefetch(Integer.parseInt(prop));
            }
            if ((prop = destAttrs.getProperty("maxNumProducers")) != null) {
                destInfo.setMaxProducers(Integer.parseInt(prop));
            }
            if ((prop = destAttrs.getProperty("useDMQ")) != null) {
                destInfo.setUseDMQ(Boolean.parseBoolean(prop));
            }
            if ((prop = destAttrs.getProperty("validateXMLSchemaEnabled")) != null) {
                destInfo.setValidateXMLSchemaEnabled(Boolean.parseBoolean(prop));
            }
            if ((prop = destAttrs.getProperty("XMLSchemaURIList")) != null) {
                destInfo.setXMLSchemaUriList(prop);
            }
            if ((prop = destAttrs.getProperty("reloadXMLSchemaOnFailure")) != null) {
                destInfo.setReloadXMLSchemaOnFailure(Boolean.parseBoolean(prop));
            }
            this.connectToBroker(broker);
            broker.sendCreateDestinationMessage(destInfo);
            broker.receiveCreateDestinationReplyMessage();
            Globals.stdOutPrintln(this.ar.getString("A1232"));
        }
        catch (BrokerAdminException bae) {
            this.handleBrokerAdminException(bae);
            Globals.stdErrPrintln(this.ar.getString("A1233"));
            return 1;
        }
        broker.close();
        return 0;
    }

    private int runDestroy(BrokerCmdProperties brokerCmdProps) {
        String input = null;
        String yes = this.ar.getString("A5016");
        String yesShort = this.ar.getString("A5015");
        String no = this.ar.getString("A5018");
        String noShort = this.ar.getString("A5017");
        String commandArg = brokerCmdProps.getCommandArg();
        boolean force = brokerCmdProps.forceModeSet();
        BrokerAdmin broker = this.init();
        if ("dst".equals(commandArg)) {
            if (broker == null) {
                Globals.stdErrPrintln(this.ar.getString("A1236"));
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            String destName = brokerCmdProps.getTargetName();
            int destTypeMask = this.getDestTypeMask(brokerCmdProps);
            Globals.stdOutPrintln(this.ar.getString("A1234"));
            this.printDestinationInfo();
            Globals.stdOutPrintln(this.ar.getString("A1200"));
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                Globals.stdErrPrintln(this.ar.getString("A1236"));
                return 1;
            }
            if (!force) {
                input = CommonCmdRunnerUtil.getUserInput(this.ar.getString("A5003"), noShort);
                Globals.stdOutPrintln("");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    broker.sendDestroyDestinationMessage(destName, destTypeMask);
                    broker.receiveDestroyDestinationReplyMessage();
                    Globals.stdOutPrintln(this.ar.getString("A1235"));
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    Globals.stdErrPrintln(this.ar.getString("A1236"));
                    return 1;
                }
            }
            if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                Globals.stdOutPrintln(this.ar.getString("A1237"));
                return 0;
            }
            Globals.stdOutPrintln(this.ar.getString("A1026", input));
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(this.ar.getString("A1237"));
            return 1;
        }
        if ("dur".equals(commandArg)) {
            if (broker == null) {
                Globals.stdErrPrintln(this.ar.getString("A1556"));
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            String subName = brokerCmdProps.getTargetName();
            String clientID = brokerCmdProps.getClientID();
            Globals.stdOutPrintln(this.ar.getString("A1554"));
            this.printDurableSubscriptionInfo();
            Globals.stdOutPrintln(this.ar.getString("A1200"));
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                Globals.stdErrPrintln(this.ar.getString("A1556"));
                return 1;
            }
            if (!force) {
                input = CommonCmdRunnerUtil.getUserInput(this.ar.getString("A5014"), noShort);
                Globals.stdOutPrintln("");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    broker.sendDestroyDurableMessage(subName, clientID);
                    broker.receiveDestroyDurableReplyMessage();
                    Globals.stdOutPrintln(this.ar.getString("A1555"));
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    Globals.stdErrPrintln(this.ar.getString("A1556"));
                    return 1;
                }
            }
            if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                Globals.stdOutPrintln(this.ar.getString("A1557"));
                return 0;
            }
            Globals.stdOutPrintln(this.ar.getString("A1026", input));
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(this.ar.getString("A1557"));
            return 1;
        }
        if ("cxn".equals(commandArg)) {
            if (broker == null) {
                Globals.stdErrPrintln(this.ar.getString("A1730"));
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            String cxnIdStr = brokerCmdProps.getTargetName();
            Long cxnId = null;
            try {
                cxnId = Long.valueOf(cxnIdStr);
            }
            catch (NumberFormatException nfe) {
                Globals.stdErrPrintln(this.ar.getString("A3159", cxnIdStr));
                Globals.stdErrPrintln(this.ar.getString("A1730"));
                return 1;
            }
            Globals.stdOutPrintln(this.ar.getString("A1729"));
            this.printConnectionInfo();
            Globals.stdOutPrintln(this.ar.getString("A1200"));
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                Globals.stdErrPrintln(this.ar.getString("A1730"));
                return 1;
            }
            if (!force) {
                input = CommonCmdRunnerUtil.getUserInput(this.ar.getString("A5029"), noShort);
                Globals.stdOutPrintln("");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    broker.sendDestroyConnectionMessage(cxnId);
                    broker.receiveDestroyConnectionReplyMessage();
                    Globals.stdOutPrintln(this.ar.getString("A1731"));
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    Globals.stdErrPrintln(this.ar.getString("A1730"));
                    return 1;
                }
            }
            if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                Globals.stdOutPrintln(this.ar.getString("A1732"));
                return 0;
            }
            Globals.stdOutPrintln(this.ar.getString("A1026", input));
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(this.ar.getString("A1732"));
            return 1;
        }
        if ("msg".equals(commandArg)) {
            if (broker == null) {
                Globals.stdErrPrintln("Destroying message failed.");
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            String destName = brokerCmdProps.getTargetName();
            int destTypeMask = this.getDestTypeMask(brokerCmdProps);
            String msgID = brokerCmdProps.getMsgID();
            Globals.stdOutPrintln("Destroying message:");
            this.printMessageInfo();
            Globals.stdOutPrintln("In the destination");
            this.printDestinationInfo();
            Globals.stdOutPrintln(this.ar.getString("A1200"));
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                Globals.stdErrPrintln("Destroying message failed.");
                return 1;
            }
            if (!force) {
                input = CommonCmdRunnerUtil.getUserInput("Are you sure you want to destroy this message? (y/n)[n] ", noShort);
                Globals.stdOutPrintln("");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    broker.sendDestroyMessagesMessage(destName, destTypeMask, msgID);
                    broker.receiveDestroyMessagesReplyMessage();
                    Globals.stdOutPrintln("Successfully destroyed message.");
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    Globals.stdErrPrintln("Destroying message failed.");
                    return 1;
                }
            } else {
                if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                    Globals.stdOutPrintln("The message was not destroyed.\n");
                    return 0;
                }
                Globals.stdOutPrintln(this.ar.getString("A1026", input));
                Globals.stdOutPrintln("");
                Globals.stdOutPrintln("The message was not destroyed.\n");
                return 1;
            }
        }
        broker.close();
        return 0;
    }

    private int runPurge(BrokerCmdProperties brokerCmdProps) {
        String input = null;
        String yes = this.ar.getString("A5016");
        String yesShort = this.ar.getString("A5015");
        String no = this.ar.getString("A5018");
        String noShort = this.ar.getString("A5017");
        String commandArg = brokerCmdProps.getCommandArg();
        boolean force = brokerCmdProps.forceModeSet();
        BrokerAdmin broker = this.init();
        if ("dst".equals(commandArg)) {
            if (broker == null) {
                Globals.stdErrPrintln(this.ar.getString("A1240"));
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            String destName = brokerCmdProps.getTargetName();
            int destTypeMask = this.getDestTypeMask(brokerCmdProps);
            Globals.stdOutPrintln(this.ar.getString("A1238"));
            this.printDestinationInfo();
            Globals.stdOutPrintln(this.ar.getString("A1200"));
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                Globals.stdErrPrintln(this.ar.getString("A1240"));
                return 1;
            }
            if (!force) {
                input = CommonCmdRunnerUtil.getUserInput(this.ar.getString("A5004"), noShort);
                Globals.stdOutPrintln("");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    broker.sendPurgeDestinationMessage(destName, destTypeMask);
                    broker.receivePurgeDestinationReplyMessage();
                    Globals.stdOutPrintln(this.ar.getString("A1239"));
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    Globals.stdErrPrintln(this.ar.getString("A1240"));
                    return 1;
                }
            }
            if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                Globals.stdOutPrintln(this.ar.getString("A1241"));
                return 0;
            }
            Globals.stdOutPrintln(this.ar.getString("A1026", input));
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(this.ar.getString("A1241"));
            return 1;
        }
        if ("dur".equals(commandArg)) {
            if (broker == null) {
                Globals.stdErrPrintln(this.ar.getString("A1634"));
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            String subName = brokerCmdProps.getTargetName();
            String clientID = brokerCmdProps.getClientID();
            Globals.stdOutPrintln(this.ar.getString("A1635"));
            this.printDurableSubscriptionInfo();
            Globals.stdOutPrintln(this.ar.getString("A1200"));
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                Globals.stdErrPrintln(this.ar.getString("A1634"));
                return 1;
            }
            if (!force) {
                input = CommonCmdRunnerUtil.getUserInput(this.ar.getString("A5020"), noShort);
                Globals.stdOutPrintln("");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    broker.sendPurgeDurableMessage(subName, clientID);
                    broker.receivePurgeDurableReplyMessage();
                    Globals.stdOutPrintln(this.ar.getString("A1636"));
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    Globals.stdErrPrintln(this.ar.getString("A1634"));
                    return 1;
                }
            } else {
                if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                    Globals.stdOutPrintln(this.ar.getString("A1637"));
                    return 0;
                }
                Globals.stdOutPrintln(this.ar.getString("A1026", input));
                Globals.stdOutPrintln("");
                Globals.stdOutPrintln(this.ar.getString("A1637"));
                return 1;
            }
        }
        broker.close();
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    private int runPurgeAll(BrokerCmdProperties brokerCmdProps) {
        input = null;
        ret_code = 0;
        yes = this.ar.getString("A5016");
        yesShort = this.ar.getString("A5015");
        no = this.ar.getString("A5018");
        noShort = this.ar.getString("A5017");
        commandArg = brokerCmdProps.getCommandArg();
        force = brokerCmdProps.forceModeSet();
        broker = this.init();
        if ("dst".equals(commandArg)) {
            if (broker == null) {
                Globals.stdErrPrintln("Purging all the destinations failed");
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            Globals.stdOutPrintln("Purging all the destinations");
            Globals.stdOutPrintln(this.ar.getString("A1200"));
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                Globals.stdErrPrintln("Purging all the destinations failed");
                return 1;
            }
            if (!force) {
                input = CommonCmdRunnerUtil.getUserInput("Are you sure you want to purge all the destinations? (y/n)[n] ", noShort);
                Globals.stdOutPrintln("");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    dstsPurged = false;
                    broker.sendGetDestinationsMessage(null, -1);
                    dests = broker.receiveGetDestinationsReplyMessage();
                    if (dests != null) {
                        thisEnum = dests.elements();
                        while (thisEnum.hasMoreElements()) {
                            dInfo = (DestinationInfo)thisEnum.nextElement();
                            destName = dInfo.name;
                            destTypeMask = dInfo.type;
                            if ("__JMQAdmin".equals(destName) || "__JMQBridgeAdmin".equals(destName) || DestType.isInternal(dInfo.fulltype) || DestType.isTemporary(dInfo.type)) {
                                Globals.stdOutPrintln("Skipping destination: " + destName);
                                continue;
                            }
                            try {
                                broker.sendPurgeDestinationMessage(destName, destTypeMask);
                                broker.receivePurgeDestinationReplyMessage();
                                if (DestType.isQueue(destTypeMask)) {
                                    Globals.stdOutPrintln("Successfully purged queue " + destName);
                                } else {
                                    Globals.stdOutPrintln("Successfully purged topic " + destName);
                                }
                                dstsPurged = true;
                            }
                            catch (BrokerAdminException purgeEx) {
                                this.handleBrokerAdminException(purgeEx);
                                if (DestType.isQueue(destTypeMask)) {
                                    Globals.stdOutPrintln("Purging failed for queue " + destName);
                                } else {
                                    Globals.stdOutPrintln("Purging failed for topic " + destName);
                                }
                                ret_code = 1;
                            }
                        }
                    }
                    if (dstsPurged) ** GOTO lbl79
                    Globals.stdOutPrintln("No destinations purged.");
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    Globals.stdErrPrintln("Purging all the destinations failed");
                    return 1;
                }
            } else {
                if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                    Globals.stdOutPrintln("The destinations were not purged.");
                    return 0;
                }
                Globals.stdOutPrintln(this.ar.getString("A1026", input));
                Globals.stdOutPrintln("");
                Globals.stdOutPrintln("The destinations were not purged.");
                return 1;
            }
        }
lbl79:
        // 4 sources

        broker.close();
        return ret_code;
    }

    /*
     * Unable to fully structure code
     */
    private int runDestroyAll(BrokerCmdProperties brokerCmdProps) {
        input = null;
        ret_code = 0;
        yes = this.ar.getString("A5016");
        yesShort = this.ar.getString("A5015");
        no = this.ar.getString("A5018");
        noShort = this.ar.getString("A5017");
        commandArg = brokerCmdProps.getCommandArg();
        force = brokerCmdProps.forceModeSet();
        broker = this.init();
        if ("dst".equals(commandArg)) {
            if (broker == null) {
                Globals.stdErrPrintln("Destroying all the destinations failed");
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            Globals.stdOutPrintln("Destroying all the destinations");
            Globals.stdOutPrintln(this.ar.getString("A1200"));
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                Globals.stdErrPrintln("Destroying all the destinations failed");
                return 1;
            }
            if (!force) {
                input = CommonCmdRunnerUtil.getUserInput("Are you sure you want to destroy all the destinations? (y/n)[n] ", noShort);
                Globals.stdOutPrintln("");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    dstsDestroyed = false;
                    broker.sendGetDestinationsMessage(null, -1);
                    dests = broker.receiveGetDestinationsReplyMessage();
                    if (dests != null) {
                        thisEnum = dests.elements();
                        while (thisEnum.hasMoreElements()) {
                            dInfo = (DestinationInfo)thisEnum.nextElement();
                            destName = dInfo.name;
                            destTypeMask = dInfo.type;
                            if ("__JMQAdmin".equals(destName) || "__JMQBridgeAdmin".equals(destName) || DestType.isInternal(dInfo.fulltype) || DestType.isTemporary(dInfo.type) || DestType.isDMQ(dInfo.type)) {
                                Globals.stdOutPrintln("Skipping destination: " + destName);
                                continue;
                            }
                            try {
                                broker.sendDestroyDestinationMessage(destName, destTypeMask);
                                broker.receiveDestroyDestinationReplyMessage();
                                if (DestType.isQueue(destTypeMask)) {
                                    Globals.stdOutPrintln("Successfully destroyed queue " + destName);
                                } else {
                                    Globals.stdOutPrintln("Successfully destroyed topic " + destName);
                                }
                                dstsDestroyed = true;
                            }
                            catch (BrokerAdminException destroyEx) {
                                this.handleBrokerAdminException(destroyEx);
                                if (DestType.isQueue(destTypeMask)) {
                                    Globals.stdOutPrintln("Destroy failed for queue " + destName);
                                } else {
                                    Globals.stdOutPrintln("Destroy failed for topic " + destName);
                                }
                                ret_code = 1;
                            }
                        }
                    }
                    if (dstsDestroyed) ** GOTO lbl79
                    Globals.stdOutPrintln("No destinations destroyed.");
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    Globals.stdErrPrintln("Destroying all the destinations failed");
                    return 1;
                }
            } else {
                if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                    Globals.stdOutPrintln("The destinations were not destroyed.");
                    return 0;
                }
                Globals.stdOutPrintln(this.ar.getString("A1026", input));
                Globals.stdOutPrintln("");
                Globals.stdOutPrintln("The destinations were not destroyed.");
                return 1;
            }
        }
lbl79:
        // 4 sources

        broker.close();
        return ret_code;
    }

    private int runUpdate(BrokerCmdProperties brokerCmdProps) {
        String input = null;
        String yes = this.ar.getString("A5016");
        String yesShort = this.ar.getString("A5015");
        String no = this.ar.getString("A5018");
        String noShort = this.ar.getString("A5017");
        BrokerAdmin broker = this.init();
        String commandArg = brokerCmdProps.getCommandArg();
        boolean force = brokerCmdProps.forceModeSet();
        if ("bkr".equals(commandArg)) {
            if (broker == null) {
                Globals.stdErrPrintln(this.ar.getString("A1538"));
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            Properties targetAttrs = brokerCmdProps.getTargetAttrs();
            Globals.stdOutPrintln(this.ar.getString("A1539"));
            Globals.stdOutPrintln("");
            this.printAttrs(targetAttrs);
            Globals.stdOutPrintln(this.ar.getString("A1200"));
            this.printBrokerInfo(broker);
            if (!force) {
                input = CommonCmdRunnerUtil.getUserInput(this.ar.getString("A5011"), noShort);
                Globals.stdOutPrintln("");
                if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                    Globals.stdOutPrintln(this.ar.getString("A1540"));
                    return 0;
                }
                if (!yesShort.equalsIgnoreCase(input) && !yes.equalsIgnoreCase(input)) {
                    Globals.stdOutPrintln(this.ar.getString("A1026", input));
                    Globals.stdOutPrintln("");
                    Globals.stdOutPrintln(this.ar.getString("A1540"));
                    return 1;
                }
            }
            try {
                this.connectToBroker(broker);
                broker.sendUpdateBrokerPropsMessage(targetAttrs);
                broker.receiveUpdateBrokerPropsReplyMessage();
                Globals.stdOutPrintln(this.ar.getString("A1541"));
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                Globals.stdErrPrintln(this.ar.getString("A1538"));
                return 1;
            }
        }
        if ("svc".equals(commandArg)) {
            if (broker == null) {
                Globals.stdErrPrintln(this.ar.getString("A1542"));
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            Properties targetAttrs = brokerCmdProps.getTargetAttrs();
            String svcName = brokerCmdProps.getTargetName();
            Globals.stdOutPrintln(this.ar.getString("A1543", svcName));
            Globals.stdOutPrintln("");
            this.printAttrs(targetAttrs);
            Globals.stdOutPrintln(this.ar.getString("A1200"));
            this.printBrokerInfo(broker);
            ServiceInfo si = this.getServiceInfoFromAttrs(targetAttrs);
            si.setName(svcName);
            int svcPort = -1;
            Vector svc = null;
            try {
                this.connectToBroker(broker);
                broker.sendGetServicesMessage(svcName);
                svc = broker.receiveGetServicesReplyMessage();
                if (svc != null && svc.size() == 1) {
                    Enumeration thisEnum = svc.elements();
                    ServiceInfo sInfo = (ServiceInfo)thisEnum.nextElement();
                    svcPort = sInfo.port;
                }
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                Globals.stdErrPrintln(this.ar.getString("A1542"));
                return 1;
            }
            if (!force) {
                input = CommonCmdRunnerUtil.getUserInput(this.ar.getString("A5012"), noShort);
                Globals.stdOutPrintln("");
                if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                    Globals.stdOutPrintln(this.ar.getString("A1544"));
                    return 0;
                }
                if (!yesShort.equalsIgnoreCase(input) && !yes.equalsIgnoreCase(input)) {
                    Globals.stdOutPrintln(this.ar.getString("A1026", input));
                    Globals.stdOutPrintln("");
                    Globals.stdOutPrintln(this.ar.getString("A1544"));
                    return 1;
                }
            }
            if (si.isModified(1) && svcPort == -1) {
                Globals.stdErrPrintln(this.ar.getString("A3149", svcName));
                Globals.stdErrPrintln(this.ar.getString("A1542"));
                return 1;
            }
            try {
                broker.sendUpdateServiceMessage(si);
                broker.receiveUpdateServiceReplyMessage();
                Globals.stdOutPrintln(this.ar.getString("A1545"));
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                Globals.stdErrPrintln(this.ar.getString("A1542"));
                return 1;
            }
        }
        if ("dst".equals(commandArg)) {
            if (broker == null) {
                Globals.stdErrPrintln(this.ar.getString("A1546"));
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            Properties targetAttrs = brokerCmdProps.getTargetAttrs();
            int destTypeMask = this.getDestTypeMask(brokerCmdProps);
            String destName = brokerCmdProps.getTargetName();
            if (DestType.isQueue(destTypeMask)) {
                Globals.stdOutPrintln(this.ar.getString("A1547", destName));
            } else {
                Globals.stdOutPrintln(this.ar.getString("A1548", destName));
            }
            Globals.stdOutPrintln("");
            this.printAttrs(targetAttrs);
            Globals.stdOutPrintln(this.ar.getString("A1200"));
            this.printBrokerInfo(broker);
            if (!force) {
                if (this.updatingDestXMLSchema(targetAttrs)) {
                    Object[] args = new Object[]{"validateXMLSchemaEnabled", "XMLSchemaURIList", "reloadXMLSchemaOnFailure"};
                    input = CommonCmdRunnerUtil.getUserInput(this.ar.getString("A5034", args), noShort);
                } else {
                    input = CommonCmdRunnerUtil.getUserInput(this.ar.getString("A5013"), noShort);
                }
                Globals.stdOutPrintln("");
                if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                    Globals.stdOutPrintln(this.ar.getString("A1549"));
                    return 0;
                }
                if (!yesShort.equalsIgnoreCase(input) && !yes.equalsIgnoreCase(input)) {
                    Globals.stdOutPrintln(this.ar.getString("A1026", input));
                    Globals.stdOutPrintln("");
                    Globals.stdOutPrintln(this.ar.getString("A1549"));
                    return 1;
                }
            }
            try {
                DestinationInfo di = this.getDestinationInfoFromAttrs(targetAttrs);
                di.setType(destTypeMask);
                di.setName(destName);
                this.connectToBroker(broker);
                broker.sendUpdateDestinationMessage(di);
                broker.receiveUpdateDestinationReplyMessage();
                Globals.stdOutPrintln(this.ar.getString("A1550"));
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                Globals.stdErrPrintln(this.ar.getString("A1546"));
                return 1;
            }
        }
        broker.close();
        return 0;
    }

    private void printAttrs(Properties targetAttrs) {
        this.printAttrs(targetAttrs, false);
    }

    private void printAttrs(Properties targetAttrs, boolean printTitle) {
        CommonCmdRunnerUtil.printAttrs(targetAttrs, printTitle, new BrokerCmdPrinter());
    }

    private ServiceInfo getServiceInfoFromAttrs(Properties svcAttrs) {
        ServiceInfo si = new ServiceInfo();
        Enumeration<?> e = svcAttrs.propertyNames();
        while (e.hasMoreElements()) {
            String propName = (String)e.nextElement();
            String value = svcAttrs.getProperty(propName);
            int intValue = 0;
            boolean valueOK = true;
            if (propName.equals("port")) {
                try {
                    intValue = Integer.parseInt(value);
                }
                catch (NumberFormatException nfe) {
                    valueOK = false;
                }
                if (!valueOK) continue;
                si.setPort(intValue);
                continue;
            }
            if (propName.equals("minThreads")) {
                try {
                    intValue = Integer.parseInt(value);
                }
                catch (NumberFormatException nfe) {
                    valueOK = false;
                }
                if (!valueOK) continue;
                si.setMinThreads(intValue);
                continue;
            }
            if (!propName.equals("maxThreads")) continue;
            try {
                intValue = Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                valueOK = false;
            }
            if (!valueOK) continue;
            si.setMaxThreads(intValue);
        }
        return si;
    }

    private boolean updatingDestXMLSchema(Properties dstAttrs) {
        if (dstAttrs == null) {
            return false;
        }
        String value = dstAttrs.getProperty("validateXMLSchemaEnabled");
        if (value != null && !value.equals("")) {
            return true;
        }
        value = dstAttrs.getProperty("XMLSchemaURIList");
        if (value != null && !value.equals("")) {
            return true;
        }
        value = dstAttrs.getProperty("reloadXMLSchemaOnFailure");
        return value != null && !value.equals("");
    }

    private DestinationInfo getDestinationInfoFromAttrs(Properties destAttrs) {
        DestinationInfo di = new DestinationInfo();
        Enumeration<?> e = destAttrs.propertyNames();
        while (e.hasMoreElements()) {
            SizeString ss;
            String propName = (String)e.nextElement();
            String value = destAttrs.getProperty(propName);
            int intValue = 0;
            long longValue = 0L;
            boolean valueOK = true;
            if (propName.equals("maxTotalMsgBytes")) {
                try {
                    ss = new SizeString(value);
                    longValue = ss.getBytes();
                }
                catch (NumberFormatException nfe) {
                    valueOK = false;
                }
                if (!valueOK) continue;
                di.setMaxMessageBytes(longValue);
                continue;
            }
            if (propName.equals("maxNumMsgs")) {
                try {
                    intValue = Integer.parseInt(value);
                }
                catch (NumberFormatException nfe) {
                    valueOK = false;
                }
                if (!valueOK) continue;
                di.setMaxMessages(intValue);
                continue;
            }
            if (propName.equals("maxBytesPerMsg")) {
                try {
                    ss = new SizeString(value);
                    longValue = ss.getBytes();
                }
                catch (NumberFormatException nfe) {
                    valueOK = false;
                }
                if (!valueOK) continue;
                di.setMaxMessageSize(longValue);
                continue;
            }
            if (propName.equals("maxNumBackupConsumers")) {
                try {
                    di.setMaxFailoverConsumers(Integer.parseInt(value));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (propName.equals("maxNumActiveConsumers")) {
                try {
                    di.setMaxActiveConsumers(Integer.parseInt(value));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (propName.equals("isLocalOnly")) {
                di.setScope(Boolean.parseBoolean(value));
            }
            if (propName.equals("limitBehavior")) {
                di.setLimitBehavior(this.getLimitBehavValue(value));
            }
            if (propName.equals("localDeliveryPreferred")) {
                di.setClusterDeliveryPolicy(this.getClusterDeliveryPolicy(value));
            }
            if (propName.equals("consumerFlowLimit")) {
                try {
                    di.setPrefetch(Integer.parseInt(value));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (propName.equals("maxNumProducers")) {
                try {
                    di.setMaxProducers(Integer.parseInt(value));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (propName.equals("useDMQ")) {
                di.setUseDMQ(Boolean.parseBoolean(value));
            }
            if (propName.equals("validateXMLSchemaEnabled")) {
                di.setValidateXMLSchemaEnabled(Boolean.parseBoolean(value));
            }
            if (propName.equals("XMLSchemaURIList")) {
                di.setXMLSchemaUriList(value);
            }
            if (!propName.equals("reloadXMLSchemaOnFailure")) continue;
            di.setReloadXMLSchemaOnFailure(Boolean.parseBoolean(value));
        }
        return di;
    }

    private int runQuery(BrokerCmdProperties brokerCmdProps) {
        BrokerAdmin broker = this.init();
        String commandArg = brokerCmdProps.getCommandArg();
        if ("dst".equals(commandArg)) {
            if (broker == null) {
                Globals.stdErrPrintln(this.ar.getString("A1245"));
                return 1;
            }
            boolean force = brokerCmdProps.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            String destName = brokerCmdProps.getTargetName();
            int destTypeMask = this.getDestTypeMask(brokerCmdProps);
            Globals.stdOutPrintln(this.ar.getString("A1242"));
            this.printDestinationInfo();
            Globals.stdOutPrintln(this.ar.getString("A1200"));
            this.printBrokerInfo(broker);
            try {
                Object[] row;
                BrokerCmdPrinter bcp;
                DestinationInfo dInfo;
                this.connectToBroker(broker);
                broker.sendGetDestinationsMessage(destName, destTypeMask);
                Vector dest = broker.receiveGetDestinationsReplyMessage();
                if (dest != null && dest.size() == 1) {
                    Enumeration thisEnum = dest.elements();
                    dInfo = (DestinationInfo)thisEnum.nextElement();
                    bcp = new BrokerCmdPrinter(2, 4);
                    row = new String[2];
                    bcp.setSortNeeded(false);
                    row[0] = this.ar.getString("A1400");
                    row[1] = dInfo.name;
                    bcp.add(row);
                    row[0] = this.ar.getString("A1401");
                    row[1] = BrokerAdminUtil.getDestinationType(dInfo.type);
                    if (DestType.isTemporary(dInfo.type)) {
                        row[1] = (String)row[1] + " (" + this.ar.getString("A1631") + ")";
                    }
                    bcp.add(row);
                    row[0] = this.ar.getString("A1429");
                    row[1] = BrokerAdminUtil.getDestinationState(dInfo.destState);
                    bcp.add(row);
                    row[0] = this.ar.getString("A1427");
                    row[1] = dInfo.autocreated ? Boolean.FALSE.toString() : Boolean.TRUE.toString();
                    bcp.add(row);
                    row[0] = "";
                    row[1] = "";
                    bcp.add(row);
                    row[0] = this.ar.getString("A1404");
                    row[1] = "";
                    bcp.add(row);
                    String indent = "    ";
                    row[0] = indent + this.ar.getString("A1735");
                    row[1] = Integer.toString(dInfo.nMessages - dInfo.nTxnMessages);
                    bcp.add(row);
                    row[0] = indent + this.ar.getString("A1738");
                    row[1] = Integer.toString(dInfo.nRemoteMessages);
                    bcp.add(row);
                    row[0] = indent + this.ar.getString("A1739");
                    row[1] = Integer.toString(dInfo.nInDelayMessages);
                    bcp.add(row);
                    row[0] = indent + this.ar.getString("A1734");
                    row[1] = Integer.toString(dInfo.nTxnMessages);
                    bcp.add(row);
                    row[0] = this.ar.getString("A1405");
                    row[1] = "";
                    bcp.add(row);
                    row[0] = indent + this.ar.getString("A1735");
                    row[1] = Long.toString(dInfo.nMessageBytes - dInfo.nTxnMessageBytes);
                    bcp.add(row);
                    row[0] = indent + this.ar.getString("A1738");
                    row[1] = Long.toString(dInfo.nRemoteMessageBytes);
                    bcp.add(row);
                    row[0] = indent + this.ar.getString("A1739");
                    row[1] = Long.toString(dInfo.nInDelayMessageBytes);
                    bcp.add(row);
                    row[0] = indent + this.ar.getString("A1734");
                    row[1] = Long.toString(dInfo.nTxnMessageBytes);
                    bcp.add(row);
                    row[0] = this.ar.getString("A1428");
                    row[1] = Integer.toString(dInfo.nProducers);
                    bcp.add(row);
                    if (DestType.isQueue(destTypeMask)) {
                        row[0] = this.ar.getString("A1416");
                        row[1] = Integer.toString(dInfo.naConsumers);
                        bcp.add(row);
                        row[0] = this.ar.getString("A1417");
                        row[1] = Integer.toString(dInfo.nfConsumers);
                        bcp.add(row);
                    } else {
                        Integer val;
                        String wildcard;
                        Enumeration keys;
                        Hashtable h = dInfo.producerWildcards;
                        row[0] = this.ar.getString("A1692");
                        row[1] = Integer.toString(this.getWildcardCount(h));
                        bcp.add(row);
                        if (h != null) {
                            keys = h.keys();
                            while (keys.hasMoreElements()) {
                                wildcard = (String)keys.nextElement();
                                val = (Integer)h.get(wildcard);
                                row[0] = indent + wildcard + "  (" + val + ")";
                                row[1] = "";
                                bcp.add(row);
                            }
                        }
                        row[0] = this.ar.getString("A1688");
                        row[1] = Integer.toString(dInfo.nConsumers);
                        bcp.add(row);
                        h = dInfo.consumerWildcards;
                        row[0] = this.ar.getString("A1693");
                        row[1] = Integer.toString(this.getWildcardCount(h));
                        bcp.add(row);
                        if (h != null) {
                            keys = h.keys();
                            while (keys.hasMoreElements()) {
                                wildcard = (String)keys.nextElement();
                                val = (Integer)h.get(wildcard);
                                row[0] = indent + wildcard + "  (" + val + ")";
                                row[1] = "";
                                bcp.add(row);
                            }
                        }
                    }
                    row[0] = "";
                    row[1] = "";
                    bcp.add(row);
                    row[0] = this.ar.getString("A1407");
                    row[1] = this.checkAndPrintUnlimitedInt(dInfo.maxMessages, this.zeroNegOneInt);
                    bcp.add(row);
                    row[0] = this.ar.getString("A1406");
                    row[1] = this.checkAndPrintUnlimitedLong(dInfo.maxMessageBytes, this.zeroNegOneLong);
                    bcp.add(row);
                    row[0] = this.ar.getString("A1408");
                    row[1] = String.valueOf(dInfo.maxMessageSize);
                    row[1] = this.checkAndPrintUnlimitedLong(dInfo.maxMessageSize, this.zeroNegOneLong);
                    bcp.add(row);
                    row[0] = this.ar.getString("A1415");
                    row[1] = this.checkAndPrintUnlimitedInt(dInfo.maxProducers, -1);
                    bcp.add(row);
                    if (DestType.isQueue(destTypeMask)) {
                        row[0] = this.ar.getString("A1410");
                        row[1] = this.checkAndPrintUnlimitedInt(dInfo.maxActiveConsumers, -1);
                        bcp.add(row);
                        row[0] = this.ar.getString("A1409");
                        row[1] = this.checkAndPrintUnlimitedInt(dInfo.maxFailoverConsumers, -1);
                        bcp.add(row);
                    }
                    row[0] = "";
                    row[1] = "";
                    bcp.add(row);
                    row[0] = this.ar.getString("A1412");
                    row[1] = DestLimitBehavior.getString(dInfo.destLimitBehavior);
                    bcp.add(row);
                    row[0] = this.ar.getString("A1414");
                    row[1] = this.checkAndPrintUnlimitedInt(dInfo.maxPrefetch, -1);
                    bcp.add(row);
                    row[0] = this.ar.getString("A1411");
                    row[1] = dInfo.isDestinationLocal() ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
                    bcp.add(row);
                    if (DestType.isQueue(destTypeMask)) {
                        row[0] = this.ar.getString("A1413");
                        row[1] = dInfo.destCDP == 1 ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
                        bcp.add(row);
                    }
                } else {
                    Globals.stdErrPrintln(this.ar.getString("A1335"));
                    Globals.stdErrPrintln(this.ar.getString("A1245"));
                    return 1;
                }
                row[0] = this.ar.getString("A1446");
                row[1] = dInfo.useDMQ() ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
                bcp.add(row);
                row[0] = this.ar.getString("A1447");
                row[1] = dInfo.validateXMLSchemaEnabled() ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
                bcp.add(row);
                row[0] = this.ar.getString("A1448");
                row[1] = dInfo.XMLSchemaUriList;
                bcp.add(row);
                row[0] = this.ar.getString("A1449");
                row[1] = dInfo.reloadXMLSchemaOnFailure() ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
                bcp.add(row);
                bcp.println();
                Globals.stdOutPrintln(this.ar.getString("A1243"));
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                Globals.stdErrPrintln(this.ar.getString("A1245"));
                return 1;
            }
        }
        if ("svc".equals(commandArg)) {
            if (broker == null) {
                Globals.stdErrPrintln(this.ar.getString("A1249"));
                return 1;
            }
            boolean force = brokerCmdProps.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            String svcName = brokerCmdProps.getTargetName();
            Globals.stdOutPrintln(this.ar.getString("A1246"));
            this.printServiceInfo();
            Globals.stdOutPrintln(this.ar.getString("A1200"));
            this.printBrokerInfo(broker);
            try {
                Object[] row;
                BrokerCmdPrinter bcp;
                ServiceInfo sInfo;
                this.connectToBroker(broker);
                broker.sendGetServicesMessage(svcName);
                Vector svc = broker.receiveGetServicesReplyMessage();
                if (svc != null && svc.size() == 1) {
                    Enumeration thisEnum = svc.elements();
                    sInfo = (ServiceInfo)thisEnum.nextElement();
                    bcp = new BrokerCmdPrinter(2, 4);
                    row = new String[2];
                    bcp.setSortNeeded(false);
                    row[0] = this.ar.getString("A1420");
                    row[1] = sInfo.name;
                    bcp.add(row);
                    row[0] = this.ar.getString("A1422");
                    row[1] = BrokerAdminUtil.getServiceState(sInfo.state);
                    bcp.add(row);
                    if (sInfo.port != -1) {
                        row[0] = this.ar.getString("A1421");
                        if (sInfo.dynamicPort) {
                            switch (sInfo.state) {
                                case -1: {
                                    row[1] = this.ar.getString("A1520");
                                    break;
                                }
                                default: {
                                    row[1] = Integer.toString(sInfo.port) + " (" + this.ar.getString("A1520") + ")";
                                    break;
                                }
                            }
                        } else {
                            row[1] = Integer.toString(sInfo.port) + " (" + this.ar.getString("A1521") + ")";
                        }
                        bcp.add(row);
                    }
                } else {
                    Globals.stdErrPrintln(this.ar.getString("A1335"));
                    Globals.stdErrPrintln(this.ar.getString("A1249"));
                    return 1;
                }
                row[0] = "";
                row[1] = "";
                bcp.add(row);
                row[0] = this.ar.getString("A1425");
                row[1] = Integer.toString(sInfo.currentThreads);
                bcp.add(row);
                row[0] = this.ar.getString("A1426");
                row[1] = Integer.toString(sInfo.nConnections);
                bcp.add(row);
                row[0] = "";
                row[1] = "";
                bcp.add(row);
                row[0] = this.ar.getString("A1423");
                row[1] = Integer.toString(sInfo.minThreads);
                bcp.add(row);
                row[0] = this.ar.getString("A1424");
                row[1] = Integer.toString(sInfo.maxThreads);
                bcp.add(row);
                bcp.println();
                Globals.stdOutPrintln(this.ar.getString("A1247"));
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                Globals.stdErrPrintln(this.ar.getString("A1249"));
                return 1;
            }
        }
        if ("bkr".equals(commandArg)) {
            if (broker == null) {
                Globals.stdErrPrintln(this.ar.getString("A1523"));
                return 1;
            }
            boolean force = brokerCmdProps.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            Globals.stdOutPrintln(this.ar.getString("A1522"));
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
                broker.sendGetBrokerPropsMessage();
                Properties bkrProps = broker.receiveGetBrokerPropsReplyMessage();
                if (bkrProps == null) {
                    Globals.stdErrPrintln(this.ar.getString("A1523"));
                    return 1;
                }
                if (brokerCmdProps.adminDebugModeSet()) {
                    this.printAllBrokerAttrs(bkrProps);
                } else {
                    this.printDisplayableBrokerAttrs(bkrProps);
                }
                Globals.stdOutPrintln(this.ar.getString("A1524"));
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                Globals.stdErrPrintln(this.ar.getString("A1523"));
                return 1;
            }
        }
        if ("txn".equals(commandArg)) {
            if (broker == null) {
                Globals.stdErrPrintln(this.ar.getString("A1256"));
                return 1;
            }
            boolean force = brokerCmdProps.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            String tidStr = brokerCmdProps.getTargetName();
            Long tid = null;
            try {
                tid = Long.valueOf(tidStr);
            }
            catch (NumberFormatException nfe) {
                Globals.stdErrPrintln(this.ar.getString("A3150", tidStr));
                Globals.stdErrPrintln(this.ar.getString("A1256"));
                return 1;
            }
            Globals.stdOutPrintln(this.ar.getString("A1254"));
            this.printTransactionInfo();
            Globals.stdOutPrintln(this.ar.getString("A1200"));
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
                broker.sendGetTxnsMessage(tid, brokerCmdProps.showPartitionModeSet());
                Vector txns = broker.receiveGetTxnsReplyMessage();
                if (txns != null && txns.size() == 1) {
                    Enumeration thisEnum = txns.elements();
                    Hashtable txnInfo = (Hashtable)thisEnum.nextElement();
                    if (brokerCmdProps.debugModeSet()) {
                        this.printAllTxnAttrs(txnInfo);
                    } else {
                        this.printDisplayableTxnAttrs(txnInfo);
                    }
                } else {
                    Globals.stdErrPrintln(this.ar.getString("A1335"));
                    Globals.stdErrPrintln(this.ar.getString("A1256"));
                    return 1;
                }
                Globals.stdOutPrintln(this.ar.getString("A1255"));
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                Globals.stdErrPrintln(this.ar.getString("A1256"));
                return 1;
            }
        }
        if ("cxn".equals(commandArg)) {
            if (broker == null) {
                Globals.stdErrPrintln(this.ar.getString("A1334"));
                return 1;
            }
            boolean force = brokerCmdProps.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            String cxnIdStr = brokerCmdProps.getTargetName();
            Long cxnId = null;
            try {
                cxnId = Long.valueOf(cxnIdStr);
            }
            catch (NumberFormatException nfe) {
                Globals.stdErrPrintln(this.ar.getString("A3159", cxnIdStr));
                Globals.stdErrPrintln(this.ar.getString("A1334"));
                return 1;
            }
            Globals.stdOutPrintln(this.ar.getString("A1332"));
            this.printConnectionInfo();
            Globals.stdOutPrintln(this.ar.getString("A1200"));
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
                broker.sendGetConnectionsMessage(null, cxnId);
                Vector cxnList = broker.receiveGetConnectionsReplyMessage();
                if (cxnList != null && cxnList.size() == 1) {
                    Enumeration thisEnum = cxnList.elements();
                    Hashtable cxnInfo = (Hashtable)thisEnum.nextElement();
                    if (brokerCmdProps.debugModeSet()) {
                        this.printAllCxnAttrs(cxnInfo);
                    } else {
                        this.printDisplayableCxnAttrs(cxnInfo);
                    }
                } else {
                    Globals.stdErrPrintln(this.ar.getString("A1335"));
                    Globals.stdErrPrintln(this.ar.getString("A1334"));
                    return 1;
                }
                Globals.stdOutPrintln(this.ar.getString("A1333"));
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                Globals.stdErrPrintln(this.ar.getString("A1334"));
                return 1;
            }
        }
        if ("msg".equals(commandArg)) {
            if (broker == null) {
                Globals.stdErrPrintln("Querying message failed.");
                return 1;
            }
            boolean force = brokerCmdProps.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            String destName = brokerCmdProps.getTargetName();
            int destTypeMask = this.getDestTypeMask(brokerCmdProps);
            String msgID = brokerCmdProps.getMsgID();
            Globals.stdOutPrintln("Querying message:");
            this.printMessageInfo();
            Globals.stdOutPrintln("In the destination");
            this.printDestinationInfo();
            Globals.stdOutPrintln(this.ar.getString("A1200"));
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
                broker.sendGetMessagesMessage(destName, destTypeMask, true, msgID, null, null);
                Vector msgList = broker.receiveGetMessagesReplyMessage();
                if (msgList != null && msgList.size() == 1) {
                    HashMap oneMsg = (HashMap)msgList.get(0);
                    this.printDisplayableMsgAttrs(oneMsg);
                    Globals.stdOutPrintln("Successfully queried message.");
                } else {
                    Globals.stdErrPrintln("There are no messages.");
                    Globals.stdOutPrintln("");
                    Globals.stdOutPrintln("Successfully queried message.");
                }
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                Globals.stdErrPrintln("Querying message failed.");
                return 1;
            }
        }
        if (broker.isConnected()) {
            broker.close();
        }
        return 0;
    }

    private int runMetrics(BrokerCmdProperties brokerCmdProps) {
        BrokerAdmin broker = this.init();
        String commandArg = brokerCmdProps.getCommandArg();
        long sleepTime = brokerCmdProps.getMetricInterval();
        int metricType = this.getMetricType(brokerCmdProps);
        int metricSamples = brokerCmdProps.getMetricSamples();
        if ("svc".equals(commandArg)) {
            BrokerCmdPrinter bcp = this.setupMetricTitle(commandArg, metricType);
            if (broker == null) {
                Globals.stdErrPrintln(this.ar.getString("A1559"));
                return 1;
            }
            boolean force = brokerCmdProps.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            String svcName = brokerCmdProps.getTargetName();
            Globals.stdOutPrintln(this.ar.getString("A1560"));
            this.printServiceInfo();
            Globals.stdOutPrintln(this.ar.getString("A1200"));
            this.printBrokerInfo(broker);
            try {
                MetricCounters previousMetrics = null;
                int rowsPrinted = 0;
                this.connectToBroker(broker);
                while (true) {
                    broker.sendGetMetricsMessage(svcName);
                    MetricCounters mc = (MetricCounters)broker.receiveGetMetricsReplyMessage();
                    if (mc == null) {
                        Globals.stdErrPrintln(this.ar.getString("A1559"));
                        return 1;
                    }
                    this.addOneMetricRow(metricType, bcp, mc, previousMetrics);
                    if (rowsPrinted % 20 == 0) {
                        bcp.print();
                    } else {
                        bcp.print(false);
                    }
                    bcp.clear();
                    previousMetrics = mc;
                    if (metricSamples > 0 && metricSamples == ++rowsPrinted) break;
                    try {
                        Thread.sleep(sleepTime * 1000L);
                    }
                    catch (InterruptedException ie) {
                        Globals.stdErrPrintln(ie.toString());
                    }
                }
                Globals.stdOutPrintln("");
                Globals.stdOutPrintln(this.ar.getString("A1298"));
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                Globals.stdErrPrintln(this.ar.getString("A1559"));
                return 1;
            }
        }
        if ("bkr".equals(commandArg)) {
            if (broker == null) {
                Globals.stdErrPrintln(this.ar.getString("A1561"));
                return 1;
            }
            BrokerCmdPrinter bcp = this.setupMetricTitle(commandArg, metricType);
            boolean force = brokerCmdProps.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            Globals.stdOutPrintln(this.ar.getString("A1562"));
            this.printBrokerInfo(broker);
            try {
                MetricCounters previousMetrics = null;
                int rowsPrinted = 0;
                this.connectToBroker(broker);
                while (true) {
                    broker.sendGetMetricsMessage(null);
                    MetricCounters mc = (MetricCounters)broker.receiveGetMetricsReplyMessage();
                    if (mc == null) {
                        Globals.stdErrPrintln(this.ar.getString("A1561"));
                        return 1;
                    }
                    this.addOneMetricRow(metricType, bcp, mc, previousMetrics);
                    if (rowsPrinted % 20 == 0) {
                        bcp.print();
                    } else {
                        bcp.print(false);
                    }
                    bcp.clear();
                    previousMetrics = mc;
                    if (metricSamples > 0 && metricSamples == ++rowsPrinted) break;
                    try {
                        Thread.sleep(sleepTime * 1000L);
                    }
                    catch (InterruptedException ie) {
                        Globals.stdErrPrintln(ie.toString());
                    }
                }
                Globals.stdOutPrintln("");
                Globals.stdOutPrintln(this.ar.getString("A1299"));
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                Globals.stdErrPrintln(this.ar.getString("A1561"));
                return 1;
            }
        }
        if ("dst".equals(commandArg)) {
            String destName = brokerCmdProps.getTargetName();
            int destTypeMask = this.getDestTypeMask(brokerCmdProps);
            BrokerCmdPrinter bcp = this.setupDestMetricTitle(commandArg, metricType, destTypeMask);
            if (broker == null) {
                Globals.stdErrPrintln(this.ar.getString("A1296"));
                return 1;
            }
            boolean force = brokerCmdProps.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            Globals.stdOutPrintln(this.ar.getString("A1297"));
            this.printDestinationInfo();
            Globals.stdOutPrintln(this.ar.getString("A1200"));
            this.printBrokerInfo(broker);
            try {
                DestMetricsCounters previousMetrics = null;
                int rowsPrinted = 0;
                this.connectToBroker(broker);
                while (true) {
                    broker.sendGetMetricsMessage(destName, destTypeMask);
                    DestMetricsCounters mc = (DestMetricsCounters)broker.receiveGetMetricsReplyMessage();
                    if (mc == null) {
                        Globals.stdErrPrintln(this.ar.getString("A1296"));
                        return 1;
                    }
                    this.addOneDestMetricRow(metricType, destTypeMask, bcp, mc, previousMetrics);
                    if (rowsPrinted % 20 == 0) {
                        bcp.print();
                    } else {
                        bcp.print(false);
                    }
                    bcp.clear();
                    previousMetrics = mc;
                    if (metricSamples > 0 && metricSamples == ++rowsPrinted) break;
                    try {
                        Thread.sleep(sleepTime * 1000L);
                    }
                    catch (InterruptedException ie) {
                        Globals.stdErrPrintln(ie.toString());
                    }
                }
                Globals.stdOutPrintln("");
                Globals.stdOutPrintln(this.ar.getString("A1300"));
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                Globals.stdErrPrintln(this.ar.getString("A1296"));
                return 1;
            }
        }
        if (broker.isConnected()) {
            broker.close();
        }
        return 0;
    }

    private BrokerCmdPrinter setupListDestTitle(int listType) {
        BrokerCmdPrinter bcp = null;
        if (listType != 2) {
            bcp = new BrokerCmdPrinter(12, 2, "-");
            String[] row = new String[12];
            int[] span = new int[12];
            int i = 0;
            bcp.setTitleAlign(1);
            span[i++] = 1;
            span[i++] = 1;
            span[i++] = 1;
            span[i++] = 2;
            span[i++] = 0;
            span[i++] = 2;
            span[i++] = 0;
            span[i++] = 5;
            span[i++] = 0;
            span[i++] = 0;
            span[i++] = 0;
            span[i++] = 0;
            i = 0;
            int n = i++;
            row[n] = this.ar.getString("A1443");
            int n2 = i++;
            row[n2] = this.ar.getString("A1444");
            int n3 = i++;
            row[n3] = this.ar.getString("A1445");
            int n4 = i++;
            row[n4] = this.ar.getString("A1675");
            row[i++] = "";
            int n5 = i++;
            row[n5] = this.ar.getString("A1676");
            row[i++] = "";
            int n6 = i++;
            row[n6] = this.ar.getString("A1677");
            row[i++] = "";
            row[i++] = "";
            row[i++] = "";
            row[i++] = "";
            bcp.addTitle(row, span);
            i = 0;
            row[i++] = "";
            row[i++] = "";
            row[i++] = "";
            int n7 = i++;
            row[n7] = this.ar.getString("A1690");
            int n8 = i++;
            row[n8] = this.ar.getString("A1691");
            int n9 = i++;
            row[n9] = this.ar.getString("A1689");
            int n10 = i++;
            row[n10] = this.ar.getString("A1691");
            int n11 = i++;
            row[n11] = this.ar.getString("A1680");
            int n12 = i++;
            row[n12] = this.ar.getString("A1738");
            int n13 = i++;
            row[n13] = this.ar.getString("A1681");
            int n14 = i++;
            row[n14] = this.ar.getString("A1694");
            int n15 = i++;
            row[n15] = this.ar.getString("A1682");
            bcp.addTitle(row);
        } else {
            bcp = new BrokerCmdPrinter(11, 2, "-");
            String[] row = new String[11];
            int[] span = new int[11];
            int i = 0;
            bcp.setTitleAlign(1);
            span[i++] = 1;
            span[i++] = 1;
            span[i++] = 1;
            span[i++] = 1;
            span[i++] = 2;
            span[i++] = 0;
            span[i++] = 5;
            span[i++] = 0;
            span[i++] = 0;
            span[i++] = 0;
            span[i++] = 0;
            i = 0;
            int n = i++;
            row[n] = this.ar.getString("A1443");
            int n16 = i++;
            row[n16] = this.ar.getString("A1444");
            int n17 = i++;
            row[n17] = this.ar.getString("A1445");
            int n18 = i++;
            row[n18] = this.ar.getString("A1675");
            int n19 = i++;
            row[n19] = this.ar.getString("A1676");
            row[i++] = "";
            int n20 = i++;
            row[n20] = this.ar.getString("A1677");
            row[i++] = "";
            row[i++] = "";
            row[i++] = "";
            row[i++] = "";
            bcp.addTitle(row, span);
            i = 0;
            row[i++] = "";
            row[i++] = "";
            row[i++] = "";
            row[i++] = "";
            int n21 = i++;
            row[n21] = this.ar.getString("A1678");
            int n22 = i++;
            row[n22] = this.ar.getString("A1679");
            int n23 = i++;
            row[n23] = this.ar.getString("A1680");
            int n24 = i++;
            row[n24] = this.ar.getString("A1738");
            int n25 = i++;
            row[n25] = this.ar.getString("A1681");
            int n26 = i++;
            row[n26] = this.ar.getString("A1694");
            int n27 = i++;
            row[n27] = this.ar.getString("A1682");
            bcp.addTitle(row);
        }
        return bcp;
    }

    private BrokerCmdPrinter setupMetricTitle(String commandArg, int metricType) {
        BrokerCmdPrinter bcp = null;
        if (metricType == 0) {
            int i = 0;
            int[] span = new int[8];
            bcp = new BrokerCmdPrinter(8, 2, "-", 1);
            bcp.setTitleAlign(1);
            String[] titleRow = new String[8];
            span[i++] = 2;
            span[i++] = 0;
            span[i++] = 2;
            span[i++] = 0;
            span[i++] = 2;
            span[i++] = 0;
            span[i++] = 2;
            span[i++] = 0;
            i = 0;
            int n = i++;
            titleRow[n] = this.ar.getString("A1659");
            titleRow[i++] = "";
            int n2 = i++;
            titleRow[n2] = this.ar.getString("A1660");
            titleRow[i++] = "";
            int n3 = i++;
            titleRow[n3] = this.ar.getString("A1661");
            titleRow[i++] = "";
            int n4 = i++;
            titleRow[n4] = this.ar.getString("A1662");
            titleRow[i++] = "";
            bcp.addTitle(titleRow, span);
            i = 0;
            int n5 = i++;
            titleRow[n5] = this.ar.getString("A1667");
            int n6 = i++;
            titleRow[n6] = this.ar.getString("A1668");
            int n7 = i++;
            titleRow[n7] = this.ar.getString("A1667");
            int n8 = i++;
            titleRow[n8] = this.ar.getString("A1668");
            int n9 = i++;
            titleRow[n9] = this.ar.getString("A1667");
            int n10 = i++;
            titleRow[n10] = this.ar.getString("A1668");
            int n11 = i++;
            titleRow[n11] = this.ar.getString("A1667");
            int n12 = i++;
            titleRow[n12] = this.ar.getString("A1668");
            bcp.addTitle(titleRow);
        } else if (metricType == 1) {
            int i = 0;
            int[] span = new int[8];
            bcp = new BrokerCmdPrinter(8, 2, "-", 1);
            bcp.setTitleAlign(1);
            String[] titleRow = new String[8];
            span[i++] = 2;
            span[i++] = 0;
            span[i++] = 2;
            span[i++] = 0;
            span[i++] = 2;
            span[i++] = 0;
            span[i++] = 2;
            span[i++] = 0;
            i = 0;
            int n = i++;
            titleRow[n] = this.ar.getString("A1663");
            titleRow[i++] = "";
            int n13 = i++;
            titleRow[n13] = this.ar.getString("A1664");
            titleRow[i++] = "";
            int n14 = i++;
            titleRow[n14] = this.ar.getString("A1665");
            titleRow[i++] = "";
            int n15 = i++;
            titleRow[n15] = this.ar.getString("A1666");
            titleRow[i++] = "";
            bcp.addTitle(titleRow, span);
            i = 0;
            int n16 = i++;
            titleRow[n16] = this.ar.getString("A1667");
            int n17 = i++;
            titleRow[n17] = this.ar.getString("A1668");
            int n18 = i++;
            titleRow[n18] = this.ar.getString("A1667");
            int n19 = i++;
            titleRow[n19] = this.ar.getString("A1668");
            int n20 = i++;
            titleRow[n20] = this.ar.getString("A1667");
            int n21 = i++;
            titleRow[n21] = this.ar.getString("A1668");
            int n22 = i++;
            titleRow[n22] = this.ar.getString("A1667");
            int n23 = i++;
            titleRow[n23] = this.ar.getString("A1668");
            bcp.addTitle(titleRow);
        } else if (metricType == 2) {
            int i = 0;
            String[] titleRow = new String[6];
            int[] span = new int[6];
            bcp = new BrokerCmdPrinter(6, 2, "-", 1);
            bcp.setTitleAlign(1);
            span[i++] = 1;
            span[i++] = 2;
            span[i++] = 0;
            span[i++] = 3;
            span[i++] = 0;
            span[i++] = 0;
            i = 0;
            int n = i++;
            titleRow[n] = this.ar.getString("A1608");
            int n24 = i++;
            titleRow[n24] = this.ar.getString("A1669");
            titleRow[i++] = "";
            int n25 = i++;
            titleRow[n25] = this.ar.getString("A1670");
            titleRow[i++] = "";
            titleRow[i++] = "";
            bcp.addTitle(titleRow, span);
            i = 0;
            int n26 = i++;
            titleRow[n26] = this.ar.getString("A1609");
            int n27 = i++;
            titleRow[n27] = this.ar.getString("A1647");
            int n28 = i++;
            titleRow[n28] = this.ar.getString("A1671");
            int n29 = i++;
            titleRow[n29] = this.ar.getString("A1672");
            int n30 = i++;
            titleRow[n30] = this.ar.getString("A1673");
            int n31 = i++;
            titleRow[n31] = this.ar.getString("A1674");
            bcp.addTitle(titleRow);
        }
        return bcp;
    }

    private BrokerCmdPrinter setupDestMetricTitle(String commandArg, int metricType, int destTypeMask) {
        BrokerCmdPrinter bcp = null;
        if (metricType == 0) {
            bcp = new BrokerCmdPrinter(11, 2, "-", 1);
            bcp.setTitleAlign(1);
            String[] titleRow = new String[11];
            int[] span = new int[11];
            int i = 0;
            span[i++] = 2;
            span[i++] = 0;
            span[i++] = 2;
            span[i++] = 0;
            span[i++] = 3;
            span[i++] = 0;
            span[i++] = 0;
            span[i++] = 3;
            span[i++] = 0;
            span[i++] = 0;
            span[i++] = 1;
            i = 0;
            int n = i++;
            titleRow[n] = this.ar.getString("A1659");
            titleRow[i++] = "";
            int n2 = i++;
            titleRow[n2] = this.ar.getString("A1660");
            titleRow[i++] = "";
            int n3 = i++;
            titleRow[n3] = this.ar.getString("A1643");
            titleRow[i++] = "";
            titleRow[i++] = "";
            int n4 = i++;
            titleRow[n4] = this.ar.getString("A1644");
            titleRow[i++] = "";
            titleRow[i++] = "";
            int n5 = i++;
            titleRow[n5] = this.ar.getString("A1645");
            bcp.addTitle(titleRow, span);
            i = 0;
            int n6 = i++;
            titleRow[n6] = this.ar.getString("A1667");
            int n7 = i++;
            titleRow[n7] = this.ar.getString("A1668");
            int n8 = i++;
            titleRow[n8] = this.ar.getString("A1667");
            int n9 = i++;
            titleRow[n9] = this.ar.getString("A1668");
            int n10 = i++;
            titleRow[n10] = this.ar.getString("A1649");
            int n11 = i++;
            titleRow[n11] = this.ar.getString("A1650");
            int n12 = i++;
            titleRow[n12] = this.ar.getString("A1651");
            int n13 = i++;
            titleRow[n13] = this.ar.getString("A1649");
            int n14 = i++;
            titleRow[n14] = this.ar.getString("A1650");
            int n15 = i++;
            titleRow[n15] = this.ar.getString("A1651");
            int n16 = i++;
            titleRow[n16] = this.ar.getString("A1646");
            bcp.addTitle(titleRow);
        } else if (metricType == 1) {
            bcp = new BrokerCmdPrinter(11, 2, "-", 1);
            bcp.setTitleAlign(1);
            String[] titleRow = new String[11];
            int[] span = new int[11];
            int i = 0;
            span[i++] = 2;
            span[i++] = 0;
            span[i++] = 2;
            span[i++] = 0;
            span[i++] = 3;
            span[i++] = 0;
            span[i++] = 0;
            span[i++] = 3;
            span[i++] = 0;
            span[i++] = 0;
            span[i++] = 1;
            i = 0;
            int n = i++;
            titleRow[n] = this.ar.getString("A1663");
            titleRow[i++] = "";
            int n17 = i++;
            titleRow[n17] = this.ar.getString("A1664");
            titleRow[i++] = "";
            int n18 = i++;
            titleRow[n18] = this.ar.getString("A1643");
            titleRow[i++] = "";
            titleRow[i++] = "";
            int n19 = i++;
            titleRow[n19] = this.ar.getString("A1644");
            titleRow[i++] = "";
            titleRow[i++] = "";
            int n20 = i++;
            titleRow[n20] = this.ar.getString("A1645");
            bcp.addTitle(titleRow, span);
            i = 0;
            int n21 = i++;
            titleRow[n21] = this.ar.getString("A1667");
            int n22 = i++;
            titleRow[n22] = this.ar.getString("A1668");
            int n23 = i++;
            titleRow[n23] = this.ar.getString("A1667");
            int n24 = i++;
            titleRow[n24] = this.ar.getString("A1668");
            int n25 = i++;
            titleRow[n25] = this.ar.getString("A1649");
            int n26 = i++;
            titleRow[n26] = this.ar.getString("A1650");
            int n27 = i++;
            titleRow[n27] = this.ar.getString("A1651");
            int n28 = i++;
            titleRow[n28] = this.ar.getString("A1649");
            int n29 = i++;
            titleRow[n29] = this.ar.getString("A1650");
            int n30 = i++;
            titleRow[n30] = this.ar.getString("A1651");
            int n31 = i++;
            titleRow[n31] = this.ar.getString("A1646");
            bcp.addTitle(titleRow);
        } else if (metricType == 3) {
            if (DestType.isQueue(destTypeMask)) {
                bcp = new BrokerCmdPrinter(9, 2, "-", 1);
                bcp.setTitleAlign(1);
                String[] titleRow = new String[9];
                int[] span = new int[9];
                int i = 0;
                span[i++] = 3;
                span[i++] = 0;
                span[i++] = 0;
                span[i++] = 3;
                span[i++] = 0;
                span[i++] = 0;
                span[i++] = 3;
                span[i++] = 0;
                span[i++] = 0;
                i = 0;
                int n = i++;
                titleRow[n] = this.ar.getString("A1652");
                titleRow[i++] = "";
                titleRow[i++] = "";
                int n32 = i++;
                titleRow[n32] = this.ar.getString("A1653");
                titleRow[i++] = "";
                titleRow[i++] = "";
                int n33 = i++;
                titleRow[n33] = this.ar.getString("A1643");
                titleRow[i++] = "";
                titleRow[i++] = "";
                bcp.addTitle(titleRow, span);
                i = 0;
                int n34 = i++;
                titleRow[n34] = this.ar.getString("A1649");
                int n35 = i++;
                titleRow[n35] = this.ar.getString("A1650");
                int n36 = i++;
                titleRow[n36] = this.ar.getString("A1651");
                int n37 = i++;
                titleRow[n37] = this.ar.getString("A1649");
                int n38 = i++;
                titleRow[n38] = this.ar.getString("A1650");
                int n39 = i++;
                titleRow[n39] = this.ar.getString("A1651");
                int n40 = i++;
                titleRow[n40] = this.ar.getString("A1649");
                int n41 = i++;
                titleRow[n41] = this.ar.getString("A1650");
                int n42 = i++;
                titleRow[n42] = this.ar.getString("A1651");
                bcp.addTitle(titleRow);
            } else {
                bcp = new BrokerCmdPrinter(6, 2, "-", 1);
                bcp.setTitleAlign(1);
                String[] titleRow = new String[6];
                int[] span = new int[6];
                int i = 0;
                span[i++] = 3;
                span[i++] = 0;
                span[i++] = 0;
                span[i++] = 3;
                span[i++] = 0;
                span[i++] = 0;
                i = 0;
                int n = i++;
                titleRow[n] = this.ar.getString("A1687");
                titleRow[i++] = "";
                titleRow[i++] = "";
                int n43 = i++;
                titleRow[n43] = this.ar.getString("A1643");
                titleRow[i++] = "";
                titleRow[i++] = "";
                bcp.addTitle(titleRow, span);
                i = 0;
                int n44 = i++;
                titleRow[n44] = this.ar.getString("A1649");
                int n45 = i++;
                titleRow[n45] = this.ar.getString("A1650");
                int n46 = i++;
                titleRow[n46] = this.ar.getString("A1651");
                int n47 = i++;
                titleRow[n47] = this.ar.getString("A1649");
                int n48 = i++;
                titleRow[n48] = this.ar.getString("A1650");
                int n49 = i++;
                titleRow[n49] = this.ar.getString("A1651");
                bcp.addTitle(titleRow);
            }
        } else if (metricType == 4) {
            bcp = new BrokerCmdPrinter(3, 2, "-", 1);
            String[] titleRow = new String[3];
            titleRow[0] = this.ar.getString("A1656");
            titleRow[1] = this.ar.getString("A1657");
            titleRow[2] = this.ar.getString("A1658");
            bcp.addTitle(titleRow);
        } else if (metricType == 5) {
            bcp = new BrokerCmdPrinter(3, 2, "-", 1);
            bcp.setTitleAlign(1);
            String[] titleRow = new String[3];
            int[] span = new int[3];
            int i = 0;
            span[i++] = 3;
            span[i++] = 0;
            span[i++] = 0;
            i = 0;
            titleRow[i++] = "Msgs Removed";
            titleRow[i++] = "";
            titleRow[i++] = "";
            bcp.addTitle(titleRow, span);
            i = 0;
            titleRow[i++] = "Expired";
            titleRow[i++] = "Discarded";
            titleRow[i++] = "Purged";
            bcp.addTitle(titleRow);
        }
        return bcp;
    }

    private void addOneMetricRow(int metricType, BrokerCmdPrinter bcp, MetricCounters latest, MetricCounters previous) {
        if (metricType == 0) {
            Object[] metricRow = new String[]{Long.toString(latest.messagesIn), Long.toString(latest.messagesOut), Long.toString(latest.messageBytesIn), Long.toString(latest.messageBytesOut), Long.toString(latest.packetsIn), Long.toString(latest.packetsOut), Long.toString(latest.packetBytesIn), Long.toString(latest.packetBytesOut)};
            bcp.add(metricRow);
        } else if (metricType == 1) {
            Object[] metricRow = new String[8];
            if (previous == null) {
                metricRow[0] = "0";
                metricRow[1] = "0";
                metricRow[2] = "0";
                metricRow[3] = "0";
                metricRow[4] = "0";
                metricRow[5] = "0";
                metricRow[6] = "0";
                metricRow[7] = "0";
            } else {
                float secs = (float)(latest.timeStamp - previous.timeStamp) / 1000.0f;
                metricRow[0] = CommonCmdRunnerUtil.getRateString(latest.messagesIn, previous.messagesIn, secs);
                metricRow[1] = CommonCmdRunnerUtil.getRateString(latest.messagesOut, previous.messagesOut, secs);
                metricRow[2] = CommonCmdRunnerUtil.getRateString(latest.messageBytesIn, previous.messageBytesIn, secs);
                metricRow[3] = CommonCmdRunnerUtil.getRateString(latest.messageBytesOut, previous.messageBytesOut, secs);
                metricRow[4] = CommonCmdRunnerUtil.getRateString(latest.packetsIn, previous.packetsIn, secs);
                metricRow[5] = CommonCmdRunnerUtil.getRateString(latest.packetsOut, previous.packetsOut, secs);
                metricRow[6] = CommonCmdRunnerUtil.getRateString(latest.packetBytesIn, previous.packetBytesIn, secs);
                metricRow[7] = CommonCmdRunnerUtil.getRateString(latest.packetBytesOut, previous.packetBytesOut, secs);
            }
            bcp.add(metricRow);
        } else if (metricType == 2) {
            Object[] metricRow = new String[]{Integer.toString(latest.nConnections), Long.toString(latest.totalMemory), Long.toString(latest.freeMemory), Integer.toString(latest.threadsActive), Integer.toString(latest.threadsLowWater), Integer.toString(latest.threadsHighWater)};
            bcp.add(metricRow);
        }
    }

    private void addOneDestMetricRow(int metricType, int destTypeMask, BrokerCmdPrinter bcp, DestMetricsCounters latestDest, DestMetricsCounters previousDest) {
        if (metricType == 0) {
            Object[] metricRow = new String[]{Long.toString(latestDest.getMessagesIn()), Long.toString(latestDest.getMessagesOut()), Long.toString(latestDest.getMessageBytesIn()), Long.toString(latestDest.getMessageBytesOut()), Integer.toString(latestDest.getCurrentMessages()), Integer.toString(latestDest.getHighWaterMessages()), Integer.toString(latestDest.getAverageMessages()), CommonCmdRunnerUtil.displayInKBytes(latestDest.getCurrentMessageBytes()), CommonCmdRunnerUtil.displayInKBytes(latestDest.getHighWaterMessageBytes()), CommonCmdRunnerUtil.displayInKBytes(latestDest.getAverageMessageBytes()), CommonCmdRunnerUtil.displayInKBytes(latestDest.getHighWaterLargestMsgBytes())};
            bcp.add(metricRow);
        } else if (metricType == 1) {
            Object[] metricRow = new String[11];
            if (previousDest == null) {
                metricRow[0] = "0";
                metricRow[1] = "0";
                metricRow[2] = "0";
                metricRow[3] = "0";
            } else {
                float secs = (float)(latestDest.timeStamp - previousDest.timeStamp) / 1000.0f;
                metricRow[0] = CommonCmdRunnerUtil.getRateString(latestDest.getMessagesIn(), previousDest.getMessagesIn(), secs);
                metricRow[1] = CommonCmdRunnerUtil.getRateString(latestDest.getMessagesOut(), previousDest.getMessagesOut(), secs);
                metricRow[2] = CommonCmdRunnerUtil.getRateString(latestDest.getMessageBytesIn(), previousDest.getMessageBytesIn(), secs);
                metricRow[3] = CommonCmdRunnerUtil.getRateString(latestDest.getMessageBytesOut(), previousDest.getMessageBytesOut(), secs);
            }
            metricRow[4] = Integer.toString(latestDest.getCurrentMessages());
            metricRow[5] = Integer.toString(latestDest.getHighWaterMessages());
            metricRow[6] = Integer.toString(latestDest.getAverageMessages());
            metricRow[7] = CommonCmdRunnerUtil.displayInKBytes(latestDest.getCurrentMessageBytes());
            metricRow[8] = CommonCmdRunnerUtil.displayInKBytes(latestDest.getHighWaterMessageBytes());
            metricRow[9] = CommonCmdRunnerUtil.displayInKBytes(latestDest.getAverageMessageBytes());
            metricRow[10] = CommonCmdRunnerUtil.displayInKBytes(latestDest.getHighWaterLargestMsgBytes());
            bcp.add(metricRow);
        } else if (metricType == 3) {
            if (DestType.isQueue(destTypeMask)) {
                Object[] metricRow = new String[]{Integer.toString(latestDest.getActiveConsumers()), Integer.toString(latestDest.getHWActiveConsumers()), Integer.toString(latestDest.getAvgActiveConsumers()), Integer.toString(latestDest.getFailoverConsumers()), Integer.toString(latestDest.getHWFailoverConsumers()), Integer.toString(latestDest.getAvgFailoverConsumers()), Integer.toString(latestDest.getCurrentMessages()), Integer.toString(latestDest.getHighWaterMessages()), Integer.toString(latestDest.getAverageMessages())};
                bcp.add(metricRow);
            } else {
                Object[] metricRow = new String[]{Integer.toString(latestDest.getActiveConsumers()), Integer.toString(latestDest.getHWActiveConsumers()), Integer.toString(latestDest.getAvgActiveConsumers()), Integer.toString(latestDest.getCurrentMessages()), Integer.toString(latestDest.getHighWaterMessages()), Integer.toString(latestDest.getAverageMessages())};
                bcp.add(metricRow);
            }
        } else if (metricType == 4) {
            Object[] metricRow = new String[]{Long.toString(latestDest.getDiskReserved()), Long.toString(latestDest.getDiskUsed()), Integer.toString(latestDest.getDiskUtilizationRatio())};
            bcp.add(metricRow);
        } else if (metricType == 5) {
            Object[] metricRow = new String[]{"0", "0", "0"};
            bcp.add(metricRow);
        }
    }

    private int runReload(BrokerCmdProperties brokerCmdProps) {
        BrokerAdmin broker = this.init();
        if (broker == null) {
            Globals.stdErrPrintln(this.ar.getString("A1570"));
            return 1;
        }
        boolean force = brokerCmdProps.forceModeSet();
        if (!force) {
            broker = this.promptForAuthentication(broker);
        }
        Globals.stdOutPrintln(this.ar.getString("A1569"));
        this.printBrokerInfo(broker);
        try {
            this.connectToBroker(broker);
            broker.sendReloadClusterMessage();
            broker.receiveReloadClusterReplyMessage();
            Globals.stdOutPrintln(this.ar.getString("A1571"));
        }
        catch (BrokerAdminException bae) {
            this.handleBrokerAdminException(bae);
            Globals.stdErrPrintln(this.ar.getString("A1570"));
            return 1;
        }
        return 0;
    }

    private int runChangeMaster(BrokerCmdProperties brokerCmdProps) {
        String yes = this.ar.getString("A5016");
        String yesShort = this.ar.getString("A5015");
        String no = this.ar.getString("A5018");
        String noShort = this.ar.getString("A5017");
        BrokerAdmin broker = this.init();
        if (broker == null) {
            Globals.stdErrPrintln(this.ar.getString("A1805"));
            return 1;
        }
        boolean force = brokerCmdProps.forceModeSet();
        if (!force) {
            broker = this.promptForAuthentication(broker);
        }
        Properties targetAttrs = brokerCmdProps.getTargetAttrs();
        Globals.stdOutPrintln(this.ar.getString("A1804"));
        Globals.stdOutPrintln("");
        this.printAttrs(targetAttrs);
        Globals.stdOutPrintln(this.ar.getString("A1200"));
        this.printBrokerInfo(broker);
        if (!force) {
            String input = CommonCmdRunnerUtil.getUserInput(this.ar.getString("A5036"), noShort);
            Globals.stdOutPrintln("");
            if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                Globals.stdOutPrintln(this.ar.getString("A1807"));
                return 0;
            }
            if (!yesShort.equalsIgnoreCase(input) && !yes.equalsIgnoreCase(input)) {
                Globals.stdOutPrintln(this.ar.getString("A1026", input));
                Globals.stdOutPrintln("");
                Globals.stdOutPrintln(this.ar.getString("A1807"));
                return 1;
            }
        }
        try {
            this.connectToBroker(broker);
            broker.sendClusterChangeMasterMessage(targetAttrs);
            broker.receiveClusterChangeMasterReplyMessage();
            Globals.stdOutPrintln(this.ar.getString("A1806"));
        }
        catch (BrokerAdminException bae) {
            this.handleBrokerAdminException(bae);
            Globals.stdErrPrintln(this.ar.getString("A1805"));
            return 1;
        }
        broker.close();
        return 0;
    }

    private int runCommit(BrokerCmdProperties brokerCmdProps) {
        block11: {
            Long tid = null;
            String yes = this.ar.getString("A5016");
            String yesShort = this.ar.getString("A5015");
            String no = this.ar.getString("A5018");
            String noShort = this.ar.getString("A5017");
            BrokerAdmin broker = this.init();
            if (broker == null) {
                Globals.stdErrPrintln(this.ar.getString("A1259"));
                return 1;
            }
            boolean force = brokerCmdProps.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            Globals.stdOutPrintln(this.ar.getString("A1257"));
            this.printTransactionInfo();
            Globals.stdOutPrintln(this.ar.getString("A1200"));
            this.printBrokerInfo(broker);
            String tidStr = brokerCmdProps.getTargetName();
            try {
                tid = Long.valueOf(tidStr);
            }
            catch (NumberFormatException nfe) {
                Globals.stdErrPrintln(this.ar.getString("A3150", tidStr));
                Globals.stdErrPrintln(this.ar.getString("A1259"));
                return 1;
            }
            try {
                this.connectToBroker(broker);
                String input = null;
                if (!force) {
                    input = CommonCmdRunnerUtil.getUserInput(this.ar.getString("A5033"), noShort);
                    Globals.stdOutPrintln("");
                }
                if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                    try {
                        broker.sendCommitTxnMessage(tid);
                        broker.receiveCommitTxnReplyMessage();
                        Globals.stdOutPrintln(this.ar.getString("A1258"));
                        break block11;
                    }
                    catch (BrokerAdminException bae) {
                        this.handleBrokerAdminException(bae);
                        Globals.stdErrPrintln(this.ar.getString("A1259"));
                        return 1;
                    }
                }
                if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                    Globals.stdOutPrintln(this.ar.getString("A1279"));
                    return 0;
                }
                Globals.stdOutPrintln(this.ar.getString("A1026", input));
                Globals.stdOutPrintln("");
                Globals.stdOutPrintln(this.ar.getString("A1279"));
                return 1;
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                Globals.stdErrPrintln(this.ar.getString("A1259"));
                return 1;
            }
        }
        return 0;
    }

    private int runRollback(BrokerCmdProperties brokerCmdProps) {
        block14: {
            Long tid = null;
            String yes = this.ar.getString("A5016");
            String yesShort = this.ar.getString("A5015");
            String no = this.ar.getString("A5018");
            String noShort = this.ar.getString("A5017");
            BrokerAdmin broker = this.init();
            if (broker == null) {
                Globals.stdErrPrintln(this.ar.getString("A1262"));
                return 1;
            }
            boolean force = brokerCmdProps.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            Globals.stdOutPrintln(this.ar.getString("A1260"));
            this.printTransactionInfo();
            Globals.stdOutPrintln(this.ar.getString("A1200"));
            this.printBrokerInfo(broker);
            String tidStr = brokerCmdProps.getTargetName();
            try {
                tid = Long.valueOf(tidStr);
            }
            catch (NumberFormatException nfe) {
                Globals.stdErrPrintln(this.ar.getString("A3150", tidStr));
                Globals.stdErrPrintln(this.ar.getString("A1262"));
                return 1;
            }
            try {
                Hashtable txnInfo = null;
                this.connectToBroker(broker);
                broker.sendGetTxnsMessage(tid, brokerCmdProps.showPartitionModeSet());
                Vector txns = broker.receiveGetTxnsReplyMessage();
                if (txns != null && txns.size() == 1) {
                    Enumeration thisEnum = txns.elements();
                    txnInfo = (Hashtable)thisEnum.nextElement();
                    if (brokerCmdProps.debugModeSet()) {
                        this.printAllTxnAttrs(txnInfo);
                    }
                } else {
                    Globals.stdErrPrintln(this.ar.getString("A1335"));
                    Globals.stdErrPrintln(this.ar.getString("A1262"));
                    return 1;
                }
                Integer tmpInt = (Integer)txnInfo.get("state");
                String txnState = this.getTxnStateString(tmpInt);
                String input = null;
                if (!force) {
                    input = CommonCmdRunnerUtil.getUserInput(this.ar.getString("A5032", txnState), noShort);
                    Globals.stdOutPrintln("");
                }
                if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                    try {
                        broker.sendRollbackTxnMessage(tid, brokerCmdProps.msgOptionSet());
                        broker.receiveRollbackTxnReplyMessage();
                        Globals.stdOutPrintln(this.ar.getString("A1261"));
                        break block14;
                    }
                    catch (BrokerAdminException bae) {
                        this.handleBrokerAdminException(bae);
                        Globals.stdErrPrintln(this.ar.getString("A1262"));
                        return 1;
                    }
                }
                if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                    Globals.stdOutPrintln(this.ar.getString("A1278"));
                    return 0;
                }
                Globals.stdOutPrintln(this.ar.getString("A1026", input));
                Globals.stdOutPrintln("");
                Globals.stdOutPrintln(this.ar.getString("A1278"));
                return 1;
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                Globals.stdErrPrintln(this.ar.getString("A1262"));
                return 1;
            }
        }
        return 0;
    }

    private int runCompact(BrokerCmdProperties brokerCmdProps) {
        String input = null;
        boolean compactAll = true;
        String yes = this.ar.getString("A5016");
        String yesShort = this.ar.getString("A5015");
        String no = this.ar.getString("A5018");
        String noShort = this.ar.getString("A5017");
        String commandArg = brokerCmdProps.getCommandArg();
        boolean force = brokerCmdProps.forceModeSet();
        BrokerAdmin broker = this.init();
        if ("dst".equals(commandArg)) {
            String destName = brokerCmdProps.getTargetName();
            int destTypeMask = this.getDestTypeMask(brokerCmdProps);
            if (destName != null) {
                compactAll = false;
            }
            if (broker == null) {
                if (compactAll) {
                    Globals.stdErrPrintln(this.ar.getString("A1306"));
                } else {
                    Globals.stdErrPrintln(this.ar.getString("A1305"));
                }
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            if (compactAll) {
                Globals.stdOutPrintln(this.ar.getString("A1302"));
                this.printBrokerInfo(broker);
            } else {
                Globals.stdOutPrintln(this.ar.getString("A1301"));
                this.printDestinationInfo();
                Globals.stdOutPrintln(this.ar.getString("A1200"));
                this.printBrokerInfo(broker);
            }
            try {
                this.connectToBroker(broker);
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                if (compactAll) {
                    Globals.stdErrPrintln(this.ar.getString("A1306"));
                } else {
                    Globals.stdErrPrintln(this.ar.getString("A1305"));
                }
                return 1;
            }
            if (!force) {
                input = compactAll ? CommonCmdRunnerUtil.getUserInput(this.ar.getString("A5024"), noShort) : CommonCmdRunnerUtil.getUserInput(this.ar.getString("A5023"), noShort);
                Globals.stdOutPrintln("");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    broker.sendCompactDestinationMessage(destName, destTypeMask);
                    broker.receiveCompactDestinationReplyMessage();
                    if (compactAll) {
                        Globals.stdOutPrintln(this.ar.getString("A1304"));
                    }
                    Globals.stdOutPrintln(this.ar.getString("A1303"));
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    if (compactAll) {
                        Globals.stdErrPrintln(this.ar.getString("A1306"));
                    } else {
                        Globals.stdErrPrintln(this.ar.getString("A1305"));
                    }
                    return 1;
                }
            } else {
                if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                    if (compactAll) {
                        Globals.stdOutPrintln(this.ar.getString("A1308"));
                    } else {
                        Globals.stdOutPrintln(this.ar.getString("A1307"));
                    }
                    return 0;
                }
                Globals.stdOutPrintln(this.ar.getString("A1026", input));
                Globals.stdOutPrintln("");
                if (compactAll) {
                    Globals.stdOutPrintln(this.ar.getString("A1308"));
                } else {
                    Globals.stdOutPrintln(this.ar.getString("A1307"));
                }
                return 1;
            }
        }
        broker.close();
        return 0;
    }

    private int runQuiesce(BrokerCmdProperties brokerCmdProps) {
        String input = null;
        String yes = this.ar.getString("A5016");
        String yesShort = this.ar.getString("A5015");
        String no = this.ar.getString("A5018");
        String noShort = this.ar.getString("A5017");
        BrokerAdmin broker = this.init();
        boolean force = brokerCmdProps.forceModeSet();
        String commandArg = brokerCmdProps.getCommandArg();
        if ("bkr".equals(commandArg)) {
            if (broker == null) {
                Globals.stdErrPrintln(this.ar.getString("A1701"));
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            Globals.stdOutPrintln(this.ar.getString("A1700"));
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                Globals.stdErrPrintln(this.ar.getString("A1701"));
                return 1;
            }
            if (!force) {
                input = CommonCmdRunnerUtil.getUserInput(this.ar.getString("A5027"), noShort);
                Globals.stdOutPrintln("");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    broker.sendQuiesceMessage();
                    broker.receiveQuiesceReplyMessage();
                    Globals.stdOutPrintln(this.ar.getString("A1702"));
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    Globals.stdErrPrintln(this.ar.getString("A1701"));
                    return 1;
                }
            } else {
                if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                    Globals.stdOutPrintln(this.ar.getString("A1703"));
                    return 0;
                }
                Globals.stdOutPrintln(this.ar.getString("A1026", input));
                Globals.stdOutPrintln("");
                Globals.stdOutPrintln(this.ar.getString("A1703"));
                return 1;
            }
        }
        broker.close();
        return 0;
    }

    private int runUnquiesce(BrokerCmdProperties brokerCmdProps) {
        String input = null;
        String yes = this.ar.getString("A5016");
        String yesShort = this.ar.getString("A5015");
        String no = this.ar.getString("A5018");
        String noShort = this.ar.getString("A5017");
        BrokerAdmin broker = this.init();
        boolean force = brokerCmdProps.forceModeSet();
        String commandArg = brokerCmdProps.getCommandArg();
        if ("bkr".equals(commandArg)) {
            if (broker == null) {
                Globals.stdErrPrintln(this.ar.getString("A1751"));
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            Globals.stdOutPrintln(this.ar.getString("A1750"));
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                Globals.stdErrPrintln(this.ar.getString("A1751"));
                return 1;
            }
            if (!force) {
                input = CommonCmdRunnerUtil.getUserInput(this.ar.getString("A5030"), noShort);
                Globals.stdOutPrintln("");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    broker.sendUnquiesceMessage();
                    broker.receiveUnquiesceReplyMessage();
                    Globals.stdOutPrintln(this.ar.getString("A1752"));
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    Globals.stdErrPrintln(this.ar.getString("A1751"));
                    return 1;
                }
            } else {
                if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                    Globals.stdOutPrintln(this.ar.getString("A1753"));
                    return 0;
                }
                Globals.stdOutPrintln(this.ar.getString("A1026", input));
                Globals.stdOutPrintln("");
                Globals.stdOutPrintln(this.ar.getString("A1753"));
                return 1;
            }
        }
        broker.close();
        return 0;
    }

    private int runTakeover(BrokerCmdProperties brokerCmdProps) {
        String input = null;
        String yes = this.ar.getString("A5016");
        String yesShort = this.ar.getString("A5015");
        String no = this.ar.getString("A5018");
        String noShort = this.ar.getString("A5017");
        BrokerAdmin broker = this.init();
        boolean force = brokerCmdProps.forceModeSet();
        String commandArg = brokerCmdProps.getCommandArg();
        if ("bkr".equals(commandArg)) {
            String brokerID = brokerCmdProps.getTargetName();
            if (broker == null) {
                Globals.stdErrPrintln(this.ar.getString("A1705"));
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            Globals.stdOutPrintln(this.ar.getString("A1704"));
            Globals.stdOutPrintln(this.ar.getString("A1708"));
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                Globals.stdErrPrintln(this.ar.getString("A1705"));
                return 1;
            }
            try {
                broker.sendGetBrokerPropsMessage();
                Properties bkrProps = broker.receiveGetBrokerPropsReplyMessage();
                String value1 = bkrProps.getProperty("imq.cluster.ha");
                String value2 = bkrProps.getProperty("imq.storemigratable");
                if (!Boolean.parseBoolean(value1) && !Boolean.parseBoolean(value2)) {
                    Globals.stdErrPrintln(this.ar.getString("A3171"));
                    Globals.stdErrPrintln(this.ar.getString("A1705"));
                    return 1;
                }
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                Globals.stdErrPrintln(this.ar.getString("A1523"));
                Globals.stdErrPrintln(this.ar.getString("A1705"));
                return 1;
            }
            Globals.stdOutPrintln(this.ar.getString("A1769"));
            BrokerCmdPrinter bcp = new BrokerCmdPrinter(5, 3, "-");
            Object[] row = new String[5];
            bcp.setSortNeeded(false);
            bcp.setTitleAlign(1);
            int i = 0;
            row[i++] = "";
            row[i++] = "";
            row[i++] = "";
            row[i++] = "";
            int n = i++;
            row[n] = this.ar.getString("A1721");
            bcp.addTitle((String[])row);
            i = 0;
            int n2 = i++;
            row[n2] = this.ar.getString("A1716");
            int n3 = i++;
            row[n3] = this.ar.getString("A1717");
            int n4 = i++;
            row[n4] = this.ar.getString("A1718");
            int n5 = i++;
            row[n5] = this.ar.getString("A1719");
            int n6 = i++;
            row[n6] = this.ar.getString("A1737");
            bcp.addTitle((String[])row);
            Vector bkrList = null;
            try {
                broker.sendGetClusterMessage(true);
                bkrList = broker.receiveGetClusterReplyMessage();
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                Globals.stdErrPrintln(this.ar.getString("A3169"));
                Globals.stdErrPrintln(this.ar.getString("A1705"));
                return 1;
            }
            String brokerIDFromList = null;
            boolean found = false;
            Enumeration thisEnum = bkrList.elements();
            while (thisEnum.hasMoreElements()) {
                Hashtable bkrClsInfo = (Hashtable)thisEnum.nextElement();
                brokerIDFromList = (String)bkrClsInfo.get("ID");
                if (brokerIDFromList == null || !brokerIDFromList.equals(brokerID)) continue;
                found = true;
                i = 0;
                row[i++] = this.checkNullAndPrint(brokerIDFromList);
                row[i++] = this.checkNullAndPrint(bkrClsInfo.get("Address"));
                Integer tmpInt = (Integer)bkrClsInfo.get("State");
                row[i++] = tmpInt != null ? BrokerState.toString(tmpInt) : "";
                Long tmpLong = (Long)bkrClsInfo.get("NumMsgs");
                row[i++] = this.checkNullAndPrint(tmpLong);
                tmpLong = (Long)bkrClsInfo.get("StatusTimestamp");
                if (tmpLong != null) {
                    long idle = System.currentTimeMillis() - tmpLong;
                    row[i++] = CommonCmdRunnerUtil.getTimeString(idle);
                } else {
                    row[i++] = "";
                }
                bcp.add(row);
                break;
            }
            if (!found) {
                Globals.stdErrPrintln(this.ar.getString("A3170", brokerID));
                Globals.stdErrPrintln(this.ar.getString("A1705"));
                return 1;
            }
            bcp.println();
            if (!force) {
                input = CommonCmdRunnerUtil.getUserInput(this.ar.getString("A5028"), noShort);
                Globals.stdOutPrintln("");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    broker.sendTakeoverMessage(brokerID);
                    broker.receiveTakeoverReplyMessage();
                    Globals.stdOutPrintln(this.ar.getString("A1706"));
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    Globals.stdErrPrintln(this.ar.getString("A1705"));
                    return 1;
                }
            } else {
                if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                    Globals.stdOutPrintln(this.ar.getString("A1707"));
                    return 0;
                }
                Globals.stdOutPrintln(this.ar.getString("A1026", input));
                Globals.stdOutPrintln("");
                Globals.stdOutPrintln(this.ar.getString("A1707"));
                return 1;
            }
        }
        broker.close();
        return 0;
    }

    private int runMigrateStore(BrokerCmdProperties brokerCmdProps) {
        String input = null;
        String yes = this.ar.getString("A5016");
        String yesShort = this.ar.getString("A5015");
        String no = this.ar.getString("A5018");
        String noShort = this.ar.getString("A5017");
        BrokerAdmin broker = this.init();
        boolean force = brokerCmdProps.forceModeSet();
        String commandArg = brokerCmdProps.getCommandArg();
        Properties targetAttrs = brokerCmdProps.getTargetAttrs();
        String partition = targetAttrs.getProperty("partition");
        if ("bkr".equals(commandArg)) {
            String brokerID = brokerCmdProps.getTargetName();
            if (brokerID == null && partition != null) {
                Globals.stdErrPrintln(this.ar.getString("A3173", partition));
                return 1;
            }
            if (broker == null) {
                if (partition == null) {
                    Globals.stdErrPrintln(this.ar.getString("A1809"));
                } else {
                    Globals.stdErrPrintln(this.ar.getString("A1815", partition, brokerID));
                }
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            if (partition == null) {
                Globals.stdOutPrintln(this.ar.getString("A1808"));
            } else {
                Globals.stdOutPrintln(this.ar.getString("A1816", partition));
            }
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                if (partition == null) {
                    Globals.stdErrPrintln(this.ar.getString("A1809"));
                } else {
                    Globals.stdErrPrintln(this.ar.getString("A1815", partition, brokerID));
                }
                return 1;
            }
            try {
                broker.sendGetBrokerPropsMessage();
                Properties bkrProps = broker.receiveGetBrokerPropsReplyMessage();
                String value2 = bkrProps.getProperty("imq.storemigratable");
                String value3 = bkrProps.getProperty("imq.partitionmigratable");
                if (partition == null && !Boolean.parseBoolean(value2)) {
                    Globals.stdErrPrintln(this.ar.getString("A3172"));
                    Globals.stdErrPrintln(this.ar.getString("A1809"));
                    return 1;
                }
                if (partition != null && !Boolean.parseBoolean(value3)) {
                    Globals.stdErrPrintln(this.ar.getString("A3174"));
                    Globals.stdErrPrintln(this.ar.getString("A1815", partition, brokerID));
                    return 1;
                }
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                Globals.stdErrPrintln(this.ar.getString("A1523"));
                if (partition == null) {
                    Globals.stdErrPrintln(this.ar.getString("A1809"));
                } else {
                    Globals.stdErrPrintln(this.ar.getString("A1815", partition, brokerID));
                }
                return 1;
            }
            if (brokerID != null) {
                if (partition == null) {
                    Globals.stdOutPrintln(this.ar.getString("A1812"));
                } else {
                    Globals.stdOutPrintln(this.ar.getString("A1817", partition));
                }
                int numcolums = 4;
                if (partition != null) {
                    numcolums = 5;
                }
                BrokerCmdPrinter bcp = new BrokerCmdPrinter(numcolums, 3, "-");
                Object[] row = new String[numcolums];
                bcp.setSortNeeded(false);
                bcp.setTitleAlign(1);
                int i = 0;
                row[i++] = "";
                row[i++] = "";
                row[i++] = "";
                int n = i++;
                row[n] = this.ar.getString("A1721");
                if (partition != null) {
                    row[i++] = "";
                }
                bcp.addTitle((String[])row);
                i = 0;
                int n2 = i++;
                row[n2] = this.ar.getString("A1716");
                int n3 = i++;
                row[n3] = this.ar.getString("A1717");
                int n4 = i++;
                row[n4] = this.ar.getString("A1718");
                int n5 = i++;
                row[n5] = this.ar.getString("A1737");
                if (partition != null) {
                    int n6 = i++;
                    row[n6] = this.ar.getString("A1818");
                }
                bcp.addTitle((String[])row);
                Vector bkrList = null;
                try {
                    broker.sendGetClusterMessage(true);
                    bkrList = broker.receiveGetClusterReplyMessage();
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    Globals.stdErrPrintln(this.ar.getString("A3169"));
                    if (partition == null) {
                        Globals.stdErrPrintln(this.ar.getString("A1809"));
                    } else {
                        Globals.stdErrPrintln(this.ar.getString("A1815", partition, brokerID));
                    }
                    return 1;
                }
                String brokerIDFromList = null;
                boolean found = false;
                Enumeration thisEnum = bkrList.elements();
                while (thisEnum.hasMoreElements()) {
                    Hashtable bkrClsInfo = (Hashtable)thisEnum.nextElement();
                    brokerIDFromList = (String)bkrClsInfo.get("ID");
                    if (brokerIDFromList == null || !brokerIDFromList.equals(brokerID)) continue;
                    found = true;
                    i = 0;
                    row[i++] = this.checkNullAndPrint(brokerIDFromList);
                    row[i++] = this.checkNullAndPrint(bkrClsInfo.get("Address"));
                    Integer tmpInt = (Integer)bkrClsInfo.get("State");
                    row[i++] = tmpInt != null ? BrokerState.toString(tmpInt) : "";
                    Long tmpLong = (Long)bkrClsInfo.get("StatusTimestamp");
                    if (tmpLong != null) {
                        long idle = System.currentTimeMillis() - tmpLong;
                        row[i++] = CommonCmdRunnerUtil.getTimeString(idle);
                    } else {
                        row[i++] = "";
                    }
                    if (partition != null) {
                        tmpInt = (Integer)bkrClsInfo.get("JMQNumPartitions");
                        row[i++] = tmpInt != null ? String.valueOf(tmpInt) : "";
                    }
                    bcp.add(row);
                    break;
                }
                if (!found) {
                    Globals.stdErrPrintln(this.ar.getString("A3170", brokerID));
                    if (partition == null) {
                        Globals.stdErrPrintln(this.ar.getString("A1809"));
                    } else {
                        Globals.stdErrPrintln(this.ar.getString("A1815", partition, brokerID));
                    }
                    return 1;
                }
                bcp.println();
            }
            if (!force) {
                input = partition == null ? CommonCmdRunnerUtil.getUserInput(this.ar.getString("A5037"), noShort) : CommonCmdRunnerUtil.getUserInput(this.ar.getString("A5038", partition, brokerID), noShort);
                Globals.stdOutPrintln("");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    broker.sendMigrateStoreMessage(brokerID, partition);
                    String tobroker = broker.receiveMigrateStoreReplyMessage();
                    if (partition == null) {
                        Globals.stdOutPrintln(this.ar.getString("A1810", tobroker));
                    }
                    Globals.stdOutPrintln(this.ar.getString("A1819", partition, tobroker));
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    int status = bae.getReplyStatus();
                    Message msg = bae.getReplyMsg();
                    Object bk = null;
                    String hp = null;
                    try {
                        bk = msg.getStringProperty("JMQBrokerID");
                        hp = msg.getStringProperty("JMQMQAddress");
                    }
                    catch (Exception brokerIDFromList) {
                        // empty catch block
                    }
                    bk = bk != null ? (String)bk + (String)(hp == null ? "" : "[" + hp + "]") : "";
                    String st = null;
                    if (status >= 0) {
                        st = Status.getString(status);
                    }
                    if (st == null) {
                        if (partition == null) {
                            Globals.stdErrPrintln(this.ar.getString("A1813", bk));
                        } else {
                            Globals.stdErrPrintln(this.ar.getString("A1820", partition, brokerID));
                        }
                    } else if (partition == null) {
                        Globals.stdErrPrintln(this.ar.getString("A1814", bk, st));
                    } else {
                        Object[] args = new Object[]{partition, brokerID, st};
                        Globals.stdErrPrintln(this.ar.getString("A1821", args));
                    }
                    return 1;
                }
            } else {
                if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                    if (partition == null) {
                        Globals.stdOutPrintln(this.ar.getString("A1811"));
                    } else {
                        Globals.stdOutPrintln(this.ar.getString("A1822", partition, brokerID));
                    }
                    return 0;
                }
                Globals.stdOutPrintln(this.ar.getString("A1026", input));
                Globals.stdOutPrintln("");
                if (partition == null) {
                    Globals.stdOutPrintln(this.ar.getString("A1811"));
                } else {
                    Globals.stdOutPrintln(this.ar.getString("A1822", partition, brokerID));
                }
                return 1;
            }
        }
        return 0;
    }

    private int runExists(BrokerCmdProperties brokerCmdProps) {
        int retValue = 1;
        BrokerAdmin broker = this.init();
        String commandArg = brokerCmdProps.getCommandArg();
        if ("dst".equals(commandArg)) {
            if (broker == null) {
                Globals.stdOutPrintln("Problems connecting to the broker.");
                return 1;
            }
            boolean force = brokerCmdProps.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            String destName = brokerCmdProps.getTargetName();
            int destTypeMask = this.getDestTypeMask(brokerCmdProps);
            try {
                this.connectToBroker(broker);
                broker.sendGetDestinationsMessage(destName, destTypeMask);
                Vector dest = broker.receiveGetDestinationsReplyMessage();
                if (dest == null || dest.size() != 1) {
                    Globals.stdErrPrintln("Problems retrieving the destination info.");
                    return 1;
                }
                Globals.stdOutPrintln(Boolean.TRUE.toString());
                retValue = 0;
            }
            catch (BrokerAdminException bae) {
                if (bae.getReplyStatus() == 404) {
                    Globals.stdOutPrintln(Boolean.FALSE.toString());
                    retValue = 0;
                }
                this.handleBrokerAdminException(bae);
                return 1;
            }
        }
        return retValue;
    }

    public List runGetAttrWithReturnResult(BrokerCmdProperties brokerCmdProps) {
        ArrayList result = new ArrayList();
        int ret = this.runGetAttr(brokerCmdProps, result);
        if (ret != 0 || result.isEmpty()) {
            return null;
        }
        return result;
    }

    private int runGetAttr(BrokerCmdProperties brokerCmdProps) {
        return this.runGetAttr(brokerCmdProps, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runGetAttr(BrokerCmdProperties brokerCmdProps, List result) {
        int retValue = 1;
        BrokerAdmin broker = this.init();
        try {
            String commandArg = brokerCmdProps.getCommandArg();
            if ("dst".equals(commandArg)) {
                block106: {
                    block105: {
                        if (broker == null) {
                            Globals.stdOutPrintln("Problems connecting to the broker.");
                            retValue = 1;
                            int n = 1;
                            return n;
                        }
                        boolean force = brokerCmdProps.forceModeSet();
                        if (!force) {
                            broker = this.promptForAuthentication(broker);
                        }
                        String destName = brokerCmdProps.getTargetName();
                        int destTypeMask = this.getDestTypeMask(brokerCmdProps);
                        String attrName = brokerCmdProps.getSingleTargetAttr();
                        try {
                            this.connectToBroker(broker);
                            broker.sendGetDestinationsMessage(destName, destTypeMask);
                            Vector dest = broker.receiveGetDestinationsReplyMessage();
                            if (dest == null || dest.size() != 1) break block105;
                            Enumeration thisEnum = dest.elements();
                            DestinationInfo dInfo = (DestinationInfo)thisEnum.nextElement();
                            if ("maxTotalMsgBytes".equals(attrName)) {
                                Globals.stdOutPrintln(Long.toString(dInfo.maxMessageBytes));
                                retValue = 0;
                                break block106;
                            }
                            if ("maxNumMsgs".equals(attrName)) {
                                Globals.stdOutPrintln(Integer.toString(dInfo.maxMessages));
                                retValue = 0;
                                break block106;
                            }
                            if ("maxBytesPerMsg".equals(attrName)) {
                                Globals.stdOutPrintln(Long.toString(dInfo.maxMessageSize));
                                retValue = 0;
                                break block106;
                            }
                            if ("curTotalMsgBytes".equals(attrName)) {
                                Globals.stdOutPrintln(Long.toString(dInfo.nMessageBytes));
                                retValue = 0;
                                break block106;
                            }
                            if ("curNumMsgs".equals(attrName)) {
                                String val = Integer.toString(dInfo.nMessages);
                                Globals.stdOutPrintln(val);
                                if (result != null) {
                                    result.add(val);
                                }
                                retValue = 0;
                                break block106;
                            }
                            if ("curNumUnackMsgs".equals(attrName)) {
                                String val = Integer.toString(dInfo.nUnackMessages);
                                Globals.stdOutPrintln(val);
                                if (result != null) {
                                    result.add(val);
                                }
                                retValue = 0;
                                break block106;
                            }
                            if ("curNumProducers".equals(attrName)) {
                                Globals.stdOutPrintln(Integer.toString(dInfo.nProducers));
                                retValue = 0;
                                break block106;
                            }
                            if ("maxNumBackupConsumers".equals(attrName)) {
                                Globals.stdOutPrintln(Integer.toString(dInfo.maxFailoverConsumers));
                                retValue = 0;
                                break block106;
                            }
                            if ("maxNumActiveConsumers".equals(attrName)) {
                                Globals.stdOutPrintln(Integer.toString(dInfo.maxActiveConsumers));
                                retValue = 0;
                                break block106;
                            }
                            if ("isLocalOnly".equals(attrName)) {
                                if (dInfo.isDestinationLocal()) {
                                    Globals.stdOutPrintln(Boolean.TRUE.toString());
                                } else {
                                    Globals.stdOutPrintln(Boolean.FALSE.toString());
                                }
                                retValue = 0;
                                break block106;
                            }
                            if ("limitBehavior".equals(attrName)) {
                                Globals.stdOutPrintln(DestLimitBehavior.getString(dInfo.destLimitBehavior));
                                retValue = 0;
                                break block106;
                            }
                            if ("localDeliveryPreferred".equals(attrName)) {
                                int cdp = dInfo.destCDP;
                                if (cdp == 1) {
                                    Globals.stdOutPrintln(Boolean.TRUE.toString());
                                } else {
                                    Globals.stdOutPrintln(Boolean.FALSE.toString());
                                }
                                retValue = 0;
                                break block106;
                            }
                            if ("consumerFlowLimit".equals(attrName)) {
                                Globals.stdOutPrintln(Integer.toString(dInfo.maxPrefetch));
                                retValue = 0;
                                break block106;
                            }
                            if ("maxNumProducers".equals(attrName)) {
                                Globals.stdOutPrintln(Integer.toString(dInfo.maxProducers));
                                retValue = 0;
                                break block106;
                            }
                            if ("curNumActiveConsumers".equals(attrName)) {
                                String val = null;
                                if (DestType.isQueue(destTypeMask)) {
                                    val = Integer.toString(dInfo.naConsumers);
                                    Globals.stdOutPrintln(val);
                                } else {
                                    val = Integer.toString(dInfo.nConsumers);
                                    Globals.stdOutPrintln(val);
                                }
                                if (result != null) {
                                    result.add(val);
                                }
                                retValue = 0;
                                break block106;
                            }
                            if ("curNumBackupConsumers".equals(attrName)) {
                                Globals.stdOutPrintln(Integer.toString(dInfo.nfConsumers));
                                retValue = 0;
                                break block106;
                            }
                            if ("useDMQ".equals(attrName)) {
                                Globals.stdOutPrintln(Boolean.toString(dInfo.useDMQ()));
                                retValue = 0;
                                break block106;
                            }
                            if ("validateXMLSchemaEnabled".equals(attrName)) {
                                Globals.stdOutPrintln(Boolean.toString(dInfo.validateXMLSchemaEnabled()));
                                retValue = 0;
                                break block106;
                            }
                            if ("XMLSchemaURIList".equals(attrName)) {
                                Globals.stdOutPrintln(dInfo.XMLSchemaUriList);
                                retValue = 0;
                                break block106;
                            }
                            if ("reloadXMLSchemaOnFailure".equals(attrName)) {
                                Globals.stdOutPrintln(Boolean.toString(dInfo.reloadXMLSchemaOnFailure()));
                                retValue = 0;
                                break block106;
                            }
                            Globals.stdErrPrintln(attrName + " is not recognized.");
                            retValue = 1;
                            int val = 1;
                            return val;
                        }
                        catch (BrokerAdminException bae) {
                            this.handleBrokerAdminException(bae);
                            retValue = 1;
                            int thisEnum = 1;
                            return thisEnum;
                        }
                    }
                    Globals.stdErrPrintln("Problems retrieving the destination info.");
                    retValue = 1;
                    int thisEnum = 1;
                    return thisEnum;
                }
                int bae = retValue;
                return bae;
            }
            if ("svc".equals(commandArg)) {
                block108: {
                    block107: {
                        if (broker == null) {
                            Globals.stdOutPrintln("Problems connecting to the broker.");
                            int force = 1;
                            return force;
                        }
                        boolean force = brokerCmdProps.forceModeSet();
                        if (!force) {
                            broker = this.promptForAuthentication(broker);
                        }
                        String svcName = brokerCmdProps.getTargetName();
                        String attrName = brokerCmdProps.getSingleTargetAttr();
                        try {
                            this.connectToBroker(broker);
                            broker.sendGetServicesMessage(svcName);
                            Vector svc = broker.receiveGetServicesReplyMessage();
                            if (svc == null || svc.size() != 1) break block107;
                            Enumeration thisEnum = svc.elements();
                            ServiceInfo sInfo = (ServiceInfo)thisEnum.nextElement();
                            if ("port".equals(attrName)) {
                                Globals.stdOutPrintln(Integer.toString(sInfo.port));
                                retValue = 0;
                                break block108;
                            }
                            if ("minThreads".equals(attrName)) {
                                Globals.stdOutPrintln(Integer.toString(sInfo.minThreads));
                                retValue = 0;
                                break block108;
                            }
                            if ("maxThreads".equals(attrName)) {
                                Globals.stdOutPrintln(Integer.toString(sInfo.maxThreads));
                                retValue = 0;
                                break block108;
                            }
                            Globals.stdOutPrintln(attrName + " is not recognized.");
                            retValue = 1;
                            int dInfo = 1;
                            return dInfo;
                        }
                        catch (BrokerAdminException bae) {
                            this.handleBrokerAdminException(bae);
                            retValue = 1;
                            int thisEnum = 1;
                            return thisEnum;
                        }
                    }
                    Globals.stdOutPrintln("Problems retrieving the service info.");
                    retValue = 1;
                    int thisEnum = 1;
                    return thisEnum;
                }
                int bae = retValue;
                return bae;
            }
            if ("bkr".equals(commandArg)) {
                Properties bkrProps;
                String attrName;
                block109: {
                    if (broker == null) {
                        Globals.stdOutPrintln("Problems connecting to the broker.");
                        retValue = 1;
                        int force = 1;
                        return force;
                    }
                    boolean force = brokerCmdProps.forceModeSet();
                    if (!force) {
                        broker = this.promptForAuthentication(broker);
                    }
                    attrName = brokerCmdProps.getSingleTargetAttr();
                    try {
                        this.connectToBroker(broker);
                        broker.sendGetBrokerPropsMessage();
                        bkrProps = broker.receiveGetBrokerPropsReplyMessage();
                        if (bkrProps != null) break block109;
                        Globals.stdOutPrintln("Problems retrieving the broker info.");
                        retValue = 1;
                        int bae = 1;
                        return bae;
                    }
                    catch (BrokerAdminException bae) {
                        this.handleBrokerAdminException(bae);
                        retValue = 1;
                        int value = 1;
                        if (broker != null) {
                            if (retValue == 1) {
                                broker.forceClose();
                            } else {
                                broker.close();
                            }
                        }
                        return value;
                    }
                }
                String value = bkrProps.getProperty(attrName, "");
                Globals.stdOutPrintln(value);
                retValue = 0;
            }
            if ("dur".equals(commandArg)) {
                DurableInfo dinfo;
                String destName = brokerCmdProps.getDestName();
                String subName = brokerCmdProps.getTargetName();
                String clientID = brokerCmdProps.getClientID();
                String attrName = brokerCmdProps.getSingleTargetAttr();
                if (!"curNumActiveConsumers".equals(attrName)) {
                    int thisEnum = 1;
                    return thisEnum;
                }
                if (broker == null) {
                    Globals.stdOutPrintln("Problems connecting to the broker.");
                    retValue = 1;
                    int thisEnum = 1;
                    return thisEnum;
                }
                boolean force = brokerCmdProps.forceModeSet();
                if (!force) {
                    broker = this.promptForAuthentication(broker);
                }
                try {
                    this.connectToBroker(broker);
                    if (destName != null) {
                        this.isDestTypeTopic(broker, destName);
                    }
                    broker.sendGetDurablesMessage(destName, null);
                    Vector durs = broker.receiveGetDurablesReplyMessage();
                    retValue = 1;
                    Enumeration thisEnum = durs.elements();
                    while (thisEnum.hasMoreElements()) {
                        dinfo = (DurableInfo)thisEnum.nextElement();
                        if (subName != null) {
                            if (!dinfo.name.equals(subName)) continue;
                            String val = null;
                            if (clientID != null && clientID.equals(dinfo.clientID)) {
                                val = Integer.toString(dinfo.activeCount);
                                Globals.stdOutPrintln(val);
                            } else {
                                val = Integer.toString(dinfo.activeCount);
                                Globals.stdOutPrintln(val);
                            }
                            if (result != null) {
                                result.add(val);
                            }
                            int n = 0;
                            return n;
                        }
                        if (destName == null || dinfo.consumer == null || !destName.equals(dinfo.consumer.destination)) continue;
                        if (clientID == null || !clientID.equals(dinfo.clientID)) break block110;
                    }
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    int n = 1;
                    return n;
                }
                {
                    block110: {
                        Globals.stdOutPrintln(Integer.toString(dinfo.activeCount));
                        int n = 0;
                        return n;
                    }
                    Globals.stdOutPrintln(Integer.toString(dinfo.activeCount));
                    int n = 0;
                    return n;
                }
                Globals.stdErrPrintln("Subscription not found.");
                int n = 1;
                return n;
            }
            if ("txn".equals(commandArg)) {
                String attrName = brokerCmdProps.getSingleTargetAttr();
                if (broker == null) {
                    Globals.stdOutPrintln("Problems connecting to the broker.");
                    retValue = 1;
                    int subName = 1;
                    return subName;
                }
                boolean force = brokerCmdProps.forceModeSet();
                if (!force) {
                    broker = this.promptForAuthentication(broker);
                }
                try {
                    this.connectToBroker(broker);
                    broker.sendGetTxnsMessage(brokerCmdProps.showPartitionModeSet());
                    Vector txns = broker.receiveGetTxnsReplyMessage();
                    if (txns == null) {
                        throw new BrokerAdminException(6);
                    }
                    if ("curNumTxns".equals(attrName)) {
                        String val = String.valueOf(txns.size());
                        Globals.stdOutPrintln(val);
                        if (result != null) {
                            result.add(val);
                        }
                        retValue = 0;
                    } else if ("allTxns".equals(attrName)) {
                        Globals.stdOutPrintln(txns.toString());
                        if (result != null) {
                            result.addAll(txns);
                        }
                        retValue = 0;
                    }
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    int n = 1;
                    if (broker != null) {
                        if (retValue == 1) {
                            broker.forceClose();
                        } else {
                            broker.close();
                        }
                    }
                    return n;
                }
            }
            int n = retValue;
            return n;
        }
        finally {
            if (broker != null) {
                if (retValue == 1) {
                    broker.forceClose();
                } else {
                    broker.close();
                }
            }
        }
    }

    private int runUngracefulKill(BrokerCmdProperties brokerCmdProps) {
        BrokerAdmin broker = this.init();
        if (broker == null) {
            Globals.stdOutPrintln("Problems connecting to the broker.");
            return 1;
        }
        boolean force = brokerCmdProps.forceModeSet();
        if (!force) {
            broker = this.promptForAuthentication(broker);
        }
        try {
            this.connectToBroker(broker);
            broker.sendShutdownMessage(false, true);
            Globals.stdOutPrintln("Ungracefully shutdown the broker.");
            return 0;
        }
        catch (BrokerAdminException bae) {
            this.handleBrokerAdminException(bae);
            return 1;
        }
    }

    private int runDebug(BrokerCmdProperties brokerCmdProps) {
        Hashtable debugHash = null;
        Properties optionalProps = null;
        BrokerAdmin broker = this.init();
        if (broker == null) {
            Globals.stdOutPrintln("Problems connecting to the broker.");
            return 1;
        }
        boolean force = brokerCmdProps.forceModeSet();
        if (!force) {
            broker = this.promptForAuthentication(broker);
        }
        String cmd = brokerCmdProps.getCommand();
        String cmdarg = brokerCmdProps.getCommandArg();
        String target = brokerCmdProps.getTargetName();
        String targetType = brokerCmdProps.getDestType();
        optionalProps = brokerCmdProps.getTargetAttrs();
        Globals.stdOutPrintln("Sending the following DEBUG message:");
        BrokerCmdPrinter bcp = new BrokerCmdPrinter(2, 4, "-", 0, false);
        Object[] row = new String[]{"Header Property Name", "Value"};
        bcp.addTitle((String[])row);
        row[0] = "JMQCommand";
        row[1] = cmd;
        bcp.add(row);
        row[0] = "JMQCommandArg";
        row[1] = cmdarg;
        bcp.add(row);
        if (target != null) {
            row[0] = "JMQTarget";
            row[1] = target;
            bcp.add(row);
        }
        if (targetType != null) {
            row[0] = "JMQTargetType";
            row[1] = targetType;
            bcp.add(row);
        }
        bcp.println();
        if (optionalProps != null && optionalProps.size() > 0) {
            Globals.stdOutPrintln("Optional properties:");
            this.printAttrs(optionalProps, true);
        }
        Globals.stdOutPrintln("To the broker specified by:");
        this.printBrokerInfo(broker);
        try {
            this.connectToBroker(broker);
            broker.sendDebugMessage(cmd, cmdarg, target, targetType, optionalProps);
            debugHash = broker.receiveDebugReplyMessage();
            if (debugHash != null && !debugHash.isEmpty()) {
                Globals.stdOutPrintln("Data received back from broker:");
                CommonCmdRunnerUtil.printDebugHash(debugHash);
            } else {
                Globals.stdOutPrintln("No additional data received back from broker.\n");
            }
            Globals.stdOutPrintln("DEBUG message sent successfully.");
            return 0;
        }
        catch (BrokerAdminException bae) {
            this.handleBrokerAdminException(bae);
            return 1;
        }
    }

    private void printAllBrokerAttrs(Properties bkrProps) {
        BrokerCmdPrinter bcp = new BrokerCmdPrinter(2, 4);
        Object[] row = new String[2];
        Enumeration<?> e = bkrProps.propertyNames();
        while (e.hasMoreElements()) {
            String curPropName;
            row[0] = curPropName = (String)e.nextElement();
            row[1] = bkrProps.getProperty(curPropName, "");
            bcp.add(row);
        }
        bcp.println();
    }

    private void printDisplayableBrokerAttrs(Properties bkrProps) {
        BrokerCmdPrinter bcp = new BrokerCmdPrinter(2, 4);
        Object[] row = new String[2];
        bcp.setSortNeeded(false);
        row[0] = this.ar.getString("A1626");
        String value = bkrProps.getProperty("imq.product.version", "");
        if (value.equals("")) {
            value = this.ar.getString("A1627");
        }
        row[1] = value;
        bcp.add(row);
        row[0] = this.ar.getString("A1525");
        value = bkrProps.getProperty("imq.instancename", "");
        row[1] = value;
        bcp.add(row);
        row[0] = this.ar.getString("A1711");
        value = bkrProps.getProperty("imq.brokerid", "");
        row[1] = value;
        bcp.add(row);
        row[0] = this.ar.getString("A1441");
        value = bkrProps.getProperty("imq.portmapper.port", "");
        row[1] = value;
        bcp.add(row);
        row[0] = this.ar.getString("A1733");
        value = bkrProps.getProperty("imq.embedded", "");
        row[1] = value;
        bcp.add(row);
        row[0] = this.ar.getString("A1763");
        value = bkrProps.getProperty("imq.varhome", "");
        row[1] = value;
        bcp.add(row);
        row[0] = "";
        row[1] = "";
        bcp.add(row);
        row[0] = this.ar.getString("A1628");
        value = bkrProps.getProperty("imq.system.current_count", "");
        row[1] = value;
        bcp.add(row);
        row[0] = this.ar.getString("A1629");
        value = bkrProps.getProperty("imq.system.current_size", "");
        row[1] = value;
        bcp.add(row);
        row[0] = "";
        row[1] = "";
        bcp.add(row);
        row[0] = this.ar.getString("A1684");
        value = bkrProps.getProperty("imq.dmq.current_count", "");
        row[1] = value;
        bcp.add(row);
        row[0] = this.ar.getString("A1685");
        value = bkrProps.getProperty("imq.dmq.current_size", "");
        row[1] = value;
        bcp.add(row);
        row[0] = "";
        row[1] = "";
        bcp.add(row);
        row[0] = this.ar.getString("A1683");
        value = bkrProps.getProperty("imq.destination.logDeadMsgs", "");
        row[1] = value;
        bcp.add(row);
        row[0] = this.ar.getString("A1686");
        value = bkrProps.getProperty("imq.destination.DMQ.truncateBody", "");
        row[1] = value;
        bcp.add(row);
        row[0] = "";
        row[1] = "";
        bcp.add(row);
        row[0] = this.ar.getString("A1534");
        value = bkrProps.getProperty("imq.system.max_count", "");
        row[1] = this.checkAndPrintUnlimited(value, this.zeroNegOneString);
        bcp.add(row);
        row[0] = this.ar.getString("A1535");
        value = bkrProps.getProperty("imq.system.max_size", "");
        row[1] = this.checkAndPrintUnlimitedBytes(value, this.zeroNegOneLong);
        bcp.add(row);
        row[0] = this.ar.getString("A1536");
        value = bkrProps.getProperty("imq.message.max_size", "");
        row[1] = this.checkAndPrintUnlimitedBytes(value, this.zeroNegOneLong);
        bcp.add(row);
        row[0] = "";
        row[1] = "";
        bcp.add(row);
        row[0] = this.ar.getString("A1527");
        value = bkrProps.getProperty("imq.autocreate.queue", "");
        row[1] = value;
        bcp.add(row);
        row[0] = this.ar.getString("A1526");
        value = bkrProps.getProperty("imq.autocreate.topic", "");
        row[1] = value;
        bcp.add(row);
        row[0] = this.ar.getString("A1654");
        value = bkrProps.getProperty("imq.autocreate.queue.maxNumActiveConsumers", "");
        row[1] = this.checkAndPrintUnlimited(value, this.negOneString);
        bcp.add(row);
        row[0] = this.ar.getString("A1655");
        value = bkrProps.getProperty("imq.autocreate.queue.maxNumBackupConsumers", "");
        row[1] = this.checkAndPrintUnlimited(value, this.negOneString);
        bcp.add(row);
        row[0] = this.ar.getString("A1785");
        value = bkrProps.getProperty("imq.autocreate.destination.useDMQ", "");
        row[1] = value;
        bcp.add(row);
        row[0] = "";
        row[1] = "";
        bcp.add(row);
        row[0] = this.ar.getString("A1709");
        value = bkrProps.getProperty("imq.cluster.clusterid", "");
        row[1] = value;
        bcp.add(row);
        row[0] = this.ar.getString("A1710");
        value = bkrProps.getProperty("imq.cluster.ha");
        row[1] = String.valueOf(value);
        bcp.add(row);
        row[0] = this.ar.getString("A1573");
        value = bkrProps.getProperty("imq.cluster.brokerlist.active", "");
        row[1] = value;
        bcp.add(row);
        row[0] = this.ar.getString("A1572");
        value = bkrProps.getProperty("imq.cluster.brokerlist", "");
        row[1] = value;
        bcp.add(row);
        row[0] = this.ar.getString("A1574");
        value = bkrProps.getProperty("imq.cluster.masterbroker", "");
        row[1] = value;
        bcp.add(row);
        row[0] = this.ar.getString("A1575");
        value = bkrProps.getProperty("imq.cluster.url", "");
        row[1] = value;
        bcp.add(row);
        row[0] = "";
        row[1] = "";
        bcp.add(row);
        row[0] = this.ar.getString("A1528");
        value = bkrProps.getProperty(".level", "");
        row[1] = value;
        bcp.add(row);
        row[0] = this.ar.getString("A1530");
        value = bkrProps.getProperty("imq.log.file.rolloversecs", "");
        row[1] = this.checkAndPrintUnlimited(value, this.zeroNegOneString);
        bcp.add(row);
        row[0] = this.ar.getString("A1529");
        value = bkrProps.getProperty("java.util.logging.FileHandler.limit", "");
        row[1] = this.checkAndPrintUnlimitedBytes(value, this.zeroNegOneLong);
        bcp.add(row);
        bcp.println();
    }

    private void printAllTxnAttrs(Hashtable txnInfo) {
        BrokerCmdPrinter bcp = new BrokerCmdPrinter(2, 4);
        Object[] row = new String[2];
        Enumeration e = txnInfo.keys();
        while (e.hasMoreElements()) {
            String curPropName;
            row[0] = curPropName = (String)e.nextElement();
            Object tmpObj = txnInfo.get(curPropName);
            row[1] = tmpObj.toString();
            bcp.add(row);
        }
        bcp.println();
    }

    private void printDisplayableTxnAttrs(Hashtable txnInfo) {
        BrokerCmdPrinter bcp = new BrokerCmdPrinter(2, 4);
        Object[] row = new String[2];
        row[0] = this.ar.getString("A1263");
        String tmpStr = (String)txnInfo.get("txnid");
        row[1] = this.checkNullAndPrint(tmpStr);
        bcp.add(row);
        row[0] = this.ar.getString("A1269");
        Integer tmpInt = (Integer)txnInfo.get("state");
        row[1] = this.getTxnStateString(tmpInt);
        bcp.add(row);
        row[0] = this.ar.getString("A1268");
        tmpInt = (Integer)txnInfo.get("nmsgs");
        row[1] = this.checkNullAndPrint(tmpInt);
        bcp.add(row);
        row[0] = this.ar.getString("A1267");
        tmpInt = (Integer)txnInfo.get("nacks");
        row[1] = this.checkNullAndPrint(tmpInt);
        bcp.add(row);
        row[0] = this.ar.getString("A1264");
        tmpStr = (String)txnInfo.get("clientid");
        row[1] = this.checkNullAndPrint(tmpStr);
        bcp.add(row);
        row[0] = this.ar.getString("A1266");
        Long tmpLong = (Long)txnInfo.get("timestamp");
        row[1] = this.checkNullAndPrintTimestamp(tmpLong);
        bcp.add(row);
        row[0] = this.ar.getString("A1265");
        tmpStr = (String)txnInfo.get("connection");
        row[1] = this.checkNullAndPrint(tmpStr);
        bcp.add(row);
        row[0] = this.ar.getString("A1277");
        tmpLong = (Long)txnInfo.get("connectionid");
        row[1] = this.checkNullAndPrint(tmpLong);
        bcp.add(row);
        row[0] = this.ar.getString("A1270");
        tmpStr = (String)txnInfo.get("user");
        row[1] = this.checkNullAndPrint(tmpStr);
        bcp.add(row);
        row[0] = this.ar.getString("A1271");
        tmpStr = (String)txnInfo.get("xid");
        row[1] = this.checkNullAndPrint(tmpStr);
        bcp.add(row);
        bcp.println();
    }

    private void printAllCxnAttrs(Hashtable cxnInfo) {
        BrokerCmdPrinter bcp = new BrokerCmdPrinter(2, 4);
        Object[] row = new String[2];
        Enumeration e = cxnInfo.keys();
        while (e.hasMoreElements()) {
            String curPropName;
            row[0] = curPropName = (String)e.nextElement();
            Object tmpObj = cxnInfo.get(curPropName);
            row[1] = tmpObj.toString();
            bcp.add(row);
        }
        bcp.println();
    }

    private void printDisplayableCxnAttrs(Hashtable cxnInfo) {
        BrokerCmdPrinter bcp = new BrokerCmdPrinter(2, 4);
        Object[] row = new String[2];
        bcp.setSortNeeded(false);
        row[0] = this.ar.getString("A1323");
        Long tmpLong = (Long)cxnInfo.get("cxnid");
        row[1] = this.checkNullAndPrint(tmpLong);
        bcp.add(row);
        row[0] = this.ar.getString("A1327");
        String tmpStr = (String)cxnInfo.get("user");
        row[1] = this.checkNullAndPrint(tmpStr);
        bcp.add(row);
        row[0] = this.ar.getString("A1331");
        tmpStr = (String)cxnInfo.get("service");
        row[1] = this.checkNullAndPrint(tmpStr);
        bcp.add(row);
        row[0] = this.ar.getString("A1328");
        Integer tmpInt = (Integer)cxnInfo.get("nproducers");
        row[1] = this.checkNullAndPrint(tmpInt);
        bcp.add(row);
        row[0] = this.ar.getString("A1329");
        tmpInt = (Integer)cxnInfo.get("nconsumers");
        row[1] = this.checkNullAndPrint(tmpInt);
        bcp.add(row);
        row[0] = this.ar.getString("A1325");
        tmpStr = (String)cxnInfo.get("host");
        row[1] = this.checkNullAndPrint(tmpStr);
        bcp.add(row);
        row[0] = this.ar.getString("A1326");
        tmpInt = (Integer)cxnInfo.get("port");
        row[1] = this.checkNullAndPrint(tmpInt);
        bcp.add(row);
        row[0] = this.ar.getString("A1324");
        tmpStr = (String)cxnInfo.get("clientid");
        row[1] = this.checkNullAndPrint(tmpStr);
        bcp.add(row);
        row[0] = this.ar.getString("A1330");
        tmpStr = (String)cxnInfo.get("clientplatform");
        row[1] = this.checkNullAndPrint(tmpStr);
        bcp.add(row);
        bcp.println();
    }

    private void printDisplayableMsgAttrs(HashMap oneMsg) {
        BrokerCmdPrinter bcp = new BrokerCmdPrinter(2, 4);
        BrokerCmdPrinter titleBcp = new BrokerCmdPrinter(1, 0, "-");
        Object[] row = new String[2];
        String[] titleRow = new String[1];
        bcp.setSortNeeded(false);
        titleRow[0] = "Message Header Information";
        titleBcp.addTitle(titleRow);
        titleBcp.print();
        row[0] = "Message ID";
        row[1] = this.checkNullAndPrint(oneMsg.get("MessageID"));
        bcp.add(row);
        row[0] = "Correlation ID";
        row[1] = this.checkNullAndPrint(oneMsg.get("CorrelationID"));
        bcp.add(row);
        row[0] = "Destination Name";
        row[1] = this.checkNullAndPrint(oneMsg.get("DestinationName"));
        bcp.add(row);
        row[0] = "Destination Type";
        Integer tmpInt = (Integer)oneMsg.get("DestinationType");
        row[1] = BrokerAdminUtil.getDestinationType(tmpInt);
        bcp.add(row);
        row[0] = "Delivery Mode";
        tmpInt = (Integer)oneMsg.get("DeliveryMode");
        row[1] = this.checkNullAndPrintDeliveryMode(tmpInt);
        bcp.add(row);
        row[0] = "Priority";
        row[1] = this.checkNullAndPrint(oneMsg.get("Priority"));
        bcp.add(row);
        row[0] = "Redelivered";
        row[1] = this.checkNullAndPrint(oneMsg.get("Redelivered"));
        bcp.add(row);
        row[0] = "Timestamp";
        row[1] = this.checkNullAndPrintTimestamp((Long)oneMsg.get("Timestamp"));
        bcp.add(row);
        row[0] = "Type";
        row[1] = this.checkNullAndPrint(oneMsg.get("Type"));
        bcp.add(row);
        row[0] = "Expiration";
        row[1] = this.checkNullAndPrintTimestamp((Long)oneMsg.get("Expiration"));
        bcp.add(row);
        row[0] = "ReplyTo Destination Name";
        row[1] = this.checkNullAndPrint(oneMsg.get("ReplyToDestinationName"));
        bcp.add(row);
        row[0] = "ReplyTo Destination Type";
        tmpInt = (Integer)oneMsg.get("ReplyToDestinationType");
        row[1] = tmpInt != null ? BrokerAdminUtil.getDestinationType(tmpInt) : "";
        bcp.add(row);
        bcp.println();
        titleBcp.clear();
        titleBcp.clearTitle();
        titleRow[0] = "Message Properties Information";
        titleBcp.addTitle(titleRow);
        titleBcp.print();
        Hashtable props = (Hashtable)oneMsg.get("MessageProperties");
        if (props != null) {
            Enumeration keys = props.keys();
            bcp.clear();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                Object val = props.get(key);
                row[0] = key;
                row[1] = val.toString();
                bcp.add(row);
            }
            bcp.println();
        } else {
            Globals.stdOutPrintln("");
        }
        titleBcp.clear();
        titleBcp.clearTitle();
        titleRow[0] = "Message Body Information";
        titleBcp.addTitle(titleRow);
        titleBcp.print();
        bcp.clear();
        row[0] = "Body Type";
        row[1] = this.checkNullAndPrintMsgBodyType((Integer)oneMsg.get("MessageBodyType"), true);
        bcp.add(row);
        bcp.println();
    }

    private int getDestTypeMask(BrokerCmdProperties brokerCmdProps) {
        Properties props = brokerCmdProps.getTargetAttrs();
        String destType = brokerCmdProps.getDestType();
        int mask = 0;
        if (destType == null || destType.equals("")) {
            return -1;
        }
        if (destType.equals("t")) {
            mask = 2;
        } else if (destType.equals("q")) {
            mask = 1;
        }
        if (props == null || props.isEmpty()) {
            return mask;
        }
        String flavour = props.getProperty("queueDeliveryPolicy");
        if (flavour == null) {
            return mask;
        }
        if (flavour.equals("s")) {
            mask |= 0x100;
        } else if (flavour.equals("f")) {
            mask |= 0x400;
        } else if (flavour.equals("r")) {
            mask |= 0x200;
        }
        return mask;
    }

    private BrokerAdmin init() {
        BrokerAdmin broker;
        String brokerHostPort = this.brokerCmdProps.getBrokerHostPort();
        String adminUser = this.brokerCmdProps.getAdminUserId();
        int numRetries = this.brokerCmdProps.getNumRetries();
        int receiveTimeout = this.brokerCmdProps.getReceiveTimeout();
        boolean adminKeyUsed = this.brokerCmdProps.isAdminKeyUsed();
        boolean useSSL = this.brokerCmdProps.useSSLTransportSet();
        if (this.brokerCmdProps.adminDebugModeSet()) {
            BrokerAdmin.setDebug(true);
        }
        try {
            String adminPasswd = this.getPasswordFromFileOrCmdLine(this.brokerCmdProps);
            broker = new BrokerAdmin(brokerHostPort, adminUser, adminPasswd, receiveTimeout * 1000, useSSL);
            if (adminKeyUsed) {
                broker.setAdminKeyUsed(true);
            }
            if (useSSL) {
                broker.setSSLTransportUsed(true);
            }
            if (numRetries > 0) {
                broker.setNumRetries(numRetries);
            }
        }
        catch (CommonCmdException bce) {
            this.handleBrokerCmdException(bce);
            return null;
        }
        catch (BrokerAdminException bae) {
            this.handleBrokerAdminException(bae);
            return null;
        }
        broker.addAdminEventListener(this);
        return broker;
    }

    private void connectToBroker(BrokerAdmin broker) throws BrokerAdminException {
        broker.connect();
        broker.sendHelloMessage();
        broker.receiveHelloReplyMessage();
    }

    private void handleBrokerAdminException(BrokerAdminException bae) {
        CommonCmdRunnerUtil.printBrokerAdminException(bae, "-b", this.brokerCmdProps.debugModeSet());
    }

    private void handleBrokerCmdException(CommonCmdException bce) {
        CommonCmdRunnerUtil.printCommonCmdException(bce);
    }

    private void printBrokerInfo(BrokerAdmin broker) {
        CommonCmdRunnerUtil.printBrokerInfo(broker, new BrokerCmdPrinter());
    }

    private void printServiceInfo() {
        this.printServiceInfo(null);
    }

    private void printServiceInfo(String svcName) {
        BrokerCmdPrinter bcp = new BrokerCmdPrinter(1, 4, "-");
        Object[] row = new String[1];
        row[0] = this.ar.getString("A1420");
        bcp.addTitle((String[])row);
        row[0] = svcName == null ? this.brokerCmdProps.getTargetName() : svcName;
        bcp.add(row);
        bcp.println();
    }

    private void printMessageInfo() {
        BrokerCmdPrinter bcp = new BrokerCmdPrinter(1, 4, "-");
        Object[] row = new String[]{"Message ID"};
        bcp.addTitle((String[])row);
        row[0] = this.brokerCmdProps.getMsgID();
        bcp.add(row);
        bcp.println();
    }

    private void printDestinationInfo() {
        BrokerCmdPrinter bcp = new BrokerCmdPrinter(2, 4, "-");
        Object[] row = new String[2];
        row[0] = this.ar.getString("A1400");
        row[1] = this.ar.getString("A1401");
        bcp.addTitle((String[])row);
        row[0] = this.brokerCmdProps.getTargetName();
        row[1] = BrokerAdminUtil.getDestinationType(this.getDestTypeMask(this.brokerCmdProps));
        bcp.add(row);
        bcp.println();
    }

    private void printDurableSubscriptionInfo() {
        BrokerCmdPrinter bcp = new BrokerCmdPrinter(2, 4, "-");
        Object[] row = new String[2];
        row[0] = this.ar.getString("A1430");
        row[1] = this.ar.getString("A1431");
        bcp.addTitle((String[])row);
        row[0] = this.brokerCmdProps.getTargetName();
        row[1] = this.brokerCmdProps.getClientID();
        bcp.add(row);
        bcp.println();
    }

    private void printTransactionInfo() {
        BrokerCmdPrinter bcp = new BrokerCmdPrinter(1, 4, "-");
        Object[] row = new String[1];
        row[0] = this.ar.getString("A1263");
        bcp.addTitle((String[])row);
        row[0] = this.brokerCmdProps.getTargetName();
        bcp.add(row);
        bcp.println();
    }

    private void printConnectionInfo() {
        BrokerCmdPrinter bcp = new BrokerCmdPrinter(1, 4, "-");
        Object[] row = new String[1];
        row[0] = this.ar.getString("A1323");
        bcp.addTitle((String[])row);
        row[0] = this.brokerCmdProps.getTargetName();
        bcp.add(row);
        bcp.println();
    }

    private void isAdminService(BrokerAdmin broker, String svcName) throws BrokerAdminException {
        broker.sendGetServicesMessage(svcName);
        Vector svc = broker.receiveGetServicesReplyMessage();
        if (svc != null && svc.size() == 1) {
            Enumeration thisEnum = svc.elements();
            ServiceInfo sInfo = (ServiceInfo)thisEnum.nextElement();
            if (sInfo.type == 1) {
                throw new BrokerAdminException(7);
            }
        }
    }

    private void isDestTypeTopic(BrokerAdmin broker, String destName) throws BrokerAdminException {
        broker.sendGetDestinationsMessage(null, -1);
        Vector dests = broker.receiveGetDestinationsReplyMessage();
        boolean found = false;
        for (int i = 0; !found && i < dests.size(); ++i) {
            DestinationInfo dInfo = (DestinationInfo)dests.elementAt(i);
            if (!destName.equals(dInfo.name) || !DestType.isTopic(dInfo.type)) continue;
            found = true;
        }
        if (!found) {
            throw new BrokerAdminException(7);
        }
    }

    private String checkAndPrintUnlimitedInt(int value, int[] unlimitedValues) {
        Object ret = null;
        for (int i = 0; i < unlimitedValues.length; ++i) {
            if (value != unlimitedValues[i]) continue;
            ret = this.ar.getString("A1537") + " (-1)";
            break;
        }
        if (ret == null) {
            ret = Integer.toString(value);
        }
        return ret;
    }

    private String checkAndPrintUnlimitedInt(int value, int unlimitedValue) {
        Object ret = value == unlimitedValue ? this.ar.getString("A1537") + " (-1)" : Integer.toString(value);
        return ret;
    }

    private String checkAndPrintUnlimitedLong(long value, long[] unlimitedValues) {
        Object ret = null;
        for (int i = 0; i < unlimitedValues.length; ++i) {
            if (value != unlimitedValues[i]) continue;
            ret = this.ar.getString("A1537") + " (-1)";
            break;
        }
        if (ret == null) {
            ret = String.valueOf(value);
        }
        return ret;
    }

    private String checkAndPrintUnlimitedBytes(String s, long[] unlimitedValues) {
        SizeString ss;
        Object ret = null;
        String value = s.trim();
        try {
            ss = new SizeString(value);
        }
        catch (Exception e) {
            return value;
        }
        for (int i = 0; i < unlimitedValues.length; ++i) {
            if (ss.getBytes() != unlimitedValues[i]) continue;
            ret = this.ar.getString("A1537") + " (-1)";
            break;
        }
        if (ret == null) {
            ret = value;
        }
        return ret;
    }

    private String checkAndPrintUnlimited(String s, String[] unlimitedValues) {
        Object ret = null;
        String value = s.trim();
        for (int i = 0; i < unlimitedValues.length; ++i) {
            if (!value.equals(unlimitedValues[i])) continue;
            ret = this.ar.getString("A1537") + " (-1)";
            break;
        }
        if (ret == null) {
            ret = value;
        }
        return ret;
    }

    private String checkNullAndPrint(Object obj) {
        return CommonCmdRunnerUtil.checkNullAndReturnPrint(obj);
    }

    private String checkNullAndPrintTimestamp(Long timestamp) {
        return CommonCmdRunnerUtil.checkNullAndReturnPrintTimestamp(timestamp);
    }

    private int getMetricType(BrokerCmdProperties brokerCmdProps) {
        String s = brokerCmdProps.getMetricType();
        if (s == null) {
            return 0;
        }
        if (s.equals("ttl")) {
            return 0;
        }
        if (s.equals("rts")) {
            return 1;
        }
        if (s.equals("cxn")) {
            return 2;
        }
        if (s.equals("con")) {
            return 3;
        }
        if (s.equals("dsk")) {
            return 4;
        }
        if (s.equals("rem")) {
            return 5;
        }
        return 0;
    }

    private BrokerAdmin promptForAuthentication(BrokerAdmin broker) {
        return (BrokerAdmin)CommonCmdRunnerUtil.promptForAuthentication(broker);
    }

    private boolean reconnectToBroker(BrokerAdmin broker) {
        boolean connected = false;
        int count = 0;
        while (!connected && count < broker.getNumRetries()) {
            try {
                broker.connect();
                broker.sendHelloMessage();
                broker.receiveHelloReplyMessage();
                connected = true;
            }
            catch (BrokerAdminException baex) {
                if (baex.getType() == 0) {
                    try {
                        Thread.sleep(broker.getTimeout());
                        ++count;
                    }
                    catch (InterruptedException ie) {
                        connected = false;
                    }
                } else {
                    connected = false;
                }
            }
            catch (Exception ex) {
                connected = false;
            }
            if (count < broker.getNumRetries()) continue;
            connected = false;
            Globals.stdErrPrintln(this.ar.getString("A3120", broker.getBrokerHost(), broker.getBrokerPort()));
            Globals.stdErrPrintln(this.ar.getString("A3116", broker.getTimeout() * (long)broker.getNumRetries() / 1000L));
        }
        return connected;
    }

    private int getPauseTypeVal(String destStateStr) {
        int ret = -1;
        if (destStateStr == null) {
            return ret;
        }
        if (destStateStr.equals("ALL")) {
            ret = 3;
        } else if (destStateStr.equals("PRODUCERS")) {
            ret = 2;
        } else if (destStateStr.equals("CONSUMERS")) {
            ret = 1;
        }
        return ret;
    }

    private String getResetTypeVal(String resetType) {
        if (resetType == null || resetType.equals("")) {
            return null;
        }
        if (resetType.equals("METRICS")) {
            return "JMQMetrics";
        }
        return null;
    }

    private int getLimitBehavValue(String limitBehavStr) {
        int ret = -1;
        if (limitBehavStr == null) {
            return ret;
        }
        if (limitBehavStr.equals(LIMIT_BEHAV_FLOW_CONTROL)) {
            ret = 0;
        } else if (limitBehavStr.equals(LIMIT_BEHAV_RM_OLDEST)) {
            ret = 1;
        } else if (limitBehavStr.equals(LIMIT_BEHAV_REJECT_NEWEST)) {
            ret = 2;
        } else if (limitBehavStr.equals(LIMIT_BEHAV_RM_LOW_PRIORITY)) {
            ret = 3;
        }
        return ret;
    }

    private int getClusterDeliveryPolicy(String cdp) {
        int ret = -1;
        if (cdp == null) {
            return ret;
        }
        boolean b = Boolean.parseBoolean(cdp);
        ret = b ? 1 : 2;
        return ret;
    }

    private String getPasswordFromFileOrCmdLine(BrokerCmdProperties brokerCmdProps) throws CommonCmdException {
        String passwd = brokerCmdProps.getAdminPasswd();
        String passfile = brokerCmdProps.getAdminPassfile();
        if (passwd != null) {
            return passwd;
        }
        return CommonCmdRunnerUtil.getPasswordFromFile(passfile, "imq.imqcmd.password", brokerCmdProps);
    }

    private String checkNullAndPrintDeliveryMode(Integer deliveryMode) {
        if (deliveryMode != null) {
            String val;
            switch (deliveryMode) {
                case 1: {
                    val = "NON_PERSISTENT";
                    break;
                }
                case 2: {
                    val = "PERSISTENT";
                    break;
                }
                default: {
                    val = "Unknown";
                }
            }
            return val + " (" + deliveryMode + ")";
        }
        return "";
    }

    private String checkNullAndPrintMsgBodyType(Integer bodyType, boolean includeValue) {
        if (bodyType != null) {
            String label = null;
            switch (bodyType) {
                case 1: {
                    label = "TextMessage";
                    break;
                }
                case 2: {
                    label = "BytesMessage";
                    break;
                }
                case 3: {
                    label = "MapMessage";
                    break;
                }
                case 4: {
                    label = "StreamMessage";
                    break;
                }
                case 5: {
                    label = "ObjectMessage";
                    break;
                }
                default: {
                    label = "Unknown";
                }
            }
            if (includeValue) {
                return label + " (" + bodyType + ")";
            }
            return label;
        }
        return "";
    }
}

