/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.tools.tree;

import java.io.PrintStream;
import org.glassfish.rmic.tools.asm.Assembler;
import org.glassfish.rmic.tools.java.Environment;
import org.glassfish.rmic.tools.java.Type;
import org.glassfish.rmic.tools.tree.ConstantExpression;
import org.glassfish.rmic.tools.tree.Context;

public class DoubleExpression
extends ConstantExpression {
    double value;

    public DoubleExpression(long where, double value) {
        super(68, where, Type.tDouble);
        this.value = value;
    }

    @Override
    public Object getValue() {
        return new Double(this.value);
    }

    @Override
    public boolean equals(int i) {
        return this.value == (double)i;
    }

    @Override
    public boolean equalsDefault() {
        return Double.doubleToLongBits(this.value) == 0L;
    }

    @Override
    public void codeValue(Environment env, Context ctx, Assembler asm) {
        asm.add(this.where, 20, new Double(this.value));
    }

    @Override
    public void print(PrintStream out) {
        out.print(this.value + "D");
    }
}

