/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.tabbedproperties.sections.widgets;

import org.eclipse.emf.ecoretools.tabbedproperties.internal.Messages;
import org.eclipse.emf.ecoretools.tabbedproperties.sections.widgets.SearchableTree;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;

public class ChooseDialog
extends SelectionDialog {
    private int DEFAULT_DIALOG_WIDTH = 400;
    private int DEFAULT_DIALOG_HEIGHT = 300;
    private int MIN_DIALOG_WIDTH = 300;
    private int MIN_DIALOG_HEIGHT = 300;
    private SearchableTree tree;
    private ILabelProvider labelProvider;
    private Object[] objects;

    public ChooseDialog(Shell parentShell, Object[] objects) {
        super(parentShell);
        this.objects = objects;
        this.setTitle(Messages.ChooseDialog_ChooseDialog_title);
        this.setMessage(Messages.ChooseDialog_ChooseDialog_message);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        shell.setMinimumSize(this.MIN_DIALOG_WIDTH, this.MIN_DIALOG_HEIGHT);
        super.configureShell(shell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogComposite = (Composite)super.createDialogArea(parent);
        GridLayout dialogLayout = new GridLayout();
        dialogLayout.marginWidth = 10;
        dialogLayout.marginHeight = 10;
        GridData dialogLayoutData = new GridData(1808);
        dialogLayoutData.widthHint = this.DEFAULT_DIALOG_WIDTH;
        dialogLayoutData.heightHint = this.DEFAULT_DIALOG_HEIGHT;
        dialogComposite.setLayout((Layout)dialogLayout);
        dialogComposite.setLayoutData((Object)dialogLayoutData);
        this.tree = new SearchableTree(dialogComposite, 4);
        this.tree.setLayoutData(new GridData(1808));
        this.tree.setContentProvider(new TreeArrayContentProvider());
        this.tree.setLabelProvider(this.labelProvider);
        this.tree.setInput(this.objects);
        this.tree.setInitialSelection((IStructuredSelection)new StructuredSelection(this.getInitialElementSelections()));
        this.hookListeners();
        return dialogComposite;
    }

    private void hookListeners() {
        this.tree.getTreeViewer().addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                ChooseDialog.this.okPressed();
            }
        });
    }

    public void setLabelProvider(ILabelProvider provider) {
        this.labelProvider = provider;
    }

    protected void okPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.tree.getTreeViewer().getSelection();
        this.setResult(selection.toList());
        super.okPressed();
    }

    private class TreeArrayContentProvider
    extends ArrayContentProvider
    implements ITreeContentProvider {
        private TreeArrayContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }
}

