/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.tabbedproperties.sections;

import org.eclipse.emf.ecoretools.tabbedproperties.sections.AbstractTabbedPropertySection;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractColorPropertySection
extends AbstractTabbedPropertySection {
    private ColorSelector colorSelector;
    private CLabel colorLabel;
    private Composite compositeColorSelector;

    protected void createWidgets(Composite composite) {
        this.colorLabel = this.getWidgetFactory().createCLabel(composite, this.getLabelText());
        this.compositeColorSelector = this.getWidgetFactory().createFlatFormComposite(composite);
        this.colorSelector = new ColorSelector(this.compositeColorSelector);
    }

    protected void setSectionData(Composite composite) {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.compositeColorSelector, -5);
        this.colorLabel.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.colorLabel, 0, 0x1000000);
        data.left = new FormAttachment((Control)this.colorLabel, 5);
        this.compositeColorSelector.setLayoutData((Object)data);
    }

    protected void hookListeners() {
        this.colorSelector.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                AbstractColorPropertySection.this.handleColorChanged();
            }
        });
    }

    protected void handleColorChanged() {
        this.createCommand(new Color(null, this.getRGBValue()), new Color(null, this.colorSelector.getColorValue()));
    }

    public void refresh() {
        this.colorSelector.setColorValue(this.getRGBValue());
    }

    protected abstract RGB getRGBValue();
}

