/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.tabbedproperties.internal.sections.listeners;

import java.math.BigInteger;
import org.eclipse.emf.common.util.AbstractEnumerator;
import org.eclipse.emf.ecoretools.tabbedproperties.sections.widgets.TableViewerComposite;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.TableItem;

public class CellModifier
implements ICellModifier {
    private TableViewerComposite tableViewer;

    public CellModifier(TableViewerComposite tableViewer) {
        this.tableViewer = tableViewer;
    }

    public boolean canModify(Object element, String property) {
        return true;
    }

    public Object getValue(Object element, String property) {
        if (element instanceof String) {
            return element;
        }
        if (element instanceof Integer) {
            return ((Integer)element).toString();
        }
        if (element instanceof BigInteger) {
            return ((BigInteger)element).toString();
        }
        if (element instanceof AbstractEnumerator) {
            String stringValue = ((AbstractEnumerator)element).getLiteral();
            String[] choices = this.tableViewer.getObjectManager().getEnumLiterals();
            int i = choices.length - 1;
            while (!stringValue.equals(choices[i]) && i > 0) {
                --i;
            }
            return new Integer(i);
        }
        return element;
    }

    public void modify(Object element, String property, Object value) {
        TableItem item = (TableItem)element;
        Object oldValue = item.getData();
        Object newValue = null;
        if (oldValue instanceof String) {
            String string = (String)value;
            newValue = string.trim();
            item.setText((String)newValue);
            item.setData(newValue);
        } else if (oldValue instanceof Integer) {
            int i = Integer.parseInt((String)value);
            newValue = new Integer(i);
            item.setText(String.valueOf(i));
            item.setData(newValue);
        } else if (oldValue instanceof BigInteger) {
            newValue = new BigInteger((String)value);
            item.setText(newValue.toString());
            item.setData(newValue);
        } else if (oldValue instanceof Double) {
            newValue = new Double((String)value);
            item.setText(newValue.toString());
            item.setData(newValue);
        } else {
            newValue = oldValue instanceof Boolean ? value : this.tableViewer.getObjectManager().createEnum((Integer)value);
        }
        this.tableViewer.getObjectManager().elementChanged(oldValue, newValue);
    }
}

