/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.diagram.part;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecoretools.diagram.part.EcoreDiagramEditorPlugin;
import org.eclipse.emf.ecoretools.diagram.part.EcoreDiagramEditorUtil;
import org.eclipse.emf.ecoretools.diagram.part.Messages;
import org.eclipse.emf.ecoretools.diagram.providers.EcoreMarkerNavigationProvider;
import org.eclipse.emf.ecoretools.diagram.providers.EcoreValidationProvider;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.model.IConstraintStatus;
import org.eclipse.emf.validation.service.IBatchValidator;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gmf.runtime.common.ui.util.IWorkbenchPartDescriptor;
import org.eclipse.gmf.runtime.diagram.ui.OffscreenEditPartFactory;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

public class ValidateAction
extends Action {
    public static final String VALIDATE_ACTION_KEY = "validateAction";
    private IWorkbenchPartDescriptor workbenchPartDescriptor;

    public ValidateAction(IWorkbenchPartDescriptor workbenchPartDescriptor) {
        this.setId(VALIDATE_ACTION_KEY);
        this.setText(Messages.ValidateActionMessage);
        this.setImageDescriptor(EcoreDiagramEditorPlugin.getBundledImageDescriptor("icons/elcl16/validate.gif"));
        this.setDisabledImageDescriptor(EcoreDiagramEditorPlugin.getBundledImageDescriptor("icons/dlcl16/validate.gif"));
        this.setHoverImageDescriptor(EcoreDiagramEditorPlugin.getBundledImageDescriptor("icons/elcl16/validate.gif"));
        this.workbenchPartDescriptor = workbenchPartDescriptor;
    }

    public void run() {
        IWorkbenchPart workbenchPart = this.workbenchPartDescriptor.getPartPage().getActivePart();
        if (workbenchPart instanceof IDiagramWorkbenchPart) {
            final IDiagramWorkbenchPart part = (IDiagramWorkbenchPart)workbenchPart;
            try {
                new WorkspaceModifyDelegatingOperation(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                        ValidateAction.runValidation(part.getDiagramEditPart(), (View)part.getDiagram());
                    }
                }).run((IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                EcoreDiagramEditorPlugin.getInstance().logError("Validation action failed", e);
            }
        }
    }

    public static void runValidation(View view) {
        try {
            if (EcoreDiagramEditorUtil.openDiagram(view.eResource())) {
                IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                if (editorPart instanceof IDiagramWorkbenchPart) {
                    ValidateAction.runValidation(((IDiagramWorkbenchPart)editorPart).getDiagramEditPart(), view);
                } else {
                    ValidateAction.runNonUIValidation(view);
                }
            }
        }
        catch (Exception e) {
            EcoreDiagramEditorPlugin.getInstance().logError("Validation action failed", e);
        }
    }

    public static void runNonUIValidation(View view) {
        DiagramEditPart diagramEditPart = OffscreenEditPartFactory.getInstance().createDiagramEditPart(view.getDiagram());
        ValidateAction.runValidation(diagramEditPart, view);
    }

    public static void runValidation(DiagramEditPart diagramEditPart, View view) {
        final DiagramEditPart fpart = diagramEditPart;
        final View fview = view;
        EcoreValidationProvider.runWithConstraints(view, new Runnable(){

            public void run() {
                ValidateAction.validate(fpart, fview);
            }
        });
    }

    private static Diagnostic runEMFValidator(View target) {
        if (target.isSetElement() && target.getElement() != null) {
            return new Diagnostician(){

                public String getObjectLabel(EObject eObject) {
                    return EMFCoreUtil.getQualifiedName((EObject)eObject, (boolean)true);
                }
            }.validate(target.getElement());
        }
        return Diagnostic.OK_INSTANCE;
    }

    private static void validate(DiagramEditPart diagramEditPart, View view) {
        IFile target;
        IFile iFile = target = view.eResource() != null ? WorkspaceSynchronizer.getFile((Resource)view.eResource()) : null;
        if (target != null) {
            EcoreMarkerNavigationProvider.deleteMarkers((IResource)target);
        }
        Diagnostic diagnostic = ValidateAction.runEMFValidator(view);
        ValidateAction.createMarkers(target, diagnostic, diagramEditPart);
        IBatchValidator validator = (IBatchValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.BATCH);
        validator.setIncludeLiveConstraints(true);
        if (view.isSetElement() && view.getElement() != null) {
            IStatus status = validator.validate(view.getElement());
            ValidateAction.createMarkers(target, status, diagramEditPart);
        }
    }

    private static void createMarkers(IFile target, IStatus validationStatus, DiagramEditPart diagramEditPart) {
        if (validationStatus.isOK()) {
            return;
        }
        IStatus rootStatus = validationStatus;
        ArrayList allStatuses = new ArrayList();
        EcoreDiagramEditorUtil.LazyElement2ViewMap element2ViewMap = new EcoreDiagramEditorUtil.LazyElement2ViewMap((View)diagramEditPart.getDiagramView(), ValidateAction.collectTargetElements(rootStatus, new HashSet(), allStatuses));
        for (IConstraintStatus nextStatus : allStatuses) {
            View view = EcoreDiagramEditorUtil.findView(diagramEditPart, nextStatus.getTarget(), element2ViewMap);
            ValidateAction.addMarker(diagramEditPart.getViewer(), target, view.eResource().getURIFragment((EObject)view), EMFCoreUtil.getQualifiedName((EObject)nextStatus.getTarget(), (boolean)true), nextStatus.getMessage(), nextStatus.getSeverity());
        }
    }

    private static void createMarkers(IFile target, Diagnostic emfValidationStatus, DiagramEditPart diagramEditPart) {
        if (emfValidationStatus.getSeverity() == 0) {
            return;
        }
        Diagnostic rootStatus = emfValidationStatus;
        ArrayList allDiagnostics = new ArrayList();
        EcoreDiagramEditorUtil.LazyElement2ViewMap element2ViewMap = new EcoreDiagramEditorUtil.LazyElement2ViewMap((View)diagramEditPart.getDiagramView(), ValidateAction.collectTargetElements(rootStatus, new HashSet(), allDiagnostics));
        for (Diagnostic nextDiagnostic : emfValidationStatus.getChildren()) {
            List data = nextDiagnostic.getData();
            if (data == null || data.isEmpty() || !(data.get(0) instanceof EObject)) continue;
            EObject element = (EObject)data.get(0);
            View view = EcoreDiagramEditorUtil.findView(diagramEditPart, element, element2ViewMap);
            ValidateAction.addMarker(diagramEditPart.getViewer(), target, view.eResource().getURIFragment((EObject)view), EMFCoreUtil.getQualifiedName((EObject)element, (boolean)true), nextDiagnostic.getMessage(), ValidateAction.diagnosticToStatusSeverity(nextDiagnostic.getSeverity()));
        }
    }

    private static void addMarker(EditPartViewer viewer, IFile target, String elementId, String location, String message, int statusSeverity) {
        if (target == null) {
            return;
        }
        EcoreMarkerNavigationProvider.addMarker(target, elementId, location, message, statusSeverity);
    }

    private static int diagnosticToStatusSeverity(int diagnosticSeverity) {
        if (diagnosticSeverity == 0) {
            return 0;
        }
        if (diagnosticSeverity == 1) {
            return 1;
        }
        if (diagnosticSeverity == 2) {
            return 2;
        }
        if (diagnosticSeverity == 4 || diagnosticSeverity == 8) {
            return 4;
        }
        return 1;
    }

    private static Set collectTargetElements(IStatus status, Set targetElementCollector, List allConstraintStatuses) {
        if (status instanceof IConstraintStatus) {
            targetElementCollector.add(((IConstraintStatus)status).getTarget());
            allConstraintStatuses.add(status);
        }
        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                ValidateAction.collectTargetElements(children[i], targetElementCollector, allConstraintStatuses);
                ++i;
            }
        }
        return targetElementCollector;
    }

    private static Set collectTargetElements(Diagnostic diagnostic, Set targetElementCollector, List allDiagnostics) {
        List data = diagnostic.getData();
        EObject target = null;
        if (data != null && !data.isEmpty() && data.get(0) instanceof EObject) {
            target = (EObject)data.get(0);
            targetElementCollector.add(target);
            allDiagnostics.add(diagnostic);
        }
        if (diagnostic.getChildren() != null && !diagnostic.getChildren().isEmpty()) {
            Iterator it = diagnostic.getChildren().iterator();
            while (it.hasNext()) {
                ValidateAction.collectTargetElements((Diagnostic)it.next(), targetElementCollector, allDiagnostics);
            }
        }
        return targetElementCollector;
    }
}

