/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.diagram.edit.parts;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecoretools.diagram.edit.figures.FigureFromLabelUtils;
import org.eclipse.emf.ecoretools.diagram.edit.parts.EDataTypeInstanceClassEditPart;
import org.eclipse.emf.ecoretools.diagram.edit.parts.EDataTypeNameEditPart;
import org.eclipse.emf.ecoretools.diagram.edit.policies.EDataTypeItemSemanticEditPolicy;
import org.eclipse.emf.ecoretools.diagram.edit.policies.EcoreTextSelectionEditPolicy;
import org.eclipse.emf.ecoretools.diagram.part.EcoreVisualIDRegistry;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ConstrainedToolbarLayoutEditPolicy;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;

public class EDataTypeEditPart
extends ShapeNodeEditPart {
    public static final int VISUAL_ID = 1004;
    protected IFigure contentPane;
    protected IFigure primaryShape;

    public EDataTypeEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new EDataTypeItemSemanticEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
        this.removeEditPolicy("ConnectionHandlesPolicy");
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        ConstrainedToolbarLayoutEditPolicy lep = new ConstrainedToolbarLayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                if (child.getEditPolicy((Object)"PrimaryDrag Policy") == null && child instanceof ITextAwareEditPart) {
                    return new EcoreTextSelectionEditPolicy();
                }
                return super.createChildEditPolicy(child);
            }
        };
        return lep;
    }

    protected IFigure createNodeShape() {
        DataTypeFigure figure = new DataTypeFigure();
        this.primaryShape = figure;
        return this.primaryShape;
    }

    public DataTypeFigure getPrimaryShape() {
        return (DataTypeFigure)this.primaryShape;
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof EDataTypeNameEditPart) {
            ((EDataTypeNameEditPart)childEditPart).setLabel(this.getPrimaryShape().getFigureDataTypeNameLabel());
            return true;
        }
        if (childEditPart instanceof EDataTypeInstanceClassEditPart) {
            ((EDataTypeInstanceClassEditPart)childEditPart).setLabel(this.getPrimaryShape().getFigureDataTypeJavaLabel());
            return true;
        }
        return false;
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        return false;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (this.addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, -1);
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (this.removeFixedChild(childEditPart)) {
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {
        return super.getContentPaneFor(editPart);
    }

    protected NodeFigure createNodePlate() {
        DefaultSizeNodeFigure result = new DefaultSizeNodeFigure(this.getMapMode().DPtoLP(40), this.getMapMode().DPtoLP(40));
        return result;
    }

    protected NodeFigure createNodeFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape);
        this.contentPane = this.setupContentPane(shape);
        return figure;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(this.getMapMode().DPtoLP(5));
            nodeShape.setLayoutManager((LayoutManager)layout);
        }
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    public EditPart getPrimaryChildEditPart() {
        return this.getChildBySemanticHint(EcoreVisualIDRegistry.getType(4008));
    }

    protected void handleNotificationEvent(Notification event) {
        if (event.getNotifier() == this.getModel() && EcorePackage.eINSTANCE.getEModelElement_EAnnotations().equals(event.getFeature())) {
            this.handleMajorSemanticChange();
        } else {
            super.handleNotificationEvent(event);
        }
    }

    protected void refreshVisuals() {
        EObject semanticElement = this.resolveSemanticElement();
        if (FigureFromLabelUtils.needFromLabel(semanticElement, this.getNotationView())) {
            this.getPrimaryShape().updateFromLabel(FigureFromLabelUtils.getQualifiedName(semanticElement));
            this.getPrimaryShape().addFromLabel();
        } else {
            this.getPrimaryShape().removeFromLabel();
        }
        super.refreshVisuals();
    }

    public class DataTypeFigure
    extends RectangleFigure {
        private WrappingLabel fFigureDataTypeNameLabel;
        private WrappingLabel fFigureDataTypeJavaLabel;
        private WrappingLabel dataTypeFixedNameLabel0;
        private boolean myUseLocalCoordinates = false;
        private boolean canRemovedFromLabel;
        private WrappingLabel fFigureFromLabel;

        public DataTypeFigure() {
            ToolbarLayout layoutThis = new ToolbarLayout();
            layoutThis.setStretchMinorAxis(true);
            layoutThis.setMinorAlignment(0);
            layoutThis.setSpacing(1);
            layoutThis.setVertical(true);
            this.setLayoutManager((LayoutManager)layoutThis);
            this.setMinimumSize(new Dimension(EDataTypeEditPart.this.getMapMode().DPtoLP(100), EDataTypeEditPart.this.getMapMode().DPtoLP(30)));
            this.createContents();
        }

        private void createContents() {
            this.dataTypeFixedNameLabel0 = new WrappingLabel();
            this.dataTypeFixedNameLabel0.setAlignment(8);
            this.dataTypeFixedNameLabel0.setText("<<datatype>>");
            this.add((IFigure)this.dataTypeFixedNameLabel0);
            this.fFigureDataTypeNameLabel = new WrappingLabel();
            this.fFigureDataTypeNameLabel.setAlignment(8);
            this.fFigureDataTypeNameLabel.setText("<..>");
            this.add((IFigure)this.fFigureDataTypeNameLabel);
            this.fFigureDataTypeJavaLabel = new WrappingLabel();
            this.fFigureDataTypeJavaLabel.setAlignment(8);
            this.fFigureDataTypeJavaLabel.setText("");
            this.add((IFigure)this.fFigureDataTypeJavaLabel);
            this.fFigureFromLabel = new WrappingLabel();
            this.fFigureFromLabel.setAlignment(8);
            this.fFigureFromLabel.setText("<..>");
        }

        protected boolean useLocalCoordinates() {
            return this.myUseLocalCoordinates;
        }

        protected void setUseLocalCoordinates(boolean useLocalCoordinates) {
            this.myUseLocalCoordinates = useLocalCoordinates;
        }

        public WrappingLabel getFigureDataTypeNameLabel() {
            return this.fFigureDataTypeNameLabel;
        }

        public WrappingLabel getFigureDataTypeJavaLabel() {
            return this.fFigureDataTypeJavaLabel;
        }

        protected void outlineShape(Graphics graphics) {
            Rectangle r = this.getBounds();
            int x = r.x + this.lineWidth / 2;
            int y = r.y + this.lineWidth / 2;
            int w = r.width - Math.max(1, this.lineWidth);
            int h = r.height - Math.max(1, this.lineWidth);
            int labelHeight = this.getFigureDataTypeJavaLabel().getBounds().y - this.dataTypeFixedNameLabel0.getBounds().y;
            Point point1 = new Point(x, y + labelHeight);
            Point point2 = new Point(x + w, y + labelHeight);
            graphics.drawLine(point1, point2);
            graphics.drawRectangle(x, y, w, h);
        }

        public void addFromLabel() {
            this.add((IFigure)this.getFigureFromLabel(), 2);
            this.canRemovedFromLabel = true;
        }

        public WrappingLabel getFigureFromLabel() {
            return this.fFigureFromLabel;
        }

        public void removeFromLabel() {
            if (this.canRemovedFromLabel) {
                this.remove((IFigure)this.getFigureFromLabel());
                this.canRemovedFromLabel = false;
            }
        }

        public void updateFromLabel(String text) {
            this.getFigureFromLabel().setText(text);
        }
    }
}

