/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.diagram.edit.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecoretools.diagram.Messages;
import org.eclipse.emf.ecoretools.diagram.edit.parts.EReferenceEditPart;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.util.EditPartUtil;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.ConnectorStyle;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateLinkedEReferenceDeferredCommand
extends AbstractTransactionalCommand {
    private EReferenceEditPart part1;
    private EReferenceEditPart part2;

    public UpdateLinkedEReferenceDeferredCommand(TransactionalEditingDomain domain, EReferenceEditPart part1, EReferenceEditPart part2) {
        super(domain, "LinkEReferenceDeferredCommand", null);
        this.part1 = part1;
        this.part2 = part2;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.part1 == null || this.part2 == null) {
            return CommandResult.newWarningCommandResult((String)Messages.UpdateLinkedEReferenceDeferredCommand_UnableToProceed, null);
        }
        RunnableWithResult<Object> refreshRunnable = new RunnableWithResult<Object>(){
            private IStatus status;
            private Object result;

            public Object getResult() {
                return this.result;
            }

            public void setStatus(IStatus status) {
                this.status = status;
            }

            public IStatus getStatus() {
                return this.status;
            }

            public void run() {
                if (!(UpdateLinkedEReferenceDeferredCommand.this.part1.getNotationView() instanceof Edge) || !(UpdateLinkedEReferenceDeferredCommand.this.part2.getNotationView() instanceof Edge)) {
                    return;
                }
                Edge edge1 = (Edge)UpdateLinkedEReferenceDeferredCommand.this.part1.getNotationView();
                Edge edge2 = (Edge)UpdateLinkedEReferenceDeferredCommand.this.part2.getNotationView();
                if (!edge1.getTarget().equals(edge2.getSource()) || !edge1.getSource().equals(edge2.getTarget())) {
                    return;
                }
                if (edge1.getSourceAnchor() == null) {
                    IdentityAnchor sourceAnchor = NotationFactory.eINSTANCE.createIdentityAnchor();
                    sourceAnchor.setId("(0.5,0.5)");
                    edge1.setSourceAnchor((Anchor)sourceAnchor);
                }
                if (edge1.getTargetAnchor() == null) {
                    IdentityAnchor targetAnchor = NotationFactory.eINSTANCE.createIdentityAnchor();
                    targetAnchor.setId("(0.5,0.5)");
                    edge1.setTargetAnchor((Anchor)targetAnchor);
                }
                if (!edge1.getTargetAnchor().equals(edge2.getSourceAnchor())) {
                    edge2.setSourceAnchor((Anchor)EcoreUtil.copy((EObject)edge1.getTargetAnchor()));
                }
                if (!edge1.getSourceAnchor().equals(edge2.getTargetAnchor())) {
                    edge2.setTargetAnchor((Anchor)EcoreUtil.copy((EObject)edge1.getSourceAnchor()));
                }
                if (!(edge1.getBendpoints() instanceof RelativeBendpoints) || !(edge2.getBendpoints() instanceof RelativeBendpoints)) {
                    return;
                }
                RelativeBendpoints edge1Benpoints = (RelativeBendpoints)edge1.getBendpoints();
                if (edge1Benpoints.getPoints().isEmpty()) {
                    return;
                }
                ArrayList<RelativeBendpoint> relativePoints = new ArrayList<RelativeBendpoint>();
                int index = edge1Benpoints.getPoints().size() - 1;
                while (index >= 0) {
                    RelativeBendpoint relativePoint = (RelativeBendpoint)edge1Benpoints.getPoints().get(index);
                    relativePoints.add(new RelativeBendpoint(relativePoint.getTargetX(), relativePoint.getTargetY(), relativePoint.getSourceX(), relativePoint.getSourceY()));
                    --index;
                }
                RelativeBendpoints edge2Benpoints = (RelativeBendpoints)edge2.getBendpoints();
                List points = edge2Benpoints.getPoints();
                if (!UpdateLinkedEReferenceDeferredCommand.this.isBendpointEqual(points, relativePoints)) {
                    edge2Benpoints.setPoints(relativePoints);
                }
                ConnectorStyle edge1Style = (ConnectorStyle)edge1.getStyle(NotationPackage.eINSTANCE.getConnectorStyle());
                ConnectorStyle edge2Style = (ConnectorStyle)edge2.getStyle(NotationPackage.eINSTANCE.getConnectorStyle());
                if (edge1Style == null || edge2Style == null) {
                    return;
                }
                if (!edge1Style.getRouting().equals(edge2Style.getRouting())) {
                    edge2Style.setRouting(edge1Style.getRouting());
                }
            }
        };
        EditPartUtil.synchronizeRunnableToMainThread((IGraphicalEditPart)this.part2, (Runnable)refreshRunnable);
        return CommandResult.newOKCommandResult();
    }

    protected boolean isBendpointEqual(List<RelativeBendpoint> relativePoints1, List<RelativeBendpoint> relativePoints2) {
        if (relativePoints1.size() != relativePoints2.size()) {
            return false;
        }
        int index = 0;
        while (index < relativePoints1.size()) {
            if (!this.isRelativePointEqual(relativePoints1.get(index), relativePoints2.get(index))) {
                return false;
            }
            ++index;
        }
        return true;
    }

    private boolean isRelativePointEqual(RelativeBendpoint relativeBendpoint1, RelativeBendpoint relativeBendpoint2) {
        return relativeBendpoint1.getSourceX() == relativeBendpoint2.getSourceX() && relativeBendpoint1.getTargetX() == relativeBendpoint2.getTargetX() && relativeBendpoint1.getSourceY() == relativeBendpoint2.getSourceY() && relativeBendpoint1.getTargetY() == relativeBendpoint2.getTargetY();
    }
}

