/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.diagram.edit.policies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecoretools.diagram.edit.commands.EcoreCreateShortcutDecorationsCommand;
import org.eclipse.emf.ecoretools.diagram.edit.commands.RestoreRelatedLinksCommand;
import org.eclipse.emf.ecoretools.diagram.edit.commands.UpdateEditPartCommand;
import org.eclipse.emf.ecoretools.diagram.part.EcoreDiagramEditorPlugin;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DiagramDragDropEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.requests.ArrangeRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class PackageDiagramDragDropEditPolicy
extends DiagramDragDropEditPolicy {
    protected Command getDropCommand(ChangeBoundsRequest dropRequest) {
        ArrayList<CreateViewRequest.ViewDescriptor> shortcutViewDescriptors = new ArrayList<CreateViewRequest.ViewDescriptor>();
        ArrayList<CreateViewRequest.ViewDescriptor> normalViewDescriptors = new ArrayList<CreateViewRequest.ViewDescriptor>();
        for (Object nextPart : dropRequest.getEditParts()) {
            EObject nextObject;
            if (!(nextPart instanceof IGraphicalEditPart) || (nextObject = ((IGraphicalEditPart)nextPart).resolveSemanticElement()) == null || this.getHostView().getElement().equals(nextObject)) continue;
            if (!this.isElementInView(nextObject, (Request)dropRequest) && this.getHostView().getElement() == nextObject.eContainer()) {
                normalViewDescriptors.add(new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter(nextObject), Node.class, null, this.getDiagramPreferencesHint()));
                continue;
            }
            shortcutViewDescriptors.add(new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter(nextObject), Node.class, null, this.getDiagramPreferencesHint()));
        }
        Command shortcutCommand = null;
        if (!shortcutViewDescriptors.isEmpty()) {
            shortcutCommand = this.createShortcutsCommand(this.castToDropObjectsRequest(dropRequest), shortcutViewDescriptors);
        }
        Command normalCommand = null;
        if (!normalViewDescriptors.isEmpty()) {
            normalCommand = this.createViewsAndRestoreRelatedLinks(this.castToDropObjectsRequest(dropRequest), normalViewDescriptors);
        }
        if (shortcutCommand != null) {
            Command createBoth = shortcutCommand.chain(normalCommand);
            return createBoth;
        }
        return normalCommand;
    }

    public Command getDropObjectsCommand(DropObjectsRequest dropRequest) {
        ArrayList<CreateViewRequest.ViewDescriptor> shortcutViewDescriptors = new ArrayList<CreateViewRequest.ViewDescriptor>();
        ArrayList<CreateViewRequest.ViewDescriptor> normalViewDescriptors = new ArrayList<CreateViewRequest.ViewDescriptor>();
        for (Object nextObject : dropRequest.getObjects()) {
            if (!(nextObject instanceof EObject) || this.getHostView().getElement().equals(nextObject)) continue;
            if (!this.isElementInView(nextObject, (Request)dropRequest) && this.getHostView().getElement() == ((EObject)nextObject).eContainer()) {
                normalViewDescriptors.add(new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter((EObject)nextObject), Node.class, null, this.getDiagramPreferencesHint()));
                continue;
            }
            shortcutViewDescriptors.add(new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter((EObject)nextObject), Node.class, null, this.getDiagramPreferencesHint()));
        }
        Command shortcutCommand = null;
        if (!shortcutViewDescriptors.isEmpty()) {
            shortcutCommand = this.createShortcutsCommand(dropRequest, shortcutViewDescriptors);
        }
        Command normalCommand = null;
        if (!normalViewDescriptors.isEmpty()) {
            normalCommand = this.createViewsAndRestoreRelatedLinks(dropRequest, normalViewDescriptors);
        }
        if (shortcutCommand != null) {
            Command createBoth = shortcutCommand.chain(normalCommand);
            return createBoth.chain((Command)new ICommandProxy((ICommand)new UpdateEditPartCommand(this.getEditingDomain(), this.getHost())));
        }
        if (normalCommand != null) {
            return normalCommand.chain((Command)new ICommandProxy((ICommand)new UpdateEditPartCommand(this.getEditingDomain(), this.getHost())));
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected boolean isElementInView(Object nextObject, Request request) {
        EList views = this.getHostView().getChildren();
        for (View nextView : views) {
            if (nextView.getEAnnotation("Shortcut") != null || nextView.getElement() == null || !nextView.getElement().equals(nextObject)) continue;
            return true;
        }
        return false;
    }

    protected Command createShortcutsCommand(DropObjectsRequest dropRequest, List<CreateViewRequest.ViewDescriptor> viewDescriptors) {
        Command createCommand = this.createViewsAndRestoreRelatedLinks(dropRequest, viewDescriptors);
        if (createCommand != null) {
            createCommand.chain((Command)new ICommandProxy((ICommand)new EcoreCreateShortcutDecorationsCommand(this.getEditingDomain(), this.getHostView(), viewDescriptors)));
        }
        return createCommand;
    }

    protected Command createViewsAndRestoreRelatedLinks(DropObjectsRequest dropRequest, List<CreateViewRequest.ViewDescriptor> viewDescriptors) {
        CreateViewRequest createViewRequest = new CreateViewRequest(viewDescriptors);
        createViewRequest.setLocation(dropRequest.getLocation());
        Command createCommand = this.getHost().getCommand((Request)createViewRequest);
        if (createCommand != null) {
            List result = (List)createViewRequest.getNewObject();
            dropRequest.setResult((Object)result);
            createCommand.chain((Command)new ICommandProxy((ICommand)new RestoreRelatedLinksCommand(this.getDiagramEditPart(), (List)createViewRequest.getNewObject())));
            ArrangeRequest arrangeRequest = new ArrangeRequest("arrange_deferred");
            arrangeRequest.setViewAdaptersToArrange(result);
            createCommand.chain(this.getHost().getCommand((Request)arrangeRequest));
        }
        return createCommand;
    }

    private DiagramEditPart getDiagramEditPart() {
        if (this.getHost() instanceof DiagramEditPart) {
            return (DiagramEditPart)this.getHost();
        }
        IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (!(editorPart instanceof DiagramEditor)) {
            return null;
        }
        return ((DiagramEditor)editorPart).getDiagramEditPart();
    }

    private TransactionalEditingDomain getEditingDomain() {
        if (this.getHost() instanceof IGraphicalEditPart) {
            return ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        }
        return null;
    }

    private View getHostView() {
        return (View)this.getHost().getModel();
    }

    private PreferencesHint getDiagramPreferencesHint() {
        return EcoreDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT;
    }
}

