/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.tabbedproperties.sections;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecoretools.tabbedproperties.internal.Messages;
import org.eclipse.emf.ecoretools.tabbedproperties.sections.AbstractTabbedPropertySection;
import org.eclipse.emf.ecoretools.tabbedproperties.sections.widgets.FileChooser;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class AbstractFileChooserPropertySection
extends AbstractTabbedPropertySection {
    private boolean isRefreshing = false;
    private FileChooser fileChooser;
    private CLabel labelText;

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
    }

    @Override
    protected void createWidgets(Composite composite) {
        this.labelText = this.getWidgetFactory().createCLabel(composite, this.getLabelText());
        this.fileChooser = new FileChooser(composite, this.getWidgetFactory(), 0);
        this.fileChooser.setEditable(true);
        if (this.getFeature() != null) {
            this.fileChooser.setChangeable(this.getFeature().isChangeable());
        }
    }

    @Override
    protected void setSectionData(Composite composite) {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.fileChooser, -5);
        data.top = new FormAttachment(0, 4);
        this.labelText.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, this.getStandardLabelWidth(composite, new String[]{this.getLabelText()}));
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.labelText, 0, 0x1000000);
        this.fileChooser.setLayoutData(data);
    }

    @Override
    protected void hookListeners() {
        this.fileChooser.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractFileChooserPropertySection.this.handleTextModified();
            }
        });
    }

    protected void handleTextModified() {
        if (!this.isRefreshing && this.getFeatureValue() != this.fileChooser.getSelection()) {
            List<IStatus> status = this.verifyFile();
            this.fileChooser.setStatus(status);
            if (status.isEmpty()) {
                EditingDomain editingDomain = this.getEditingDomain();
                if (this.getEObjectList().size() == 1) {
                    editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)editingDomain, (Object)this.getEObject(), (Object)this.getFeature(), (Object)this.fileChooser.getSelection()));
                }
            }
        }
    }

    public void refresh() {
        this.isRefreshing = true;
        this.fileChooser.setChangeable(!this.isReadOnly());
        this.fileChooser.setSelection(this.getFeatureValue());
        this.isRefreshing = false;
    }

    protected FileChooser getFileChooser() {
        return this.fileChooser;
    }

    protected boolean isRefreshing() {
        return this.isRefreshing;
    }

    protected List<IStatus> verifyFile() {
        ArrayList statusList = new ArrayList();
        if (this.isCheckFileExistence()) {
            String selection = this.fileChooser.getSelection();
            if (selection != null && !"".equals(selection)) {
                File file = new File(selection);
                if (!file.exists()) {
                    statusList.add(new Status(4, "org.eclipse.emf.ecoretools.tabbedproperties", String.valueOf(this.getLabelText()) + Messages.AbstractFileChooserPropertySection_NotExist));
                }
                if (!file.isFile()) {
                    statusList.add(new Status(4, "org.eclipse.emf.ecoretools.tabbedproperties", String.valueOf(this.getLabelText()) + Messages.AbstractFileChooserPropertySection_NotADirectory));
                }
            } else if (this.cannotBeBlank()) {
                statusList.add(new Status(4, "org.eclipse.emf.ecoretools.tabbedproperties", String.valueOf(this.getLabelText()) + Messages.AbstractFileChooserPropertySection_NotBlank));
            }
        }
        List<IStatus> emptyList = Collections.emptyList();
        return statusList.isEmpty() ? emptyList : statusList;
    }

    public boolean isCheckFileExistence() {
        return false;
    }

    public boolean cannotBeBlank() {
        return false;
    }

    protected abstract String getFeatureValue();
}

