/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.properties.internal.metadata;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecoretools.properties.internal.Messages;
import org.eclipse.emf.ecoretools.tabbedproperties.EMFRecordingChangeCommand;
import org.eclipse.emf.ecoretools.tabbedproperties.sections.AbstractTabbedPropertySection;
import org.eclipse.emf.ecoretools.tabbedproperties.utils.TextChangeListener;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class MinLengthSection
extends AbstractTabbedPropertySection {
    private boolean isRefreshing = false;
    private Text lengthTxt;
    private CLabel labelTxt;

    protected void createWidgets(Composite composite) {
        this.labelTxt = this.getWidgetFactory().createCLabel(composite, this.getLabelText());
        this.lengthTxt = this.getWidgetFactory().createText(composite, "");
    }

    protected void setSectionData(Composite composite) {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.lengthTxt, -5);
        data.top = new FormAttachment(0, 4);
        this.labelTxt.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, this.getStandardLabelWidth(composite, new String[]{this.getLabelText()}));
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.labelTxt, 0, 0x1000000);
        this.lengthTxt.setLayoutData((Object)data);
    }

    protected void hookListeners() {
        TextChangeListener listener = new TextChangeListener(){

            public void textChanged(Control control) {
                MinLengthSection.this.handleTextModified();
            }
        };
        listener.startListeningTo((Control)this.lengthTxt);
        listener.startListeningForEnter((Control)this.lengthTxt);
    }

    protected void handleTextModified() {
        if (!this.isRefreshing) {
            try {
                if (this.lengthTxt.getText() == null || this.lengthTxt.getText().length() == 0) {
                    this.lengthTxt.setText("-1");
                }
                final int newLength = Integer.parseInt(this.lengthTxt.getText());
                EditingDomain editingDomain = this.getEditingDomain();
                if (this.getEObjectList().size() == 1) {
                    int oldLength = ExtendedMetaData.INSTANCE.getMinLengthFacet((EDataType)this.getEObject());
                    if (oldLength != newLength) {
                        editingDomain.getCommandStack().execute((Command)new EMFRecordingChangeCommand(this.getEObject().eResource()){

                            protected void doExecute() {
                                ExtendedMetaData.INSTANCE.setMinLengthFacet((EDataType)MinLengthSection.this.getEObject(), newLength);
                            }
                        });
                    }
                } else {
                    CompoundCommand compoundCommand = new CompoundCommand();
                    for (final EObject nextObject : this.getEObjectList()) {
                        int oldLength = ExtendedMetaData.INSTANCE.getMinLengthFacet((EDataType)nextObject);
                        if (oldLength == newLength) continue;
                        editingDomain.getCommandStack().execute((Command)new EMFRecordingChangeCommand(nextObject.eResource()){

                            protected void doExecute() {
                                ExtendedMetaData.INSTANCE.setMinLengthFacet((EDataType)nextObject, newLength);
                            }
                        });
                    }
                    editingDomain.getCommandStack().execute((Command)compoundCommand);
                }
            }
            catch (NumberFormatException e) {
                this.refresh();
            }
        }
    }

    public void refresh() {
        this.isRefreshing = true;
        this.lengthTxt.setText("" + ExtendedMetaData.INSTANCE.getMinLengthFacet((EDataType)this.getEObject()));
        this.isRefreshing = false;
    }

    protected EStructuralFeature getFeature() {
        return null;
    }

    protected String getLabelText() {
        return Messages.MinLengthSection_MinimumLength;
    }
}

