/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.diagram.edit.dialogs;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecoretools.diagram.Messages;
import org.eclipse.emf.ecoretools.diagram.part.EcoreDiagramEditorPlugin;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.WorkbenchLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManageDiagramsDialog
extends Dialog {
    private static final int DELETE_ID = 2034;
    private static final int CREATE_ID = 2044;
    private static final String DELETE_LABEL = Messages.ManageDiagramsDialog_Delete;
    private static final String CREATE_LABEL = Messages.ManageDiagramsDialog_Create;
    private TreeViewer myTreeViewer;
    private List<Diagram> diagramList;
    private Diagram selectedDiagram;
    private Button initializeContentButton;
    private boolean initializeContentButtonState;
    public static final int CREATE = 1020;
    public static final int DELETE = 1010;

    public ManageDiagramsDialog(Shell parentShell, List<Diagram> initialDiagrams) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.diagramList = initialDiagrams;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.getShell().setText(Messages.ManageDiagramsDialog_ManageDiagrams);
        this.createDiagramTreeBrowser(composite);
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Control btnBar = super.createButtonBar(parent);
        this.getButton(0).setText(Messages.ManageDiagramsDialog_Open);
        this.getButton(0).setToolTipText(Messages.ManageDiagramsDialog_OpenSelectedDiagram);
        this.getButton(2044).setToolTipText(Messages.ManageDiagramsDialog_CreateNewDiagram);
        this.getButton(2034).setToolTipText(Messages.ManageDiagramsDialog_DeleteSelectedDiagram);
        this.getButton(1).setToolTipText(Messages.ManageDiagramsDialog_CloseDialog);
        this.validateDialog();
        return btnBar;
    }

    private void validateDialog() {
        if (this.getSelectedDiagram() == null) {
            this.getButton(0).setEnabled(false);
            this.getButton(2034).setEnabled(false);
        } else {
            this.getButton(0).setEnabled(true);
            this.getButton(2034).setEnabled(true);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 2044, CREATE_LABEL, false);
        this.createButton(parent, 2034, DELETE_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private void createDiagramTreeBrowser(Composite composite) {
        this.myTreeViewer = new TreeViewer(composite, 2820);
        GridData layoutData = new GridData(1808);
        layoutData.heightHint = 300;
        layoutData.widthHint = 300;
        this.myTreeViewer.getTree().setLayoutData((Object)layoutData);
        this.myTreeViewer.setContentProvider((IContentProvider)new DiagramTreeContentProvider());
        this.myTreeViewer.setLabelProvider((IBaseLabelProvider)new DiagramTreeLabelProvider());
        this.myTreeViewer.setInput(this.diagramList);
        this.myTreeViewer.addSelectionChangedListener((ISelectionChangedListener)new DiagramTreeSelectionChangedListener());
        this.initializeContentButton = new Button(composite, 32);
        this.initializeContentButton.setText(Messages.ManageDiagramsDialog_InitializeDiagramContents);
        this.initializeContentButton.setSelection(true);
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 0: {
                this.okPressed();
                break;
            }
            case 2044: {
                this.initializeContentButtonState = this.initializeContentButton.getSelection();
                this.setReturnCode(1020);
                this.close();
                break;
            }
            case 2034: {
                this.setReturnCode(1010);
                this.close();
                break;
            }
            case 1: {
                this.cancelPressed();
                break;
            }
        }
    }

    public Diagram getSelectedDiagram() {
        return this.selectedDiagram;
    }

    public boolean getInitializeContentButtonState() {
        return this.initializeContentButtonState;
    }

    private class DiagramTreeContentProvider
    implements ITreeContentProvider {
        private DiagramTreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof List) {
                return ((List)parentElement).toArray();
            }
            return Collections.EMPTY_LIST.toArray();
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof List) {
                return ((List)element).isEmpty();
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class DiagramTreeLabelProvider
    implements ILabelProvider {
        private WorkbenchLabelProvider myWorkbenchLabelProvider = new WorkbenchLabelProvider();
        private AdapterFactoryLabelProvider myAdapterFactoryLabelProvider = new AdapterFactoryLabelProvider(EcoreDiagramEditorPlugin.getInstance().getItemProvidersAdapterFactory());

        private DiagramTreeLabelProvider() {
        }

        public Image getImage(Object element) {
            return EcoreDiagramEditorPlugin.getInstance().getBundledImage("icons/EPackage.gif");
        }

        public String getText(Object element) {
            return ((Diagram)element).getName();
        }

        public void addListener(ILabelProviderListener listener) {
            this.myWorkbenchLabelProvider.addListener(listener);
            this.myAdapterFactoryLabelProvider.addListener(listener);
        }

        public void dispose() {
            this.myWorkbenchLabelProvider.dispose();
            this.myAdapterFactoryLabelProvider.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            return this.myWorkbenchLabelProvider.isLabelProperty(element, property) || this.myAdapterFactoryLabelProvider.isLabelProperty(element, property);
        }

        public void removeListener(ILabelProviderListener listener) {
            this.myWorkbenchLabelProvider.removeListener(listener);
            this.myAdapterFactoryLabelProvider.removeListener(listener);
        }
    }

    private class DiagramTreeSelectionChangedListener
    implements ISelectionChangedListener {
        private DiagramTreeSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Object selectedElement;
            IStructuredSelection selection;
            if (event.getSelection() instanceof IStructuredSelection && (selection = (IStructuredSelection)event.getSelection()).size() == 1 && (selectedElement = selection.getFirstElement()) instanceof Diagram) {
                ManageDiagramsDialog.this.selectedDiagram = (Diagram)selectedElement;
                ManageDiagramsDialog.this.validateDialog();
                return;
            }
            ManageDiagramsDialog.this.selectedDiagram = null;
            ManageDiagramsDialog.this.validateDialog();
        }
    }
}

