/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.internal;

import org.eclipse.xtext.formatting2.internal.CommentReplacer;
import org.eclipse.xtext.formatting2.regionaccess.IComment;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.formatting2.regionaccess.internal.TextSegment;

public abstract class SinglelineCommentReplacer
extends CommentReplacer {
    private final String prefix;

    public SinglelineCommentReplacer(IComment comment, String prefix) {
        super(comment);
        this.prefix = prefix;
    }

    protected ITextSegment getFirstSpace() {
        int start;
        IComment comment = this.getComment();
        String text = comment.getText();
        if (!text.startsWith(this.prefix)) {
            return null;
        }
        for (int i = start = this.prefix.length(); i < text.length(); ++i) {
            char charAt = text.charAt(i);
            if (Character.isWhitespace(charAt) && charAt != '\r' && charAt != '\n') continue;
            return new TextSegment(comment.getTextRegionAccess(), comment.getOffset() + start, i - start);
        }
        return new TextSegment(comment.getTextRegionAccess(), comment.getOffset() + start, text.length() - start);
    }

    public String getPrefix() {
        return this.prefix;
    }

    protected boolean hasEmptyBody() {
        int start;
        IComment comment = this.getComment();
        String text = comment.getText();
        if (!text.startsWith(this.prefix)) {
            return false;
        }
        for (int i = start = this.prefix.length(); i < text.length(); ++i) {
            char charAt = text.charAt(i);
            if (Character.isWhitespace(charAt)) continue;
            return false;
        }
        return true;
    }
}

