/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.office.model;

import com.google.common.io.Files;
import java.awt.Desktop;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.NoSuchFileException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.poi.hssf.OldExcelFormatException;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.eclipse.capra.ui.office.exceptions.CapraOfficeObjectNotFound;
import org.eclipse.capra.ui.office.model.CapraOfficeObject;
import org.eclipse.capra.ui.office.utils.CapraOfficeUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSelection;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetView;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetViews;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CapraExcelRow
extends CapraOfficeObject {
    private static final Logger LOG = LoggerFactory.getLogger(CapraExcelRow.class);
    private static final String LINE_BREAKS_AND_CONTROL_REQ = "[\r\n\t\\p{C}]+";
    private static final DataFormatter FORMATTER = new DataFormatter();
    private static final String CELL_DELIMITER = " | ";
    private static final int NO_ROW_INDEX = -1;
    private static final String NO_LAST_CELL_REFERENCE = "-1";
    private String idColumn;

    public CapraExcelRow(File officeFile, Row row, String idColumn) {
        this.idColumn = idColumn;
        String rowId = this.getRowIdFromExcelRow(row);
        StringBuilder rowBuilder = new StringBuilder();
        rowBuilder.append("ID " + rowId + ": ");
        boolean firstCellSet = false;
        int j = 1;
        while (j < row.getLastCellNum()) {
            Cell cell = row.getCell(j);
            String cellValue = FORMATTER.formatCellValue(cell);
            if (!cellValue.isEmpty()) {
                if (!firstCellSet) {
                    rowBuilder.append(cellValue);
                    firstCellSet = true;
                } else {
                    rowBuilder.append(CELL_DELIMITER + cellValue);
                }
            }
            ++j;
        }
        if (firstCellSet) {
            Pattern p = Pattern.compile(LINE_BREAKS_AND_CONTROL_REQ);
            Matcher m = p.matcher(rowBuilder);
            String rowData = m.replaceAll(" ").trim();
            Path path = new Path(officeFile.getAbsolutePath());
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IFile file = root.getFileForLocation((IPath)path);
            try {
                URI uri = file != null ? new URIBuilder().setScheme("platform").setPath("/resource" + file.getFullPath()).addParameter("sheet", row.getSheet().getSheetName()).addParameter("row", rowId).build() : new URIBuilder().setScheme("file").setPath(officeFile.getAbsolutePath()).addParameter("sheet", row.getSheet().getSheetName()).addParameter("row", rowId).build();
                this.setData(rowData);
                this.setUri(uri);
            }
            catch (URISyntaxException e) {
                LOG.error("Could not build URI for ", (Object)officeFile.getPath());
            }
        }
    }

    @Override
    public void showOfficeObjectInNativeEnvironment() throws CapraOfficeObjectNotFound {
        Object hssfSheet;
        int firstDisplayedRowIndex;
        File officeFile;
        try {
            officeFile = this.getFile();
        }
        catch (NoSuchFileException e) {
            LOG.warn("Could not find file {}", (Object)this.getPath());
            return;
        }
        String fileType = Files.getFileExtension((String)officeFile.getAbsolutePath());
        String rowId = this.getRowId();
        String sheetName = this.getSheetName();
        Sheet sheet = null;
        try {
            Workbook workBook = CapraOfficeUtils.getExcelWorkbook(officeFile);
            sheet = CapraOfficeUtils.getSheet(workBook, sheetName);
        }
        catch (IOException | OldExcelFormatException e) {
            LOG.warn("Excel file is in old format or cannot be read.", e);
            return;
        }
        String lastCellReference = NO_LAST_CELL_REFERENCE;
        int rowIndex = -1;
        int i = 0;
        while (i <= sheet.getLastRowNum()) {
            String currRowId;
            Row row = sheet.getRow(i);
            if (row != null && (currRowId = this.getRowIdFromExcelRow(row)).equals(rowId)) {
                rowIndex = i;
                lastCellReference = String.valueOf(CellReference.convertNumToColString((int)row.getLastCellNum())) + (rowIndex + 1);
                break;
            }
            ++i;
        }
        if (rowIndex == -1 || lastCellReference.equals(NO_LAST_CELL_REFERENCE)) {
            throw new CapraOfficeObjectNotFound(this.getRowId());
        }
        int n = firstDisplayedRowIndex = rowIndex - 2 > 0 ? rowIndex - 2 : 1;
        if (fileType.equals("xlsx")) {
            XSSFSheet xssfSheet = (XSSFSheet)XSSFSheet.class.cast(sheet);
            int sheetIndex = xssfSheet.getWorkbook().getSheetIndex((Sheet)xssfSheet);
            xssfSheet.getWorkbook().setActiveSheet(sheetIndex);
            CTSheetViews ctSheetViews = xssfSheet.getCTWorksheet().getSheetViews();
            CTSheetView ctSheetView = ctSheetViews.getSheetViewArray(ctSheetViews.sizeOfSheetViewArray() - 1);
            ctSheetView.setTopLeftCell("A" + firstDisplayedRowIndex);
            CTSelection ctSelection = ctSheetView.addNewSelection();
            ctSelection.setActiveCell("A" + (rowIndex + 1));
            ctSelection.setSqref(Arrays.asList("A" + (rowIndex + 1) + ":" + lastCellReference));
        } else {
            hssfSheet = (HSSFSheet)HSSFSheet.class.cast(sheet);
            hssfSheet.setActive(true);
            hssfSheet.showInPane((int)((short)rowIndex), 0);
            HSSFRow row = hssfSheet.getRow(rowIndex);
            HSSFCell cell = row.getCell(0);
            cell.setAsActiveCell();
        }
        try {
            hssfSheet = null;
            Object var10_17 = null;
            try (FileOutputStream out = new FileOutputStream(this.getFile());){
                sheet.getWorkbook().write((OutputStream)out);
            }
            catch (Throwable throwable) {
                if (hssfSheet == null) {
                    hssfSheet = throwable;
                } else if (hssfSheet != throwable) {
                    ((Throwable)hssfSheet).addSuppressed(throwable);
                }
                throw hssfSheet;
            }
        }
        catch (IOException e) {
            LOG.debug("Could not write to file.", (Throwable)e);
        }
        try {
            Desktop.getDesktop().open(this.getFile());
        }
        catch (IOException e) {
            LOG.debug("Could not open file.", (Throwable)e);
        }
    }

    public String getSheetName() {
        List params = URLEncodedUtils.parse((URI)this.getUri(), (Charset)Charset.forName("UTF-8"));
        for (NameValuePair param : params) {
            if (!param.getName().equals("sheet")) continue;
            return param.getValue();
        }
        return "";
    }

    public String getRowId() {
        List params = URLEncodedUtils.parse((URI)this.getUri(), (Charset)Charset.forName("UTF-8"));
        for (NameValuePair param : params) {
            if (!param.getName().equals("row")) continue;
            return param.getValue();
        }
        return "";
    }

    protected final String getRowIdFromExcelRow(Row row) {
        String rowId = "";
        if (this.idColumn.equals("0")) {
            rowId = Integer.toString(row.getRowNum());
        } else if (this.idColumn.length() > 1) {
            StringBuilder sId = new StringBuilder();
            char[] cArray = this.idColumn.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char id = cArray[n2];
                sId.append(" ");
                sId.append(FORMATTER.formatCellValue(row.getCell(CellReference.convertColStringToIndex((String)String.valueOf(id)))));
                ++n2;
            }
            rowId = sId.toString();
        } else {
            rowId = FORMATTER.formatCellValue(row.getCell(CellReference.convertColStringToIndex((String)this.idColumn)));
        }
        return rowId;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.idColumn == null ? 0 : this.idColumn.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CapraExcelRow other = (CapraExcelRow)obj;
        return !(this.idColumn == null ? other.idColumn != null : !this.idColumn.equals(other.idColumn));
    }
}

