/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.matrix;

import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Locale;
import org.eclipse.capra.core.helpers.ArtifactHelper;
import org.eclipse.capra.ui.matrix.TraceabilityMatrixDataProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.tooltip.NatTableContentTooltip;
import org.eclipse.swt.widgets.Event;

public class TraceabilityMatrixHeaderToolTip
extends NatTableContentTooltip {
    private TraceabilityMatrixDataProvider dataProvider;
    private ArtifactHelper artifactHelper;

    public TraceabilityMatrixHeaderToolTip(NatTable natTable, TraceabilityMatrixDataProvider dataProvider, ArtifactHelper artifactHelper) {
        super(natTable, new String[]{"COLUMN_HEADER"});
        this.natTable = natTable;
        this.dataProvider = dataProvider;
        this.artifactHelper = artifactHelper;
    }

    protected String getText(Event event) {
        int col = this.natTable.getColumnIndexByPosition(this.natTable.getColumnPositionByX(event.x));
        EObject artifact = this.dataProvider.getColumn(col).getArtifact();
        StringBuilder tooltipBuilder = new StringBuilder();
        tooltipBuilder.append(this.artifactHelper.getArtifactLabel(artifact));
        tooltipBuilder.append("\nLocated at:\n");
        tooltipBuilder.append(this.artifactHelper.getArtifactLocation(artifact));
        try {
            URI uri = new URI(this.artifactHelper.getArtifactLocation(artifact));
            Path path = new Path(uri.getPath());
            path = path.removeFirstSegments(1);
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            if (file != null) {
                if (file.exists()) {
                    tooltipBuilder.append("\nLast modified: ");
                    LocalDate date = Instant.ofEpochMilli(file.getLocalTimeStamp()).atZone(ZoneId.systemDefault()).toLocalDate();
                    tooltipBuilder.append(date.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM).withLocale(new Locale("no", "NO"))));
                } else {
                    tooltipBuilder.append("\nArtifact does not exist.");
                }
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return tooltipBuilder.toString();
    }
}

